/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

public class TileImprovement
extends TileItem {
    private static Logger logger = Logger.getLogger(TileImprovement.class.getName());
    private TileImprovementType type;
    private int turnsToComplete;
    private int magnitude;
    public static final int NO_RIVER = 0;
    public static final int SMALL_RIVER = 1;
    public static final int LARGE_RIVER = 2;
    public static final int FJORD_RIVER = 3;
    private int style;
    private boolean virtual;

    public TileImprovement(Game game, Tile tile, TileImprovementType type) {
        super(game, tile);
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be 'null'.");
        }
        this.type = type;
        if (!type.isNatural()) {
            this.turnsToComplete = tile.getType().getBasicWorkTurns() + type.getAddWorkTurns();
        }
        this.magnitude = type.getMagnitude();
    }

    public TileImprovement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public TileImprovement(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public TileImprovement(Game game, String id) {
        super(game, id);
    }

    public TileImprovementType getType() {
        return this.type;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(int magnitude) {
        this.magnitude = magnitude;
    }

    public final boolean isVirtual() {
        return this.virtual;
    }

    public final void setVirtual(boolean newVirtual) {
        this.virtual = newVirtual;
    }

    public boolean isRoad() {
        return this.getType().getId().equals("model.improvement.Road");
    }

    public boolean isRiver() {
        return this.getType().getId().equals("model.improvement.River");
    }

    public String toString() {
        if (this.turnsToComplete > 0) {
            return this.getName() + " (" + Integer.toString(this.turnsToComplete) + " turns left)";
        }
        return this.getName();
    }

    public String getName() {
        return this.getType().getName();
    }

    public String getOccupationString() {
        return this.type.getOccupationString();
    }

    public int getTurnsToComplete() {
        return this.turnsToComplete;
    }

    public void setTurnsToComplete(int turns) {
        this.turnsToComplete = turns;
    }

    public boolean isComplete() {
        return this.turnsToComplete <= 0;
    }

    public int doWork(int turns) {
        this.turnsToComplete -= turns;
        if (this.turnsToComplete <= 0) {
            this.turnsToComplete = 0;
        }
        return this.turnsToComplete;
    }

    public int doWork() {
        return this.doWork(1);
    }

    public EquipmentType getExpendedEquipmentType() {
        return this.type.getExpendedEquipmentType();
    }

    public int getExpendedAmount() {
        return this.type.getExpendedAmount();
    }

    public GoodsType getDeliverGoodsType() {
        return this.type.getDeliverGoodsType();
    }

    public int getDeliverAmount() {
        return this.type.getDeliverAmount();
    }

    public int getBonus(GoodsType goodsType) {
        if (!this.isComplete()) {
            return 0;
        }
        return this.type.getBonus(goodsType);
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        if (!this.isComplete()) {
            return null;
        }
        return this.type.getProductionModifier(goodsType);
    }

    public int getMovementCost(int moveCost, Tile fromTile) {
        if (!this.isComplete()) {
            return moveCost;
        }
        String typeId = this.type.getId();
        if (typeId == null) {
            return this.type.getMovementCost(moveCost);
        }
        for (TileImprovement improvement : fromTile.getTileImprovements()) {
            if (!improvement.getType().getId().equals(typeId)) continue;
            return this.type.getMovementCost(moveCost);
        }
        return moveCost;
    }

    public TileType getChange(TileType tileType) {
        if (!this.isComplete()) {
            return null;
        }
        return this.type.getChange(tileType);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public static int[] getBase(Map.Direction[] directions, int baseNumber) {
        Map.Direction[] allDirections = Map.Direction.values();
        int[] base = new int[allDirections.length];
        int n = 1;
        block0: for (int i = 0; i < allDirections.length; ++i) {
            base[i] = 0;
            for (Map.Direction direction : directions) {
                if (direction != allDirections[i]) continue;
                base[i] = n;
                n *= baseNumber;
                continue block0;
            }
        }
        return base;
    }

    public int[] getStyleBreakdown(Map.Direction[] directions, int baseNumber) {
        return this.getStyleBreakdown(TileImprovement.getBase(directions, baseNumber));
    }

    public int[] getStyleBreakdown(int[] base) {
        int[] result = new int[8];
        int tempStyle = this.style;
        for (int i = base.length - 1; i >= 0; --i) {
            if (base[i] == 0) continue;
            result[i] = tempStyle / base[i];
            tempStyle -= result[i] * base[i];
        }
        return result;
    }

    public void compileStyleBreakdown(int[] base, int[] breakdown) {
        if (base.length != breakdown.length) {
            logger.warning("base.length != breakdown.length");
            return;
        }
        this.style = 0;
        for (int i = 0; i < base.length; ++i) {
            this.style += base[i] * breakdown[i];
        }
    }

    public static TileImprovementType findBestTileImprovementType(Tile tile, GoodsType goodsType) {
        List<TileImprovementType> impTypeList = FreeCol.getSpecification().getTileImprovementTypeList();
        int bestValue = 0;
        TileImprovementType bestType = null;
        for (TileImprovementType impType : impTypeList) {
            int value;
            if (impType.isNatural() || !impType.isTileTypeAllowed(tile.getType()) || tile.findTileImprovementType(impType) != null || (value = impType.getValue(tile.getType(), goodsType)) <= bestValue) continue;
            bestValue = value;
            bestType = impType;
        }
        return bestType;
    }

    public boolean isWorkerAllowed(Unit unit) {
        if (unit == null) {
            return false;
        }
        if (this.isComplete()) {
            return false;
        }
        return this.type.isWorkerAllowed(unit);
    }

    public void dispose() {
        super.dispose();
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(TileImprovement.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("tile", this.getTile().getId());
        out.writeAttribute("type", this.getType().getId());
        out.writeAttribute("turns", Integer.toString(this.turnsToComplete));
        out.writeAttribute("magnitude", Integer.toString(this.magnitude));
        out.writeAttribute("style", Integer.toString(this.style));
        if (this.virtual) {
            out.writeAttribute("virtual", Boolean.toString(this.virtual));
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.tile = (Tile)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "tile"));
        if (this.tile == null) {
            this.tile = new Tile(this.getGame(), in.getAttributeValue(null, "tile"));
        }
        this.type = FreeCol.getSpecification().getTileImprovementType(in.getAttributeValue(null, "type"));
        this.turnsToComplete = Integer.parseInt(in.getAttributeValue(null, "turns"));
        this.magnitude = Integer.parseInt(in.getAttributeValue(null, "magnitude"));
        this.style = Integer.parseInt(in.getAttributeValue(null, "style"));
        this.virtual = this.getAttribute(in, "virtual", false);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "tileimprovement";
    }
}

