/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class TileImprovementType
extends FreeColGameObjectType {
    private boolean natural;
    private String typeId;
    private int magnitude;
    private int addWorkTurns;
    private String artOverlay;
    private boolean artOverTrees;
    private List<TileType> allowedTileTypes;
    private TileImprovementType requiredImprovementType;
    private Set<String> allowedWorkers;
    private EquipmentType expendedEquipmentType;
    private int expendedAmount;
    private GoodsType deliverGoodsType;
    private int deliverAmount;
    private Map<TileType, TileType> tileTypeChange = new HashMap<TileType, TileType>();
    private int movementCost;
    private float movementCostFactor;

    public TileImprovementType(int index) {
        this.setIndex(index);
    }

    public boolean isNatural() {
        return this.natural;
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public int getAddWorkTurns() {
        return this.addWorkTurns;
    }

    public String getOccupationString() {
        return Messages.message(this.getId() + ".occupationString", new String[0]);
    }

    public String getArtOverlay() {
        return this.artOverlay;
    }

    public boolean isArtOverTrees() {
        return this.artOverTrees;
    }

    public TileImprovementType getRequiredImprovementType() {
        return this.requiredImprovementType;
    }

    public EquipmentType getExpendedEquipmentType() {
        return this.expendedEquipmentType;
    }

    public int getExpendedAmount() {
        return this.expendedAmount;
    }

    public GoodsType getDeliverGoodsType() {
        return this.deliverGoodsType;
    }

    public int getDeliverAmount() {
        return this.deliverAmount;
    }

    public boolean isWorkerTypeAllowed(UnitType unitType) {
        return this.allowedWorkers.isEmpty() || this.allowedWorkers.contains(unitType.getId());
    }

    public boolean isWorkerAllowed(Unit unit) {
        if (!this.isWorkerTypeAllowed(unit.getType())) {
            return false;
        }
        if (this.expendedAmount == 0) {
            return true;
        }
        int count = 0;
        for (EquipmentType equipmentType : unit.getEquipment()) {
            if (equipmentType != this.expendedEquipmentType || ++count < this.expendedAmount) continue;
            return true;
        }
        return false;
    }

    public boolean isTileTypeAllowed(TileType tileType) {
        return this.allowedTileTypes.indexOf(tileType) >= 0;
    }

    public boolean isTileAllowed(Tile tile) {
        if (!this.isTileTypeAllowed(tile.getType())) {
            return false;
        }
        if (this.requiredImprovementType != null && tile.findTileImprovementType(this.requiredImprovementType) == null) {
            return false;
        }
        TileImprovement ti = tile.findTileImprovementType(this);
        return ti == null || !ti.isComplete();
    }

    public int getBonus(GoodsType goodsType) {
        Modifier result = this.getProductionModifier(goodsType);
        if (result == null) {
            return 0;
        }
        return (int)result.getValue();
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        Set<Modifier> modifierSet = this.featureContainer.getModifierSet(goodsType.getId());
        if (modifierSet == null || modifierSet.isEmpty()) {
            return null;
        }
        if (modifierSet.size() > 1) {
            logger.warning("Only one Modifier for " + goodsType.getId() + " expected!");
        }
        return modifierSet.iterator().next();
    }

    public TileType getChange(TileType tileType) {
        return this.tileTypeChange.get(tileType);
    }

    public int getValue(TileType tileType, GoodsType goodsType) {
        List<GoodsType> goodsList = FreeCol.getSpecification().getGoodsTypeList();
        TileType newTileType = this.getChange(tileType);
        int value = 0;
        if (newTileType != null) {
            for (GoodsType g : goodsList) {
                if (!g.isFarmed()) continue;
                int change = newTileType.getProductionOf(g, null) - tileType.getProductionOf(g, null);
                if (goodsType == g) {
                    if (change < 0) {
                        return 0;
                    }
                    change *= 3;
                }
                value += change;
            }
        } else {
            for (Modifier modifier : this.featureContainer.getModifiers()) {
                float change = modifier.applyTo(1.0f);
                if (modifier.getId().equals(goodsType.getId())) {
                    if (change < 1.0f) {
                        return 0;
                    }
                    change *= 3.0f;
                }
                value = (int)((float)value + change);
            }
        }
        return value;
    }

    public int getMovementCost(int moveCost) {
        float cost2;
        int cost = moveCost;
        if (this.movementCostFactor >= 0.0f && (float)(cost = (int)(cost2 = (float)cost * this.movementCostFactor)) < cost2) {
            ++cost;
        }
        if (this.movementCost >= 0) {
            if (this.movementCost < cost) {
                return this.movementCost;
            }
            return cost;
        }
        return cost;
    }

    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.natural = this.getAttribute(in, "natural", false);
        this.addWorkTurns = this.getAttribute(in, "add-work-turns", 0);
        this.movementCost = this.getAttribute(in, "movement-cost", -1);
        this.movementCostFactor = -1.0f;
        this.magnitude = this.getAttribute(in, "magnitude", 1);
        this.requiredImprovementType = specification.getType(in, "required-improvement", TileImprovementType.class, null);
        this.artOverlay = this.getAttribute(in, "overlay", null);
        this.artOverTrees = this.getAttribute(in, "over-trees", false);
        this.expendedEquipmentType = specification.getType(in, "expended-equipment-type", EquipmentType.class, null);
        this.expendedAmount = this.getAttribute(in, "expended-amount", 0);
        this.deliverGoodsType = specification.getType(in, "deliver-goods-type", GoodsType.class, null);
        this.deliverAmount = this.getAttribute(in, "deliver-amount", 0);
    }

    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.allowedWorkers = new HashSet<String>();
        this.allowedTileTypes = new ArrayList<TileType>();
        this.tileTypeChange = new HashMap<TileType, TileType>();
        while (in.nextTag() != 2) {
            String childName = in.getLocalName();
            if ("tiles".equals(childName)) {
                boolean allLand = this.getAttribute(in, "all-land-tiles", false);
                boolean allForestUndefined = in.getAttributeValue(null, "all-forest-tiles") == null;
                boolean allForest = this.getAttribute(in, "all-forest-tiles", false);
                boolean allWater = this.getAttribute(in, "all-water-tiles", false);
                for (TileType t : specification.getTileTypeList()) {
                    if (t.isWater()) {
                        if (!allWater) continue;
                        this.allowedTileTypes.add(t);
                        continue;
                    }
                    if (t.isForested()) {
                        if ((!allLand || !allForestUndefined) && !allForest) continue;
                        this.allowedTileTypes.add(t);
                        continue;
                    }
                    if (!allLand) continue;
                    this.allowedTileTypes.add(t);
                }
                in.nextTag();
                continue;
            }
            if ("tile".equals(childName)) {
                String tileId = in.getAttributeValue(null, "id");
                if (this.getAttribute(in, "value", true)) {
                    this.allowedTileTypes.add(specification.getTileType(tileId));
                } else {
                    this.allowedTileTypes.remove(specification.getTileType(tileId));
                }
                in.nextTag();
                continue;
            }
            if ("worker".equals(childName)) {
                this.allowedWorkers.add(in.getAttributeValue(null, "id"));
                in.nextTag();
                continue;
            }
            if ("change".equals(childName)) {
                this.tileTypeChange.put(specification.getTileType(in.getAttributeValue(null, "from")), specification.getTileType(in.getAttributeValue(null, "to")));
                in.nextTag();
                continue;
            }
            super.readChild(in, specification);
        }
    }
}

