/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileItemContainer
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Location.class.getName());
    private List<TileImprovement> improvements = new ArrayList<TileImprovement>();
    private Resource resource = null;
    private TileImprovement road = null;
    private TileImprovement river = null;
    private Tile tile;

    public TileItemContainer(Game game, Tile tile) {
        super(game);
        if (tile == null) {
            throw new IllegalArgumentException("Tile must not be 'null'.");
        }
        this.tile = tile;
    }

    public TileItemContainer(Game game, Tile tile, Tile.PlayerExploredTile pet) {
        super(game);
        if (tile == null) {
            throw new IllegalArgumentException("Tile must not be 'null'.");
        }
        this.tile = tile;
        this.improvements = pet.getImprovements();
        this.resource = pet.getResource();
        this.road = pet.getRoad();
        this.river = pet.getRiver();
    }

    public TileItemContainer(Game game, Tile tile, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        if (tile == null) {
            throw new IllegalArgumentException("Tile must not be 'null'.");
        }
        this.tile = tile;
        this.readFromXML(in);
    }

    public TileItemContainer(Game game, Tile tile, Element e) {
        super(game, e);
        if (tile == null) {
            throw new IllegalArgumentException("Tile must not be 'null'.");
        }
        this.tile = tile;
        this.readFromXMLElement(e);
    }

    public TileItemContainer clone() {
        return this.clone(true, false);
    }

    public TileItemContainer clone(boolean importBonuses) {
        return this.clone(importBonuses, false);
    }

    public TileItemContainer clone(boolean importBonuses, boolean copyOnlyNatural) {
        TileItemContainer ticClone = new TileItemContainer(this.getGame(), this.getTile());
        ticClone.copyFrom(this, importBonuses, copyOnlyNatural);
        return ticClone;
    }

    public Tile getTile() {
        return this.tile;
    }

    public boolean hasRoad() {
        return this.road != null && this.road.isComplete();
    }

    public boolean hasRiver() {
        return this.river != null;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public TileImprovement getRoad() {
        return this.road;
    }

    public TileImprovement getRiver() {
        return this.river;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void clearResource() {
        if (this.hasResource()) {
            this.resource.dispose();
            this.resource = null;
        }
    }

    public void clear() {
        this.clearResource();
        for (TileImprovement t : this.improvements) {
            t.dispose();
        }
        this.improvements.clear();
        this.road = null;
        this.river = null;
    }

    public void removeIncompatibleImprovements() {
        TileType tileType = this.tile.getType();
        Iterator<TileImprovement> improvementIterator = this.getImprovementIterator();
        while (improvementIterator.hasNext()) {
            TileImprovement improvement = improvementIterator.next();
            if (improvement.getType().isTileTypeAllowed(tileType)) continue;
            improvementIterator.remove();
            if (improvement == this.road) {
                this.road = null;
            } else if (improvement == this.river) {
                this.river = null;
            }
            improvement.dispose();
        }
        if (this.resource != null && !tileType.canHaveResourceType(this.resource.getType())) {
            this.clearResource();
        }
    }

    public Iterator<TileImprovement> getImprovementIterator() {
        return this.getImprovements().iterator();
    }

    public List<TileImprovement> getImprovements() {
        return this.improvements;
    }

    public int getImprovementBonusPotential(GoodsType g) {
        int bonus = 0;
        for (TileImprovement ti : this.improvements) {
            bonus += ti.getBonus(g);
        }
        return bonus;
    }

    public int getResourceBonusPotential(GoodsType g, UnitType unitType, int potential) {
        if (this.hasResource()) {
            potential = this.resource.getBonus(g, unitType, potential);
        }
        return potential;
    }

    public int getTotalBonusPotential(GoodsType g, UnitType unitType, int tilePotential) {
        int potential = tilePotential + this.getImprovementBonusPotential(g);
        potential = this.getResourceBonusPotential(g, unitType, potential);
        return potential;
    }

    public Set<Modifier> getProductionBonus(GoodsType goodsType, UnitType unitType) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        if (this.resource != null) {
            result.addAll(this.resource.getType().getProductionModifier(goodsType, unitType));
        }
        for (TileImprovement improvement : this.improvements) {
            Modifier modifier = improvement.getProductionModifier(goodsType);
            if (modifier == null) continue;
            result.add(modifier);
        }
        return result;
    }

    public int getMoveCost(int basicMoveCost, Tile fromTile) {
        int moveCost = basicMoveCost;
        for (TileImprovement ti : this.improvements) {
            moveCost = ti.getMovementCost(moveCost, fromTile);
        }
        return moveCost;
    }

    public String getLabel(String separator) {
        String label = new String();
        for (TileImprovement ti : this.improvements) {
            if (!ti.isComplete()) continue;
            label = label + separator + Messages.message(ti.getName(), new String[0]);
        }
        return label;
    }

    public String getLabel() {
        return this.getLabel("/");
    }

    public TileItem addTileItem(TileItem t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Resource) {
            if (this.resource != null) {
                this.resource.dispose();
            }
            this.resource = (Resource)t;
            return t;
        }
        if (t instanceof TileImprovement) {
            TileImprovement improvement = (TileImprovement)t;
            String typeId = improvement.getType().getId();
            if (typeId != null) {
                for (TileImprovement imp : this.improvements) {
                    if (!imp.getType().getId().equals(typeId)) continue;
                    if (imp.getMagnitude() < improvement.getMagnitude()) {
                        this.removeTileItem(imp);
                        break;
                    }
                    return imp;
                }
            }
            if (improvement.isRoad()) {
                this.road = improvement;
            } else if (improvement.isRiver()) {
                this.river = improvement;
            }
            this.improvements.add(improvement);
            return improvement;
        }
        logger.warning("TileItem " + t.getClass().getSimpleName() + " has not be implemented yet.");
        return null;
    }

    public TileItem removeTileItem(TileItem t) {
        if (t == null) {
            return null;
        }
        if (t instanceof Resource && this.resource == t) {
            this.resource = null;
            return t;
        }
        if (t instanceof TileImprovement) {
            if (this.river == t) {
                this.river = null;
            } else if (this.road == t) {
                this.road = null;
            }
            return this.improvements.remove(t) ? t : null;
        }
        logger.warning("TileItem " + t.getClass().getSimpleName() + " has not be implemented yet.");
        return null;
    }

    public void copyFrom(TileItemContainer tic) {
        this.copyFrom(tic, true, false);
    }

    public void copyFrom(TileItemContainer tic, boolean importBonuses) {
        this.copyFrom(tic, importBonuses, false);
    }

    public void copyFrom(TileItemContainer tic, boolean importBonuses, boolean copyOnlyNatural) {
        this.clear();
        if (tic.hasResource() && importBonuses) {
            Resource ticR = tic.getResource();
            Resource r = new Resource(this.getGame(), this.tile, ticR.getType());
            r.setQuantity(ticR.getQuantity());
            this.addTileItem(r);
        }
        for (TileImprovement ti : tic.getImprovements()) {
            if (copyOnlyNatural && !ti.getType().isNatural()) continue;
            TileImprovement newTI = new TileImprovement(this.getGame(), this.tile, ti.getType());
            newTI.setMagnitude(ti.getMagnitude());
            newTI.setStyle(ti.getStyle());
            newTI.setTurnsToComplete(ti.getTurnsToComplete());
            this.addTileItem(newTI);
        }
    }

    public void removeAll() {
        this.clear();
    }

    public boolean contains(TileItem t) {
        if (t instanceof Resource) {
            return (Resource)t == this.resource;
        }
        if (t instanceof TileImprovement) {
            return this.improvements.indexOf(t) >= 0;
        }
        return false;
    }

    public TileImprovement findTileImprovementType(TileImprovementType type) {
        for (TileImprovement ti : this.improvements) {
            if (ti.getType() != type) continue;
            return ti;
        }
        return null;
    }

    public boolean hasImprovement(TileImprovementType type) {
        TileImprovement improvement = this.findTileImprovementType(type);
        return improvement != null && improvement.isComplete();
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }

    public TileImprovement addRiver(int magnitude, int style) {
        if (magnitude == 0) {
            return null;
        }
        if (!this.hasRiver()) {
            this.river = new TileImprovement(this.getGame(), this.tile, FreeCol.getSpecification().getTileImprovementType("model.improvement.River"));
            this.addTileItem(this.river);
        }
        this.river.setMagnitude(magnitude);
        this.river.setStyle(style);
        return this.river;
    }

    public TileImprovement removeRiver() {
        return (TileImprovement)this.removeTileItem(this.river);
    }

    public int getRiverStyle() {
        if (this.river == null) {
            return 0;
        }
        return this.river.getStyle();
    }

    public void disposeAllTileItems() {
        this.clear();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(TileItemContainer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("tile", this.tile.getId());
        if (this.hasResource()) {
            this.resource.toXML(out, player, showAll, toSavedGame);
        }
        Iterator<TileImprovement> ti = this.getImprovementIterator();
        while (ti.hasNext()) {
            TileImprovement t = ti.next();
            t.toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.tile = (Tile)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "tile"));
        if (this.tile == null) {
            this.tile = new Tile(this.getGame(), in.getAttributeValue(null, "tile"));
        }
        this.improvements.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(Resource.getXMLElementTagName())) {
                this.resource = (Resource)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (this.resource == null) {
                    this.resource = new Resource(this.getGame(), in);
                    continue;
                }
                this.resource.readFromXML(in);
                continue;
            }
            if (!in.getLocalName().equals(TileImprovement.getXMLElementTagName())) continue;
            TileImprovement ti = (TileImprovement)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
            if (ti == null) {
                ti = new TileImprovement(this.getGame(), in);
                this.improvements.add(ti);
            } else {
                ti.readFromXML(in);
                if (!this.improvements.contains(ti)) {
                    this.improvements.add(ti);
                }
            }
            if (ti.isRoad()) {
                this.road = ti;
                continue;
            }
            if (!ti.isRiver()) continue;
            this.river = ti;
        }
    }

    public static String getXMLElementTagName() {
        return "tileitemcontainer";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append("TileItemContainer with: ");
        if (this.hasResource()) {
            sb.append(this.resource.toString() + ", ");
        }
        for (TileImprovement i : this.improvements) {
            sb.append(i.toString() + ", ");
        }
        return sb.toString();
    }
}

