/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TileType
extends FreeColGameObjectType {
    private String artBasic;
    private String artOverlay;
    private String artForest;
    private String artCoast;
    private Color minimapColor;
    private boolean forest;
    private boolean water;
    private boolean canSettle;
    private boolean canHaveRiver;
    private int basicMoveCost;
    private int basicWorkTurns;
    private int[] humidity = new int[2];
    private int[] temperature = new int[2];
    private int[] altitude = new int[2];
    private List<RandomChoice<ResourceType>> resourceType;
    private GoodsType secondaryGoods = null;
    private boolean connected;
    private List<AbstractGoods> production;

    public TileType(int index) {
        this.setIndex(index);
    }

    public String getArtBasic() {
        return this.artBasic;
    }

    public String getArtOverlay() {
        return this.artOverlay;
    }

    public String getArtForest() {
        return this.artForest;
    }

    public String getArtCoast() {
        return this.artCoast;
    }

    public Color getMinimapColor() {
        return this.minimapColor;
    }

    public boolean isForested() {
        return this.forest;
    }

    public boolean isWater() {
        return this.water;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean canSettle() {
        return this.canSettle;
    }

    public boolean canHaveRiver() {
        return this.canHaveRiver;
    }

    public int getBasicMoveCost() {
        return this.basicMoveCost;
    }

    public int getBasicWorkTurns() {
        return this.basicWorkTurns;
    }

    public Set<Modifier> getDefenceBonus() {
        return this.getModifierSet("model.modifier.defence");
    }

    public int getProductionOf(GoodsType goodsType, UnitType unitType) {
        return (int)this.featureContainer.applyModifier(0.0f, goodsType.getId(), unitType);
    }

    public Set<Modifier> getProductionBonus(GoodsType goodsType) {
        return this.featureContainer.getModifierSet(goodsType.getId());
    }

    public GoodsType getSecondaryGoods() {
        return this.secondaryGoods;
    }

    public List<AbstractGoods> getProduction() {
        return this.production;
    }

    public List<RandomChoice<ResourceType>> getWeightedResources() {
        return this.resourceType;
    }

    public List<ResourceType> getResourceTypeList() {
        ArrayList<ResourceType> result = new ArrayList<ResourceType>();
        for (RandomChoice<ResourceType> resource : this.resourceType) {
            result.add(resource.getObject());
        }
        return result;
    }

    public boolean canHaveResourceType(ResourceType resourceType) {
        return this.getResourceTypeList().contains(resourceType);
    }

    public boolean withinRange(RangeType rangeType, int value) {
        switch (rangeType) {
            case HUMIDITY: {
                return this.humidity[0] <= value && value <= this.humidity[1];
            }
            case TEMPERATURE: {
                return this.temperature[0] <= value && value <= this.temperature[1];
            }
            case ALTITUDE: {
                return this.altitude[0] <= value && value <= this.altitude[1];
            }
        }
        return false;
    }

    @Override
    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.basicMoveCost = Integer.parseInt(in.getAttributeValue(null, "basic-move-cost"));
        this.basicWorkTurns = Integer.parseInt(in.getAttributeValue(null, "basic-work-turns"));
        this.forest = this.getAttribute(in, "is-forest", false);
        this.water = this.getAttribute(in, "is-water", false);
        this.canSettle = this.getAttribute(in, "can-settle", !this.water);
        this.connected = this.getAttribute(in, "is-connected", false);
        boolean bl = this.canHaveRiver = !this.getAttribute(in, "no-river", this.water);
        if (!this.water && this.canSettle) {
            this.secondaryGoods = specification.getGoodsType(in.getAttributeValue(null, "secondary-goods"));
        }
    }

    @Override
    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.artBasic = null;
        this.production = new ArrayList<AbstractGoods>();
        this.resourceType = new ArrayList<RandomChoice<ResourceType>>();
        while (in.nextTag() != 2) {
            FreeColGameObjectType type;
            String childName = in.getLocalName();
            if ("art".equals(childName)) {
                this.artBasic = in.getAttributeValue(null, "basic");
                this.artOverlay = in.getAttributeValue(null, "overlay");
                this.artForest = in.getAttributeValue(null, "forest");
                this.artCoast = this.getAttribute(in, "coast", this.water ? null : "terrain/beach/");
                float[] defaultArray = new float[]{0.0f, 0.0f, 0.0f};
                this.minimapColor = new Color(Integer.decode(in.getAttributeValue(null, "minimap-color")));
                in.nextTag();
                continue;
            }
            if ("gen".equals(childName)) {
                this.humidity[0] = this.getAttribute(in, "humidityMin", 0);
                this.humidity[1] = this.getAttribute(in, "humidityMax", 100);
                this.temperature[0] = this.getAttribute(in, "temperatureMin", -20);
                this.temperature[1] = this.getAttribute(in, "temperatureMax", 40);
                this.altitude[0] = this.getAttribute(in, "altitudeMin", 0);
                this.altitude[1] = this.getAttribute(in, "altitudeMax", 0);
                in.nextTag();
                continue;
            }
            if ("production".equals(childName)) {
                type = specification.getGoodsType(in.getAttributeValue(null, "goods-type"));
                int amount = Integer.parseInt(in.getAttributeValue(null, "value"));
                this.production.add(new AbstractGoods((GoodsType)type, amount));
                this.addModifier(new Modifier(type.getId(), this, amount, Modifier.Type.ADDITIVE));
                in.nextTag();
                continue;
            }
            if ("resource".equals(childName)) {
                type = specification.getResourceType(in.getAttributeValue(null, "type"));
                int probability = this.getAttribute(in, "probability", 100);
                this.resourceType.add(new RandomChoice<GoodsType>((GoodsType)type, probability));
                in.nextTag();
                continue;
            }
            super.readChild(in, specification);
        }
        if (this.artBasic == null) {
            throw new RuntimeException("TileType " + this.getId() + " has no art defined!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RangeType {
        HUMIDITY,
        TEMPERATURE,
        ALTITUDE;

    }
}

