/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeRoute
extends FreeColGameObject
implements Cloneable,
Ownable {
    public static final TradeRoute NO_TRADE_ROUTE = new TradeRoute();
    private String name;
    private boolean modified = false;
    private Player owner;
    private ArrayList<Stop> stops = new ArrayList();

    private TradeRoute() {
    }

    public TradeRoute(Game game, String name, Player player) {
        super(game);
        this.name = name;
        this.owner = player;
    }

    public TradeRoute(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public TradeRoute(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public synchronized void updateFrom(TradeRoute other) {
        this.setName(other.getName());
        this.stops.clear();
        for (Stop otherStop : other.getStops()) {
            this.addStop(new Stop(otherStop));
        }
    }

    public final boolean isModified() {
        return this.modified;
    }

    public final void setModified(boolean newModified) {
        this.modified = newModified;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String newName) {
        this.name = newName;
    }

    public void addStop(Stop stop) {
        this.stops.add(stop);
    }

    @Override
    public final Player getOwner() {
        return this.owner;
    }

    @Override
    public final void setOwner(Player newOwner) {
        this.owner = newOwner;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public final ArrayList<Stop> getStops() {
        return this.stops;
    }

    public final void setStops(ArrayList<Stop> newStops) {
        this.stops = newStops;
    }

    public void newTurn() {
    }

    public TradeRoute clone() {
        try {
            TradeRoute copy = (TradeRoute)super.clone();
            copy.replaceStops(this.getStops());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone should be supported!", e);
        }
    }

    private void replaceStops(List<Stop> otherStops) {
        this.stops = new ArrayList();
        for (Stop otherStop : otherStops) {
            this.addStop(new Stop(otherStop));
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(TradeRoute.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("name", this.getName());
        out.writeAttribute("owner", this.getOwner().getId());
        for (Stop stop : this.stops) {
            stop.toXMLImpl(out);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.setName(in.getAttributeValue(null, "name"));
        String ownerID = in.getAttributeValue(null, "owner");
        Game game = this.getGame();
        if (game != null) {
            if (ownerID.equals("unknown enemy")) {
                this.owner = game.getUnknownEnemy();
            } else {
                this.owner = (Player)this.getGame().getFreeColGameObject(ownerID);
                if (this.owner == null) {
                    this.owner = new Player(this.getGame(), in.getAttributeValue(null, "owner"));
                }
            }
        }
        while (in.nextTag() != 2) {
            if (!TradeRoute.getStopXMLElementTagName().equals(in.getLocalName())) continue;
            this.stops.add(new Stop(in));
        }
    }

    public static boolean isStopValid(Unit unit, Stop stop) {
        return TradeRoute.isStopValid(unit.getOwner(), stop);
    }

    public static boolean isStopValid(Player player, Stop stop) {
        if (stop == null) {
            return false;
        }
        Location location = stop.getLocation();
        if (location == null) {
            return false;
        }
        return !(location instanceof Europe) || player.getPlayerType() != Player.PlayerType.REBEL;
    }

    public static String getXMLElementTagName() {
        return "tradeRoute";
    }

    public static String getStopXMLElementTagName() {
        return "tradeRouteStop";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Stop {
        private String locationId;
        private ArrayList<GoodsType> cargo = new ArrayList();
        private boolean modified = false;

        public Stop(Location location) {
            this.locationId = location.getId();
        }

        private Stop(Stop other) {
            this.locationId = other.locationId;
            this.cargo = new ArrayList<GoodsType>(other.cargo);
        }

        private Stop(XMLStreamReader in) throws XMLStreamException {
            this.locationId = in.getAttributeValue(null, "location");
            List<GoodsType> goodsList = FreeCol.getSpecification().getGoodsTypeList();
            for (int cargoIndex : TradeRoute.this.readFromArrayElement("cargo", in, new int[0])) {
                this.addCargo(goodsList.get(cargoIndex));
            }
            in.nextTag();
        }

        public final boolean isModified() {
            return this.modified;
        }

        public final void setModified(boolean newModified) {
            this.modified = newModified;
        }

        public final Location getLocation() {
            Game g = TradeRoute.this.getGame();
            return g != null ? (Location)((Object)g.getFreeColGameObject(this.locationId)) : null;
        }

        public final ArrayList<GoodsType> getCargo() {
            return (ArrayList)this.cargo.clone();
        }

        public final void setCargo(ArrayList<GoodsType> cargo) {
            this.cargo.clear();
            this.cargo.addAll(cargo);
        }

        public void addCargo(GoodsType newCargo) {
            this.cargo.add(newCargo);
        }

        public String toString() {
            Location l = this.getLocation();
            return l != null ? l.getLocationName() : Messages.message("traderouteDialog.invalidStop", new String[0]);
        }

        public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
            out.writeStartElement(TradeRoute.getStopXMLElementTagName());
            out.writeAttribute("location", this.locationId);
            int[] cargoIndexArray = new int[this.cargo.size()];
            for (int index = 0; index < cargoIndexArray.length; ++index) {
                cargoIndexArray[index] = this.cargo.get(index).getIndex();
            }
            TradeRoute.this.toArrayElement("cargo", cargoIndexArray, out);
            out.writeEndElement();
        }
    }
}

