/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeRouteStop {
    private Location location;
    private boolean modified = false;
    private List<AbstractGoods> goodsToUnload;
    private List<AbstractGoods> goodsToLoad;

    public TradeRouteStop(Location location) {
        this.location = location;
    }

    public final List<AbstractGoods> getGoodsToLoad() {
        return this.goodsToLoad;
    }

    public final void setGoodsToLoad(List<AbstractGoods> newGoodsToLoad) {
        this.goodsToLoad = newGoodsToLoad;
    }

    public final List<AbstractGoods> getGoodsToUnload() {
        return this.goodsToUnload;
    }

    public final void setGoodsToUnload(List<AbstractGoods> newGoodsToUnload) {
        this.goodsToUnload = newGoodsToUnload;
    }

    public final boolean isModified() {
        return this.modified;
    }

    public final void setModified(boolean newModified) {
        this.modified = newModified;
    }

    public final Location getLocation() {
        return this.location;
    }

    public void setLocation(Location newLocation) {
        this.location = newLocation;
    }

    public String toString() {
        if (this.location == null) {
            return null;
        }
        return this.location.getLocationName();
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(TradeRouteStop.getXMLElementTagName());
        out.writeAttribute("location", this.location.getId());
        if (this.goodsToUnload != null) {
            out.writeStartElement("goodsToUnload");
            for (AbstractGoods goods : this.goodsToUnload) {
                goods.toXML(out);
            }
            out.writeEndElement();
        }
        if (this.goodsToLoad != null) {
            out.writeStartElement("goodsToLoad");
            for (AbstractGoods goods : this.goodsToLoad) {
                goods.toXML(out);
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLImpl(in, null);
    }

    protected void readFromXMLImpl(XMLStreamReader in, Game game) throws XMLStreamException {
        if (game != null) {
            this.location = (Location)((Object)game.getFreeColGameObject(in.getAttributeValue(null, "location")));
        }
        while (in.nextTag() != 2) {
            AbstractGoods goods;
            if (in.getLocalName().equals("goodsToUnload")) {
                this.goodsToUnload = new ArrayList<AbstractGoods>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(AbstractGoods.getXMLElementTagName())) continue;
                    goods = new AbstractGoods();
                    goods.readFromXML(in);
                    this.goodsToUnload.add(goods);
                }
                continue;
            }
            if (!in.getLocalName().equals("goodsToLoad")) continue;
            this.goodsToLoad = new ArrayList<AbstractGoods>();
            while (in.nextTag() != 2) {
                if (!in.getLocalName().equals(AbstractGoods.getXMLElementTagName())) continue;
                goods = new AbstractGoods();
                goods.readFromXML(in);
                this.goodsToLoad.add(goods);
            }
        }
    }

    public static String getXMLElementTagName() {
        return "tradeRouteStop";
    }
}

