/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.client.gui.i18n.Messages;

public class Turn {
    public static final int STARTING_YEAR = 1492;
    public static final int SEASON_YEAR = 1600;
    private int turn;

    public Turn(int turn) {
        this.turn = turn;
    }

    public void increase() {
        ++this.turn;
    }

    public int getNumber() {
        return this.turn;
    }

    public void setNumber(int turn) {
        this.turn = turn;
    }

    public int getAge() {
        if (this.getYear() < 1600) {
            return 1;
        }
        if (this.getYear() < 1700) {
            return 2;
        }
        return 3;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Turn)) {
            return false;
        }
        return this.turn == ((Turn)o).turn;
    }

    public static int getYear(int turn) {
        if (1492 + turn - 1 < 1600) {
            return 1492 + turn - 1;
        }
        int c = turn - 107;
        return 1600 + c / 2 - 1;
    }

    public int getYear() {
        return Turn.getYear(this.turn);
    }

    public String toString() {
        return Turn.toString(this.turn);
    }

    public static String toString(int turn) {
        if (1492 + turn - 1 < 1600) {
            return Integer.toString(1492 + turn - 1);
        }
        int c = turn - 107;
        return (c % 2 == 0 ? Messages.message("spring", new String[0]) : Messages.message("autumn", new String[0])) + " " + Integer.toString(1600 + c / 2 - 1);
    }

    public String toSaveGameString() {
        if (1492 + this.turn - 1 < 1600) {
            return Integer.toString(1492 + this.turn - 1);
        }
        int c = this.turn - 107;
        String result = Integer.toString(1600 + c / 2 - 1);
        result = c % 2 == 0 ? result + "_1_" + Messages.message("spring", new String[0]) : result + "_2_" + Messages.message("autumn", new String[0]);
        return result;
    }
}

