/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.EmptyIterator;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unit
extends FreeColGameObject
implements Locatable,
Location,
Ownable,
Nameable {
    private static final Logger logger = Logger.getLogger(Unit.class.getName());
    private static final String EQUIPMENT_TAG = "equipment";
    private static final String UNITS_TAG_NAME = "units";
    public static final int TURNS_TO_SAIL = Specification.getSpecification().getIntegerOption("model.option.turnsToSail").getValue();
    private UnitType unitType;
    private boolean naval;
    private int movesLeft;
    private UnitState state = UnitState.ACTIVE;
    private Role role = Role.DEFAULT;
    private int workLeft;
    private int hitpoints;
    private Player owner;
    private List<Unit> units = Collections.emptyList();
    private GoodsContainer goodsContainer;
    private Location entryLocation;
    private Location location;
    private IndianSettlement indianSettlement = null;
    private Location destination = null;
    private TradeRoute tradeRoute = null;
    private int currentStop = -1;
    private int treasureAmount;
    private TileImprovement workImprovement;
    private GoodsType workType;
    private int experience = 0;
    private int turnsOfTraining = 0;
    private int attrition = 0;
    private String name = null;
    private int visibleGoodsCount;
    private boolean alreadyOnHighSea = false;
    private Unit student;
    private Unit teacher;
    private List<EquipmentType> equipment = new ArrayList<EquipmentType>();

    public Unit(Game game, Player owner, UnitType type) {
        this(game, null, owner, type, UnitState.ACTIVE);
    }

    public Unit(Game game, Location location, Player owner, UnitType type, UnitState state) {
        this(game, location, owner, type, state, type.getDefaultEquipment());
    }

    public Unit(Game game, Location location, Player owner, UnitType type, UnitState state, EquipmentType ... initialEquipment) {
        super(game);
        this.visibleGoodsCount = -1;
        if (type.canCarryGoods()) {
            this.goodsContainer = new GoodsContainer(game, this);
        }
        this.owner = owner;
        this.unitType = type;
        this.naval = this.unitType.hasAbility("model.ability.navalUnit");
        this.setLocation(location);
        this.workLeft = -1;
        this.workType = Goods.FOOD;
        this.movesLeft = this.getInitialMovesLeft();
        this.hitpoints = this.unitType.getHitPoints();
        for (EquipmentType equipmentType : initialEquipment) {
            if (EquipmentType.NO_EQUIPMENT.equals(equipmentType)) {
                this.equipment.clear();
                break;
            }
            this.equipment.add(equipmentType);
        }
        this.setRole();
        this.setStateUnchecked(state);
        this.getOwner().setUnit(this);
        this.getOwner().invalidateCanSeeTiles();
        this.getOwner().modifyScore(type.getScoreValue());
    }

    public Unit(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
        this.getOwner().setUnit(this);
    }

    public Unit(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
        this.getOwner().setUnit(this);
    }

    public Unit(Game game, String id) {
        super(game, id);
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    @Override
    public String getLocationName() {
        return Messages.message("onBoard", "%unit%", this.getName());
    }

    public final UnitType getType() {
        return this.unitType;
    }

    public int getTreasureAmount() {
        if (this.canCarryTreasure()) {
            return this.treasureAmount;
        }
        throw new IllegalStateException("Unit can't carry treasure");
    }

    public void setTreasureAmount(int amt) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Unit can't carry treasure");
        }
        this.treasureAmount = amt;
    }

    public final List<EquipmentType> getEquipment() {
        return this.equipment;
    }

    public final void setEquipment(List<EquipmentType> newEquipment) {
        this.equipment = newEquipment;
    }

    public final TradeRoute getTradeRoute() {
        return this.tradeRoute;
    }

    public final void setTradeRoute(TradeRoute newTradeRoute) {
        ArrayList<TradeRoute.Stop> stops;
        this.tradeRoute = newTradeRoute;
        if (newTradeRoute != null && (stops = newTradeRoute.getStops()).size() > 0) {
            this.setDestination(newTradeRoute.getStops().get(0).getLocation());
            this.currentStop = 0;
        }
    }

    public TradeRoute.Stop getCurrentStop() {
        ArrayList<TradeRoute.Stop> stops = this.getTradeRoute().getStops();
        if (this.currentStop < 0 || this.currentStop >= stops.size()) {
            this.currentStop = 0;
        }
        return stops.get(this.currentStop);
    }

    public TradeRoute.Stop nextStop() {
        TradeRoute.Stop stop;
        ArrayList<TradeRoute.Stop> stops = this.getTradeRoute().getStops();
        if (stops.size() == 0) {
            this.currentStop = -1;
            this.setDestination(null);
            return null;
        }
        int oldStop = this.currentStop;
        do {
            ++this.currentStop;
            if (this.currentStop < stops.size()) continue;
            this.currentStop = 0;
        } while (!this.shouldGoToStop(stop = stops.get(this.currentStop)) && this.currentStop != oldStop);
        this.setDestination(stop.getLocation());
        return stop;
    }

    public boolean shouldGoToStop(TradeRoute.Stop stop) {
        ArrayList<GoodsType> goodsTypes = stop.getCargo();
        for (Goods goods : this.getGoodsList()) {
            boolean unload = true;
            for (int index = 0; index < goodsTypes.size(); ++index) {
                if (goods.getType() != goodsTypes.get(index)) continue;
                goodsTypes.remove(index);
                unload = false;
                break;
            }
            if (!unload) continue;
            return true;
        }
        return this.getSpaceLeft() > 0 && goodsTypes.size() > 0;
    }

    public void trade(Settlement settlement, Goods goods, int gold) {
        if (this.getTile().getDistanceTo(settlement.getTile()) > 1) {
            logger.warning("Unit not adjacent to settlement!");
            throw new IllegalStateException("Unit not adjacent to settlement!");
        }
        if (goods.getLocation() != this) {
            logger.warning("Goods not onboard this unit!");
            throw new IllegalStateException("Goods not onboard this unit!");
        }
        goods.setLocation(settlement);
        if (settlement.getOwner().getGold() - gold >= 0) {
            settlement.getOwner().modifyGold(-gold);
        }
        this.getOwner().modifyGold(gold);
        this.getOwner().modifySales(goods.getType(), goods.getAmount());
        this.getOwner().modifyIncomeBeforeTaxes(goods.getType(), gold);
        this.getOwner().modifyIncomeAfterTaxes(goods.getType(), gold);
        if (settlement instanceof IndianSettlement) {
            IndianSettlement nativeSettlement = (IndianSettlement)settlement;
            int value = nativeSettlement.getPrice(goods) / 1000;
            nativeSettlement.modifyAlarm(this.getOwner(), -value * 2);
        }
    }

    public void buy(IndianSettlement settlement, Goods goods, int gold) {
        if (this.getTile().getDistanceTo(settlement.getTile()) > 1) {
            logger.warning("Unit not adjacent to settlement!");
            throw new IllegalStateException("Unit not adjacent to settlement!");
        }
        if (goods.getLocation() != settlement) {
            logger.warning("Goods not in the settlement!");
            throw new IllegalStateException("Goods not in the settlement!");
        }
        goods.setLocation(this);
        settlement.getOwner().modifyGold(gold);
        this.getOwner().modifyGold(-gold);
        settlement.modifyAlarm(this.getOwner(), -gold / 50);
    }

    public void deliverGift(Settlement settlement, Goods goods) {
        if (this.getTile().getDistanceTo(settlement.getTile()) > 1) {
            logger.warning("Unit not adjacent to settlement!");
            throw new IllegalStateException("Unit not adjacent to settlement!");
        }
        if (goods.getLocation() != this) {
            logger.warning("Goods not onboard this unit!");
            throw new IllegalStateException("Goods not onboard this unit!");
        }
        int amount = goods.getAmount();
        goods.setLocation(settlement);
        if (settlement instanceof IndianSettlement) {
            int value = ((IndianSettlement)settlement).getPrice(goods) / 100;
            ((IndianSettlement)settlement).modifyAlarm(this.getOwner(), -value * 2);
        } else {
            this.addModelMessage((FreeColGameObject)settlement, ModelMessage.MessageType.GIFT_GOODS, goods.getType(), "model.unit.gift", "%player%", this.getOwner().getNationAsString(), "%type%", goods.getName(), "%amount%", Integer.toString(amount), "%colony%", ((Colony)settlement).getName());
        }
    }

    public boolean canCashInTreasureTrain() {
        return this.canCashInTreasureTrain(this.getLocation());
    }

    public boolean canCashInTreasureTrain(Location loc) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Can't carry treasure");
        }
        if (this.getOwner().getEurope() != null) {
            return loc.getColony() != null && !loc.getColony().isLandLocked() || loc instanceof Europe || loc instanceof Unit && ((Unit)loc).getLocation() instanceof Europe;
        }
        return loc.getColony() != null;
    }

    public int getTransportFee() {
        if (this.canCashInTreasureTrain() && !this.isInEurope() && this.getOwner().getEurope() != null) {
            return (int)this.getOwner().getFeatureContainer().applyModifier((float)this.getTreasureAmount() / 2.0f, "model.modifier.treasureTransportFee", this.unitType, this.getGame().getTurn());
        }
        return 0;
    }

    public void cashInTreasureTrain() {
        FreeColGameObject owner;
        int cashInAmount;
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Unit with ID " + this.getId() + " can't carry a treasure");
        }
        if (this.canCashInTreasureTrain()) {
            cashInAmount = this.getTreasureAmount() - this.getTransportFee();
            cashInAmount = cashInAmount * (100 - this.getOwner().getTax()) / 100;
            owner = this.getOwner();
            if (this.isInEurope()) {
                owner = this.getOwner().getEurope();
            }
        } else {
            throw new IllegalStateException("Cannot cash in treasure train at the current location.");
        }
        this.getOwner().modifyGold(cashInAmount);
        this.addModelMessage(owner, ModelMessage.MessageType.DEFAULT, "model.unit.cashInTreasureTrain", "%amount%", Integer.toString(this.getTreasureAmount()), "%cashInAmount%", Integer.toString(cashInAmount));
        this.dispose();
    }

    public boolean isColonist() {
        return this.unitType.hasAbility("model.ability.foundColony");
    }

    public int getNeededTurnsOfTraining() {
        if (this.student != null) {
            return Unit.getNeededTurnsOfTraining(this.unitType, this.student.unitType);
        }
        return 0;
    }

    public static int getNeededTurnsOfTraining(UnitType typeTeacher, UnitType typeStudent) {
        UnitType teaching = Unit.getUnitTypeTeaching(typeTeacher, typeStudent);
        if (teaching != null) {
            return typeStudent.getEducationTurns(teaching);
        }
        throw new IllegalStateException();
    }

    public static UnitType getUnitTypeTeaching(UnitType typeTeacher, UnitType typeStudent) {
        if (typeStudent.canBeUpgraded(typeTeacher, UnitType.UpgradeType.EDUCATION)) {
            return typeTeacher;
        }
        return typeStudent.getEducationUnit(0);
    }

    public int getSkillLevel() {
        return Unit.getSkillLevel(this.unitType);
    }

    public static int getSkillLevel(UnitType unitType) {
        if (unitType.hasSkill()) {
            return unitType.getSkill();
        }
        return 0;
    }

    public int getTurnsOfTraining() {
        return this.turnsOfTraining;
    }

    public void setTurnsOfTraining(int turnsOfTraining) {
        this.turnsOfTraining = turnsOfTraining;
    }

    public int getExperience() {
        return this.experience;
    }

    public void modifyExperience(int value) {
        this.experience += value;
    }

    public boolean hasAbility(String id) {
        HashSet<Ability> result = new HashSet<Ability>();
        result.addAll(this.unitType.getFeatureContainer().getAbilitySet(id));
        result.addAll(this.getOwner().getFeatureContainer().getAbilitySet(id, this.unitType, this.getGame().getTurn()));
        for (EquipmentType equipmentType : this.equipment) {
            result.addAll(equipmentType.getFeatureContainer().getAbilitySet(id));
        }
        return FeatureContainer.hasAbility(result);
    }

    public Set<Modifier> getModifierSet(String id) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(this.unitType.getFeatureContainer().getModifierSet(id));
        result.addAll(this.getOwner().getFeatureContainer().getModifierSet(id, this.unitType, this.getGame().getTurn()));
        for (EquipmentType equipmentType : this.equipment) {
            result.addAll(equipmentType.getFeatureContainer().getModifierSet(id));
        }
        return result;
    }

    public void addFeature(Feature feature) {
        throw new UnsupportedOperationException("Can not add Feature to Unit directly!");
    }

    public boolean canBeStudent(Unit teacher) {
        return Unit.canBeStudent(this.unitType, teacher.unitType);
    }

    public static boolean canBeStudent(UnitType typeStudent, UnitType typeTeacher) {
        return Unit.getUnitTypeTeaching(typeTeacher, typeStudent) != null;
    }

    public final Unit getStudent() {
        return this.student;
    }

    public final void setStudent(Unit newStudent) {
        if (newStudent == null) {
            this.student = null;
        } else if (newStudent.getColony() != null && newStudent.getColony() == this.getColony() && newStudent.canBeStudent(this)) {
            this.student = newStudent;
        } else {
            throw new IllegalStateException("unit can not be student: " + newStudent.getName());
        }
    }

    public final Unit getTeacher() {
        return this.teacher;
    }

    public final void setTeacher(Unit newTeacher) {
        if (newTeacher == null) {
            this.teacher = null;
        } else {
            UnitType skillTaught = FreeCol.getSpecification().getUnitType(newTeacher.getType().getSkillTaught());
            if (newTeacher.getColony() != null && newTeacher.getColony() == this.getColony() && this.getColony().canTrain(skillTaught)) {
                this.teacher = newTeacher;
            } else {
                throw new IllegalStateException("unit can not be teacher: " + newTeacher.getName());
            }
        }
    }

    public Building getWorkLocation() {
        if (this.getLocation() instanceof Building) {
            return (Building)this.getLocation();
        }
        return null;
    }

    public ColonyTile getWorkTile() {
        if (this.getLocation() instanceof ColonyTile) {
            return (ColonyTile)this.getLocation();
        }
        return null;
    }

    public GoodsType getWorkType() {
        if (this.getLocation() instanceof Building) {
            return ((Building)this.getLocation()).getGoodsOutputType();
        }
        return this.workType;
    }

    public void setWorkType(GoodsType type) {
        if (this.workType != type) {
            this.experience = 0;
        }
        if (type.isFarmed()) {
            this.workType = type;
        }
    }

    public TileImprovement getWorkImprovement() {
        return this.workImprovement;
    }

    public void setWorkImprovement(TileImprovement imp) {
        this.workImprovement = imp;
    }

    public Location getDestination() {
        return this.destination;
    }

    public void setDestination(Location newDestination) {
        this.destination = newDestination;
    }

    public PathNode findPath(Tile end) {
        if (this.getTile() == null) {
            logger.warning("getTile() == null for " + this.getName() + " at location: " + this.getLocation());
        }
        return this.findPath(this.getTile(), end);
    }

    public PathNode findPath(Tile start, Tile end) {
        Location dest = this.getDestination();
        this.setDestination(end);
        PathNode path = this.getGame().getMap().findPath(this, start, end);
        this.setDestination(dest);
        return path;
    }

    public int getTurnsToReach(Tile end) {
        return this.getTurnsToReach(this.getTile(), end);
    }

    public int getTurnsToReach(Tile start, Tile end) {
        PathNode p;
        if (start == end) {
            return 0;
        }
        if (this.isOnCarrier()) {
            Location dest = this.getDestination();
            this.setDestination(end);
            PathNode p2 = this.getGame().getMap().findPath(this, start, end, (Unit)this.getLocation());
            this.setDestination(dest);
            if (p2 != null) {
                return p2.getTotalTurns();
            }
        }
        if ((p = this.findPath(start, end)) != null) {
            return p.getTotalTurns();
        }
        return Integer.MAX_VALUE;
    }

    public int getTurnsToReach(Location destination) {
        if (destination == null) {
            logger.log(Level.WARNING, "destination == null", new Throwable());
        }
        if (this.getTile() == null) {
            PathNode p;
            if (destination.getTile() == null) {
                return 0;
            }
            if (this.isOnCarrier()) {
                Unit carrier = (Unit)this.getLocation();
                p = this.getGame().getMap().findPath(this, (Tile)carrier.getEntryLocation(), destination.getTile(), carrier);
            } else {
                p = this.getGame().getMap().findPath((Tile)this.getOwner().getEntryLocation(), destination.getTile(), Map.PathType.BOTH_LAND_AND_SEA);
            }
            if (p != null) {
                return p.getTotalTurns();
            }
            return Integer.MAX_VALUE;
        }
        if (destination.getTile() == null) {
            return 10;
        }
        return this.getTurnsToReach(destination.getTile());
    }

    public int getMoveCost(Tile target) {
        return this.getMoveCost(this.getTile(), target, this.getMovesLeft());
    }

    public int getMoveCost(Tile from, Tile target, int ml) {
        int cost = target.getMoveCost(from);
        if (cost > ml) {
            if ((ml + 2 >= this.getInitialMovesLeft() || cost <= ml + 2) && ml != 0) {
                return ml;
            }
            return cost;
        }
        if (this.isNaval() && from.isLand() && from.getSettlement() == null) {
            return ml;
        }
        return cost;
    }

    public boolean canTradeWith(Settlement settlement) {
        return this.canCarryGoods() && this.goodsContainer.getGoodsCount() > 0 && this.getOwner().getStance(settlement.getOwner()) != Player.Stance.WAR && (settlement instanceof IndianSettlement || this.hasAbility("model.ability.tradeWithForeignColonies"));
    }

    public MoveType getMoveType(Map.Direction direction) {
        if (this.getTile() == null) {
            throw new IllegalStateException("getTile() == null");
        }
        Tile target = this.getGame().getMap().getNeighbourOrNull(direction, this.getTile());
        return this.getMoveType(target);
    }

    public MoveType getMoveType(Tile target) {
        return this.getMoveType(this.getTile(), target, this.getMovesLeft());
    }

    public MoveType getMoveType(Tile from, Tile target, int ml) {
        if (this.isUnderRepair()) {
            return MoveType.ILLEGAL_MOVE;
        }
        if (ml <= 0) {
            return MoveType.ILLEGAL_MOVE;
        }
        if (this.isNaval()) {
            return this.getNavalMoveType(from, target, ml);
        }
        return this.getLandMoveType(from, target, ml);
    }

    private MoveType getNavalMoveType(Tile from, Tile target, int ml) {
        if (target == null) {
            if (this.getOwner().canMoveToEurope()) {
                return MoveType.MOVE_HIGH_SEAS;
            }
            return MoveType.ILLEGAL_MOVE;
        }
        Unit defender = target.getFirstUnit();
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement != null) {
                if (settlement.getOwner() == this.getOwner()) {
                    return MoveType.MOVE;
                }
                if (this.canTradeWith(settlement)) {
                    return MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS;
                }
                logger.finest("Trying to enter another player's settlement with " + this.getName());
                return MoveType.ILLEGAL_MOVE;
            }
            if (defender != null && defender.getOwner() != this.getOwner()) {
                logger.finest("Trying to sail into tile occupied by enemy units with " + this.getName());
                return MoveType.ILLEGAL_MOVE;
            }
            Iterator<Unit> unitIterator = this.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit u = unitIterator.next();
                if (u.getMovesLeft() <= 0) continue;
                return MoveType.DISEMBARK;
            }
            logger.finest("No units to disembark from " + this.getName());
            return MoveType.ILLEGAL_MOVE;
        }
        if (defender != null && defender.getOwner() != this.getOwner()) {
            if (this.isOffensiveUnit()) {
                return MoveType.ATTACK;
            }
            return MoveType.ILLEGAL_MOVE;
        }
        if (target.canMoveToEurope()) {
            if (this.getOwner().canMoveToEurope()) {
                return MoveType.MOVE_HIGH_SEAS;
            }
            return MoveType.MOVE;
        }
        return MoveType.MOVE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private MoveType getLandMoveType(Tile from, Tile target, int ml) {
        Unit u;
        if (target == null) {
            logger.finest("Trying to enter null tile with land unit " + this.getName());
            return MoveType.ILLEGAL_MOVE;
        }
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            Unit defender = target.getFirstUnit();
            if (settlement != null) {
                if (settlement.getOwner() == this.getOwner()) {
                    return MoveType.MOVE;
                }
                if (this.canTradeWith(settlement)) {
                    return MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS;
                }
                if (settlement instanceof IndianSettlement) {
                    IndianSettlement indian = (IndianSettlement)settlement;
                    if (this.isColonist() && !this.isArmed() && this.hasAbility("model.ability.scoutIndianSettlement")) {
                        return MoveType.ENTER_INDIAN_VILLAGE_WITH_SCOUT;
                    }
                    if (this.hasAbility("model.ability.missionary")) {
                        return MoveType.ENTER_INDIAN_VILLAGE_WITH_MISSIONARY;
                    }
                    if (this.isOffensiveUnit()) {
                        return MoveType.ATTACK;
                    }
                    if (this.isColonist() && (indian.getLearnableSkill() != null || !indian.hasBeenVisited())) {
                        return MoveType.ENTER_INDIAN_VILLAGE_WITH_FREE_COLONIST;
                    }
                    return MoveType.ILLEGAL_MOVE;
                }
                if (!(settlement instanceof Colony)) {
                    logger.info("Default illegal move for " + this.getName());
                    return MoveType.ILLEGAL_MOVE;
                }
                if (this.isColonist() && !this.isArmed() && this.hasAbility("model.ability.scoutForeignColony")) {
                    return MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT;
                }
                if (this.isOffensiveUnit()) {
                    return MoveType.ATTACK;
                }
                logger.finest("Trying to enter foreign colony with " + this.getName());
                return MoveType.ILLEGAL_MOVE;
            }
            if (defender != null && defender.getOwner() != this.getOwner()) {
                if (from != null && !from.isLand()) {
                    logger.finest("Attempting marine assault with " + this.getName());
                    return MoveType.ILLEGAL_MOVE;
                }
                if (this.isOffensiveUnit()) {
                    return MoveType.ATTACK;
                }
                logger.finest("Trying to attack with civilian " + this.getName());
                return MoveType.ILLEGAL_MOVE;
            }
            if (target.getFirstUnit() != null && target.getFirstUnit().isNaval() && target.getFirstUnit().getOwner() != this.getOwner()) {
                return MoveType.ILLEGAL_MOVE;
            }
            if (from != null && this.getMoveCost(from, target, ml) > ml) {
                return MoveType.ILLEGAL_MOVE;
            }
            if (target.hasLostCityRumour()) {
                return MoveType.EXPLORE_LOST_CITY_RUMOUR;
            }
            return MoveType.MOVE;
        }
        if (target.getFirstUnit() == null || target.getFirstUnit().getOwner() != this.getOwner()) {
            logger.finest("Trying to embark on tile occupied by foreign units with " + this.getName());
            return MoveType.ILLEGAL_MOVE;
        }
        Iterator<Unit> i$ = target.getUnitList().iterator();
        do {
            if (i$.hasNext()) continue;
            logger.finest("Trying to board full vessel with " + this.getName());
            return MoveType.ILLEGAL_MOVE;
        } while ((u = i$.next()).getSpaceLeft() < this.getSpaceTaken());
        return MoveType.EMBARK;
    }

    public void setMovesLeft(int movesLeft) {
        if (movesLeft < 0) {
            movesLeft = 0;
        }
        this.movesLeft = movesLeft;
    }

    @Override
    public int getSpaceTaken() {
        return this.unitType.getSpaceTaken();
    }

    public int getLineOfSight() {
        float line = this.unitType.getLineOfSight();
        Set<Modifier> modifierSet = this.getModifierSet("model.modifier.lineOfSightBonus");
        if (this.getTile() != null && this.getTile().getType() != null) {
            modifierSet.addAll(this.getTile().getType().getFeatureContainer().getModifierSet("model.modifier.lineOfSightBonus", this.unitType, this.getGame().getTurn()));
        }
        return (int)FeatureContainer.applyModifierSet(line, this.getGame().getTurn(), modifierSet);
    }

    public void move(Map.Direction direction) {
        MoveType moveType = this.getMoveType(direction);
        switch (moveType) {
            case MOVE: 
            case MOVE_HIGH_SEAS: 
            case EXPLORE_LOST_CITY_RUMOUR: {
                break;
            }
            default: {
                throw new IllegalStateException("\nIllegal move requested: " + (Object)((Object)moveType) + " while trying to move a " + this.getName() + " located at " + this.getTile().getPosition().toString() + ". Direction: " + (Object)((Object)direction) + " Moves Left: " + this.getMovesLeft());
            }
        }
        this.moveToTile(this.getGame().getMap().getNeighbourOrNull(direction, this.getTile()));
    }

    public void moveToTile(Tile newTile) {
        if (newTile != null) {
            this.setState(UnitState.ACTIVE);
            this.setStateToAllChildren(UnitState.SENTRY);
            int moveCost = this.getMoveCost(newTile);
            this.setMovesLeft(this.getMovesLeft() - moveCost);
            this.setLocation(newTile);
            this.activeAdjacentSentryUnits(newTile);
            if (newTile.canMoveToEurope()) {
                this.setAlreadyOnHighSea(true);
            } else {
                this.setAlreadyOnHighSea(false);
            }
        } else {
            throw new IllegalStateException("Illegal move requested - no target tile!");
        }
    }

    public void activeAdjacentSentryUnits(Tile tile) {
        Map map = this.getGame().getMap();
        Iterator<Map.Position> it = map.getAdjacentIterator(tile.getPosition());
        while (it.hasNext()) {
            Iterator<Unit> unitIt = map.getTile(it.next()).getUnitIterator();
            while (unitIt.hasNext()) {
                Unit unit = unitIt.next();
                if (unit.getState() != UnitState.SENTRY || unit.getOwner() == this.getOwner()) continue;
                unit.setState(UnitState.ACTIVE);
            }
        }
    }

    public void embark(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Target of embarkation must not be 'null'.");
        }
        if (this.getMoveType(unit.getTile()) != MoveType.EMBARK) {
            throw new IllegalStateException("Illegal disembark requested!");
        }
        this.setLocation(unit);
        this.setMovesLeft(this.getMovesLeft() - 3);
    }

    public void boardShip(Unit carrier) {
        if (this.isNaval()) {
            throw new IllegalStateException("A ship cannot board another carrier!");
        }
        if (this.getTile() != carrier.getTile() || this.isInEurope() != carrier.isInEurope()) {
            throw new IllegalStateException("It is not allowed to board a ship on another tile.");
        }
        this.setLocation(carrier);
        this.setState(UnitState.SENTRY);
    }

    public void leaveShip() {
        Unit carrier = (Unit)this.getLocation();
        Location l = carrier.getLocation();
        if (carrier.isInEurope()) {
            this.setLocation(l);
        } else if (this.getTile().getSettlement() != null) {
            this.setLocation(this.getTile());
            if (this.canCarryTreasure() && this.canCashInTreasureTrain()) {
                this.cashInTreasureTrain();
            }
        } else {
            throw new IllegalStateException("A unit may only leave a ship while in a harbour.");
        }
        this.setState(UnitState.ACTIVE);
    }

    public boolean isOnCarrier() {
        return this.getLocation() instanceof Unit;
    }

    public void setStateToAllChildren(UnitState state) {
        if (this.canCarryUnits()) {
            for (Unit u : this.getUnitList()) {
                u.setState(state);
            }
        }
    }

    private void spendAllMoves() {
        if (this.getColony() != null && this.getMovesLeft() < this.getInitialMovesLeft()) {
            this.setMovesLeft(0);
        }
    }

    @Override
    public void add(Locatable locatable) {
        if (locatable instanceof Unit && this.canCarryUnits()) {
            if (this.getSpaceLeft() < locatable.getSpaceTaken()) {
                throw new IllegalStateException();
            }
            if (this.units.contains(locatable)) {
                logger.warning("Tried to add a 'Locatable' already in the carrier.");
                return;
            }
            if (((Object)this.units).equals(Collections.emptyList())) {
                this.units = new ArrayList<Unit>();
            }
            this.units.add((Unit)locatable);
            this.spendAllMoves();
        } else if (locatable instanceof Goods && this.canCarryGoods()) {
            Goods goods = (Goods)locatable;
            if (this.getLoadableAmount(goods.getType()) < goods.getAmount()) {
                throw new IllegalStateException("Not enough space for the given locatable!");
            }
            this.goodsContainer.addGoods(goods);
            this.spendAllMoves();
        } else {
            throw new IllegalStateException("Tried to add a 'Locatable' to a non-carrier unit.");
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable == null) {
            throw new IllegalArgumentException("Locatable must not be 'null'.");
        }
        if (locatable instanceof Unit && this.canCarryUnits()) {
            this.units.remove(locatable);
            this.spendAllMoves();
        } else if (locatable instanceof Goods && this.canCarryGoods()) {
            this.goodsContainer.removeGoods((Goods)locatable);
            this.spendAllMoves();
        } else {
            logger.warning("Tried to remove a 'Locatable' from a non-carrier unit.");
        }
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit && this.canCarryUnits()) {
            return this.units.contains(locatable);
        }
        if (locatable instanceof Goods && this.canCarryGoods()) {
            return this.goodsContainer.contains((Goods)locatable);
        }
        return false;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable == this) {
            return false;
        }
        if (locatable instanceof Unit && this.canCarryUnits()) {
            return this.getSpaceLeft() >= locatable.getSpaceTaken();
        }
        if (locatable instanceof Goods) {
            Goods g = (Goods)locatable;
            return this.getLoadableAmount(g.getType()) >= g.getAmount();
        }
        return false;
    }

    public int getLoadableAmount(GoodsType type) {
        if (this.canCarryGoods()) {
            int result = this.getSpaceLeft() * 100;
            int count = this.getGoodsContainer().getGoodsCount(type) % 100;
            if (count > 0 && count < 100) {
                result += 100 - count;
            }
            return result;
        }
        return 0;
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    public boolean isVisibleTo(Player player) {
        if (player == this.getOwner()) {
            return true;
        }
        Tile unitTile = this.getTile();
        if (unitTile == null) {
            return false;
        }
        if (!player.canSee(unitTile)) {
            return false;
        }
        Settlement settlement = unitTile.getSettlement();
        if (settlement != null && settlement.getOwner() != player) {
            return false;
        }
        return !this.isOnCarrier() || ((Unit)this.getLocation()).getOwner() == player;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return new ArrayList<Unit>(this.units).iterator();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.units;
    }

    public Iterator<Goods> getGoodsIterator() {
        if (this.canCarryGoods()) {
            return this.goodsContainer.getGoodsIterator();
        }
        return EmptyIterator.getInstance();
    }

    public List<Goods> getGoodsList() {
        if (this.canCarryGoods()) {
            return this.goodsContainer.getGoods();
        }
        return Collections.emptyList();
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return this.goodsContainer;
    }

    public void work(WorkLocation workLocation) {
        if (workLocation.getColony() != this.getColony()) {
            throw new IllegalStateException("Can only set a 'Unit'  to a 'WorkLocation' that is in the same 'Colony'.");
        }
        this.setState(UnitState.IN_COLONY);
        this.setLocation(workLocation);
    }

    public void work(TileImprovement improvement) {
        if (!this.hasAbility("model.ability.improveTerrain")) {
            throw new IllegalStateException("Only 'Pioneers' can perform TileImprovement.");
        }
        if (improvement == null) {
            throw new IllegalArgumentException("Improvement must not be 'null'.");
        }
        if (!this.canPerformImprovement(improvement.getType())) {
            throw new IllegalArgumentException("Cannot perform this improvement for this tile");
        }
        this.setWorkImprovement(improvement);
        this.setState(UnitState.IMPROVING);
    }

    public void setLocationNoUpdate(Location newLocation) {
        this.location = newLocation;
    }

    @Override
    public void setLocation(Location newLocation) {
        Colony oldColony = this.getColony();
        Location oldLocation = this.location;
        if (this.location != null) {
            if (this.location instanceof ColonyTile) {
                ((ColonyTile)this.location).getWorkTile().setOwner(null);
            }
            this.location.remove(this);
        }
        this.location = newLocation;
        if (newLocation != null) {
            newLocation.add(this);
        }
        if (oldLocation instanceof WorkLocation) {
            if (!(newLocation instanceof WorkLocation)) {
                this.getOwner().modifyScore(-this.getType().getScoreValue());
                if (oldColony != null) {
                    int newPopulation = oldColony.getUnitCount();
                    oldColony.updatePopulation(-1);
                    if (this.getState() != UnitState.ACTIVE) {
                        logger.warning("Removing unit " + this.getId() + " with state==" + (Object)((Object)this.getState()) + " (should not be IN_COLONY) from WorkLocation in " + oldLocation.getColony().getName() + ". Fixing: ");
                        this.setState(UnitState.ACTIVE);
                    }
                }
            }
        } else if (newLocation instanceof WorkLocation) {
            this.getOwner().modifyScore(this.getType().getScoreValue());
            int oldPopulation = newLocation.getColony().getUnitCount();
            newLocation.getColony().updatePopulation(1);
            if (this.getState() != UnitState.IN_COLONY) {
                logger.warning("Adding unit " + this.getId() + " with state==" + (Object)((Object)this.getState()) + " (should be IN_COLONY) to WorkLocation in " + newLocation.getColony().getName() + ". Fixing: ");
                this.setState(UnitState.IN_COLONY);
            }
        }
        if (!Utils.equals(oldColony, this.getColony())) {
            this.setTurnsOfTraining(0);
        }
        if (!(this.student == null || newLocation instanceof Building && ((Building)newLocation).getType().hasAbility("model.ability.teach"))) {
            this.student.setTeacher(null);
            this.student = null;
        }
        if (newLocation instanceof WorkLocation) {
            this.removeAllEquipment(false);
        } else if (this.teacher != null) {
            this.teacher.setStudent(null);
            this.teacher = null;
        }
        if (this.getGame().getMap() != null && this.location != null && this.location instanceof Tile && !this.isNaval()) {
            this.contactAdjacent(this.getTile());
        }
        if (!this.getOwner().isIndian()) {
            this.getOwner().setExplored(this);
        }
    }

    public void contactAdjacent(Tile tile) {
        Iterator<Map.Position> tileIterator = this.getGame().getMap().getAdjacentIterator(tile.getPosition());
        Player thisUnitOwner = this.getOwner();
        if (thisUnitOwner == null) {
            throw new IllegalStateException("This unit has no owner");
        }
        while (tileIterator.hasNext()) {
            Tile t = this.getGame().getMap().getTile(tileIterator.next());
            if (t == null || !t.isLand()) continue;
            Settlement settlement = t.getSettlement();
            Unit unitOnTile = t.getFirstUnit();
            if (settlement == null && unitOnTile == null) continue;
            Player otherPlayer = null;
            otherPlayer = settlement != null ? settlement.getOwner() : unitOnTile.getOwner();
            if (otherPlayer == null) {
                throw new IllegalStateException("Cannot determine the other player.");
            }
            if (otherPlayer == thisUnitOwner) continue;
            if (!otherPlayer.hasContacted(thisUnitOwner)) {
                otherPlayer.setContacted(thisUnitOwner, true);
                thisUnitOwner.setContacted(otherPlayer, true);
            }
            IndianSettlement indianSettlement = null;
            if (settlement != null) {
                if (settlement instanceof IndianSettlement) {
                    indianSettlement = (IndianSettlement)settlement;
                }
            } else {
                indianSettlement = unitOnTile.getIndianSettlement();
            }
            if (indianSettlement == null || indianSettlement.getAlarm(thisUnitOwner) != null) continue;
            indianSettlement.setAlarm(thisUnitOwner, otherPlayer.getTension(thisUnitOwner));
        }
    }

    public void setIndianSettlement(IndianSettlement indianSettlement) {
        if (this.indianSettlement != null) {
            this.indianSettlement.removeOwnedUnit(this);
        }
        this.indianSettlement = indianSettlement;
        if (indianSettlement != null) {
            indianSettlement.addOwnedUnit(this);
        }
    }

    public IndianSettlement getIndianSettlement() {
        return this.indianSettlement;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void putOutsideColony() {
        if (this.getTile().getSettlement() == null) {
            throw new IllegalStateException();
        }
        if (this.getState() == UnitState.IN_COLONY) {
            this.setState(UnitState.ACTIVE);
        }
        this.setLocation(this.getTile());
    }

    public boolean canBeEquippedWith(EquipmentType equipmentType) {
        for (Map.Entry<String, Boolean> entry : equipmentType.getUnitAbilitiesRequired().entrySet()) {
            if (this.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return false;
        }
        if (!equipmentType.getLocationAbilitiesRequired().isEmpty()) {
            if (this.isInEurope()) {
                return true;
            }
            Colony colony = this.getColony();
            if (colony == null) {
                return false;
            }
            for (Map.Entry entry : equipmentType.getLocationAbilitiesRequired().entrySet()) {
                if (colony.getFeatureContainer().hasAbility((String)entry.getKey()) == ((Boolean)entry.getValue()).booleanValue()) continue;
                return false;
            }
        }
        int count = 1;
        for (EquipmentType equipmentType2 : this.equipment) {
            if (equipmentType2 != equipmentType) continue;
            ++count;
        }
        return count <= equipmentType.getMaximumCount();
    }

    public void equipWith(EquipmentType equipmentType) {
        this.equipWith(equipmentType, false);
    }

    public void equipWith(EquipmentType equipmentType, boolean asResultOfCombat) {
        if (equipmentType == null) {
            throw new IllegalArgumentException("EquipmentType is 'null'.");
        }
        if (!this.canBeEquippedWith(equipmentType)) {
            logger.fine("Unable to equip unit " + this.getId() + " with " + equipmentType.getName());
            return;
        }
        if (!(asResultOfCombat || this.getColony() != null && this.getColony().canBuildEquipment(equipmentType) || this.isInEurope() && this.getOwner().getEurope().canBuildEquipment(equipmentType) || this.getIndianSettlement() != null)) {
            logger.fine("Unable to build equipment " + equipmentType.getName());
            return;
        }
        Iterator<EquipmentType> equipmentIterator = this.equipment.iterator();
        while (equipmentIterator.hasNext()) {
            EquipmentType oldEquipment = equipmentIterator.next();
            if (oldEquipment.isCompatibleWith(equipmentType)) continue;
            this.dumpEquipment(oldEquipment, asResultOfCombat);
            equipmentIterator.remove();
        }
        if (!asResultOfCombat) {
            this.setMovesLeft(0);
            if (this.getColony() != null) {
                for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                    if (this.getColony().getGoodsCount(goods.getType()) < goods.getAmount()) {
                        throw new IllegalStateException("Not enough goods to equip");
                    }
                    this.getColony().removeGoods(goods);
                }
            } else if (this.isInEurope()) {
                for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                    this.getOwner().getMarket().buy(goods.getType(), goods.getAmount(), this.getOwner());
                }
            } else if (this.getIndianSettlement() != null) {
                for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                    if (this.getIndianSettlement().getGoodsCount(goods.getType()) < goods.getAmount()) {
                        throw new IllegalStateException("Not enough goods to equip");
                    }
                    this.getIndianSettlement().removeGoods(goods);
                }
            }
        }
        this.equipment.add(equipmentType);
        this.setRole();
    }

    public void removeEquipment(EquipmentType equipmentType) {
        this.removeEquipment(equipmentType, false);
    }

    public void removeEquipment(EquipmentType equipmentType, boolean asResultOfCombat) {
        this.dumpEquipment(equipmentType, asResultOfCombat);
        this.equipment.remove(equipmentType);
        if (asResultOfCombat) {
            this.setMovesLeft(Math.min(this.movesLeft, this.getInitialMovesLeft()));
        } else {
            this.setMovesLeft(0);
        }
        this.setRole();
    }

    public void removeAllEquipment(boolean asResultOfCombat) {
        for (EquipmentType equipmentType : this.equipment) {
            this.dumpEquipment(equipmentType, asResultOfCombat);
        }
        this.equipment.clear();
        this.setMovesLeft(0);
        this.role = Role.DEFAULT;
    }

    private void dumpEquipment(EquipmentType equipmentType, boolean asResultOfCombat) {
        block2: {
            block3: {
                if (asResultOfCombat) break block2;
                if (this.getColony() == null) break block3;
                for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                    this.getColony().addGoods(goods);
                }
                break block2;
            }
            if (!this.isInEurope()) break block2;
            for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                this.getOwner().getMarket().sell(goods.getType(), goods.getAmount(), this.getOwner());
            }
        }
    }

    public int getEquipmentCount(EquipmentType equipmentType) {
        return Collections.frequency(this.equipment, equipmentType);
    }

    public boolean isInEurope() {
        if (this.location instanceof Unit) {
            return ((Unit)this.location).isInEurope();
        }
        return this.getLocation() instanceof Europe && this.getState() != UnitState.TO_EUROPE && this.getState() != UnitState.TO_AMERICA;
    }

    public void buyGoods(GoodsType goodsType, int amount) {
        if (!this.canCarryGoods() || !this.isInEurope()) {
            throw new IllegalStateException("Cannot buy goods when not a carrier or in Europe.");
        }
        try {
            this.getOwner().getMarket().buy(goodsType, amount, this.getOwner());
            this.goodsContainer.addGoods(goodsType, amount);
        }
        catch (IllegalStateException ise) {
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.DEFAULT, "notEnoughGold", new String[0]);
        }
    }

    public boolean isCarrier() {
        return Unit.isCarrier(this.unitType);
    }

    public static boolean isCarrier(UnitType unitType) {
        return unitType.canCarryGoods() || unitType.canCarryUnits();
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    public String getApparentOwnerName() {
        return this.hasAbility("model.ability.piracy") ? "unknown enemy" : this.owner.getNationAsString();
    }

    @Override
    public void setOwner(Player owner) {
        Player oldOwner = this.owner;
        if (oldOwner == owner) {
            return;
        }
        if (oldOwner == null) {
            logger.warning("Unit " + this.getId() + " had no previous owner");
        } else {
            oldOwner.removeUnit(this);
            oldOwner.modifyScore(-this.getType().getScoreValue());
            oldOwner.invalidateCanSeeTiles();
        }
        this.owner = owner;
        owner.setUnit(this);
        if (oldOwner != null) {
            owner.modifyScore(this.getType().getScoreValue());
            this.getOwner().setExplored(this);
            if (this.getGame().getFreeColGameObjectListener() != null) {
                this.getGame().getFreeColGameObjectListener().ownerChanged(this, oldOwner, owner);
            }
        }
    }

    public void setType(UnitType newUnitType) {
        if (newUnitType.isAvailableTo(this.owner)) {
            if (this.unitType == null) {
                this.owner.modifyScore(newUnitType.getScoreValue());
            } else {
                this.owner.modifyScore(newUnitType.getScoreValue() - this.unitType.getScoreValue());
            }
            this.unitType = newUnitType;
            this.naval = this.unitType.hasAbility("model.ability.navalUnit");
            if (this.getMovesLeft() > this.getInitialMovesLeft()) {
                this.setMovesLeft(this.getInitialMovesLeft());
            }
            this.hitpoints = this.unitType.getHitPoints();
            if (this.getTeacher() != null && !this.canBeStudent(this.getTeacher())) {
                this.getTeacher().setStudent(null);
                this.setTeacher(null);
            }
        } else {
            logger.warning(newUnitType.getName() + " is not available to " + (Object)((Object)this.owner.getPlayerType()) + " player " + this.owner.getName());
        }
    }

    public int getMovesLeft() {
        return this.movesLeft;
    }

    public boolean isArmed() {
        if (this.getOwner().isIndian()) {
            return this.equipment.contains(FreeCol.getSpecification().getEquipmentType("model.equipment.indian.muskets"));
        }
        return this.equipment.contains(FreeCol.getSpecification().getEquipmentType("model.equipment.muskets"));
    }

    public boolean isMounted() {
        if (this.getOwner().isIndian()) {
            return this.equipment.contains(FreeCol.getSpecification().getEquipmentType("model.equipment.indian.horses"));
        }
        return this.equipment.contains(FreeCol.getSpecification().getEquipmentType("model.equipment.horses"));
    }

    @Override
    public String getName() {
        String completeName = "";
        String customName = "";
        if (this.name != null) {
            customName = " " + this.name + " ";
        }
        completeName = this.canCarryTreasure() ? Messages.message(this.getType().getId() + ".gold", "%gold%", String.valueOf(this.getTreasureAmount())) : ((this.equipment == null || this.equipment.isEmpty()) && this.getType().getDefaultEquipmentType() != null ? Unit.getName(this.getType(), this.getRole()) + " (" + Messages.message(this.getType().getDefaultEquipmentType().getId() + ".none", new String[0]) + ")" : Unit.getName(this.getType(), this.getRole()));
        int index = completeName.lastIndexOf(" (");
        completeName = index < 0 ? completeName + customName : completeName.substring(0, index) + customName + completeName.substring(index + 1);
        return completeName;
    }

    public static String getName(UnitType someType, Role someRole) {
        String messageID;
        String key = someRole.toString().toLowerCase();
        if (someRole == Role.DEFAULT) {
            key = "name";
        }
        if (Messages.containsKey(messageID = someType.getId() + "." + key)) {
            return Messages.message(messageID, new String[0]);
        }
        return Messages.message("model.unit." + key + ".name", "%unit%", someType.getName());
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public int getInitialMovesLeft() {
        return (int)FeatureContainer.applyModifierSet(this.unitType.getMovement(), this.getGame().getTurn(), this.getModifierSet("model.modifier.movementBonus"));
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
        if (hitpoints >= this.unitType.getHitPoints()) {
            this.setState(UnitState.ACTIVE);
        }
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isUnderRepair() {
        return this.hitpoints < this.unitType.getHitPoints();
    }

    public void sendToRepairLocation(Location l) {
        this.setLocation(l);
        this.setState(UnitState.ACTIVE);
        this.setMovesLeft(0);
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.getMovesAsString();
    }

    public String getMovesAsString() {
        String moves = "";
        if (this.getMovesLeft() % 3 == 0 || this.getMovesLeft() / 3 > 0) {
            moves = moves + Integer.toString(this.getMovesLeft() / 3);
        }
        if (this.getMovesLeft() % 3 != 0) {
            if (this.getMovesLeft() / 3 > 0) {
                moves = moves + " ";
            }
            moves = moves + "(" + Integer.toString(this.getMovesLeft() - this.getMovesLeft() / 3 * 3) + "/3) ";
        }
        moves = moves + "/" + Integer.toString(this.getInitialMovesLeft() / 3);
        return moves;
    }

    public boolean isNaval() {
        return this.naval;
    }

    public String getOccupationIndicator() {
        if (this.getDestination() != null) {
            if (this.getTradeRoute() != null) {
                return Messages.message("model.unit.occupation.inTradeRoute", new String[0]);
            }
            return Messages.message("model.unit.occupation.goingSomewhere", new String[0]);
        }
        if (this.state == UnitState.IMPROVING && this.workImprovement != null) {
            return this.workImprovement.getOccupationString();
        }
        if (this.state == UnitState.ACTIVE && this.getMovesLeft() == 0) {
            if (this.isUnderRepair()) {
                return Messages.message("model.unit.occupation.underRepair", new String[0]);
            }
            return Messages.message("model.unit.occupation.activeNoMovesLeft", new String[0]);
        }
        return Messages.message("model.unit.occupation." + this.state.toString().toLowerCase(), new String[0]);
    }

    public String getDetailedOccupationIndicator() {
        TradeRoute tradeRoute = this.getTradeRoute();
        switch (this.state) {
            case ACTIVE: {
                if (this.getMovesLeft() != 0) break;
                return this.isUnderRepair() ? Messages.message("model.unit.occupation.underRepair", new String[0]) + ": " + Integer.toString(this.getTurnsForRepair()) : (tradeRoute != null ? Messages.message("model.unit.occupation.inTradeRoute", new String[0]) + ": " + tradeRoute.getName() : Messages.message("model.unit.occupation.activeNoMovesLeft", new String[0]));
            }
            case IMPROVING: {
                if (this.workImprovement == null) break;
                return this.workImprovement.getOccupationString() + ": " + Integer.toString(this.getWorkLeft());
            }
        }
        return tradeRoute != null ? Messages.message("model.unit.occupation.inTradeRoute", new String[0]) + ": " + tradeRoute.getName() : (this.getDestination() != null ? Messages.message("model.unit.occupation.goingSomewhere", new String[0]) : Messages.message("model.unit.occupation." + this.state.toString().toLowerCase(), new String[0]));
    }

    public UnitState getState() {
        return this.state;
    }

    public Role getRole() {
        return this.role;
    }

    private void setRole() {
        boolean keepExperience;
        Role oldRole = this.role;
        this.role = Role.DEFAULT;
        block4: for (EquipmentType type : this.equipment) {
            switch (type.getRole()) {
                case SOLDIER: {
                    if (this.role == Role.SCOUT) {
                        this.role = Role.DRAGOON;
                        continue block4;
                    }
                    this.role = Role.SOLDIER;
                    continue block4;
                }
                case SCOUT: {
                    if (this.role == Role.SOLDIER) {
                        this.role = Role.DRAGOON;
                        continue block4;
                    }
                    this.role = Role.SCOUT;
                    continue block4;
                }
            }
            this.role = type.getRole();
        }
        if (this.getState() == UnitState.IMPROVING && this.role != Role.PIONEER) {
            this.setStateUnchecked(UnitState.ACTIVE);
            this.setMovesLeft(0);
        }
        boolean bl = keepExperience = this.role == oldRole || this.role == Role.SOLDIER && oldRole == Role.DRAGOON || this.role == Role.DRAGOON && oldRole == Role.SOLDIER;
        if (!keepExperience) {
            this.experience = 0;
        }
    }

    public boolean checkSetState(UnitState s) {
        switch (s) {
            case ACTIVE: 
            case SENTRY: {
                return true;
            }
            case IN_COLONY: {
                return !this.isNaval();
            }
            case FORTIFIED: {
                return this.getState() == UnitState.FORTIFYING;
            }
            case IMPROVING: 
            case FORTIFYING: 
            case SKIPPED: {
                return this.getMovesLeft() > 0;
            }
            case TO_EUROPE: {
                return this.isNaval() && this.location instanceof Europe && this.getState() == UnitState.TO_AMERICA || this.getEntryLocation() == this.getLocation();
            }
            case TO_AMERICA: {
                return this.location instanceof Europe && this.isNaval() && !this.isUnderRepair();
            }
        }
        logger.warning("Invalid unit state: " + (Object)((Object)s));
        return false;
    }

    public void setState(UnitState s) {
        if (this.state == s) {
            return;
        }
        if (!this.checkSetState(s)) {
            throw new IllegalStateException("Illegal UnitState transition: " + (Object)((Object)this.state) + " -> " + (Object)((Object)s));
        }
        this.setStateUnchecked(s);
    }

    private void setStateUnchecked(UnitState s) {
        switch (this.state) {
            case IMPROVING: {
                if (this.workLeft <= 0) break;
                this.workImprovement.getTile().getTileItemContainer().removeTileItem(this.workImprovement);
                this.workImprovement = null;
                break;
            }
        }
        switch (s) {
            case ACTIVE: {
                this.workLeft = -1;
                break;
            }
            case SENTRY: {
                this.workLeft = -1;
                break;
            }
            case FORTIFIED: {
                this.workLeft = -1;
                this.movesLeft = 0;
                break;
            }
            case FORTIFYING: {
                this.movesLeft = 0;
                this.workLeft = 1;
                break;
            }
            case IMPROVING: {
                this.movesLeft = 0;
                this.getTile().takeOwnership(this.getOwner(), null);
                this.workLeft = -1;
                if (this.workImprovement != null) {
                    this.workLeft = this.workImprovement.getTurnsToComplete();
                }
                this.state = s;
                this.doAssignedWork();
                return;
            }
            case TO_EUROPE: {
                this.workLeft = this.state == UnitState.TO_AMERICA ? TURNS_TO_SAIL + 1 - this.workLeft : TURNS_TO_SAIL;
                this.workLeft = (int)this.getOwner().getFeatureContainer().applyModifier(this.workLeft, "model.modifier.sailHighSeas", this.unitType, this.getGame().getTurn());
                this.movesLeft = 0;
                break;
            }
            case TO_AMERICA: {
                this.workLeft = this.state == UnitState.TO_EUROPE ? TURNS_TO_SAIL + 1 - this.workLeft : TURNS_TO_SAIL;
                this.workLeft = (int)this.getOwner().getFeatureContainer().applyModifier(this.workLeft, "model.modifier.sailHighSeas", this.unitType, this.getGame().getTurn());
                this.movesLeft = 0;
                break;
            }
            case SKIPPED: {
                break;
            }
            default: {
                this.workLeft = -1;
            }
        }
        this.state = s;
    }

    public boolean canMoveToEurope() {
        if (this.getLocation() instanceof Europe) {
            return true;
        }
        if (!this.getOwner().canMoveToEurope()) {
            return false;
        }
        List<Tile> surroundingTiles = this.getGame().getMap().getSurroundingTiles(this.getTile(), 1);
        if (surroundingTiles.size() != 8) {
            return true;
        }
        for (int i = 0; i < surroundingTiles.size(); ++i) {
            Tile tile = surroundingTiles.get(i);
            if (tile != null && !tile.canMoveToEurope()) continue;
            return true;
        }
        return false;
    }

    public void moveToEurope() {
        if (!this.canMoveToEurope()) {
            throw new IllegalStateException("It is not allowed to move units to europe from the tile where this unit is located.");
        }
        if (this.getLocation() instanceof Tile) {
            this.setEntryLocation(this.getLocation());
        }
        this.setState(UnitState.TO_EUROPE);
        this.setLocation(this.getOwner().getEurope());
        logger.info("Unit " + this.getId() + " moving to Europe");
        this.alreadyOnHighSea = false;
    }

    public void moveToAmerica() {
        if (!(this.getLocation() instanceof Europe)) {
            throw new IllegalStateException("A unit can only be moved to america from europe.");
        }
        this.setState(UnitState.TO_AMERICA);
        logger.info("Unit " + this.getId() + " moving to America");
        this.alreadyOnHighSea = false;
    }

    public boolean canPerformImprovement(TileImprovementType impType) {
        if (impType == null || impType.isNatural()) {
            return false;
        }
        if (!impType.isTileTypeAllowed(this.getTile().getType())) {
            return false;
        }
        TileImprovement improvement = this.getTile().findTileImprovementType(impType);
        if (improvement == null) {
            return impType.isWorkerAllowed(this);
        }
        return improvement.isWorkerAllowed(this);
    }

    public boolean canBuildColony() {
        return this.unitType.hasAbility("model.ability.foundColony") && this.getMovesLeft() > 0 && this.getTile() != null && this.getTile().isColonizeable();
    }

    public void buildColony(Colony colony) {
        if (!this.canBuildColony()) {
            throw new IllegalStateException("Unit " + this.getName() + " can not build colony on " + this.getTile().getName() + "!");
        }
        if (!this.getTile().getPosition().equals(colony.getTile().getPosition())) {
            throw new IllegalStateException("A Unit can only build a colony if on the same tile as the colony");
        }
        this.getTile().setOwner(this.owner);
        this.getTile().setSettlement(colony);
        this.setState(UnitState.IN_COLONY);
        this.setLocation(colony);
        this.setMovesLeft(0);
        this.owner.getHistory().add(new HistoryEvent(this.getGame().getTurn().getNumber(), HistoryEvent.Type.FOUND_COLONY, "%colony%", colony.getName()));
    }

    @Override
    public Tile getTile() {
        return this.location != null ? this.location.getTile() : null;
    }

    public int getSpaceLeft() {
        int space = this.unitType.getSpace() - this.getGoodsCount();
        Iterator<Unit> unitIterator = this.getUnitIterator();
        while (unitIterator.hasNext()) {
            Unit u = unitIterator.next();
            space -= u.getSpaceTaken();
        }
        return space;
    }

    public int getVisibleGoodsCount() {
        if (this.visibleGoodsCount >= 0) {
            return this.visibleGoodsCount;
        }
        return this.getGoodsCount();
    }

    public int getGoodsCount() {
        return this.canCarryGoods() ? this.goodsContainer.getGoodsCount() : 0;
    }

    public void moveToFront(Unit u) {
        if (this.canCarryUnits() && this.units.remove(u)) {
            this.units.add(0, u);
        }
    }

    public int getWorkLeft() {
        if (this.state == UnitState.IMPROVING && this.unitType.hasAbility("model.ability.expertPioneer")) {
            return this.workLeft / 2;
        }
        return this.workLeft;
    }

    public void doAssignedWork() {
        logger.finest("Entering method doAssignedWork.");
        if (this.workLeft > 0) {
            if (this.state == UnitState.IMPROVING) {
                if (this.getWorkImprovement().isComplete()) {
                    this.setState(UnitState.ACTIVE);
                    return;
                }
                int amountOfWork = this.unitType.hasAbility("model.ability.expertPioneer") ? 2 : 1;
                this.workLeft = this.getWorkImprovement().doWork(amountOfWork);
                if (0 < this.workLeft && this.workLeft < amountOfWork) {
                    this.workLeft = this.getWorkImprovement().doWork(this.workLeft);
                }
            } else {
                --this.workLeft;
            }
            if (this.state == UnitState.TO_AMERICA && this.getOwner().isREF()) {
                this.workLeft = 0;
            }
            if (this.workLeft == 0) {
                this.workLeft = -1;
                UnitState state = this.getState();
                switch (state) {
                    case TO_EUROPE: {
                        logger.info("Unit " + this.getId() + " arrives in Europe");
                        if (this.getTradeRoute() != null) {
                            this.setMovesLeft(0);
                            this.setState(UnitState.ACTIVE);
                            return;
                        }
                        this.addModelMessage((FreeColGameObject)this.getOwner().getEurope(), ModelMessage.MessageType.DEFAULT, this, "model.unit.arriveInEurope", "%europe%", this.getOwner().getEurope().getName());
                        this.setState(UnitState.ACTIVE);
                        ArrayList<Unit> unitList = new ArrayList<Unit>(this.getUnitList());
                        for (Unit u : unitList) {
                            if (!u.canCarryTreasure()) continue;
                            u.cashInTreasureTrain();
                        }
                        break;
                    }
                    case TO_AMERICA: {
                        logger.info("Unit " + this.getId() + " arrives in America");
                        this.getGame().getModelController().setToVacantEntryLocation(this);
                        this.setState(UnitState.ACTIVE);
                        break;
                    }
                    case FORTIFYING: {
                        this.setState(UnitState.FORTIFIED);
                        break;
                    }
                    case IMPROVING: {
                        TileType changeType;
                        this.expendEquipment(this.getWorkImprovement().getExpendedEquipmentType(), this.getWorkImprovement().getExpendedAmount());
                        GoodsType deliverType = this.getWorkImprovement().getDeliverGoodsType();
                        if (deliverType != null) {
                            int deliverAmount = this.getTile().potential(deliverType, this.getType()) * this.getWorkImprovement().getDeliverAmount();
                            if (this.unitType.hasAbility("model.ability.expertPioneer")) {
                                deliverAmount *= 2;
                            }
                            if (this.getColony() != null && this.getColony().getOwner().equals(this.getOwner())) {
                                this.getColony().addGoods(deliverType, deliverAmount);
                            } else {
                                List<Tile> surroundingTiles = this.getTile().getMap().getSurroundingTiles(this.getTile(), 1);
                                ArrayList<Colony> adjacentColonies = new ArrayList<Colony>();
                                for (int i = 0; i < surroundingTiles.size(); ++i) {
                                    Tile t = surroundingTiles.get(i);
                                    if (t.getColony() == null || !t.getColony().getOwner().equals(this.getOwner())) continue;
                                    adjacentColonies.add(t.getColony());
                                }
                                if (adjacentColonies.size() > 0) {
                                    int deliverPerCity = deliverAmount / adjacentColonies.size();
                                    for (int i = 0; i < adjacentColonies.size(); ++i) {
                                        Colony c = (Colony)adjacentColonies.get(i);
                                        if (i == 0) {
                                            c.addGoods(deliverType, deliverPerCity + deliverAmount % adjacentColonies.size());
                                            continue;
                                        }
                                        c.addGoods(deliverType, deliverPerCity);
                                    }
                                }
                            }
                        }
                        if ((changeType = this.getWorkImprovement().getChange(this.getTile().getType())) != null) {
                            this.getTile().setType(changeType);
                        } else {
                            this.getTile().add(this.workImprovement);
                        }
                        this.setWorkImprovement(null);
                        this.setState(UnitState.ACTIVE);
                        this.setMovesLeft(0);
                        break;
                    }
                    default: {
                        logger.warning("Unknown work completed. State: " + (Object)((Object)state));
                        this.setState(UnitState.ACTIVE);
                    }
                }
            }
        }
    }

    private void expendEquipment(EquipmentType type, int amount) {
        for (int count = 0; count < amount; ++count) {
            this.equipment.remove(type);
        }
        this.setRole();
        EquipmentType tools = FreeCol.getSpecification().getEquipmentType("model.equipment.tools");
        if (!this.equipment.contains(tools)) {
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.WARNING, this, Messages.getKey(this.getId() + ".noMoreTools", "model.unit.noMoreTools"), "%unit%", this.getName());
        }
    }

    public void setEntryLocation(Location entryLocation) {
        this.entryLocation = entryLocation;
    }

    public Location getEntryLocation() {
        return this.entryLocation != null ? this.entryLocation : this.getOwner().getEntryLocation();
    }

    public Location getVacantEntryLocation() {
        Tile l = (Tile)this.getEntryLocation();
        if (l.getFirstUnit() != null && l.getFirstUnit().getOwner() != this.getOwner()) {
            int radius = 1;
            while (true) {
                Map.CircleIterator i = this.getGame().getMap().getCircleIterator(l.getPosition(), false, radius);
                while (i.hasNext()) {
                    Tile l2 = this.getGame().getMap().getTile((Map.Position)i.next());
                    if (l2.getFirstUnit() != null && l2.getFirstUnit().getOwner() != this.getOwner()) continue;
                    return l2;
                }
                ++radius;
            }
        }
        return l;
    }

    public boolean isOffensiveUnit() {
        return this.unitType.getOffence() > 0 || this.isArmed() || this.isMounted();
    }

    public boolean isDefensiveUnit() {
        return (this.unitType.getDefence() > 1 || this.isArmed() || this.isMounted()) && !this.isNaval();
    }

    public boolean isUndead() {
        return this.hasAbility("model.ability.undead");
    }

    public void train() {
        String newName;
        String oldName = this.getName();
        UnitType skillTaught = FreeCol.getSpecification().getUnitType(this.getTeacher().getType().getSkillTaught());
        UnitType learning = Unit.getUnitTypeTeaching(skillTaught, this.unitType);
        if (learning != null) {
            this.setType(learning);
        }
        if (!(newName = this.getName()).equals(oldName)) {
            Colony colony = this.getTile().getColony();
            this.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.UNIT_IMPROVED, this, "model.unit.unitEducated", "%oldName%", oldName, "%unit%", newName, "%colony%", colony.getName());
        }
        this.setTurnsOfTraining(0);
        this.setMovesLeft(0);
    }

    public void adjustTension(Unit enemyUnit) {
        Player myPlayer = this.getOwner();
        Player enemy = enemyUnit.getOwner();
        myPlayer.modifyTension(enemy, -100);
        if (this.getIndianSettlement() != null) {
            this.getIndianSettlement().modifyAlarm(enemy, -200);
        }
        if (enemy.isAI()) {
            Settlement settlement = enemyUnit.getTile().getSettlement();
            if (settlement != null) {
                if (settlement instanceof IndianSettlement) {
                    IndianSettlement indianSettlement = (IndianSettlement)settlement;
                    if (indianSettlement.isCapital()) {
                        indianSettlement.modifyAlarm(myPlayer, 600);
                    } else {
                        indianSettlement.modifyAlarm(myPlayer, 500);
                    }
                } else {
                    enemy.modifyTension(myPlayer, 200);
                }
            } else {
                IndianSettlement homeTown = enemyUnit.getIndianSettlement();
                if (homeTown != null) {
                    homeTown.modifyAlarm(myPlayer, 400);
                } else {
                    enemy.modifyTension(myPlayer, 100);
                }
            }
        }
    }

    public boolean canCarryTreasure() {
        return this.unitType.hasAbility("model.ability.carryTreasure");
    }

    public boolean canCaptureGoods() {
        return this.unitType.hasAbility("model.ability.captureGoods");
    }

    public void captureGoods(Unit enemyUnit) {
        if (!this.canCaptureGoods()) {
            return;
        }
        Iterator<Goods> iter = enemyUnit.getGoodsIterator();
        while (iter.hasNext() && this.getSpaceLeft() > 0) {
            Goods g = iter.next();
            this.getGoodsContainer().addGoods(g);
        }
    }

    @Override
    public Colony getColony() {
        Location location = this.getLocation();
        return location != null ? location.getColony() : null;
    }

    public void clearSpeciality() {
        UnitType newType = this.unitType.getDowngrade(UnitType.DowngradeType.CLEAR_SKILL);
        if (newType != null) {
            this.setType(newType);
        }
    }

    public int getProductionOf(GoodsType goodsType, int base) {
        if (base == 0) {
            return 0;
        }
        return Math.round(FeatureContainer.applyModifierSet(base, this.getGame().getTurn(), this.getModifierSet(goodsType.getId())));
    }

    public void disposeAllUnits() {
        for (Unit unit : new ArrayList<Unit>(this.units)) {
            unit.dispose();
        }
    }

    @Override
    public void dispose() {
        this.disposeAllUnits();
        if (this.unitType.canCarryGoods()) {
            this.goodsContainer.dispose();
        }
        if (this.location != null) {
            this.location.remove(this);
        }
        if (this.teacher != null) {
            this.teacher.setStudent(null);
            this.teacher = null;
        }
        if (this.student != null) {
            this.student.setTeacher(null);
            this.student = null;
        }
        this.setIndianSettlement(null);
        this.getOwner().invalidateCanSeeTiles();
        this.getOwner().removeUnit(this);
        super.dispose();
    }

    private void checkExperiencePromotion() {
        GoodsType produce = this.getWorkType();
        if (produce == null) {
            return;
        }
        UnitType learnType = FreeCol.getSpecification().getExpertForProducing(produce);
        if (learnType == null || learnType == this.unitType || !this.unitType.canBeUpgraded(learnType, UnitType.UpgradeType.EXPERIENCE)) {
            return;
        }
        int random = this.getGame().getModelController().getRandom(this.getId() + "experience", 5000);
        if (random >= Math.min(this.experience, 200)) {
            return;
        }
        logger.finest("About to change type of unit due to experience.");
        String oldName = this.getName();
        this.setType(learnType);
        this.addModelMessage((FreeColGameObject)this.getColony(), ModelMessage.MessageType.UNIT_IMPROVED, this, "model.unit.experience", "%oldName%", oldName, "%unit%", this.getName(), "%colony%", this.getColony().getName());
    }

    public void newTurn() {
        if (this.isUninitialized()) {
            logger.warning("Calling newTurn for an uninitialized object: " + this.getId());
            return;
        }
        if (this.location instanceof ColonyTile) {
            this.checkExperiencePromotion();
        }
        if (this.location instanceof Tile && ((Tile)this.location).getSettlement() == null) {
            ++this.attrition;
            if (this.attrition > this.getType().getMaximumAttrition()) {
                this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.UNIT_LOST, this, "model.unit.attrition", "%unit%", this.getName());
                this.dispose();
            }
        } else {
            this.attrition = 0;
        }
        this.movesLeft = this.isUnderRepair() ? 0 : this.getInitialMovesLeft();
        this.doAssignedWork();
        if (this.getState() == UnitState.SKIPPED) {
            this.setState(UnitState.ACTIVE);
        }
    }

    private void unitsToXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (!this.units.isEmpty()) {
            out.writeStartElement(UNITS_TAG_NAME);
            for (Unit unit : this.units) {
                unit.toXML(out, player, showAll, toSavedGame);
            }
            out.writeEndElement();
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Unit.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        if (this.name != null) {
            out.writeAttribute("name", this.name);
        }
        out.writeAttribute("unitType", this.unitType.getId());
        out.writeAttribute("movesLeft", Integer.toString(this.movesLeft));
        out.writeAttribute("state", this.state.toString());
        out.writeAttribute("role", this.role.toString());
        String ownerID = null;
        ownerID = this.getOwner().equals(player) || !this.hasAbility("model.ability.piracy") || showAll ? this.owner.getId() : "unknown enemy";
        out.writeAttribute("owner", ownerID);
        out.writeAttribute("turnsOfTraining", Integer.toString(this.turnsOfTraining));
        out.writeAttribute("workType", this.workType.getId());
        out.writeAttribute("experience", Integer.toString(this.experience));
        out.writeAttribute("treasureAmount", Integer.toString(this.treasureAmount));
        out.writeAttribute("hitpoints", Integer.toString(this.hitpoints));
        out.writeAttribute("attrition", Integer.toString(this.attrition));
        this.writeAttribute(out, "student", this.student);
        this.writeAttribute(out, "teacher", this.teacher);
        if (this.getGame().isClientTrusted() || showAll || player == this.getOwner()) {
            this.writeAttribute(out, "indianSettlement", this.indianSettlement);
            out.writeAttribute("workLeft", Integer.toString(this.workLeft));
        } else {
            out.writeAttribute("workLeft", Integer.toString(-1));
        }
        if (this.entryLocation != null) {
            out.writeAttribute("entryLocation", this.entryLocation.getId());
        }
        if (this.location != null) {
            if (this.getGame().isClientTrusted() || showAll || player == this.getOwner() || !(this.location instanceof Building) && !(this.location instanceof ColonyTile)) {
                out.writeAttribute("location", this.location.getId());
            } else {
                out.writeAttribute("location", this.getColony().getId());
            }
        }
        if (this.destination != null) {
            out.writeAttribute("destination", this.destination.getId());
        }
        if (this.tradeRoute != null) {
            out.writeAttribute("tradeRoute", this.tradeRoute.getId());
            out.writeAttribute("currentStop", String.valueOf(this.currentStop));
        }
        this.writeFreeColGameObject(this.workImprovement, out, player, showAll, toSavedGame);
        if (this.getGame().isClientTrusted() || showAll || this.getOwner().equals(player) || !this.getGameOptions().getBoolean("model.option.unitHiding") && player.canSee(this.getTile())) {
            this.unitsToXML(out, player, showAll, toSavedGame);
            if (this.canCarryGoods()) {
                this.goodsContainer.toXML(out, player, showAll, toSavedGame);
            }
        } else if (this.canCarryGoods()) {
            out.writeAttribute("visibleGoodsCount", Integer.toString(this.getGoodsCount()));
            GoodsContainer emptyGoodsContainer = new GoodsContainer(this.getGame(), this);
            emptyGoodsContainer.setFakeID(this.goodsContainer.getId());
            emptyGoodsContainer.toXML(out, player, showAll, toSavedGame);
        }
        if (!this.equipment.isEmpty()) {
            out.writeStartElement(EQUIPMENT_TAG);
            out.writeAttribute("xLength", Integer.toString(this.equipment.size()));
            int index = 0;
            for (EquipmentType type : this.equipment) {
                out.writeAttribute("x" + Integer.toString(index), type.getId());
                ++index;
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String locationStr;
        this.setId(in.getAttributeValue(null, "ID"));
        this.setName(in.getAttributeValue(null, "name"));
        UnitType oldUnitType = this.unitType;
        this.unitType = FreeCol.getSpecification().getUnitType(in.getAttributeValue(null, "unitType"));
        this.naval = this.unitType.hasAbility("model.ability.navalUnit");
        this.movesLeft = Integer.parseInt(in.getAttributeValue(null, "movesLeft"));
        this.state = Enum.valueOf(UnitState.class, in.getAttributeValue(null, "state"));
        this.role = Enum.valueOf(Role.class, in.getAttributeValue(null, "role"));
        this.workLeft = Integer.parseInt(in.getAttributeValue(null, "workLeft"));
        this.attrition = this.getAttribute(in, "attrition", 0);
        String ownerID = in.getAttributeValue(null, "owner");
        if (ownerID.equals("unknown enemy")) {
            this.owner = this.getGame().getUnknownEnemy();
        } else {
            this.owner = (Player)this.getGame().getFreeColGameObject(ownerID);
            if (this.owner == null) {
                this.owner = new Player(this.getGame(), in.getAttributeValue(null, "owner"));
            }
        }
        if (oldUnitType == null) {
            this.owner.modifyScore(this.unitType.getScoreValue());
        } else {
            this.owner.modifyScore(this.unitType.getScoreValue() - oldUnitType.getScoreValue());
        }
        this.turnsOfTraining = Integer.parseInt(in.getAttributeValue(null, "turnsOfTraining"));
        this.hitpoints = Integer.parseInt(in.getAttributeValue(null, "hitpoints"));
        this.teacher = this.getFreeColGameObject(in, "teacher", Unit.class);
        this.student = this.getFreeColGameObject(in, "student", Unit.class);
        String indianSettlementStr = in.getAttributeValue(null, "indianSettlement");
        if (indianSettlementStr != null) {
            this.indianSettlement = (IndianSettlement)this.getGame().getFreeColGameObject(indianSettlementStr);
            if (this.indianSettlement == null) {
                this.indianSettlement = new IndianSettlement(this.getGame(), indianSettlementStr);
            }
        } else {
            this.setIndianSettlement(null);
        }
        this.treasureAmount = this.getAttribute(in, "treasureAmount", 0);
        String destinationStr = in.getAttributeValue(null, "destination");
        if (destinationStr != null) {
            this.destination = (Location)((Object)this.getGame().getFreeColGameObject(destinationStr));
            if (this.destination == null) {
                this.destination = this.newLocation(this.getGame(), destinationStr);
            }
        } else {
            this.destination = null;
        }
        this.currentStop = -1;
        this.tradeRoute = null;
        String tradeRouteStr = in.getAttributeValue(null, "tradeRoute");
        if (tradeRouteStr != null) {
            this.tradeRoute = (TradeRoute)this.getGame().getFreeColGameObject(tradeRouteStr);
            String currentStopStr = in.getAttributeValue(null, "currentStop");
            if (currentStopStr != null) {
                this.currentStop = Integer.parseInt(currentStopStr);
            }
        }
        this.workType = FreeCol.getSpecification().getType(in, "workType", GoodsType.class, null);
        this.experience = this.getAttribute(in, "experience", 0);
        this.visibleGoodsCount = this.getAttribute(in, "visibleGoodsCount", -1);
        String entryLocationStr = in.getAttributeValue(null, "entryLocation");
        if (entryLocationStr != null) {
            this.entryLocation = (Location)((Object)this.getGame().getFreeColGameObject(entryLocationStr));
            if (this.entryLocation == null) {
                this.entryLocation = this.newLocation(this.getGame(), entryLocationStr);
            }
        }
        if ((locationStr = in.getAttributeValue(null, "location")) != null) {
            this.location = (Location)((Object)this.getGame().getFreeColGameObject(locationStr));
            if (this.location == null) {
                this.location = this.newLocation(this.getGame(), locationStr);
            }
            if (this.location instanceof WorkLocation && this.state != UnitState.IN_COLONY) {
                logger.warning("Found " + this.getId() + " with state==" + (Object)((Object)this.state) + " on WorkLocation in " + this.location.getColony().getName() + ". Fixing: ");
                this.state = UnitState.IN_COLONY;
            }
        }
        this.equipment.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(UNITS_TAG_NAME)) {
                this.units = new ArrayList<Unit>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    this.units.add(this.updateFreeColGameObject(in, Unit.class));
                }
                continue;
            }
            if (in.getLocalName().equals(GoodsContainer.getXMLElementTagName())) {
                this.goodsContainer = (GoodsContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (this.goodsContainer != null) {
                    this.goodsContainer.readFromXML(in);
                    continue;
                }
                this.goodsContainer = new GoodsContainer(this.getGame(), (Location)this, in);
                continue;
            }
            if (in.getLocalName().equals(EQUIPMENT_TAG)) {
                int length = Integer.parseInt(in.getAttributeValue(null, "xLength"));
                for (int index = 0; index < length; ++index) {
                    String equipmentId = in.getAttributeValue(null, "x" + String.valueOf(index));
                    this.equipment.add(FreeCol.getSpecification().getEquipmentType(equipmentId));
                }
                in.nextTag();
                continue;
            }
            if (!in.getLocalName().equals(TileImprovement.getXMLElementTagName())) continue;
            this.workImprovement = this.updateFreeColGameObject(in, TileImprovement.class);
        }
        if (this.goodsContainer == null && this.canCarryGoods()) {
            logger.warning("Carrier with ID " + this.getId() + " did not have a \"goodsContainer\"-tag.");
            this.goodsContainer = new GoodsContainer(this.getGame(), this);
        }
        this.getOwner().invalidateCanSeeTiles();
    }

    public static String getXMLElementTagName() {
        return "unit";
    }

    private Location newLocation(Game game, String locationString) {
        String XMLElementTag = locationString.substring(0, locationString.indexOf(58));
        if (XMLElementTag.equals(Tile.getXMLElementTagName())) {
            return new Tile(game, locationString);
        }
        if (XMLElementTag.equals(ColonyTile.getXMLElementTagName())) {
            return new ColonyTile(game, locationString);
        }
        if (XMLElementTag.equals(Colony.getXMLElementTagName())) {
            return new Colony(game, locationString);
        }
        if (XMLElementTag.equals(IndianSettlement.getXMLElementTagName())) {
            return new IndianSettlement(game, locationString);
        }
        if (XMLElementTag.equals(Europe.getXMLElementTagName())) {
            return new Europe(game, locationString);
        }
        if (XMLElementTag.equals(Building.getXMLElementTagName())) {
            return new Building(game, locationString);
        }
        if (XMLElementTag.equals(Unit.getXMLElementTagName())) {
            return new Unit(game, locationString);
        }
        logger.warning("Unknown type of Location: " + locationString);
        return new Tile(game, locationString);
    }

    public boolean isAlreadyOnHighSea() {
        return this.alreadyOnHighSea;
    }

    public void setAlreadyOnHighSea(boolean alreadyOnHighSea) {
        this.alreadyOnHighSea = alreadyOnHighSea;
    }

    public int getTurnsForRepair() {
        return this.unitType.getHitPoints() - this.getHitpoints();
    }

    public String getPathTypeImage() {
        if (this.isMounted()) {
            return "horse";
        }
        return this.unitType.getPathImage();
    }

    public List<EquipmentType> getAutomaticEquipment() {
        if (this.isArmed()) {
            return null;
        }
        if (!this.getOwner().hasAbility("model.ability.automaticEquipment")) {
            return null;
        }
        Settlement settlement = null;
        if (this.getLocation() instanceof WorkLocation) {
            settlement = this.getColony();
        }
        if (this.getLocation() instanceof IndianSettlement) {
            settlement = (Settlement)this.getLocation();
        }
        if (settlement == null) {
            return null;
        }
        ArrayList<EquipmentType> equipmentList = null;
        Set<Ability> autoDefence = this.getOwner().getFeatureContainer().getAbilitySet("model.ability.automaticEquipment");
        for (EquipmentType equipment : Specification.getSpecification().getEquipmentTypeList()) {
            for (Ability ability : autoDefence) {
                if (!ability.appliesTo(equipment) || !this.canBeEquippedWith(equipment)) continue;
                boolean hasReqGoods = true;
                for (AbstractGoods goods : equipment.getGoodsRequired()) {
                    if (settlement.getGoodsCount(goods.getType()) >= goods.getAmount()) continue;
                    hasReqGoods = false;
                    break;
                }
                if (!hasReqGoods) continue;
                if (equipmentList == null) {
                    equipmentList = new ArrayList<EquipmentType>();
                }
                equipmentList.add(equipment);
            }
        }
        return equipmentList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoveType {
        MOVE,
        MOVE_HIGH_SEAS,
        ATTACK,
        EMBARK,
        DISEMBARK,
        ENTER_INDIAN_VILLAGE_WITH_FREE_COLONIST,
        ENTER_INDIAN_VILLAGE_WITH_SCOUT,
        ENTER_INDIAN_VILLAGE_WITH_MISSIONARY,
        ENTER_FOREIGN_COLONY_WITH_SCOUT,
        ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS,
        EXPLORE_LOST_CITY_RUMOUR,
        ILLEGAL_MOVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        DEFAULT,
        PIONEER,
        MISSIONARY,
        SOLDIER,
        SCOUT,
        DRAGOON;


        public String getId() {
            return this.toString().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitState {
        ACTIVE,
        FORTIFIED,
        SENTRY,
        IN_COLONY,
        IMPROVING,
        TO_EUROPE,
        IN_EUROPE,
        TO_AMERICA,
        FORTIFYING,
        SKIPPED;

    }
}

