/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;

public class UnitTradeItem
extends TradeItem {
    private Unit unit;

    public UnitTradeItem(Game game, Player source, Player destination, Unit unit) {
        super(game, "tradeItem.unit", source, destination);
        this.unit = unit;
    }

    public UnitTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXMLImpl(in);
    }

    public final Unit getUnit() {
        return this.unit;
    }

    public final void setUnit(Unit newUnit) {
        this.unit = newUnit;
    }

    public boolean isValid() {
        return this.unit.getOwner() == this.getSource();
    }

    public boolean isUnique() {
        return false;
    }

    public void makeTrade() {
        this.unit.setOwner(this.getDestination());
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readFromXMLImpl(in);
        String unitID = in.getAttributeValue(null, "unit");
        this.unit = (Unit)this.getGame().getFreeColGameObject(unitID);
        in.nextTag();
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(UnitTradeItem.getXMLElementTagName());
        super.toXMLImpl(out);
        out.writeAttribute("unit", this.unit.getId());
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "unitTradeItem";
    }
}

