/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitType
extends BuildableType {
    public static final int DEFAULT_OFFENCE = 0;
    public static final int DEFAULT_DEFENCE = 1;
    private int offence;
    private int defence;
    private int space;
    private int hitPoints;
    private int spaceTaken;
    private int skill;
    private int price;
    private int movement;
    private int lineOfSight;
    private int recruitProbability;
    private GoodsType expertProduction;
    private int scoreValue;
    private String pathImage;
    private int maximumAttrition;
    private String skillTaught;
    private EquipmentType defaultEquipment;
    private HashMap<String, Upgrade> upgrades = new HashMap();
    private HashMap<String, Downgrade> downgrades = new HashMap();

    public UnitType(int index) {
        this.setIndex(index);
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public int getScoreValue() {
        return this.scoreValue;
    }

    public void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    public int getOffence() {
        return this.offence;
    }

    public void setOffence(int newOffence) {
        this.offence = newOffence;
    }

    public int getDefence() {
        return this.defence;
    }

    public void setDefence(int newDefence) {
        this.defence = newDefence;
    }

    public int getLineOfSight() {
        return this.lineOfSight;
    }

    public void setLineOfSight(int newLineOfSight) {
        this.lineOfSight = newLineOfSight;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int newSpace) {
        this.space = newSpace;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public void setHitPoints(int newHitPoints) {
        this.hitPoints = newHitPoints;
    }

    public int getSpaceTaken() {
        return Math.max(this.spaceTaken, this.space + 1);
    }

    public void setSpaceTaken(int newSpaceTaken) {
        this.spaceTaken = newSpaceTaken;
    }

    public boolean isRecruitable() {
        return this.recruitProbability > 0;
    }

    public int getRecruitProbability() {
        return this.recruitProbability;
    }

    public void setRecruitProbability(int newRecruitProbability) {
        this.recruitProbability = newRecruitProbability;
    }

    public int getSkill() {
        return this.skill;
    }

    public void setSkill(int newSkill) {
        this.skill = newSkill;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int newPrice) {
        this.price = newPrice;
    }

    public int getMovement() {
        return this.movement;
    }

    public void setMovement(int newMovement) {
        this.movement = newMovement;
    }

    public int getMaximumAttrition() {
        return this.maximumAttrition;
    }

    public void setMaximumAttrition(int newMaximumAttrition) {
        this.maximumAttrition = newMaximumAttrition;
    }

    public GoodsType getExpertProduction() {
        return this.expertProduction;
    }

    public void setExpertProduction(GoodsType newExpertProduction) {
        this.expertProduction = newExpertProduction;
    }

    public EquipmentType getDefaultEquipmentType() {
        return this.defaultEquipment;
    }

    public void setDefaultEquipmentType(EquipmentType newDefaultEquipment) {
        this.defaultEquipment = newDefaultEquipment;
    }

    public EquipmentType[] getDefaultEquipment() {
        if (this.hasAbility("model.ability.canBeEquipped") && this.defaultEquipment != null) {
            int count = this.defaultEquipment.getMaximumCount();
            EquipmentType[] result = new EquipmentType[count];
            for (int index = 0; index < count; ++index) {
                result[index] = this.defaultEquipment;
            }
            return result;
        }
        return EquipmentType.NO_EQUIPMENT;
    }

    public String getPathImage() {
        return this.pathImage;
    }

    public void setPathImage(String newPathImage) {
        this.pathImage = newPathImage;
    }

    public String getSkillTaught() {
        return this.skillTaught;
    }

    public void setSkillTaught(String newSkillTaught) {
        this.skillTaught = newSkillTaught;
    }

    public boolean isAvailableTo(Player player) {
        Map<String, Boolean> requiredAbilities = this.getAbilitiesRequired();
        for (Map.Entry<String, Boolean> entry : requiredAbilities.entrySet()) {
            if (player.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public UnitType getPromotion() {
        for (Map.Entry<String, Upgrade> entry : this.upgrades.entrySet()) {
            if (!entry.getValue().asResultOf.get((Object)UpgradeType.PROMOTION).booleanValue()) continue;
            return FreeCol.getSpecification().getUnitType(entry.getKey());
        }
        return null;
    }

    public UnitType getDowngrade(DowngradeType downgradeType) {
        for (Map.Entry<String, Downgrade> pair : this.downgrades.entrySet()) {
            if (!pair.getValue().asResultOf.get((Object)downgradeType).booleanValue()) continue;
            return FreeCol.getSpecification().getUnitType(pair.getKey());
        }
        return null;
    }

    public boolean canBeUpgraded(UnitType newType, UpgradeType educationType) {
        Upgrade upgrade = this.upgrades.get(newType.getSkillTaught());
        return upgrade != null && upgrade.asResultOf.get((Object)educationType) != false;
    }

    public List<UnitType> getUnitTypesLearntInLostCity() {
        Iterator<Map.Entry<String, Upgrade>> iterator = this.upgrades.entrySet().iterator();
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        while (iterator.hasNext()) {
            Map.Entry<String, Upgrade> pair = iterator.next();
            if (!pair.getValue().asResultOf.get((Object)UpgradeType.LOST_CITY).booleanValue()) continue;
            unitTypes.add(FreeCol.getSpecification().getUnitType(pair.getKey()));
        }
        return unitTypes;
    }

    public UnitType getEducationUnit(int maximumSkill) {
        for (Map.Entry<String, Upgrade> entry : this.upgrades.entrySet()) {
            UnitType unitType;
            if (!entry.getValue().canBeTaught() || !(unitType = FreeCol.getSpecification().getUnitType(entry.getKey())).hasSkill() || unitType.getSkill() > maximumSkill) continue;
            return unitType;
        }
        return null;
    }

    public int getEducationTurns(UnitType unitType) {
        Upgrade upgrade = this.upgrades.get(unitType.getId());
        if (upgrade != null) {
            return upgrade.turnsToLearn;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.offence = this.getAttribute(in, "offence", 0);
        this.defence = this.getAttribute(in, "defence", 1);
        this.movement = Integer.parseInt(in.getAttributeValue(null, "movement"));
        this.lineOfSight = this.getAttribute(in, "lineOfSight", 1);
        this.scoreValue = this.getAttribute(in, "scoreValue", 0);
        this.space = this.getAttribute(in, "space", 0);
        this.hitPoints = this.getAttribute(in, "hitPoints", 0);
        this.spaceTaken = this.getAttribute(in, "spaceTaken", 1);
        this.maximumAttrition = this.getAttribute(in, "maximumAttrition", Integer.MAX_VALUE);
        this.skillTaught = this.getAttribute(in, "skillTaught", this.getId());
        this.pathImage = in.getAttributeValue(null, "pathImage");
        this.recruitProbability = this.getAttribute(in, "recruitProbability", 0);
        this.skill = this.getAttribute(in, "skill", Integer.MIN_VALUE);
        this.setPopulationRequired(this.getAttribute(in, "population-required", 1));
        this.price = this.getAttribute(in, "price", Integer.MIN_VALUE);
        this.expertProduction = specification.getType(in, "expert-production", GoodsType.class, null);
    }

    @Override
    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String educationUnit;
            String nodeName = in.getLocalName();
            if ("upgrade".equals(nodeName)) {
                Upgrade upgrade = new Upgrade();
                educationUnit = in.getAttributeValue(null, "unit");
                upgrade.turnsToLearn = this.getAttribute(in, "turnsToLearn", Integer.MIN_VALUE);
                upgrade.asResultOf.put(UpgradeType.EDUCATION, this.getAttribute(in, "learnInSchool", true));
                upgrade.asResultOf.put(UpgradeType.NATIVES, this.getAttribute(in, "learnFromNatives", false));
                upgrade.asResultOf.put(UpgradeType.EXPERIENCE, this.getAttribute(in, "learnFromExperience", false));
                upgrade.asResultOf.put(UpgradeType.LOST_CITY, this.getAttribute(in, "learnInLostCity", false));
                upgrade.asResultOf.put(UpgradeType.PROMOTION, this.getAttribute(in, "promotion", false));
                this.upgrades.put(educationUnit, upgrade);
                in.nextTag();
                continue;
            }
            if ("downgrade".equals(nodeName)) {
                Downgrade downgrade = new Downgrade();
                educationUnit = in.getAttributeValue(null, "unit");
                downgrade.asResultOf.put(DowngradeType.CLEAR_SKILL, this.getAttribute(in, "clearSkill", true));
                downgrade.asResultOf.put(DowngradeType.DEMOTION, this.getAttribute(in, "demotion", false));
                downgrade.asResultOf.put(DowngradeType.CAPTURE, this.getAttribute(in, "capture", false));
                this.downgrades.put(educationUnit, downgrade);
                in.nextTag();
                continue;
            }
            if ("default-equipment".equals(nodeName)) {
                String equipmentString = in.getAttributeValue(null, "id");
                if (equipmentString != null) {
                    this.defaultEquipment = specification.getEquipmentType(equipmentString);
                }
                in.nextTag();
                continue;
            }
            super.readChild(in, specification);
        }
    }

    public boolean hasSkill() {
        return this.skill != Integer.MIN_VALUE;
    }

    public boolean canBeBuilt() {
        return !this.getGoodsRequired().isEmpty();
    }

    public boolean hasPrice() {
        return this.price != Integer.MIN_VALUE;
    }

    public int getProductionFor(GoodsType goodsType, int base) {
        if (base == 0) {
            return 0;
        }
        base = (int)this.featureContainer.applyModifier(base, goodsType.getId());
        return Math.max(base, 1);
    }

    private class Downgrade {
        protected EnumMap<DowngradeType, Boolean> asResultOf = new EnumMap(DowngradeType.class);

        private Downgrade() {
        }
    }

    private class Upgrade {
        protected int turnsToLearn;
        protected EnumMap<UpgradeType, Boolean> asResultOf = new EnumMap(UpgradeType.class);

        private Upgrade() {
        }

        public boolean canBeTaught() {
            return this.asResultOf.get((Object)UpgradeType.EDUCATION) != false && this.turnsToLearn > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DowngradeType {
        CLEAR_SKILL,
        DEMOTION,
        CAPTURE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpgradeType {
        EDUCATION,
        NATIVES,
        EXPERIENCE,
        LOST_CITY,
        PROMOTION;

    }
}

