/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;

public class BuyLandMessage
extends Message {
    private Tile tile;

    public BuyLandMessage(Tile tile) {
        this.tile = tile;
    }

    public BuyLandMessage(Game game, Element element) {
        this.tile = (Tile)game.getFreeColGameObject(element.getAttribute("tile"));
    }

    public final Tile getTile() {
        return this.tile;
    }

    public final void setTile(Tile newTile) {
        this.tile = newTile;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        if (this.tile == null) {
            throw new IllegalStateException("Tile must not be 'null'.");
        }
        if (this.tile.getOwner() == null) {
            this.tile.setOwner(player);
        } else {
            if (this.tile.getOwner().isEuropean()) {
                throw new IllegalStateException("Can not buy land from European players!");
            }
            player.buyLand(this.tile);
        }
        return null;
    }

    public Element toXMLElement() {
        Element result = BuyLandMessage.createNewRootElement(BuyLandMessage.getXMLElementTagName());
        result.setAttribute("tile", this.tile.getId());
        return result;
    }

    public static String getXMLElementTagName() {
        return "buyLand";
    }
}

