/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Message {
    protected static final Logger logger = Logger.getLogger(Message.class.getName());
    private static final String FREECOL_PROTOCOL_VERSION = "0.1.4";
    private static final String INVALID_MESSAGE = "invalid";
    protected Document document;

    protected Message() {
    }

    public Message(String msg) throws SAXException, IOException {
        this(new InputSource(new StringReader(msg)));
    }

    public Message(InputStream inputStream) throws SAXException, IOException {
        this(new InputSource(inputStream));
    }

    private Message(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document tempDocument = null;
        boolean dumpMsgOnError = FreeCol.isInDebugMode();
        dumpMsgOnError = true;
        if (dumpMsgOnError) {
            inputSource.setByteStream(new BufferedInputStream(inputSource.getByteStream()));
            inputSource.getByteStream().mark(1000000);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            tempDocument = builder.parse(inputSource);
        }
        catch (ParserConfigurationException pce) {
            StringWriter sw = new StringWriter();
            pce.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
        }
        catch (SAXException se) {
            throw se;
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (dumpMsgOnError) {
                int i;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                inputSource.getByteStream().reset();
                while (-1 != (i = inputSource.getByteStream().read())) {
                    baos.write(i);
                }
                logger.severe(baos.toString());
            }
            throw e;
        }
        this.document = tempDocument;
    }

    public Message(Document document) {
        this.document = document;
    }

    public static String getFreeColProtocolVersion() {
        return FREECOL_PROTOCOL_VERSION;
    }

    public static Document createNewDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return null;
        }
    }

    public static Element createNewRootElement(String tagName) {
        return Message.createNewDocument().createElement(tagName);
    }

    public static Element createError(String messageID, String message) {
        Element errorElement = Message.createNewRootElement("error");
        if (messageID != null && !messageID.equals("")) {
            errorElement.setAttribute("messageID", messageID);
        }
        if (message != null && !message.equals("")) {
            errorElement.setAttribute("message", message);
        }
        return errorElement;
    }

    public static void createError(XMLStreamWriter out, String messageID, String message) {
        try {
            out.writeStartElement("error");
            if (messageID != null && !messageID.equals("")) {
                out.writeAttribute("messageID", messageID);
            }
            if (message != null && !message.equals("")) {
                out.writeAttribute("message", message);
            }
            out.writeEndElement();
        }
        catch (XMLStreamException e) {
            logger.warning("Could not send error message.");
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public String getType() {
        if (this.document != null && this.document.getDocumentElement() != null) {
            return this.document.getDocumentElement().getTagName();
        }
        return INVALID_MESSAGE;
    }

    public boolean isType(String type) {
        return this.getType().equals(type);
    }

    public void setAttribute(String key, String value) {
        this.document.getDocumentElement().setAttribute(key, value);
    }

    public void setAttribute(String key, int value) {
        this.document.getDocumentElement().setAttribute(key, new Integer(value).toString());
    }

    public String getAttribute(String key) {
        return this.document.getDocumentElement().getAttribute(key);
    }

    public boolean hasAttribute(String attribute) {
        return this.document.getDocumentElement().hasAttribute(attribute);
    }

    public void insertAsRoot(Element newRoot) {
        Element oldRoot = this.document.getDocumentElement();
        if (oldRoot != null) {
            this.document.removeChild(oldRoot);
            newRoot.appendChild(oldRoot);
        }
        this.document.appendChild(newRoot);
    }

    public static Element getChildElement(Element element, String tagName) {
        NodeList n = element.getChildNodes();
        for (int i = 0; i < n.getLength(); ++i) {
            if (!(n.item(i) instanceof Element) || !((Element)n.item(i)).getTagName().equals(tagName)) continue;
            return (Element)n.item(i);
        }
        return null;
    }

    public String toString() {
        return this.document.getDocumentElement().toString();
    }
}

