/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;

public class StealLandMessage
extends Message {
    private Tile tile;
    private Colony colony;

    public StealLandMessage(Tile tile, Colony colony) {
        this.tile = tile;
        this.colony = colony;
    }

    public StealLandMessage(Game game, Element element) {
        this.tile = (Tile)game.getFreeColGameObject(element.getAttribute("tile"));
        String colonyID = element.getAttribute("colony");
        if (colonyID != null) {
            this.colony = (Colony)game.getFreeColGameObject(element.getAttribute("colony"));
        }
    }

    public final Tile getTile() {
        return this.tile;
    }

    public final void setTile(Tile newTile) {
        this.tile = newTile;
    }

    public final Colony getColony() {
        return this.colony;
    }

    public final void setColony(Colony newColony) {
        this.colony = newColony;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        if (this.tile.getOwner() != null && this.tile.getOwner().isEuropean()) {
            throw new IllegalStateException("Can not steal land from European players!");
        }
        this.tile.takeOwnership(player, this.colony);
        return null;
    }

    public Element toXMLElement() {
        Element result = StealLandMessage.createNewRootElement(StealLandMessage.getXMLElementTagName());
        result.setAttribute("tile", this.tile.getId());
        if (this.colony != null) {
            result.setAttribute("colony", this.colony.getId());
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "stealLand";
    }
}

