/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;

public abstract class AbstractOption
extends FreeColObject
implements Option {
    public static final String NO_ID = "NO_ID";
    private static Logger logger = Logger.getLogger(AbstractOption.class.getName());
    private String optionGroup = "";
    protected boolean isDefined = false;
    protected boolean previewEnabled = false;

    public AbstractOption(String id) {
        this(id, null);
    }

    public AbstractOption(String id, OptionGroup optionGroup) {
        this.setId(id);
        if (optionGroup != null) {
            this.setGroup(optionGroup.getId());
            optionGroup.add(this);
        }
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.previewEnabled = previewEnabled;
    }

    public String toString() {
        return this.getName();
    }

    public String getGroup() {
        return this.optionGroup;
    }

    public void setGroup(String group) {
        this.optionGroup = group == null ? "" : group;
    }

    public String getName() {
        return Messages.message(this.getGroup() + "." + this.getId().replaceFirst("model\\.option\\.", "") + ".name", new String[0]);
    }

    public String getShortDescription() {
        return Messages.message(this.getGroup() + "." + this.getId().replaceFirst("model\\.option\\.", "") + ".shortDescription", new String[0]);
    }
}

