/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.OptionGroup;

public class IntegerOption
extends AbstractOption {
    private static Logger logger = Logger.getLogger(IntegerOption.class.getName());
    private int value;
    private int minimumValue;
    private int maximumValue;

    public IntegerOption(String id, OptionGroup optionGroup, int minimumValue, int maximumValue, int defaultValue) {
        super(id, optionGroup);
        this.value = defaultValue;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    public IntegerOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        int oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", (Object)oldValue, (Object)value);
        }
        this.isDefined = true;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(IntegerOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", Integer.toString(this.value));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + IntegerOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + IntegerOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(Integer.parseInt(value));
        } else {
            this.setValue(Integer.parseInt(defaultValue));
            this.minimumValue = Integer.parseInt(in.getAttributeValue(null, "minimumValue"));
            this.maximumValue = Integer.parseInt(in.getAttributeValue(null, "maximumValue"));
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "integerOption";
    }
}

