/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionGroup
extends AbstractOption {
    private static Logger logger = Logger.getLogger(OptionGroup.class.getName());
    private ArrayList<Option> options = new ArrayList();

    public OptionGroup() {
        this("NO_ID");
    }

    public OptionGroup(String id) {
        super(id);
    }

    public OptionGroup(XMLStreamReader in) throws XMLStreamException {
        this("NO_ID");
        this.readFromXML(in);
    }

    public void add(Option option) {
        this.options.add(option);
    }

    public void removeAll() {
        this.options.clear();
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(OptionGroup.getXMLElementTagName());
        Iterator<Option> oi = this.options.iterator();
        while (oi.hasNext()) {
            oi.next().toXML(out);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id != null) {
            this.setId(id);
        }
        while (in.nextTag() != 2) {
            AbstractOption option = null;
            String optionType = in.getLocalName();
            if (IntegerOption.getXMLElementTagName().equals(optionType) || "integer-option".equals(optionType)) {
                option = new IntegerOption(in);
            } else if (BooleanOption.getXMLElementTagName().equals(optionType) || "boolean-option".equals(optionType)) {
                option = new BooleanOption(in);
            } else if (RangeOption.getXMLElementTagName().equals(optionType) || "range-option".equals(optionType)) {
                option = new RangeOption(in);
            } else if (SelectOption.getXMLElementTagName().equals(optionType) || "select-option".equals(optionType)) {
                option = new SelectOption(in);
            } else if (LanguageOption.getXMLElementTagName().equals(optionType) || "language-option".equals(optionType)) {
                option = new LanguageOption(in);
            } else if (FileOption.getXMLElementTagName().equals(optionType) || "file-option".equals(optionType)) {
                option = new FileOption(in);
            } else {
                logger.finest("Parsing of " + optionType + " is not implemented yet");
                in.nextTag();
            }
            if (option == null) continue;
            this.add(option);
            option.setGroup(this.getId());
        }
    }

    public static String getXMLElementTagName() {
        return "optionGroup";
    }

    @Override
    public String getName() {
        return Messages.message(this.getId() + ".name", new String[0]);
    }

    @Override
    public String getShortDescription() {
        return Messages.message(this.getId() + ".shortDescription", new String[0]);
    }
}

