/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import org.w3c.dom.Element;

public abstract class OptionMap
extends OptionGroup {
    private static Logger logger = Logger.getLogger(OptionMap.class.getName());
    private String xmlTagName;
    private HashMap<String, Option> values;

    public OptionMap(String xmlTagName) {
        super(xmlTagName);
        this.xmlTagName = xmlTagName;
        this.values = new HashMap();
        this.addDefaultOptions();
        this.addToMap(this);
    }

    public OptionMap(XMLStreamReader in, String xmlTagName) throws XMLStreamException {
        this(xmlTagName);
        this.readFromXML(in);
    }

    public OptionMap(Element element, String xmlTagName) {
        this(xmlTagName);
        this.readFromXMLElement(element);
    }

    protected abstract void addDefaultOptions();

    public Option getObject(String id) {
        return this.values.get(id);
    }

    public int getInteger(String id) {
        Option o = this.values.get(id);
        if (o instanceof IntegerOption) {
            return ((IntegerOption)o).getValue();
        }
        if (o instanceof SelectOption) {
            return ((SelectOption)o).getValue();
        }
        if (o instanceof RangeOption) {
            return ((RangeOption)o).getValue();
        }
        throw new IllegalArgumentException("No integer value associated with the specified option.");
    }

    public boolean getBoolean(String id) {
        try {
            return ((BooleanOption)this.values.get(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No boolean value associated with the specified option.");
        }
    }

    public File getFile(String id) {
        try {
            return ((FileOption)this.values.get(id)).getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No File associated with the specified option.");
        }
    }

    public void addToMap(OptionGroup og) {
        Iterator<Option> it = og.iterator();
        while (it.hasNext()) {
            Option option = it.next();
            if (option instanceof OptionGroup) {
                this.addToMap((OptionGroup)option);
                continue;
            }
            this.values.put(option.getId(), option);
        }
    }

    public void putOption(Option option) {
        this.values.put(option.getId(), option);
    }

    private static XMLStreamReader createXMLStreamReader(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ((InputStream)in).mark(10);
        byte[] buf = new byte[5];
        ((InputStream)in).read(buf, 0, 5);
        ((InputStream)in).reset();
        if (!new String(buf).equals("<?xml")) {
            in = new BufferedInputStream(new InflaterInputStream(in));
        }
        XMLInputFactory xif = XMLInputFactory.newInstance();
        try {
            return xif.createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
    }

    protected abstract boolean isCorrectTagName(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File loadFile) {
        if (loadFile == null || !loadFile.exists()) {
            logger.warning("Could not find the client options file.");
            return;
        }
        XMLStreamReader in = null;
        try {
            in = OptionMap.createXMLStreamReader(loadFile);
            in.nextTag();
            while (!this.isCorrectTagName(in.getLocalName())) {
                in.nextTag();
            }
            this.readFromXML(in);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while loading options.", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while closing stream.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File saveFile) {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter xsw = null;
        try {
            xsw = xof.createXMLStreamWriter(new FileOutputStream(saveFile));
            xsw.writeStartDocument("UTF-8", "1.0");
            this.toXML(xsw);
            xsw.writeEndDocument();
            xsw.flush();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while storing options.", e);
        }
        finally {
            try {
                if (xsw != null) {
                    xsw.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while closing stream.", e);
            }
        }
    }

    public void toXML(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(this.xmlTagName);
        Iterator<Option> it = this.values.values().iterator();
        while (it.hasNext()) {
            it.next().toXML(out);
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.updateFromXML(in);
    }

    private void updateFromXML(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String ignoredTag;
            Option o;
            if (in.getLocalName().equals(OptionGroup.getXMLElementTagName())) {
                this.updateFromXML(in);
                continue;
            }
            String idStr = in.getAttributeValue(null, "id");
            if (idStr != null) {
                o = this.getObject(idStr);
                if (o != null) {
                    o.readFromXML(in);
                    continue;
                }
                logger.info("Option \"" + idStr + "\" (" + in.getLocalName() + ") could not be found.");
                ignoredTag = in.getLocalName();
                while (in.nextTag() != 2 || !in.getLocalName().equals(ignoredTag)) {
                }
                continue;
            }
            o = this.getObject(in.getLocalName());
            if (o != null) {
                o.readFromXML(in);
                continue;
            }
            logger.info("Option \"" + in.getLocalName() + " not found.");
            ignoredTag = in.getLocalName();
            while (in.nextTag() != 2 || !in.getLocalName().equals(ignoredTag)) {
            }
        }
    }

    public static String getXMLElementTagName() {
        throw new UnsupportedOperationException();
    }

    public void setFile(String id, File newFileValue) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("Requires an ID");
        }
        if (newFileValue == null) {
            throw new IllegalArgumentException("Requires a File parameter");
        }
        if (this.values.get(id) == null) {
            throw new IllegalArgumentException("No option with ID=[" + id + "]");
        }
        try {
            ((FileOption)this.values.get(id)).setValue(newFileValue);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("No File associated with option [" + id + "].");
        }
    }
}

