/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.OptionGroup;

public class PercentageOption
extends IntegerOption {
    private static Logger logger = Logger.getLogger(PercentageOption.class.getName());

    public PercentageOption(XMLStreamReader in) throws XMLStreamException {
        super(in);
    }

    public PercentageOption(String id, OptionGroup optionGroup, int defaultOption) {
        super(id, optionGroup, 0, 100, defaultOption);
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(PercentageOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", Integer.toString(this.getValue()));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String value = in.getAttributeValue(null, "value");
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + PercentageOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + PercentageOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(Integer.parseInt(value));
        } else {
            this.setValue(Integer.parseInt(defaultValue));
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "percentageOption";
    }
}

