/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOption
extends AbstractOption {
    private static Logger logger = Logger.getLogger(SelectOption.class.getName());
    private int value;
    protected boolean localizedLabels = false;
    private Map<Integer, String> itemValues = new LinkedHashMap<Integer, String>();

    public SelectOption(XMLStreamReader in) throws XMLStreamException {
        super("NO_ID");
        this.readFromXML(in);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        int oldValue = this.value;
        this.value = value;
        if (value != oldValue) {
            this.firePropertyChange("value", (Object)oldValue, (Object)value);
        }
        this.isDefined = true;
    }

    public Map<Integer, String> getItemValues() {
        return this.itemValues;
    }

    protected String getStringValue() {
        return Integer.toString(this.value);
    }

    protected void setValue(String value) {
        this.setValue(Integer.parseInt(value));
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(SelectOption.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", this.getStringValue());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        String defaultValue = in.getAttributeValue(null, "defaultValue");
        String localizedLabels = in.getAttributeValue(null, "localizedLabels");
        String value = in.getAttributeValue(null, "value");
        if (localizedLabels != null) {
            this.localizedLabels = localizedLabels.equals("true");
        }
        if (id == null && this.getId().equals("NO_ID")) {
            throw new XMLStreamException("invalid <" + SelectOption.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        if (defaultValue == null && value == null) {
            throw new XMLStreamException("invalid <" + SelectOption.getXMLElementTagName() + "> tag : no value nor default value found.");
        }
        if (this.getId() == "NO_ID") {
            this.setId(id);
        }
        if (value != null) {
            this.setValue(Integer.parseInt(value));
            in.nextTag();
        } else {
            this.setValue(Integer.parseInt(defaultValue));
            while (in.nextTag() != 2) {
                String itemValue;
                String label;
                if (in.getLocalName() == this.getXMLItemElementTagName()) {
                    label = in.getAttributeValue(null, "label");
                    itemValue = in.getAttributeValue(null, "value");
                    if (this.localizedLabels) {
                        label = Messages.message(label, new String[0]);
                    }
                } else {
                    throw new XMLStreamException("Unknown child \"" + in.getLocalName() + "\" in a \"" + SelectOption.getXMLElementTagName() + "\". ");
                }
                this.itemValues.put(Integer.parseInt(itemValue), label);
                in.nextTag();
            }
        }
    }

    public static String getXMLElementTagName() {
        return "selectOption";
    }

    public String getXMLItemElementTagName() {
        return "selectValue";
    }
}

