/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.freecol.common.resources.Resource;

public class ImageResource
extends Resource {
    private Map<Dimension, Image> grayscaleImages = new HashMap<Dimension, Image>();
    private Map<Dimension, Image> scaledImages = new HashMap<Dimension, Image>();
    private Image image = null;
    private Object loadingLock = new Object();
    private static final Component _c = new Component(){};

    ImageResource(URL resourceLocator) {
        super(resourceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.image != null) {
                return this.image;
            }
            MediaTracker mt = new MediaTracker(_c);
            Image im = Toolkit.getDefaultToolkit().createImage(this.getResourceLocator());
            mt.addImage(im, 0);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                return null;
            }
            this.image = im;
            return this.image;
        }
    }

    public Image getImage(double scale) {
        Image im = this.getImage();
        return this.getImage(new Dimension((int)((double)im.getWidth(null) * scale), (int)((double)im.getHeight(null) * scale)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Dimension d) {
        Image im = this.getImage();
        if (im.getWidth(null) == d.width && im.getHeight(null) == d.height) {
            return im;
        }
        Image cachedScaledVersion = this.scaledImages.get(d);
        if (cachedScaledVersion != null) {
            return cachedScaledVersion;
        }
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.scaledImages.get(d) != null) {
                return this.scaledImages.get(d);
            }
            MediaTracker mt = new MediaTracker(_c);
            Image scaledVersion = im.getScaledInstance(d.width, d.height, 4);
            mt.addImage(scaledVersion, 0, d.width, d.height);
            try {
                mt.waitForID(0);
            }
            catch (InterruptedException e) {
                return null;
            }
            this.scaledImages.put(d, scaledVersion);
            return scaledVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getGrayscaleImage(Dimension d) {
        Image cachedGrayscaleImage = this.grayscaleImages.get(d);
        if (cachedGrayscaleImage != null) {
            return cachedGrayscaleImage;
        }
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.grayscaleImages.get(d) != null) {
                return this.grayscaleImages.get(d);
            }
            Image grayscaleImage = this.convertToGrayscale(this.getImage(d));
            this.grayscaleImages.put(d, grayscaleImage);
            return grayscaleImage;
        }
    }

    public Image getGrayscaleImage(double scale) {
        Image im = this.getImage();
        return this.getGrayscaleImage(new Dimension((int)((double)im.getWidth(null) * scale), (int)((double)im.getHeight(null) * scale)));
    }

    private Image convertToGrayscale(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        ColorConvertOp filter = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage srcImage = new BufferedImage(width, height, 2);
        srcImage.createGraphics().drawImage(image, 0, 0, null);
        return filter.filter(srcImage, null);
    }
}

