/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;

public class ResourceFactory {
    private static Map<URL, WeakReference<Resource>> resources = new WeakHashMap<URL, WeakReference<Resource>>();

    private static Resource getResource(URL url) {
        Resource r;
        WeakReference<Resource> wr = resources.get(url);
        if (wr != null && (r = (Resource)wr.get()) != null) {
            return r;
        }
        return null;
    }

    public static Resource createResource(URL url) {
        Resource r = ResourceFactory.getResource(url);
        if (r == null) {
            r = new ImageResource(url);
            resources.put(url, new WeakReference<Resource>(r));
        }
        return r;
    }
}

