/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Dimension;
import java.awt.Image;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceMapping;

public class ResourceManager {
    private static ResourceMapping baseMapping;
    private static ResourceMapping tcMapping;
    private static ResourceMapping campaignMapping;
    private static ResourceMapping scenarioMapping;
    private static List<ResourceMapping> modMappings;
    private static ResourceMapping mergedContainer;
    private static volatile Thread preloadThread;

    public static void update() {
        ResourceManager.createMergedContainer();
    }

    public static void preload(Dimension windowSize) {
        ResourceManager.getImage("CanvasBackgroundImage", windowSize);
        ResourceManager.getImage("TitleImage");
        ResourceManager.getImage("BackgroundImage");
        ResourceManager.startBackgroundPreloading(windowSize);
    }

    public static void startBackgroundPreloading(final Dimension windowSize) {
        preloadThread = new Thread("FreeColClient:Resource loader"){

            public void run() {
                ResourceManager.getImage("EuropeBackgroundImage", windowSize);
                for (String key : mergedContainer.getResources().keySet()) {
                    if (preloadThread != this) {
                        return;
                    }
                    ResourceManager.getImage(key);
                }
            }
        };
        preloadThread.setPriority(2);
        preloadThread.start();
    }

    private static void createMergedContainer() {
        mergedContainer = new ResourceMapping();
        mergedContainer.addAll(baseMapping);
        mergedContainer.addAll(tcMapping);
        mergedContainer.addAll(campaignMapping);
        mergedContainer.addAll(scenarioMapping);
        ListIterator<ResourceMapping> it = modMappings.listIterator();
        while (it.hasPrevious()) {
            mergedContainer.addAll(it.previous());
        }
    }

    public static void setBaseMapping(ResourceMapping _baseMapping) {
        baseMapping = _baseMapping;
    }

    public static void setTcMapping(ResourceMapping _tcMapping) {
        tcMapping = _tcMapping;
    }

    public static void setCampaignMapping(ResourceMapping _campaignMapping) {
        campaignMapping = _campaignMapping;
    }

    public static void setScenarioMapping(ResourceMapping _scenarioMapping) {
        scenarioMapping = _scenarioMapping;
    }

    public static Image getImage(String resource) {
        Resource r = mergedContainer.get(resource);
        if (!(r instanceof ImageResource)) {
            return null;
        }
        return ((ImageResource)r).getImage();
    }

    public static Image getImage(String resource, double scale) {
        Resource r = mergedContainer.get(resource);
        if (!(r instanceof ImageResource)) {
            return null;
        }
        return ((ImageResource)r).getImage(scale);
    }

    public static Image getImage(String resource, Dimension size) {
        Resource r = mergedContainer.get(resource);
        if (!(r instanceof ImageResource)) {
            return null;
        }
        return ((ImageResource)r).getImage(size);
    }

    public static Image getGrayscaleImage(String resource, Dimension size) {
        Resource r = mergedContainer.get(resource);
        if (!(r instanceof ImageResource)) {
            return null;
        }
        return ((ImageResource)r).getGrayscaleImage(size);
    }

    public static Image getGrayscaleImage(String resource, double scale) {
        Resource r = mergedContainer.get(resource);
        if (!(r instanceof ImageResource)) {
            return null;
        }
        return ((ImageResource)r).getGrayscaleImage(scale);
    }

    public static ImageIcon getImageIcon(String resource) {
        Image im = ResourceManager.getImage(resource);
        return im != null ? new ImageIcon(im) : null;
    }

    static {
        modMappings = new LinkedList<ResourceMapping>();
        preloadThread = null;
    }
}

