/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.Collection;
import java.util.Random;
import net.sf.freecol.common.PseudoRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomChoice<T> {
    private final int probability;
    private final T object;

    public RandomChoice(T object, int probability) {
        this.probability = probability;
        this.object = object;
    }

    public int getProbability() {
        return this.probability;
    }

    public T getObject() {
        return this.object;
    }

    public static <T> T getWeightedRandom(PseudoRandom pseudoRandom, Collection<RandomChoice<T>> input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        if (input.size() == 1) {
            return input.iterator().next().getObject();
        }
        return RandomChoice.select(input, pseudoRandom.nextInt(RandomChoice.getTotalProbability(input)));
    }

    public static <T> T getWeightedRandom(Random random, Collection<RandomChoice<T>> input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        if (input.size() == 1) {
            return input.iterator().next().getObject();
        }
        return RandomChoice.select(input, random.nextInt(RandomChoice.getTotalProbability(input)));
    }

    public static <T> int getTotalProbability(Collection<RandomChoice<T>> input) {
        int total = 0;
        for (RandomChoice<T> choice : input) {
            total += choice.getProbability();
        }
        return total;
    }

    public static <T> T select(Collection<RandomChoice<T>> input, int probability) {
        if (input.isEmpty()) {
            return null;
        }
        int total = 0;
        for (RandomChoice<T> choice : input) {
            if (probability >= (total += choice.getProbability())) continue;
            return choice.getObject();
        }
        return input.iterator().next().getObject();
    }
}

