/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.io.IOException;
import java.io.InputStream;

public final class ReplayableInputStream
extends InputStream {
    private static final int NORMAL = 0;
    private static final int RECORDING = 1;
    private static final int REPLAYING = 2;
    private final InputStream underlyingStream;
    private int state;
    private byte[] replayBuffer;
    private int recordedBytes;
    private int replayedBytes;

    public ReplayableInputStream(InputStream in) {
        this.underlyingStream = in;
    }

    public int read() throws IOException {
        int i;
        if (2 == this.state && this.replayedBytes < this.recordedBytes) {
            i = this.replayBuffer[this.replayedBytes++];
        } else {
            i = this.underlyingStream.read();
            if (i != -1 && 1 == this.state) {
                if (this.recordedBytes < this.replayBuffer.length) {
                    this.replayBuffer[this.recordedBytes++] = (byte)i;
                } else {
                    this.state = 0;
                }
            }
        }
        return i;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        this.replayBuffer = new byte[readlimit];
        this.state = 1;
        this.recordedBytes = 0;
    }

    public synchronized void reset() throws IOException {
        if (this.state != 1) {
            throw new IOException("no mark set");
        }
        this.state = 2;
        this.replayedBytes = 0;
    }
}

