/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Xml {
    public static Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e);
        }
    }

    public static Document documentFrom(String string) {
        return Xml.documentFrom(new InputSource(new StringReader(string)));
    }

    public static Document documentFrom(InputStream stream) {
        return Xml.documentFrom(new InputSource(stream));
    }

    public static String toString(Document document) {
        return document.getDocumentElement().toString();
    }

    public static boolean hasAttribute(Node xmlElement, String attributeName) {
        return xmlElement.getAttributes().getNamedItem(attributeName) != null;
    }

    public static String attribute(Node xmlElement, String attributeName) {
        return xmlElement.getAttributes().getNamedItem(attributeName).getNodeValue();
    }

    public static String attribute(Node xmlElement, String attributeName, String otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.attribute(xmlElement, attributeName);
        }
        return otherwise;
    }

    public static String[] arrayAttribute(Node xmlElement, String attributeName, String separator) {
        return Xml.attribute(xmlElement, attributeName).split(separator);
    }

    public static String[] arrayAttribute(Node xmlElement, String attributeName) {
        return Xml.arrayAttribute(xmlElement, attributeName, ",");
    }

    public static String[] arrayAttribute(Node xmlElement, String attributeName, String[] otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.arrayAttribute(xmlElement, attributeName, ",");
        }
        return otherwise;
    }

    public static char charAttribute(Node xmlElement, String attributeName) {
        return Xml.attribute(xmlElement, attributeName).charAt(0);
    }

    public static char charAttribute(Node xmlElement, String attributeName, char otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.charAttribute(xmlElement, attributeName);
        }
        return otherwise;
    }

    public static float floatAttribute(Node xmlElement, String attributeName) {
        return Float.parseFloat(Xml.attribute(xmlElement, attributeName));
    }

    public static float floatAttribute(Node xmlElement, String attributeName, float otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.floatAttribute(xmlElement, attributeName);
        }
        return otherwise;
    }

    public static float[] floatArrayAttribute(Node xmlElement, String attributeName, String separator) {
        String[] array = Xml.arrayAttribute(xmlElement, attributeName, separator);
        float[] output = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            output[i] = Float.parseFloat(array[i]);
        }
        return output;
    }

    public static float[] floatArrayAttribute(Node xmlElement, String attributeName) {
        return Xml.floatArrayAttribute(xmlElement, attributeName, ",");
    }

    public static float[] floatArrayAttribute(Node xmlElement, String attributeName, float[] otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.floatArrayAttribute(xmlElement, attributeName, ",");
        }
        return otherwise;
    }

    public static int intAttribute(Node xmlElement, String attributeName) {
        return Integer.parseInt(Xml.attribute(xmlElement, attributeName));
    }

    public static int intAttribute(Node xmlElement, String attributeName, int otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.intAttribute(xmlElement, attributeName);
        }
        return otherwise;
    }

    public static int[] intArrayAttribute(Node xmlElement, String attributeName, String separator) {
        String[] array = Xml.arrayAttribute(xmlElement, attributeName, separator);
        int[] output = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            output[i] = Integer.parseInt(array[i]);
        }
        return output;
    }

    public static int[] intArrayAttribute(Node xmlElement, String attributeName) {
        return Xml.intArrayAttribute(xmlElement, attributeName, ",");
    }

    public static int[] intArrayAttribute(Node xmlElement, String attributeName, int[] otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.intArrayAttribute(xmlElement, attributeName, ",");
        }
        return otherwise;
    }

    public static boolean booleanAttribute(Node xmlElement, String attributeName) {
        return Xml.parseTruth(Xml.attribute(xmlElement, attributeName));
    }

    public static boolean booleanAttribute(Node xmlElement, String attributeName, boolean otherwise) {
        if (Xml.hasAttribute(xmlElement, attributeName)) {
            return Xml.booleanAttribute(xmlElement, attributeName);
        }
        return otherwise;
    }

    public static void forEachChild(Node xml, Method method) {
        NodeList childList = xml.getChildNodes();
        int nc = childList.getLength();
        for (int ci = 0; ci < nc; ++ci) {
            Node child = childList.item(ci);
            if (!(child instanceof Element)) continue;
            method.invokeOn(child);
        }
    }

    private static Document documentFrom(InputSource source) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e);
        }
        catch (SAXException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    private static boolean parseTruth(String truthAsString) {
        if ("yes".equals(truthAsString) || "true".equals(truthAsString)) {
            return true;
        }
        if ("no".equals(truthAsString)) {
            return false;
        }
        throw new RuntimeException("mus be 'yes' or 'no': " + truthAsString);
    }

    private Xml() {
    }

    public static final class Exception
    extends RuntimeException {
        Exception(Throwable cause) {
            super(cause);
        }
    }

    public static interface Method {
        public void invokeOn(Node var1);
    }
}

