/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.PseudoRandom;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.server.ai.AIInGameInputHandler;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.control.InGameInputHandler;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.control.PreGameInputHandler;
import net.sf.freecol.server.control.ServerModelController;
import net.sf.freecol.server.control.UserConnectionHandler;
import net.sf.freecol.server.generator.IMapGenerator;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FreeColServer {
    private static final Logger logger = Logger.getLogger(FreeColServer.class.getName());
    private static final int META_SERVER_UPDATE_INTERVAL = 60000;
    private static final int NUMBER_OF_HIGH_SCORES = 10;
    private static final String HIGH_SCORE_FILE = "HighScores.xml";
    private GameState gameState = GameState.STARTING_GAME;
    private Server server;
    private final UserConnectionHandler userConnectionHandler;
    private final PreGameController preGameController;
    private final PreGameInputHandler preGameInputHandler;
    private final InGameInputHandler inGameInputHandler;
    private final ServerModelController modelController;
    private final InGameController inGameController;
    private Game game;
    private AIMain aiMain;
    private IMapGenerator mapGenerator;
    private boolean singleplayer;
    private String owner;
    private boolean publicServer = false;
    private final int port;
    private String name;
    private int numberOfPlayers;
    private int advantages;
    private boolean additionalNations;
    private final ServerPseudoRandom _pseudoRandom = new ServerPseudoRandom();
    private boolean integrity = false;
    private List<HighScore> highScores = null;
    public static final Comparator<HighScore> highScoreComparator = new Comparator<HighScore>(){

        @Override
        public int compare(HighScore score1, HighScore score2) {
            return score2.getScore() - score1.getScore();
        }
    };

    public FreeColServer(boolean publicServer, boolean singleplayer, int port, String name) throws IOException, NoRouteToServerException {
        this(publicServer, singleplayer, port, name, 4, 0, false);
    }

    public FreeColServer(boolean publicServer, boolean singleplayer, int port, String name, int players, int advantages, boolean additionalNations) throws IOException, NoRouteToServerException {
        this.publicServer = publicServer;
        this.singleplayer = singleplayer;
        this.port = port;
        this.name = name;
        this.numberOfPlayers = players;
        this.additionalNations = additionalNations;
        this.advantages = advantages;
        this.modelController = new ServerModelController(this);
        this.game = new Game(this.modelController);
        if (additionalNations) {
            this.game.setVacantNations(new ArrayList<Nation>(FreeCol.getSpecification().getEuropeanNations()));
        } else {
            this.game.setVacantNations(new ArrayList<Nation>(FreeCol.getSpecification().getClassicNations()));
        }
        this.game.setMaximumPlayers(players);
        this.mapGenerator = new MapGenerator();
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.inGameController = new InGameController(this);
        try {
            this.server = new Server(this, port);
            this.server.start();
        }
        catch (IOException e) {
            logger.warning("Exception while starting server: " + e);
            throw e;
        }
        this.updateMetaServer(true);
        this.startMetaServerUpdateThread();
    }

    public FreeColServer(File file, boolean publicServer, boolean singleplayer, int port, String name) throws IOException, FreeColException, NoRouteToServerException {
        this.publicServer = publicServer;
        this.singleplayer = singleplayer;
        this.port = port;
        this.name = name;
        this.mapGenerator = new MapGenerator();
        this.modelController = new ServerModelController(this);
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.inGameController = new InGameController(this);
        try {
            this.server = new Server(this, port);
            this.server.start();
        }
        catch (IOException e) {
            logger.warning("Exception while starting server: " + e);
            throw e;
        }
        try {
            this.owner = this.loadGame(file);
        }
        catch (FreeColException e) {
            this.server.shutdown();
            throw e;
        }
        catch (Exception e) {
            this.server.shutdown();
            FreeColException fe = new FreeColException("couldNotLoadGame");
            fe.initCause(e);
            throw fe;
        }
        Specification.getSpecification().applyDifficultyLevel(this.game.getGameOptions().getInteger("model.option.difficulty"));
        this.updateMetaServer(true);
        this.startMetaServerUpdateThread();
    }

    public void startMetaServerUpdateThread() {
        if (!this.publicServer) {
            return;
        }
        Timer t = new Timer(true);
        t.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                try {
                    FreeColServer.this.updateMetaServer();
                }
                catch (NoRouteToServerException noRouteToServerException) {
                    // empty catch block
                }
            }
        }, 60000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterRevengeMode(String username) {
        ServerPlayer p;
        if (!this.singleplayer) {
            throw new IllegalStateException("Cannot enter revenge mode when not singleplayer.");
        }
        ServerPlayer serverPlayer = p = (ServerPlayer)this.getGame().getPlayerByName(username);
        synchronized (serverPlayer) {
            List<UnitType> undeads = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.undead");
            ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
            ArrayList<UnitType> landUnits = new ArrayList<UnitType>();
            for (UnitType undead : undeads) {
                if (undead.hasAbility("model.ability.navalUnit")) {
                    navalUnits.add(undead);
                    continue;
                }
                if (!undead.getId().equals("model.unit.revenger")) continue;
                landUnits.add(undead);
            }
            if (navalUnits.size() > 0) {
                UnitType navalType = (UnitType)navalUnits.get(this.getPseudoRandom().nextInt(navalUnits.size()));
                Unit theFlyingDutchman = new Unit(this.game, p.getEntryLocation(), p, navalType, Unit.UnitState.ACTIVE);
                if (landUnits.size() > 0) {
                    UnitType landType = (UnitType)landUnits.get(this.getPseudoRandom().nextInt(landUnits.size()));
                    new Unit(this.game, theFlyingDutchman, p, landType, Unit.UnitState.SENTRY);
                }
                p.setDead(false);
                p.setPlayerType(Player.PlayerType.UNDEAD);
                p.setColor(Color.BLACK);
                Element updateElement = Message.createNewRootElement("update");
                updateElement.appendChild(((FreeColGameObject)((Object)p.getEntryLocation())).toXMLElement(p, updateElement.getOwnerDocument()));
                updateElement.appendChild(p.toXMLElement(p, updateElement.getOwnerDocument()));
                try {
                    p.getConnection().sendAndWait(updateElement);
                }
                catch (IOException e) {
                    logger.warning("Could not send update");
                }
            }
        }
    }

    public IMapGenerator getMapGenerator() {
        return this.mapGenerator;
    }

    public void setMapGenerator(IMapGenerator mapGenerator) {
        this.mapGenerator = mapGenerator;
    }

    public void updateMetaServer() throws NoRouteToServerException {
        this.updateMetaServer(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAdvantages() {
        return this.advantages;
    }

    public boolean getAdditionalNations() {
        return this.additionalNations;
    }

    public int getNumberOfPlayers() {
        return this.numberOfPlayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaServer(boolean firstTime) throws NoRouteToServerException {
        Connection mc;
        if (!this.publicServer) {
            return;
        }
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");
        }
        catch (IOException e) {
            logger.warning("Could not connect to meta-server.");
            return;
        }
        try {
            Element element = firstTime ? Message.createNewRootElement("register") : Message.createNewRootElement("update");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            } else {
                element.setAttribute("name", mc.getSocket().getLocalAddress().getHostAddress() + ":" + Integer.toString(this.port));
            }
            element.setAttribute("port", Integer.toString(this.port));
            element.setAttribute("slotsAvailable", Integer.toString(this.getSlotsAvailable()));
            element.setAttribute("currentlyPlaying", Integer.toString(this.getNumberOfLivingHumanPlayers()));
            element.setAttribute("isGameStarted", Boolean.toString(this.gameState != GameState.STARTING_GAME));
            element.setAttribute("version", FreeCol.getVersion());
            element.setAttribute("gameState", Integer.toString(this.getGameState().ordinal()));
            Element reply = mc.ask(element);
            if (reply != null && reply.getTagName().equals("noRouteToServer")) {
                throw new NoRouteToServerException();
            }
        }
        catch (IOException e) {
            logger.warning("Network error while communicating with the meta-server.");
            return;
        }
        finally {
            try {
                mc.close();
            }
            catch (IOException e) {
                logger.warning("Could not close connection to meta-server.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMetaServer() {
        Connection mc;
        if (!this.publicServer) {
            return;
        }
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");
        }
        catch (IOException e) {
            logger.warning("Could not connect to meta-server.");
            return;
        }
        try {
            Element element = Message.createNewRootElement("remove");
            element.setAttribute("port", Integer.toString(this.port));
            mc.send(element);
        }
        catch (IOException e) {
            logger.warning("Network error while communicating with the meta-server.");
            return;
        }
        finally {
            try {
                mc.close();
            }
            catch (IOException e) {
                logger.warning("Could not close connection to meta-server.");
                return;
            }
        }
    }

    public int getSlotsAvailable() {
        List<Player> players = this.game.getPlayers();
        int n = this.game.getMaximumPlayers();
        for (int i = 0; i < players.size(); ++i) {
            ServerPlayer p = (ServerPlayer)players.get(i);
            if (!p.isEuropean() || p.isREF() || !p.isDead() && (!p.isConnected() || p.isAI())) continue;
            --n;
        }
        return n;
    }

    public int getNumberOfLivingHumanPlayers() {
        List<Player> players = this.game.getPlayers();
        int n = 0;
        for (int i = 0; i < players.size(); ++i) {
            if (((ServerPlayer)players.get(i)).isAI() || ((ServerPlayer)players.get(i)).isDead() || !((ServerPlayer)players.get(i)).isConnected()) continue;
            ++n;
        }
        return n;
    }

    public String getOwner() {
        return this.owner;
    }

    public void saveGame(File file, String username) throws IOException {
        Game game = this.getGame();
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        ZipOutputStream fos = null;
        try {
            fos = new JarOutputStream(new FileOutputStream(file));
            ((JarOutputStream)fos).putNextEntry(new JarEntry(file.getName().split("\\.")[0] + "/" + "savegame.xml"));
            XMLStreamWriter xsw = xof.createXMLStreamWriter(fos, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeComment("Game version: " + FreeCol.getRevision());
            xsw.writeStartElement("savedGame");
            xsw.writeAttribute("owner", username);
            xsw.writeAttribute("publicServer", Boolean.toString(this.publicServer));
            xsw.writeAttribute("singleplayer", Boolean.toString(this.singleplayer));
            xsw.writeAttribute("version", Message.getFreeColProtocolVersion());
            xsw.writeAttribute("randomState", this._pseudoRandom.getState());
            xsw.writeStartElement("serverObjects");
            Iterator<FreeColGameObject> fcgoIterator = game.getFreeColGameObjectIterator();
            while (fcgoIterator.hasNext()) {
                FreeColGameObject fcgo = fcgoIterator.next();
                if (!(fcgo instanceof ServerModelObject)) continue;
                ((ServerModelObject)((Object)fcgo)).toServerAdditionElement(xsw);
            }
            xsw.writeEndElement();
            game.toSavedXML(xsw);
            if (this.aiMain != null) {
                this.aiMain.toXML(xsw);
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static XMLStreamReader createXMLStreamReader(FreeColSavegameFile fis) throws IOException {
        try {
            InputStream in = fis.getSavegameInputStream();
            XMLInputFactory xif = XMLInputFactory.newInstance();
            return xif.createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (NullPointerException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new NullPointerException("NullPointerException.");
        }
    }

    public String loadGame(File file) throws IOException, FreeColException {
        boolean doNotLoadAI = false;
        FreeColSavegameFile fis = null;
        try {
            fis = new FreeColSavegameFile(file);
            XMLStreamReader xsr = FreeColServer.createXMLStreamReader(fis);
            xsr.nextTag();
            String version = xsr.getAttributeValue(null, "version");
            if (!Message.getFreeColProtocolVersion().equals(version)) {
                throw new FreeColException("incompatibleVersions");
            }
            String randomState = xsr.getAttributeValue(null, "randomState");
            if (randomState != null && randomState.length() > 0) {
                try {
                    this._pseudoRandom.restoreState(randomState);
                }
                catch (IOException e) {
                    logger.warning("Failed to restore random state, ignoring!");
                }
            }
            String owner = xsr.getAttributeValue(null, "owner");
            ArrayList<ServerPlayer> serverObjects = null;
            this.aiMain = null;
            while (xsr.nextTag() != 2) {
                if (xsr.getLocalName().equals("serverObjects")) {
                    serverObjects = new ArrayList<ServerPlayer>();
                    while (xsr.nextTag() != 2) {
                        if (xsr.getLocalName().equals(ServerPlayer.getServerAdditionXMLElementTagName())) {
                            serverObjects.add(new ServerPlayer(xsr));
                            continue;
                        }
                        throw new XMLStreamException("Unknown tag: " + xsr.getLocalName());
                    }
                    continue;
                }
                if (xsr.getLocalName().equals(Game.getXMLElementTagName())) {
                    this.game = new Game(null, this.getModelController(), xsr, serverObjects.toArray(new FreeColGameObject[0]));
                    this.game.setCurrentPlayer(null);
                    this.gameState = GameState.IN_GAME;
                    this.integrity = this.game.checkIntegrity();
                    continue;
                }
                if (xsr.getLocalName().equals(AIMain.getXMLElementTagName())) {
                    if (doNotLoadAI) {
                        this.aiMain = new AIMain(this);
                        this.game.setFreeColGameObjectListener(this.aiMain);
                        break;
                    }
                    this.aiMain = new AIMain(this, xsr);
                    if (!this.aiMain.checkIntegrity()) {
                        this.aiMain = new AIMain(this);
                        logger.info("Replacing AIMain.");
                    }
                    this.game.setFreeColGameObjectListener(this.aiMain);
                    continue;
                }
                if (xsr.getLocalName().equals("marketdata")) {
                    logger.info("Ignoring market data for compatibility.");
                    continue;
                }
                throw new XMLStreamException("Unknown tag: " + xsr.getLocalName());
            }
            if (this.aiMain == null) {
                this.aiMain = new AIMain(this);
                this.game.setFreeColGameObjectListener(this.aiMain);
            }
            Iterator<Player> playerIterator = this.game.getPlayerIterator();
            while (playerIterator.hasNext()) {
                ServerPlayer player = (ServerPlayer)playerIterator.next();
                if (!player.isAI()) continue;
                DummyConnection theConnection = new DummyConnection("Server-Server-" + player.getName(), this.getInGameInputHandler());
                DummyConnection aiConnection = new DummyConnection("Server-AI-" + player.getName(), new AIInGameInputHandler(this, player, this.aiMain));
                aiConnection.setOutgoingMessageHandler(theConnection);
                theConnection.setOutgoingMessageHandler(aiConnection);
                this.getServer().addDummyConnection(theConnection);
                player.setConnection(theConnection);
                player.setConnected(true);
            }
            xsr.close();
            String string = owner;
            return string;
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (FreeColException fe) {
            StringWriter sw = new StringWriter();
            fe.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw fe;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void setSingleplayer(boolean singleplayer) {
        this.singleplayer = singleplayer;
    }

    public boolean isSingleplayer() {
        return this.singleplayer;
    }

    public void revealMapForAllPlayers() {
        ServerPlayer player;
        Iterator<Player> playerIterator = this.getGame().getPlayerIterator();
        while (playerIterator.hasNext()) {
            player = (ServerPlayer)playerIterator.next();
            player.revealMap();
        }
        playerIterator = this.getGame().getPlayerIterator();
        while (playerIterator.hasNext()) {
            player = (ServerPlayer)playerIterator.next();
            Element reconnect = Message.createNewRootElement("reconnect");
            try {
                player.getConnection().send(reconnect);
            }
            catch (IOException ex) {
                logger.warning("Could not send reconnect message!");
            }
        }
    }

    public ServerPlayer getPlayer(Connection connection) {
        Iterator<Player> playerIterator = this.getGame().getPlayerIterator();
        while (playerIterator.hasNext()) {
            ServerPlayer player = (ServerPlayer)playerIterator.next();
            if (player.getConnection() != connection) continue;
            return player;
        }
        return null;
    }

    public UserConnectionHandler getUserConnectionHandler() {
        return this.userConnectionHandler;
    }

    public Controller getController() {
        if (this.getGameState() == GameState.IN_GAME) {
            return this.inGameController;
        }
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public ServerModelController getModelController() {
        return this.modelController;
    }

    public Game getGame() {
        return this.game;
    }

    public void setAIMain(AIMain aiMain) {
        this.aiMain = aiMain;
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState state) {
        this.gameState = state;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public PseudoRandom getPseudoRandom() {
        return this._pseudoRandom;
    }

    public int[] getRandomNumbers(int n) {
        return this._pseudoRandom.getRandomNumbers(n);
    }

    public void sendUpdatedTileToAll(Tile newTile, Player player) {
        for (Player enemy : this.getGame().getPlayers()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemy;
            if (player != null && player.equals(enemyPlayer) || enemyPlayer.getConnection() == null) continue;
            try {
                if (!enemyPlayer.canSee(newTile)) continue;
                Element updateElement = Message.createNewRootElement("update");
                updateElement.appendChild(newTile.toXMLElement(enemyPlayer, updateElement.getOwnerDocument()));
                enemyPlayer.getConnection().sendAndWait(updateElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    public ServerPlayer addAIPlayer(Nation nation) {
        String name = nation.getRulerName();
        DummyConnection theConnection = new DummyConnection("Server connection - " + name, this.getInGameInputHandler());
        ServerPlayer aiPlayer = new ServerPlayer(this.getGame(), name, false, true, null, theConnection, nation);
        DummyConnection aiConnection = new DummyConnection("AI connection - " + name, new AIInGameInputHandler(this, aiPlayer, this.getAIMain()));
        aiConnection.setOutgoingMessageHandler(theConnection);
        theConnection.setOutgoingMessageHandler(aiConnection);
        this.getServer().addDummyConnection(theConnection);
        this.getGame().addPlayer(aiPlayer);
        Element addNewPlayer = Message.createNewRootElement("addPlayer");
        addNewPlayer.appendChild(aiPlayer.toXMLElement(null, addNewPlayer.getOwnerDocument()));
        this.getServer().sendToAll(addNewPlayer, theConnection);
        return aiPlayer;
    }

    public List<HighScore> getHighScores() {
        if (this.highScores == null) {
            try {
                this.loadHighScores();
            }
            catch (Exception e) {
                logger.warning(e.toString());
                this.highScores = new ArrayList<HighScore>();
            }
        }
        return this.highScores;
    }

    public boolean newHighScore(Player player) {
        this.getHighScores();
        if (!this.highScores.isEmpty() && player.getScore() <= this.highScores.get(this.highScores.size() - 1).getScore()) {
            return false;
        }
        this.highScores.add(new HighScore(player, new Date()));
        Collections.sort(this.highScores, highScoreComparator);
        if (this.highScores.size() == 10) {
            this.highScores.remove(9);
        }
        return true;
    }

    public void saveHighScores() throws IOException {
        if (this.highScores == null || this.highScores.isEmpty()) {
            return;
        }
        Collections.sort(this.highScores, highScoreComparator);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(FreeCol.getDataDirectory(), HIGH_SCORE_FILE));
            XMLStreamWriter xsw = xof.createXMLStreamWriter(fos, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeStartElement("highScores");
            int count = 0;
            for (HighScore score : this.highScores) {
                score.toXML(xsw);
                if (++count != 10) continue;
                break;
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void loadHighScores() throws IOException, FreeColException {
        this.highScores = new ArrayList<HighScore>();
        XMLInputFactory xif = XMLInputFactory.newInstance();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(FreeCol.getDataDirectory(), HIGH_SCORE_FILE));
            XMLStreamReader xsr = xif.createXMLStreamReader(fis);
            xsr.nextTag();
            while (xsr.nextTag() != 2) {
                if (!xsr.getLocalName().equals("highScore")) continue;
                this.highScores.add(new HighScore(xsr));
            }
            xsr.close();
            Collections.sort(this.highScores, highScoreComparator);
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException("XMLStreamException.");
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new IOException(e.toString());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private static class ServerPseudoRandom
    implements PseudoRandom {
        private static final String HEX_DIGITS = "0123456789ABCDEF";
        private Random _random = new Random(new SecureRandom().nextLong());

        public synchronized int nextInt(int n) {
            return this._random.nextInt(n);
        }

        public synchronized int[] getRandomNumbers(int size) {
            int[] numbers = new int[size];
            for (int i = 0; i < size; ++i) {
                numbers[i] = this._random.nextInt();
            }
            return numbers;
        }

        public synchronized String getState() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this._random);
                oos.flush();
            }
            catch (IOException e) {
                throw new IllegalStateException("IO exception in memory!?!", e);
            }
            byte[] bytes = bos.toByteArray();
            StringBuffer sb = new StringBuffer(bytes.length * 2);
            for (byte b : bytes) {
                sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
                sb.append(HEX_DIGITS.charAt(b & 0xF));
            }
            return sb.toString();
        }

        public synchronized void restoreState(String state) throws IOException {
            byte[] bytes = new byte[state.length() / 2];
            int pos = 0;
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = (byte)HEX_DIGITS.indexOf(state.charAt(pos++));
                int n = i;
                bytes[n] = (byte)(bytes[n] << 4);
                int n2 = i++;
                bytes[n2] = (byte)(bytes[n2] | (byte)HEX_DIGITS.indexOf(state.charAt(pos++)));
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                this._random = (Random)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Failed to restore random!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameState {
        STARTING_GAME,
        IN_GAME,
        ENDING_GAME;

    }
}

