/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ColonyPlan;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkLocationPlan;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIColony
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIColony.class.getName());
    private static final EquipmentType toolsType = FreeCol.getSpecification().getEquipmentType("model.equipment.tools");
    private Colony colony;
    private ColonyPlan colonyPlan;
    private ArrayList<AIGoods> aiGoods = new ArrayList();
    private ArrayList<Wish> wishes = new ArrayList();
    private ArrayList<TileImprovementPlan> TileImprovementPlans = new ArrayList();

    public AIColony(AIMain aiMain, Colony colony) {
        super(aiMain, colony.getId());
        this.colony = colony;
        this.colonyPlan = new ColonyPlan(aiMain, colony);
    }

    public AIColony(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public AIColony(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public AIColony(AIMain aiMain, String id) {
        this(aiMain, (Colony)aiMain.getGame().getFreeColGameObject(id));
    }

    public Colony getColony() {
        return this.colony;
    }

    @Override
    public void dispose() {
        ArrayList<AIObject> disposeList = new ArrayList<AIObject>();
        for (AIGoods ag : this.aiGoods) {
            if (ag.getGoods().getLocation() != this.colony) continue;
            disposeList.add(ag);
        }
        for (Wish w : this.wishes) {
            disposeList.add(w);
        }
        for (TileImprovementPlan ti : this.TileImprovementPlans) {
            disposeList.add(ti);
        }
        for (AIObject o : disposeList) {
            o.dispose();
        }
        super.dispose();
    }

    private void updateCustomHouse() {
        int capacity = this.colony.getWarehouseCapacity();
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            if (goodsType.isTradeGoods()) {
                this.colony.setExportData(new ExportData(goodsType, false, 0));
                continue;
            }
            if (!goodsType.isStorable()) {
                this.colony.setExportData(new ExportData(goodsType, false, 0));
                continue;
            }
            if (goodsType.isBreedable()) {
                this.colony.setExportData(new ExportData(goodsType, true, capacity - 20));
                continue;
            }
            if (goodsType.isMilitaryGoods()) {
                this.colony.setExportData(new ExportData(goodsType, true, capacity - 50));
                continue;
            }
            if (goodsType.isBuildingMaterial()) {
                this.colony.setExportData(new ExportData(goodsType, true, Math.min(capacity, 250)));
                continue;
            }
            if (goodsType.isFoodType()) {
                this.colony.setExportData(new ExportData(goodsType, false, 0));
                continue;
            }
            if (goodsType.isNewWorldGoodsType() || goodsType.isRefined()) {
                this.colony.setExportData(new ExportData(goodsType, true, 0));
                continue;
            }
            this.colony.setExportData(new ExportData(goodsType, false, 0));
        }
    }

    public Iterator<AIGoods> getAIGoodsIterator() {
        Iterator<AIGoods> agi = this.aiGoods.iterator();
        while (agi.hasNext()) {
            AIGoods ag = agi.next();
            if (ag.getGoods().getLocation() == this.colony) continue;
            agi.remove();
        }
        return this.aiGoods.iterator();
    }

    public Iterator<Wish> getWishIterator() {
        return this.wishes.iterator();
    }

    public void createTileImprovementPlans() {
        List<WorkLocationPlan> workLocationPlans = this.colonyPlan.getSortedWorkLocationPlans();
        for (WorkLocationPlan wlp : workLocationPlans) {
            TileImprovementPlan ti;
            if (!(wlp.getWorkLocation() instanceof ColonyTile)) continue;
            Tile target = ((ColonyTile)wlp.getWorkLocation()).getWorkTile();
            boolean TileImprovementPlanUpdated = false;
            Iterator<TileImprovementPlan> tiIterator = this.TileImprovementPlans.iterator();
            while (tiIterator.hasNext()) {
                ti = tiIterator.next();
                if (ti.getTarget() != target) continue;
                if (wlp.updateTileImprovementPlan(ti) == null) {
                    ti.dispose();
                    tiIterator.remove();
                }
                TileImprovementPlanUpdated = true;
                break;
            }
            if (TileImprovementPlanUpdated || (ti = wlp.createTileImprovementPlan()) == null) continue;
            this.TileImprovementPlans.add(ti);
        }
        Collections.sort(this.TileImprovementPlans, new Comparator<TileImprovementPlan>(){

            @Override
            public int compare(TileImprovementPlan o, TileImprovementPlan p) {
                Integer i = o.getValue();
                Integer j = p.getValue();
                return j.compareTo(i);
            }
        });
    }

    public Iterator<TileImprovementPlan> getTileImprovementPlanIterator() {
        return this.TileImprovementPlans.iterator();
    }

    public boolean removeTileImprovementPlan(TileImprovementPlan plan) {
        return this.TileImprovementPlans.remove(plan);
    }

    private void createWishes() {
        logger.finest("Entering method createWishes");
        List<WorkLocationPlan> workLocationPlans = this.colonyPlan.getSortedWorkLocationPlans();
        Iterator<WorkLocationPlan> rit = workLocationPlans.iterator();
        while (rit.hasNext()) {
            WorkLocationPlan wlp = rit.next();
            if (wlp.getWorkLocation() instanceof ColonyTile && ((ColonyTile)wlp.getWorkLocation()).getWorkTile().getSettlement() != null) {
                rit.remove();
            }
            if (!(wlp.getWorkLocation() instanceof ColonyTile) || ((ColonyTile)wlp.getWorkLocation()).getWorkTile().isLand() || this.colony.hasAbility("model.ability.produceInWater")) continue;
            rit.remove();
        }
        int[] production = new int[FreeCol.getSpecification().numberOfGoodsTypes()];
        ArrayList<Unit> nonExpertUnits = new ArrayList<Unit>();
        Iterator<Unit> unitIterator = this.colony.getUnitIterator();
        block1: while (unitIterator.hasNext()) {
            Unit u = unitIterator.next();
            GoodsType workType = u.getType().getExpertProduction();
            if (workType != null) {
                Iterator<WorkLocationPlan> wlpIterator = workLocationPlans.iterator();
                while (wlpIterator.hasNext()) {
                    WorkLocationPlan wlp = wlpIterator.next();
                    if (wlp.getGoodsType() != workType) continue;
                    if (workType.getIndex() < production.length) {
                        int n = workType.getIndex();
                        production[n] = production[n] + wlp.getProductionOf(workType);
                    }
                    int n = Goods.FOOD.getIndex();
                    production[n] = production[n] - 2;
                    wlpIterator.remove();
                    continue block1;
                }
                continue;
            }
            nonExpertUnits.add(u);
        }
        ArrayList<Wish> newWishes = new ArrayList<Wish>();
        int value = 120;
        while (workLocationPlans.size() > 0) {
            WorkLocationPlan wlp;
            UnitType unitType = null;
            if (production[Goods.FOOD.getIndex()] < 2) {
                Iterator<WorkLocationPlan> wlpIterator = workLocationPlans.iterator();
                while (wlpIterator.hasNext()) {
                    wlp = wlpIterator.next();
                    if (wlp.getGoodsType() != Goods.FOOD) continue;
                    int n = Goods.FOOD.getIndex();
                    production[n] = production[n] + wlp.getProductionOf(Goods.FOOD);
                    int n2 = Goods.FOOD.getIndex();
                    production[n2] = production[n2] - 2;
                    wlpIterator.remove();
                    if (((ColonyTile)wlp.getWorkLocation()).getWorkTile().isLand()) {
                        unitType = FreeCol.getSpecification().getExpertForProducing(Goods.FOOD);
                        break;
                    }
                    unitType = FreeCol.getSpecification().getExpertForProducing(Goods.FISH);
                    break;
                }
            }
            if (unitType == null) {
                if (production[Goods.FOOD.getIndex()] < 2) break;
                Iterator<WorkLocationPlan> wlpIterator = workLocationPlans.iterator();
                if (wlpIterator.hasNext()) {
                    wlp = wlpIterator.next();
                    if (wlp.getGoodsType().getIndex() < production.length) {
                        int n = wlp.getGoodsType().getIndex();
                        production[n] = production[n] + wlp.getProductionOf(wlp.getGoodsType());
                    }
                    int n = Goods.FOOD.getIndex();
                    production[n] = production[n] - 2;
                    wlpIterator.remove();
                    unitType = wlp.getWorkLocation() instanceof ColonyTile ? FreeCol.getSpecification().getExpertForProducing(wlp.getGoodsType()) : ((Building)wlp.getWorkLocation()).getExpertUnitType();
                }
            }
            if (unitType == null) continue;
            boolean expert = nonExpertUnits.size() <= 0;
            boolean wishFound = false;
            for (Wish w : this.wishes) {
                WorkerWish ww;
                if (!(w instanceof WorkerWish) || (ww = (WorkerWish)w).getUnitType() != unitType || newWishes.contains(ww)) continue;
                ww.update(value, unitType, expert);
                newWishes.add(ww);
                wishFound = true;
                break;
            }
            if (!wishFound) {
                WorkerWish ww = new WorkerWish(this.getAIMain(), this.colony, value, unitType, expert);
                this.wishes.add(ww);
                newWishes.add(ww);
            }
            if (!expert) {
                nonExpertUnits.remove(0);
            }
            if ((value -= 5) >= 50) continue;
            value = 50;
        }
        AIUnit unequippedHardyPioneer = this.getUnequippedHardyPioneer();
        boolean needsPioneer = this.TileImprovementPlans.size() > 0 || unequippedHardyPioneer != null && PioneeringMission.isValid(unequippedHardyPioneer);
        int toolsRequiredForBuilding = 0;
        if (this.colony.getCurrentlyBuilding() != BuildableType.NOTHING) {
            toolsRequiredForBuilding = this.getToolsRequired(this.colony.getCurrentlyBuilding());
        }
        if (this.colony.getProductionNetOf(Goods.TOOLS) == 0 && this.colony.getGoodsCount(Goods.TOOLS) < 20 && needsPioneer || toolsRequiredForBuilding > this.colony.getGoodsCount(Goods.TOOLS)) {
            int goodsWishValue = 10 + 10 * this.TileImprovementPlans.size() + (unequippedHardyPioneer != null ? 90 : 0) + (toolsRequiredForBuilding > this.colony.getGoodsCount(Goods.TOOLS) ? 100 + (toolsRequiredForBuilding - this.colony.getGoodsCount(Goods.TOOLS)) : 0);
            boolean goodsOrdered = false;
            for (Wish w : this.wishes) {
                GoodsWish gw;
                if (!(w instanceof GoodsWish) || (gw = (GoodsWish)w).getGoodsType() != Goods.TOOLS) continue;
                gw.value = goodsWishValue;
                goodsOrdered = true;
                break;
            }
            if (!goodsOrdered) {
                GoodsWish gw = new GoodsWish(this.getAIMain(), this.colony, goodsWishValue, Goods.TOOLS);
                this.wishes.add(gw);
            }
        } else {
            this.disposeAllToolsGoodsWishes();
        }
        this.disposeUnwantedWishes(newWishes);
        Collections.sort(this.wishes, new Comparator<Wish>(){

            @Override
            public int compare(Wish o, Wish p) {
                Integer i = o.getValue();
                Integer j = p.getValue();
                return j.compareTo(i);
            }
        });
    }

    private int getToolsRequired(BuildableType buildableType) {
        int toolsRequiredForBuilding = 0;
        for (AbstractGoods goodsRequired : buildableType.getGoodsRequired()) {
            if (goodsRequired.getType() != Goods.TOOLS) continue;
            toolsRequiredForBuilding = goodsRequired.getAmount();
            break;
        }
        return toolsRequiredForBuilding;
    }

    private int getHammersRequired(BuildableType buildableType) {
        int hammersRequiredForBuilding = 0;
        for (AbstractGoods goodsRequired : buildableType.getGoodsRequired()) {
            if (goodsRequired.getType() != Goods.HAMMERS) continue;
            hammersRequiredForBuilding = goodsRequired.getAmount();
            break;
        }
        return hammersRequiredForBuilding;
    }

    private void disposeAllToolsGoodsWishes() {
        ArrayList<GoodsWish> toolsWishes = new ArrayList<GoodsWish>();
        for (Wish w : this.wishes) {
            GoodsWish gw;
            if (!(w instanceof GoodsWish) || (gw = (GoodsWish)w).getGoodsType() != Goods.TOOLS) continue;
            toolsWishes.add(gw);
        }
        for (GoodsWish gw : toolsWishes) {
            gw.dispose();
        }
    }

    private void disposeUnwantedWishes(List<Wish> newWishes) {
        ArrayList<Wish> wishesToDispose = new ArrayList<Wish>();
        for (Wish w : this.wishes) {
            if (w instanceof WorkerWish) {
                if (newWishes.contains(w)) continue;
                wishesToDispose.add(w);
                continue;
            }
            if (w instanceof GoodsWish) {
                GoodsWish gw = (GoodsWish)w;
                if (this.getColony().getGoodsCount(gw.getGoodsType()) < 20) continue;
                wishesToDispose.add(gw);
                continue;
            }
            logger.warning("Unknown type of Wish: " + w + " for " + this);
        }
        for (Wish w : wishesToDispose) {
            w.dispose();
        }
    }

    private AIUnit getUnequippedHardyPioneer() {
        AIUnit au;
        Unit u;
        Iterator<Unit> ui = this.colony.getTile().getUnitIterator();
        while (ui.hasNext()) {
            u = ui.next();
            au = (AIUnit)this.getAIMain().getAIObject(u);
            if (au.getMission() == null || !(au.getMission() instanceof PioneeringMission) || u.getEquipment().contains(toolsType)) continue;
            return au;
        }
        ui = this.colony.getUnitIterator();
        while (ui.hasNext()) {
            u = ui.next();
            au = (AIUnit)this.getAIMain().getAIObject(u);
            if (!u.hasAbility("model.ability.expertPioneer")) continue;
            return au;
        }
        return null;
    }

    public void removeWish(Wish w) {
        this.wishes.remove(w);
    }

    public void createAIGoods() {
        this.createExportAIGoodsList();
    }

    public void addGoodsWish(GoodsWish gw) {
        this.wishes.add(gw);
    }

    public void removeAIGoods(AIGoods ag) {
        while (this.aiGoods.remove(ag)) {
        }
    }

    private void createExportAIGoodsList() {
        ArrayList<AIGoods> newAIGoods = new ArrayList<AIGoods>();
        this.updateCustomHouse();
        if (this.colony.hasAbility("model.ability.export")) {
            this.aiGoods.clear();
            return;
        }
        List<GoodsType> goodsList = FreeCol.getSpecification().getGoodsTypeList();
        for (GoodsType goodsType : goodsList) {
            if (goodsType == Goods.FOOD || goodsType == Goods.LUMBER || !goodsType.isStorable() || goodsType == Goods.MUSKETS && (this.colony.getProductionOf(Goods.MUSKETS) == 0 || this.colony.getGoodsCount(Goods.MUSKETS) < this.colony.getWarehouseCapacity() - this.colony.getProductionOf(Goods.MUSKETS)) || goodsType == Goods.HORSES && (this.colony.getProductionOf(Goods.HORSES) == 0 || this.colony.getGoodsCount(Goods.HORSES) < this.colony.getWarehouseCapacity() - this.colony.getProductionOf(Goods.HORSES))) continue;
            if (goodsType == Goods.TOOLS && this.colony.getGoodsCount(Goods.TOOLS) > 0) {
                if (this.colony.getProductionNetOf(Goods.TOOLS) <= 0) continue;
                BuildableType currentlyBuilding = this.colony.getCurrentlyBuilding();
                int requiredTools = this.getToolsRequired(currentlyBuilding);
                int requiredHammers = this.getHammersRequired(currentlyBuilding);
                int buildTurns = (requiredHammers - this.colony.getGoodsCount(Goods.HAMMERS)) / (this.colony.getProductionOf(Goods.HAMMERS) + 1);
                if (requiredTools > 0) {
                    int toolsProductionTurns;
                    if (this.colony.getWarehouseCapacity() > 100) {
                        requiredTools += 100;
                    }
                    if (buildTurns <= (toolsProductionTurns = requiredTools / this.colony.getProductionNetOf(Goods.TOOLS)) + 1) {
                        continue;
                    }
                } else if (this.colony.getWarehouseCapacity() > 100 && this.colony.getGoodsCount(Goods.TOOLS) <= 100) continue;
            }
            if (this.colony.getGoodsCount(goodsType) <= 0) continue;
            ArrayList<AIGoods> alreadyAdded = new ArrayList<AIGoods>();
            for (int j = 0; j < this.aiGoods.size(); ++j) {
                AIGoods ag = this.aiGoods.get(j);
                if (ag == null) {
                    logger.warning("aiGoods == null");
                } else if (ag.getGoods() == null) {
                    logger.warning("aiGoods.getGoods() == null");
                    if (ag.isUninitialized()) {
                        logger.warning("AIGoods uninitialized: " + ag.getId());
                    }
                }
                if (ag == null || ag.getGoods() == null || ag.getGoods().getType() != goodsType || ag.getGoods().getLocation() != this.colony) continue;
                alreadyAdded.add(ag);
            }
            int amountRemaining = this.colony.getGoodsCount(goodsType);
            for (int i = 0; i < alreadyAdded.size(); ++i) {
                AIGoods oldGoods = (AIGoods)alreadyAdded.get(i);
                if (oldGoods.getGoods().getLocation() != this.colony) continue;
                if (oldGoods.getGoods().getAmount() < 100 && oldGoods.getGoods().getAmount() < amountRemaining) {
                    int goodsAmount = Math.min(100, amountRemaining);
                    oldGoods.getGoods().setAmount(goodsAmount);
                    if (amountRemaining >= this.colony.getWarehouseCapacity() && oldGoods.getTransportPriority() < 110) {
                        oldGoods.setTransportPriority(110);
                    } else if (goodsAmount == 100 && oldGoods.getTransportPriority() < 100) {
                        oldGoods.setTransportPriority(100);
                    }
                    amountRemaining -= goodsAmount;
                    newAIGoods.add(oldGoods);
                    continue;
                }
                if (oldGoods.getGoods().getAmount() > amountRemaining) {
                    if (amountRemaining == 0) {
                        if (oldGoods.getTransport() != null && oldGoods.getTransport().getMission() instanceof TransportMission) {
                            ((TransportMission)oldGoods.getTransport().getMission()).removeFromTransportList(oldGoods);
                        }
                        oldGoods.dispose();
                        continue;
                    }
                    oldGoods.getGoods().setAmount(amountRemaining);
                    newAIGoods.add(oldGoods);
                    amountRemaining = 0;
                    continue;
                }
                newAIGoods.add(oldGoods);
                amountRemaining -= oldGoods.getGoods().getAmount();
            }
            while (amountRemaining > 0) {
                if (amountRemaining >= 100) {
                    AIGoods newGoods = new AIGoods(this.getAIMain(), this.colony, goodsType, 100, this.getColony().getOwner().getEurope());
                    if (amountRemaining >= this.colony.getWarehouseCapacity()) {
                        newGoods.setTransportPriority(110);
                    } else {
                        newGoods.setTransportPriority(100);
                    }
                    newAIGoods.add(newGoods);
                    amountRemaining -= 100;
                    continue;
                }
                AIGoods newGoods = new AIGoods(this.getAIMain(), this.colony, goodsType, amountRemaining, this.getColony().getOwner().getEurope());
                newAIGoods.add(newGoods);
                amountRemaining = 0;
            }
        }
        this.aiGoods.clear();
        for (AIGoods ag : newAIGoods) {
            int i;
            for (i = 0; i < this.aiGoods.size() && this.aiGoods.get(i).getTransportPriority() > ag.getTransportPriority(); ++i) {
            }
            this.aiGoods.add(i, ag);
        }
    }

    public int getAvailableGoods(GoodsType goodsType) {
        int materialsRequiredForBuilding = 0;
        if (this.colony.getCurrentlyBuilding() != BuildableType.NOTHING) {
            for (AbstractGoods materials : this.colony.getCurrentlyBuilding().getGoodsRequired()) {
                if (materials.getType() != goodsType) continue;
                materialsRequiredForBuilding = materials.getAmount();
                break;
            }
        }
        return Math.max(0, this.colony.getGoodsCount(goodsType) - materialsRequiredForBuilding);
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        if (this.getColony().canBuildEquipment(equipmentType)) {
            for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                int breedingNumber = goods.getType().getBreedingNumber();
                if (breedingNumber != Integer.MAX_VALUE && this.getColony().getGoodsCount(goods.getType()) < goods.getAmount() + breedingNumber) {
                    return false;
                }
                if (this.getAvailableGoods(goods.getType()) >= goods.getAmount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void rearrangeWorkers(Connection connection) {
        Iterator<Unit> unitIterator;
        this.colonyPlan.create();
        if (this.colony.getUnitCount() > 1) {
            AIUnit unequippedPioneer;
            boolean canBuildTools = true;
            for (AbstractGoods materials : toolsType.getGoodsRequired()) {
                if (this.getAvailableGoods(materials.getType()) >= materials.getAmount()) continue;
                canBuildTools = false;
                break;
            }
            if (canBuildTools && (unequippedPioneer = this.getUnequippedHardyPioneer()) != null && (unequippedPioneer.getMission() == null || !(unequippedPioneer.getMission() instanceof PioneeringMission)) && PioneeringMission.isValid(unequippedPioneer)) {
                unequippedPioneer.getUnit().putOutsideColony();
                unequippedPioneer.setMission(new PioneeringMission(this.getAIMain(), unequippedPioneer));
            }
        }
        ArrayList<Unit> units = new ArrayList<Unit>();
        List<WorkLocationPlan> workLocationPlans = this.colonyPlan.getWorkLocationPlans();
        Collections.sort(workLocationPlans, new Comparator<WorkLocationPlan>(){

            @Override
            public int compare(WorkLocationPlan o, WorkLocationPlan p) {
                Integer i = o.getProductionOf(o.getGoodsType());
                Integer j = p.getProductionOf(p.getGoodsType());
                return j.compareTo(i);
            }
        });
        Iterator<Unit> ui = this.colony.getUnitIterator();
        while (ui.hasNext()) {
            Unit unit = ui.next();
            units.add(unit);
            unit.putOutsideColony();
        }
        Iterator uit = units.iterator();
        block2: while (uit.hasNext()) {
            Unit unit = (Unit)uit.next();
            if (unit.getType().getExpertProduction() == null) continue;
            Iterator<WorkLocationPlan> wlpIterator = workLocationPlans.iterator();
            while (wlpIterator.hasNext()) {
                WorkLocationPlan wlp = wlpIterator.next();
                WorkLocation wl = wlp.getWorkLocation();
                if (unit.getType().getExpertProduction() != wlp.getGoodsType() || !wlp.getWorkLocation().canAdd(unit) || wlp.getGoodsType() == Goods.FOOD && (((ColonyTile)wl).getWorkTile().isLand() || !unit.getType().getExpertProduction().equals(Goods.FISH) || !this.colony.hasAbility("model.ability.produceInWater")) && (!((ColonyTile)wl).getWorkTile().isLand() || unit.getType().getExpertProduction().equals(Goods.FISH))) continue;
                unit.work(wlp.getWorkLocation());
                unit.setWorkType(wlp.getGoodsType());
                wlpIterator.remove();
                uit.remove();
                continue block2;
            }
        }
        boolean workerAdded = true;
        while (workerAdded) {
            WorkLocationPlan wlp;
            int i;
            workerAdded = false;
            int food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
            for (i = 0; i < workLocationPlans.size() && food < 2; ++i) {
                wlp = workLocationPlans.get(i);
                WorkLocation wl = wlp.getWorkLocation();
                if (wlp.getGoodsType() != Goods.FOOD || !((ColonyTile)wl).getWorkTile().isLand() && !this.colony.hasAbility("model.ability.produceInWater")) continue;
                Unit bestUnit = null;
                int bestProduction = 0;
                for (Unit unit : units) {
                    int production = ((ColonyTile)wlp.getWorkLocation()).getProductionOf(unit, Goods.FOOD);
                    if (production <= 1 || bestUnit != null && production <= bestProduction && (production != bestProduction || unit.getSkillLevel() >= bestUnit.getSkillLevel())) continue;
                    bestUnit = unit;
                    bestProduction = production;
                }
                if (bestUnit == null || !wlp.getWorkLocation().canAdd(bestUnit)) continue;
                bestUnit.work(wlp.getWorkLocation());
                bestUnit.setWorkType(wlp.getGoodsType());
                units.remove(bestUnit);
                workLocationPlans.remove(wlp);
                workerAdded = true;
                food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
            }
            if (food < 2) continue;
            for (i = 0; i < workLocationPlans.size(); ++i) {
                wlp = workLocationPlans.get(i);
                if (wlp.getGoodsType() == Goods.FOOD) continue;
                Unit bestUnit = null;
                int bestProduction = 0;
                for (Unit unit : units) {
                    int production = 0;
                    WorkLocation location = wlp.getWorkLocation();
                    if (location instanceof ColonyTile) {
                        production = ((ColonyTile)wlp.getWorkLocation()).getProductionOf(unit, wlp.getGoodsType());
                    } else if (location instanceof Building) {
                        production = ((Building)location).getUnitProductivity(unit);
                    }
                    if (bestUnit != null && production <= bestProduction && (production != bestProduction || unit.getSkillLevel() >= bestUnit.getSkillLevel())) continue;
                    bestUnit = unit;
                    bestProduction = production;
                }
                if (bestUnit == null || !wlp.getWorkLocation().canAdd(bestUnit)) continue;
                bestUnit.work(wlp.getWorkLocation());
                bestUnit.setWorkType(wlp.getGoodsType());
                units.remove(bestUnit);
                workLocationPlans.remove(wlp);
                workerAdded = true;
                food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
            }
        }
        int food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
        while (food < 0 && this.colony.getGoodsCount(Goods.FOOD) + food * 3 < 0) {
            Unit u;
            WorkLocation bestPick = null;
            for (WorkLocation wl : this.colony.getWorkLocations()) {
                if (wl.getUnitCount() <= 0) continue;
                if (wl instanceof ColonyTile) {
                    ColonyTile ct = (ColonyTile)wl;
                    u = ct.getUnit();
                    if (ct.getUnit().getWorkType() == Goods.FOOD) continue;
                    int uProduction = ct.getProductionOf(u, Goods.FOOD);
                    if (uProduction > 1) {
                        if (bestPick == null || bestPick instanceof Building) {
                            bestPick = wl;
                            continue;
                        }
                        ColonyTile bpct = (ColonyTile)bestPick;
                        int bestPickProduction = bpct.getProductionOf(bpct.getUnit(), Goods.FOOD);
                        if (uProduction <= bestPickProduction && (uProduction != bestPickProduction || u.getSkillLevel() >= bpct.getUnit().getSkillLevel())) continue;
                        bestPick = wl;
                        continue;
                    }
                    if (bestPick != null) continue;
                    bestPick = wl;
                    continue;
                }
                if (bestPick != null && (!(bestPick instanceof Building) || ((Building)wl).getProduction() >= ((Building)bestPick).getProduction())) continue;
                bestPick = wl;
            }
            if (bestPick == null) break;
            if (bestPick instanceof ColonyTile) {
                ColonyTile ct = (ColonyTile)bestPick;
                Unit u2 = ct.getUnit();
                if (ct.getProductionOf(u2, Goods.FOOD) > 1) {
                    u2.setWorkType(Goods.FOOD);
                } else {
                    u2.putOutsideColony();
                    AIUnit au = (AIUnit)this.getAIMain().getAIObject(u2);
                    if (au.getMission() instanceof WorkInsideColonyMission) {
                        au.setMission(null);
                    }
                }
            } else {
                Building b = (Building)bestPick;
                unitIterator = b.getUnitIterator();
                Unit bestUnit = unitIterator.next();
                while (unitIterator.hasNext()) {
                    u = unitIterator.next();
                    if (u.getType().getExpertProduction() == u.getWorkType()) continue;
                    bestUnit = u;
                    break;
                }
                bestUnit.putOutsideColony();
                AIUnit au = (AIUnit)this.getAIMain().getAIObject(bestUnit);
                if (au.getMission() instanceof WorkInsideColonyMission) {
                    au.setMission(null);
                }
            }
            food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
        }
        block12: for (WorkLocation wl : this.colony.getWorkLocations()) {
            while (wl.getUnitCount() > 0 && wl instanceof Building && ((Building)wl).getProductionNextTurn() <= 0) {
                GoodsType rawMaterial;
                ColonyTile ct;
                unitIterator = wl.getUnitIterator();
                Unit bestPick = unitIterator.next();
                while (unitIterator.hasNext()) {
                    Unit u = unitIterator.next();
                    if (u.getType().getExpertProduction() == u.getWorkType()) continue;
                    bestPick = u;
                    break;
                }
                ColonyTile colonyTile = ct = (rawMaterial = bestPick.getWorkType().getRawMaterial()) != null ? this.colony.getVacantColonyTileFor(bestPick, rawMaterial) : null;
                if (ct != null) {
                    bestPick.work(ct);
                    bestPick.setWorkType(rawMaterial);
                    continue;
                }
                Building th = this.colony.getBuildingForProducing(Goods.BELLS);
                if (th.canAdd(bestPick)) {
                    bestPick.work(th);
                    continue;
                }
                ct = this.colony.getVacantColonyTileFor(bestPick, Goods.FOOD);
                if (ct != null) {
                    bestPick.work(ct);
                    bestPick.setWorkType(Goods.FOOD);
                    continue;
                }
                bestPick.putOutsideColony();
                if (bestPick.getLocation() != wl) continue;
                continue block12;
            }
        }
        List<GoodsType> goodsList = FreeCol.getSpecification().getGoodsTypeList();
        for (GoodsType goodsType : goodsList) {
            int production = this.colony.getProductionNetOf(goodsType);
            int in_stock = this.colony.getGoodsCount(goodsType);
            if (Goods.FOOD == goodsType || production + in_stock <= this.colony.getWarehouseCapacity()) continue;
            Iterator<Unit> unitIterator2 = this.colony.getUnitIterator();
            int waste = production + in_stock - this.colony.getWarehouseCapacity();
            while (unitIterator2.hasNext() && waste > 0) {
                Unit unit = unitIterator2.next();
                if (unit.getWorkType() != goodsType) continue;
                Location oldLocation = unit.getLocation();
                unit.putOutsideColony();
                boolean working = false;
                waste = this.colony.getGoodsCount(goodsType) + this.colony.getProductionNetOf(goodsType) - this.colony.getWarehouseCapacity();
                int best = 0;
                for (GoodsType goodsType2 : goodsList) {
                    int production2;
                    if (!goodsType2.isFarmed() || (production2 = this.colony.getVacantColonyTileProductionFor(unit, goodsType2)) <= best || production2 + this.colony.getGoodsCount(goodsType2) + this.colony.getProductionNetOf(goodsType2) >= this.colony.getWarehouseCapacity()) continue;
                    if (working) {
                        unit.putOutsideColony();
                    }
                    unit.work(this.colony.getVacantColonyTileFor(unit, goodsType2));
                    unit.setWorkType(goodsType2);
                    best = production2;
                    working = true;
                }
                if (working) continue;
                unit.setLocation(oldLocation);
            }
        }
        for (int i = 0; i < workLocationPlans.size(); ++i) {
            WorkLocationPlan wlp = workLocationPlans.get(i);
            WorkLocation wl = wlp.getWorkLocation();
            if (wlp.getGoodsType() != Goods.FOOD || !((ColonyTile)wl).getWorkTile().isLand() && !this.colony.hasAbility("model.ability.produceInWater")) continue;
            Unit bestUnit = null;
            int bestProduction = 0;
            for (Unit unit : units) {
                int production = ((ColonyTile)wlp.getWorkLocation()).getProductionOf(unit, Goods.FOOD);
                if (production <= 1 || bestUnit != null && production <= bestProduction && (production != bestProduction || unit.getSkillLevel() >= bestUnit.getSkillLevel())) continue;
                bestUnit = unit;
                bestProduction = production;
            }
            if (bestUnit == null || !wlp.getWorkLocation().canAdd(bestUnit)) continue;
            bestUnit.work(wlp.getWorkLocation());
            bestUnit.setWorkType(wlp.getGoodsType());
            units.remove(bestUnit);
            workLocationPlans.remove(wlp);
        }
        for (Unit u2 : units) {
            u2.putOutsideColony();
            AIUnit au = (AIUnit)this.getAIMain().getAIObject(u2);
            if (!(au.getMission() instanceof WorkInsideColonyMission)) continue;
            au.setMission(null);
        }
        this.decideBuildable(connection);
        this.createTileImprovementPlans();
        this.createWishes();
        if (this.colony.getUnitCount() <= 0) {
            throw new IllegalStateException("Colony " + this.colony.getName() + " contains no units!");
        }
    }

    private void decideBuildable(Connection connection) {
        BuildableType buildable;
        int hammersOld = this.getHammersRequired(this.colony.getCurrentlyBuilding());
        boolean isOldValid = this.colony.canBuild();
        Iterator<BuildableType> bi = this.colonyPlan.getBuildable();
        while (bi.hasNext() && (buildable = bi.next()) != this.colony.getCurrentlyBuilding()) {
            int hammersNew = this.getHammersRequired(buildable);
            if (hammersNew <= this.colony.getGoodsCount(Goods.HAMMERS) && hammersNew <= hammersOld && isOldValid) continue;
            Element setCurrentlyBuildingElement = Message.createNewRootElement("setCurrentlyBuilding");
            setCurrentlyBuildingElement.setAttribute("colony", this.colony.getId());
            setCurrentlyBuildingElement.setAttribute("type", buildable.getId());
            try {
                connection.sendAndWait(setCurrentlyBuildingElement);
            }
            catch (IOException e) {
                logger.warning("Could not send \"setCurrentlyBuilding\"-message.");
            }
            break;
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIColony.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        for (AIGoods ag : this.aiGoods) {
            if (ag == null) {
                logger.warning("ag == null");
                continue;
            }
            if (ag.getId() == null) {
                logger.warning("ag.getId() == null");
                continue;
            }
            out.writeStartElement(AIGoods.getXMLElementTagName() + "ListElement");
            out.writeAttribute("ID", ag.getId());
            out.writeEndElement();
        }
        for (Wish w : this.wishes) {
            if (!w.shouldBeStored()) continue;
            if (w instanceof WorkerWish) {
                out.writeStartElement(WorkerWish.getXMLElementTagName() + "WishListElement");
            } else if (w instanceof GoodsWish) {
                out.writeStartElement(GoodsWish.getXMLElementTagName() + "WishListElement");
            } else {
                logger.warning("Unknown type of wish.");
                continue;
            }
            out.writeAttribute("ID", w.getId());
            out.writeEndElement();
        }
        for (TileImprovementPlan ti : this.TileImprovementPlans) {
            out.writeStartElement(TileImprovementPlan.getXMLElementTagName() + "ListElement");
            out.writeAttribute("ID", ti.getId());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.colony = (Colony)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID"));
        if (this.colony == null) {
            throw new NullPointerException("Could not find Colony with ID: " + in.getAttributeValue(null, "ID"));
        }
        this.aiGoods.clear();
        this.wishes.clear();
        this.colonyPlan = new ColonyPlan(this.getAIMain(), this.colony);
        this.colonyPlan.create();
        while (in.nextTag() != 2) {
            Wish w;
            if (in.getLocalName().equals(AIGoods.getXMLElementTagName() + "ListElement")) {
                AIGoods ag = (AIGoods)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (ag == null) {
                    ag = new AIGoods(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.aiGoods.add(ag);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(WorkerWish.getXMLElementTagName() + "WishListElement")) {
                w = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (w == null) {
                    w = new WorkerWish(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.wishes.add(w);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(GoodsWish.getXMLElementTagName() + "WishListElement")) {
                w = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (w == null) {
                    w = new GoodsWish(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.wishes.add(w);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(TileImprovementPlan.getXMLElementTagName() + "ListElement")) {
                TileImprovementPlan ti = (TileImprovementPlan)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (ti == null) {
                    ti = new TileImprovementPlan(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.TileImprovementPlans.add(ti);
                in.nextTag();
                continue;
            }
            logger.warning("Unknown tag name: " + in.getLocalName());
        }
        if (!in.getLocalName().equals(AIColony.getXMLElementTagName())) {
            logger.warning("Expected end tag, received: " + in.getLocalName());
        }
    }

    public static String getXMLElementTagName() {
        return "aiColony";
    }
}

