/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AIPlayer
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIPlayer.class.getName());
    private ServerPlayer player;
    private Connection debuggingConnection;
    protected ArrayList<AIUnit> aiUnits = new ArrayList();

    public AIPlayer(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public Player getPlayer() {
        return this.player;
    }

    protected void setPlayer(ServerPlayer p) {
        this.player = p;
    }

    protected Iterator<AIUnit> getAIUnitIterator() {
        if (this.aiUnits.size() == 0) {
            ArrayList<AIUnit> au = new ArrayList<AIUnit>();
            Iterator<Unit> unitsIterator = this.getPlayer().getUnitIterator();
            while (unitsIterator.hasNext()) {
                Unit theUnit = unitsIterator.next();
                AIUnit a = (AIUnit)this.getAIMain().getAIObject(theUnit.getId());
                if (a != null) {
                    au.add(a);
                    continue;
                }
                logger.warning("Could not find the AIUnit for: " + theUnit + " (" + theUnit.getId() + ") - " + (this.getGame().getFreeColGameObject(theUnit.getId()) != null));
            }
            this.aiUnits = au;
        }
        return this.aiUnits.iterator();
    }

    protected Iterator<AIColony> getAIColonyIterator() {
        ArrayList<AIColony> ac = new ArrayList<AIColony>();
        for (Colony colony : this.getPlayer().getColonies()) {
            AIColony a = (AIColony)this.getAIMain().getAIObject(colony.getId());
            if (a != null) {
                ac.add(a);
                continue;
            }
            logger.warning("Could not find the AIColony for: " + colony);
        }
        return ac.iterator();
    }

    public Connection getConnection() {
        if (this.debuggingConnection != null) {
            return this.debuggingConnection;
        }
        return ((DummyConnection)this.player.getConnection()).getOtherConnection();
    }

    public void setDebuggingConnection(Connection debuggingConnection) {
        this.debuggingConnection = debuggingConnection;
    }

    protected void sendAndWaitSafely(Element element) {
        logger.finest("Entering method sendAndWaitSafely");
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("AI player (" + this + ") sending " + element.getTagName() + "...");
            }
            this.getConnection().sendAndWait(element);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Sent and waited, returning.");
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Couldn't send AI element " + element.getTagName() + "!", e);
        }
    }

    protected void sendUpdatedTilesToAll(ArrayList<Tile> tiles) {
        Iterator<Player> enemyPlayerIterator = this.getGame().getPlayerIterator();
        while (enemyPlayerIterator.hasNext()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
            if (this.equals(enemyPlayer) || enemyPlayer.getConnection() == null) continue;
            try {
                Element updateElement = Message.createNewRootElement("update");
                boolean send = false;
                for (Tile tile : tiles) {
                    if (!enemyPlayer.canSee(tile)) continue;
                    updateElement.appendChild(tile.toXMLElement(enemyPlayer, updateElement.getOwnerDocument()));
                    send = true;
                }
                if (!send) continue;
                enemyPlayer.getConnection().send(updateElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    @Override
    public String getId() {
        return this.player.getId();
    }

    public AIUnit trainAIUnitInEurope(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Invalid UnitType.");
        }
        AIUnit unit = null;
        try {
            Element trainUnitInEuropeElement = Message.createNewRootElement("trainUnitInEurope");
            trainUnitInEuropeElement.setAttribute("unitType", unitType.getId());
            Element reply = this.getConnection().ask(trainUnitInEuropeElement);
            if (reply != null && reply.getTagName().equals("trainUnitInEuropeConfirmed")) {
                Element unitElement = (Element)reply.getChildNodes().item(0);
                String unitID = unitElement.getAttribute("ID");
                unit = (AIUnit)this.getAIMain().getAIObject(unitID);
                if (unit == null) {
                    logger.warning("Could not train the specified AI unit " + unitType.getId() + " in europe.");
                }
            } else {
                logger.warning("Could not train the specified AI unit " + unitType.getId() + " in europe.");
            }
        }
        catch (IOException e) {
            logger.warning("Could not send \"trainUnitInEurope\"-message to the server.");
        }
        return unit;
    }

    public AIUnit recruitAIUnitInEurope(int slot) {
        AIUnit unit = null;
        Element recruitUnitInEuropeElement = Message.createNewRootElement("recruitUnitInEurope");
        recruitUnitInEuropeElement.setAttribute("slot", Integer.toString(slot));
        try {
            Element reply = this.getConnection().ask(recruitUnitInEuropeElement);
            if (reply != null && reply.getTagName().equals("recruitUnitInEuropeConfirmed")) {
                Element unitElement = (Element)reply.getChildNodes().item(0);
                String unitID = unitElement.getAttribute("ID");
                unit = (AIUnit)this.getAIMain().getAIObject(unitID);
                if (unit == null) {
                    logger.warning("Could not recruit the specified AI unit in europe");
                }
                return unit;
            }
            logger.warning("Could not recruit the specified AI unit in europe.");
        }
        catch (IOException e) {
            logger.warning("Could not send \"recruitUnitInEurope\"-message to the server.");
        }
        return unit;
    }

    protected boolean checkForREFDefeat() {
        logger.finest("Entering method checkForREFDefeat");
        if (!this.getPlayer().isREF()) {
            throw new IllegalStateException("Checking for REF player defeat when player not REF.");
        }
        List<Player> dominions = this.getPlayer().getDominionsAtWar();
        if (dominions.isEmpty()) {
            return false;
        }
        if (!this.getPlayer().getSettlements().isEmpty()) {
            return false;
        }
        if (this.getPlayer().hasManOfWar() && this.getPlayer().getNumberOfKingLandUnits() > 6) {
            return false;
        }
        for (Player p : dominions) {
            Element giveIndependenceElement = Message.createNewRootElement("giveIndependence");
            giveIndependenceElement.setAttribute("player", p.getId());
            this.sendAndWaitSafely(giveIndependenceElement);
        }
        return true;
    }

    public abstract void startWorking();

    public abstract Iterator<TileImprovementPlan> getTileImprovementPlanIterator();

    public abstract void removeTileImprovementPlan(TileImprovementPlan var1);

    public abstract boolean hasFewColonies();

    public abstract Iterator<Wish> getWishIterator();

    public abstract FoundingFather selectFoundingFather(List<FoundingFather> var1);

    public abstract boolean acceptTax(int var1);

    public abstract boolean acceptIndianDemand(Unit var1, Colony var2, Goods var3, int var4);

    public abstract boolean acceptMercenaryOffer();

    public abstract boolean acceptDiplomaticTrade(DiplomaticTrade var1);

    public abstract void registerSellGoods(Goods var1);

    public abstract int buyProposition(Unit var1, Goods var2, int var3);

    public abstract int tradeProposition(Unit var1, Settlement var2, Goods var3, int var4);

    @Override
    protected abstract void toXMLImpl(XMLStreamWriter var1) throws XMLStreamException;

    @Override
    protected abstract void readFromXMLImpl(XMLStreamReader var1) throws XMLStreamException;

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }
}

