/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColonialAIPlayer
extends EuropeanAIPlayer {
    private static final Logger logger = Logger.getLogger(ColonialAIPlayer.class.getName());

    @Override
    public void startWorking() {
        logger.fine("Entering AI code for: " + this.getPlayer().getNationAsString());
        this.sessionRegister.clear();
        this.clearAIUnits();
        this.cheat();
        this.determineStances();
        this.rearrangeWorkersInColonies();
        this.abortInvalidAndOneTimeMissions();
        this.ensureCorrectMissions();
        this.giveNavalMissions();
        this.secureSettlements();
        this.giveNormalMissions();
        this.createAIGoodsInColonies();
        this.createTransportLists();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.ensureCorrectMissions();
        this.clearAIUnits();
    }

    /*
     * WARNING - void declaration
     */
    private void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        int numberOfUnits = FreeCol.getSpecification().numberOfUnitTypes();
        ArrayList workerWishes = new ArrayList(numberOfUnits);
        for (int i = 0; i < numberOfUnits; ++i) {
            workerWishes.add(new ArrayList());
        }
        if (this.getPlayer().isEuropean()) {
            Iterator<AIColony> aIterator = this.getAIColonyIterator();
            while (aIterator.hasNext()) {
                Iterator<Wish> wIterator = aIterator.next().getWishIterator();
                while (wIterator.hasNext()) {
                    Wish w = wIterator.next();
                    if (!(w instanceof WorkerWish) || w.getTransportable() != null) continue;
                    ((ArrayList)workerWishes.get(((WorkerWish)w).getUnitType().getIndex())).add(w);
                }
            }
        }
        boolean fewColonies = this.hasFewColonies();
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            if (unit.canCarryTreasure()) {
                aiUnit.setMission(new CashInTreasureTrainMission(this.getAIMain(), aiUnit));
            } else if (unit.hasAbility("model.ability.scoutIndianSettlement") && ScoutingMission.isValid(aiUnit)) {
                aiUnit.setMission(new ScoutingMission(this.getAIMain(), aiUnit));
            } else if ((unit.isOffensiveUnit() || unit.isDefensiveUnit()) && (!unit.isColonist() || unit.hasAbility("model.ability.expertSoldier") || this.getGame().getTurn().getNumber() > 5)) {
                this.giveMilitaryMission(aiUnit);
            } else if (unit.getEquipment().contains(toolsType) && PioneeringMission.isValid(aiUnit)) {
                aiUnit.setMission(new PioneeringMission(this.getAIMain(), aiUnit));
            } else if (unit.isColonist()) {
                void var9_10;
                void var9_14;
                HashMap<Location, Integer> distances = new HashMap<Location, Integer>(121);
                for (ArrayList arrayList : workerWishes) {
                    for (Wish w : arrayList) {
                        if (distances.containsKey(w.getDestination())) continue;
                        distances.put(w.getDestination(), unit.getTurnsToReach(w.getDestination()));
                    }
                }
                ArrayList wishList = (ArrayList)workerWishes.get(unit.getType().getIndex());
                Object var9_13 = null;
                int bestTurns = Integer.MAX_VALUE;
                for (int i = 0; i < wishList.size(); ++i) {
                    WorkerWish ww = (WorkerWish)wishList.get(i);
                    if (ww.getTransportable() != null) {
                        wishList.remove(i);
                        --i;
                        continue;
                    }
                    int turns = (Integer)distances.get(ww.getDestination());
                    if (turns == Integer.MAX_VALUE) {
                        turns = ww.getDestination().getTile() == null ? 5 : 10;
                    } else if (turns > 5) {
                        turns = 5;
                    }
                    if (var9_14 != null && ww.getValue() - turns * 2 <= var9_14.getValue() - bestTurns * 2) continue;
                    WorkerWish workerWish = ww;
                    bestTurns = turns;
                }
                if (var9_14 != null) {
                    var9_14.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, (Wish)var9_14));
                    continue;
                }
                Tile colonyTile = null;
                if (this.getPlayer().canBuildColonies()) {
                    colonyTile = BuildColonyMission.findColonyLocation(aiUnit.getUnit());
                }
                if (colonyTile != null) {
                    bestTurns = unit.getTurnsToReach(colonyTile);
                }
                if (!fewColonies || colonyTile == null || bestTurns > 10) {
                    for (int i = 0; i < workerWishes.size(); ++i) {
                        wishList = (ArrayList)workerWishes.get(i);
                        for (int j = 0; j < wishList.size(); ++j) {
                            WorkerWish ww = (WorkerWish)wishList.get(j);
                            if (ww.getTransportable() != null) {
                                wishList.remove(j);
                                --j;
                                continue;
                            }
                            int turns = (Integer)distances.get(ww.getDestination());
                            if (turns == Integer.MAX_VALUE) {
                                turns = ww.getDestination().getTile() == null ? 5 : 10;
                            } else if (turns > 5) {
                                turns = 5;
                            }
                            if (var9_10 != null && ww.getValue() - turns * 2 <= var9_10.getValue() - bestTurns * 2) continue;
                            WorkerWish workerWish = ww;
                            bestTurns = turns;
                        }
                    }
                }
                if (var9_10 != null) {
                    var9_10.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, (Wish)var9_10));
                    continue;
                }
                if (colonyTile != null) {
                    BuildColonyMission mission = new BuildColonyMission(this.getAIMain(), aiUnit, colonyTile, this.getPlayer().getColonyValue(colonyTile));
                    aiUnit.setMission(mission);
                    boolean isUnitOnCarrier = aiUnit.getUnit().isOnCarrier();
                    if (!isUnitOnCarrier) continue;
                    AIUnit carrier = (AIUnit)this.getAIMain().getAIObject((FreeColGameObject)((Object)aiUnit.getUnit().getLocation()));
                    Mission carrierMission = carrier.getMission();
                    boolean isCarrierMissionToTransport = carrierMission instanceof TransportMission;
                    if (!isCarrierMissionToTransport) {
                        throw new IllegalStateException("Carrier carrying unit not on a transport mission");
                    }
                    ((TransportMission)carrierMission).addToTransportList(aiUnit);
                    continue;
                }
            }
            if (aiUnit.hasMission()) continue;
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
        }
    }

    @Override
    public void giveNavalMissions() {
        logger.finest("Entering method giveNavalMissions");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            Unit unit = aiUnit.getUnit();
            if (aiUnit.hasMission() || !unit.isNaval()) continue;
            if (PrivateerMission.isValid(aiUnit)) {
                aiUnit.setMission(new PrivateerMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new TransportMission(this.getAIMain(), aiUnit));
        }
    }

    private void cheat() {
        logger.finest("Entering method cheat");
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            this.getPlayer().resetArrears(goodsType);
        }
        if (this.getAIMain().getFreeColServer().isSingleplayer() && this.getPlayer().isAI() && this.getPlayer().getPlayerType() == Player.PlayerType.COLONIAL) {
            Europe europe = this.getPlayer().getEurope();
            List<UnitType> unitTypes = FreeCol.getSpecification().getUnitTypeList();
            if (this.getRandom().nextInt(10) == 1) {
                int price = 0;
                UnitType unitToTrain = null;
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasPrice()) continue;
                    int unitPrice = europe.getUnitPrice(unitType);
                    if (unitToTrain != null && unitPrice >= price) continue;
                    unitToTrain = unitType;
                    price = unitPrice;
                }
                Unit unit = null;
                if (unitToTrain != null) {
                    this.getPlayer().modifyGold(price);
                    unit = this.trainAIUnitInEurope(unitToTrain).getUnit();
                }
                if (unit != null && unit.isColonist()) {
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(Goods.MUSKETS, 50));
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(Goods.HORSES, 50));
                    Element clearSpecialityElement = Message.createNewRootElement("clearSpeciality");
                    clearSpecialityElement.setAttribute("unit", unit.getId());
                    this.sendAndWaitSafely(clearSpecialityElement);
                    Element equipMusketsElement = Message.createNewRootElement("equipUnit");
                    equipMusketsElement.setAttribute("unit", unit.getId());
                    equipMusketsElement.setAttribute("type", "model.equipment.muskets");
                    equipMusketsElement.setAttribute("amount", Integer.toString(50));
                    this.sendAndWaitSafely(equipMusketsElement);
                    Element equipHorsesElement = Message.createNewRootElement("equipUnit");
                    equipHorsesElement.setAttribute("unit", unit.getId());
                    equipHorsesElement.setAttribute("type", "model.equipment.horses");
                    equipHorsesElement.setAttribute("amount", Integer.toString(50));
                    this.sendAndWaitSafely(equipHorsesElement);
                }
            }
            if (this.getRandom().nextInt(40) == 21) {
                int total = 0;
                ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.hasPrice()) continue;
                    navalUnits.add(unitType);
                    total += europe.getUnitPrice(unitType);
                }
                UnitType unitToPurchase = null;
                int random = this.getRandom().nextInt(total);
                total = 0;
                for (UnitType unitType : navalUnits) {
                    if (random >= (total += unitType.getPrice())) continue;
                    unitToPurchase = unitType;
                    break;
                }
                this.getPlayer().modifyGold(europe.getUnitPrice(unitToPurchase));
                this.trainAIUnitInEurope(unitToPurchase);
            }
        }
    }

    public FoundingFather selectFoundingFather(List<FoundingFather> foundingFathers) {
        int age = this.getGame().getTurn().getAge();
        FoundingFather bestFather = null;
        int bestWeight = -1;
        for (FoundingFather father : foundingFathers) {
            int weight;
            if (father == null || (weight = father.getWeight(age)) <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }

    public boolean acceptTax(int tax) {
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        if (toBeDestroyed == null) {
            return false;
        }
        GoodsType goodsType = toBeDestroyed.getType();
        if (goodsType.isFoodType() || goodsType.isBreedable()) {
            return false;
        }
        if (goodsType.isMilitaryGoods() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            return this.getGame().getTurn().getAge() != 3;
        }
        int averageIncome = 0;
        int numberOfGoods = 0;
        List<GoodsType> goodsTypes = FreeCol.getSpecification().getGoodsTypeList();
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable()) continue;
            averageIncome += this.getPlayer().getIncomeAfterTaxes(type);
            ++numberOfGoods;
        }
        return this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType()) <= (averageIncome /= numberOfGoods);
    }

    @Override
    public boolean acceptIndianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return !goods.getType().isMilitaryGoods();
    }
}

