/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.WorkLocationPlan;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonyPlan {
    private static final Logger logger = Logger.getLogger(ColonyPlan.class.getName());
    private static final int MAX_LEVEL = 3;
    private Colony colony;
    private AIMain aiMain;
    private ArrayList<WorkLocationPlan> workLocationPlans = new ArrayList();

    public ColonyPlan(AIMain aiMain, Colony colony) {
        if (colony == null) {
            throw new IllegalArgumentException("Parameter 'colony' must not be 'null'.");
        }
        this.aiMain = aiMain;
        this.colony = colony;
    }

    public ColonyPlan(AIMain aiMain, Element element) {
        this.aiMain = aiMain;
        this.readFromXMLElement(element);
    }

    public List<WorkLocationPlan> getWorkLocationPlans() {
        return new ArrayList<WorkLocationPlan>(this.workLocationPlans);
    }

    public List<WorkLocationPlan> getSortedWorkLocationPlans() {
        List<WorkLocationPlan> workLocationPlans = this.getWorkLocationPlans();
        Collections.sort(workLocationPlans, new Comparator<WorkLocationPlan>(){

            @Override
            public int compare(WorkLocationPlan o, WorkLocationPlan p) {
                return p.getProductionOf(p.getGoodsType()) - o.getProductionOf(o.getGoodsType());
            }
        });
        return workLocationPlans;
    }

    public Iterator<BuildableType> getBuildable() {
        Building building;
        ArrayList<BuildableType> buildList = new ArrayList<BuildableType>();
        BuildingType docks = null;
        BuildingType customHouse = null;
        BuildingType carpenter = null;
        BuildingType stables = null;
        BuildingType stockade = null;
        BuildingType armory = null;
        BuildingType schoolhouse = null;
        for (BuildingType type : FreeCol.getSpecification().getBuildingTypeList()) {
            if (type.getUpgradesFrom() != null) continue;
            if (type.hasAbility("model.ability.produceInWater")) {
                docks = type;
                continue;
            }
            if (type.hasAbility("model.ability.export")) {
                customHouse = type;
                continue;
            }
            if (type.hasAbility("model.ability.teach")) {
                schoolhouse = type;
                continue;
            }
            if (type.getProducedGoodsType() == Goods.HAMMERS) {
                carpenter = type;
                continue;
            }
            if (type.getProducedGoodsType() == Goods.HORSES) {
                stables = type;
                continue;
            }
            if (type.getProducedGoodsType() == Goods.MUSKETS) {
                armory = type;
                continue;
            }
            if (type.getModifierSet("model.modifier.defence").isEmpty()) continue;
            stockade = type;
        }
        String ability = "model.ability.produceInWater";
        if (!this.colony.hasAbility(ability) && this.colony.canBuild(docks)) {
            buildList.add(docks);
        }
        if ((building = this.colony.getStockade()) == null) {
            if (this.colony.canBuild(stockade)) {
                buildList.add(stockade);
            }
        } else if (building.canBuildNext()) {
            buildList.add(building.getType().getUpgradesTo());
        }
        for (WorkLocationPlan wlp : this.getSortedWorkLocationPlans()) {
            GoodsType outputType;
            if (!(wlp.getWorkLocation() instanceof Building)) continue;
            Building b = (Building)wlp.getWorkLocation();
            if (b.canBuildNext()) {
                buildList.add(b.getType().getUpgradesTo());
            }
            if ((outputType = b.getGoodsOutputType()) == null) continue;
            for (Building manufacture : this.colony.getBuildings()) {
                if (manufacture.getType().getModifierSet(outputType.getId()).isEmpty() || !manufacture.canBuildNext()) continue;
                buildList.add(manufacture.getType().getUpgradesTo());
            }
        }
        Object buildingForExport = null;
        ability = "model.ability.export";
        if (!this.colony.hasAbility(ability) && this.colony.canBuild(customHouse) && this.colony.getGoodsContainer().hasReachedCapacity(this.colony.getWarehouseCapacity())) {
            buildList.add(customHouse);
        }
        if ((building = this.colony.getWarehouse()).canBuildNext()) {
            if (this.colony.getGoodsContainer().hasReachedCapacity(this.colony.getWarehouseCapacity())) {
                buildList.add(0, building.getType().getUpgradesTo());
            } else {
                buildList.add(building.getType());
            }
        }
        building = this.colony.getBuildingForProducing(Goods.HAMMERS);
        if (buildList.size() > 3) {
            if (building == null) {
                if (this.colony.canBuild(carpenter)) {
                    buildList.add(0, carpenter);
                }
            } else if (building.canBuildNext()) {
                buildList.add(0, building.getType().getUpgradesTo());
            }
        }
        building = this.colony.getBuildingForProducing(Goods.HORSES);
        if (this.colony.getProductionOf(Goods.HORSES) > 2) {
            if (building == null) {
                if (this.colony.canBuild(stables)) {
                    buildList.add(stables);
                }
            } else if (building.canBuildNext()) {
                buildList.add(building.getType().getUpgradesTo());
            }
        }
        if ((building = this.colony.getBuildingForProducing(Goods.MUSKETS)) == null) {
            if (this.colony.canBuild(armory)) {
                buildList.add(armory);
            }
        } else if (building.canBuildNext()) {
            buildList.add(building.getType().getUpgradesTo());
        }
        buildList.add(FreeCol.getSpecification().getUnitType("model.unit.artillery"));
        ability = "model.ability.teach";
        if (!this.colony.hasAbility(ability) && this.colony.canBuild(schoolhouse)) {
            buildList.add(schoolhouse);
        }
        return buildList.iterator();
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public Game getGame() {
        return this.aiMain.getGame();
    }

    public void create() {
        Tile t;
        WorkLocationPlan wlp;
        Iterator<WorkLocationPlan> wlpIterator2;
        WorkLocationPlan wlp2;
        GoodsType producedGoods;
        Building b;
        WorkLocationPlan wlp3;
        GoodsType hammersType = FreeCol.getSpecification().getGoodsType("model.goods.hammers");
        GoodsType toolsType = FreeCol.getSpecification().getGoodsType("model.goods.tools");
        GoodsType lumberType = FreeCol.getSpecification().getGoodsType("model.goods.lumber");
        GoodsType oreType = FreeCol.getSpecification().getGoodsType("model.goods.ore");
        this.workLocationPlans.clear();
        Building townHall = this.colony.getBuildingForProducing(Goods.BELLS);
        for (ColonyTile ct : this.colony.getColonyTiles()) {
            if (ct.getWorkTile().getOwningSettlement() != null && ct.getWorkTile().getOwningSettlement() != this.colony || ct.isColonyCenterTile()) continue;
            GoodsType goodsType = this.getBestGoodsToProduce(ct.getWorkTile());
            WorkLocationPlan wlp4 = new WorkLocationPlan(this.getAIMain(), ct, goodsType);
            this.workLocationPlans.add(wlp4);
        }
        GoodsType buildingReq = null;
        GoodsType buildingRawMat = null;
        Building buildingReqProducer = null;
        BuildableType currBuild = this.colony.getCurrentlyBuilding();
        if (currBuild != null) {
            if (this.colony.getGoodsCount(hammersType) < currBuild.getAmountRequiredOf(hammersType)) {
                buildingReq = hammersType;
                buildingRawMat = lumberType;
            } else {
                buildingReq = toolsType;
                buildingRawMat = oreType;
            }
            buildingReqProducer = this.colony.getBuildingForProducing(buildingReq);
        }
        if (buildingRawMat != null && this.getProductionOf(buildingRawMat) <= 0) {
            WorkLocationPlan bestChoice = null;
            int highestPotential = 0;
            for (WorkLocationPlan wlp5 : this.workLocationPlans) {
                if (!(wlp5.getWorkLocation() instanceof ColonyTile) || ((ColonyTile)wlp5.getWorkLocation()).getWorkTile().potential(buildingRawMat, null) <= highestPotential) continue;
                highestPotential = ((ColonyTile)wlp5.getWorkLocation()).getWorkTile().potential(buildingRawMat, null);
                bestChoice = wlp5;
            }
            if (highestPotential > 0) {
                assert (bestChoice != null);
                bestChoice.setGoodsType(Goods.LUMBER);
            }
        }
        GoodsType primaryRawMaterial = null;
        int primaryRawMaterialProduction = 0;
        GoodsType secondaryRawMaterial = null;
        int secondaryRawMaterialProduction = 0;
        List<GoodsType> goodsTypeList = FreeCol.getSpecification().getGoodsTypeList();
        for (GoodsType goodsType : goodsTypeList) {
            if (goodsType.getProducedMaterial() == null || goodsType.getProducedMaterial() == hammersType) continue;
            if (this.getProductionOf(goodsType) > primaryRawMaterialProduction) {
                secondaryRawMaterial = primaryRawMaterial;
                secondaryRawMaterialProduction = primaryRawMaterialProduction;
                primaryRawMaterial = goodsType;
                primaryRawMaterialProduction = this.getProductionOf(goodsType);
                continue;
            }
            if (this.getProductionOf(goodsType) <= secondaryRawMaterialProduction) continue;
            secondaryRawMaterial = goodsType;
            secondaryRawMaterialProduction = this.getProductionOf(goodsType);
        }
        Iterator<WorkLocationPlan> wlpIterator = this.workLocationPlans.iterator();
        while (wlpIterator.hasNext()) {
            wlp3 = wlpIterator.next();
            if (!(wlp3.getWorkLocation() instanceof ColonyTile) || wlp3.getGoodsType() == primaryRawMaterial || wlp3.getGoodsType() == secondaryRawMaterial || wlp3.getGoodsType() == Goods.LUMBER || wlp3.getGoodsType() == Goods.ORE || wlp3.getGoodsType() == Goods.SILVER) continue;
            if (((ColonyTile)wlp3.getWorkLocation()).getWorkTile().potential(Goods.FOOD, null) <= 2) {
                if (wlp3.getGoodsType() == null) {
                    wlpIterator.remove();
                    continue;
                }
                if (wlp3.getProductionOf(wlp3.getGoodsType()) > 2) continue;
                wlpIterator.remove();
                continue;
            }
            wlp3.setGoodsType(Goods.FOOD);
        }
        if (buildingReq != null && (this.getProductionOf(buildingRawMat) > 0 || this.colony.getGoodsCount(buildingRawMat) > 0)) {
            wlp3 = new WorkLocationPlan(this.getAIMain(), this.colony.getBuildingForProducing(buildingReq), buildingReq);
            this.workLocationPlans.add(wlp3);
        }
        WorkLocationPlan townHallWlp = new WorkLocationPlan(this.getAIMain(), townHall, Goods.BELLS);
        this.workLocationPlans.add(townHallWlp);
        if (primaryRawMaterial != null && (b = this.colony.getBuildingForProducing(producedGoods = primaryRawMaterial.getProducedMaterial())) != null) {
            wlp2 = new WorkLocationPlan(this.getAIMain(), b, producedGoods);
            this.workLocationPlans.add(wlp2);
        }
        if (this.getFoodProduction() < this.workLocationPlans.size() * 2 && secondaryRawMaterial.isNewWorldGoodsType()) {
            wlpIterator2 = this.workLocationPlans.iterator();
            while (wlpIterator2.hasNext()) {
                wlp = wlpIterator2.next();
                if (!(wlp.getWorkLocation() instanceof ColonyTile) || wlp.getGoodsType() != secondaryRawMaterial) continue;
                t = ((ColonyTile)wlp.getWorkLocation()).getWorkTile();
                if (t.getMaximumPotential(Goods.FOOD, null) > 2) {
                    wlp.setGoodsType(Goods.FOOD);
                    continue;
                }
                wlpIterator2.remove();
            }
        }
        if (this.getFoodProduction() < this.workLocationPlans.size() * 2) {
            wlpIterator2 = this.workLocationPlans.iterator();
            while (wlpIterator2.hasNext() && this.getFoodProduction() < this.workLocationPlans.size() * 2) {
                wlp = wlpIterator2.next();
                if (!(wlp.getWorkLocation() instanceof ColonyTile) || wlp.getGoodsType() != primaryRawMaterial) continue;
                t = ((ColonyTile)wlp.getWorkLocation()).getWorkTile();
                if (t.getMaximumPotential(Goods.FOOD, null) > 2) {
                    wlp.setGoodsType(Goods.FOOD);
                    continue;
                }
                wlpIterator2.remove();
            }
        }
        if (this.getFoodProduction() < this.workLocationPlans.size() * 2) {
            wlpIterator2 = this.workLocationPlans.iterator();
            while (wlpIterator2.hasNext() && this.getFoodProduction() < this.workLocationPlans.size() * 2) {
                Building b2;
                wlp = wlpIterator2.next();
                if (!(wlp.getWorkLocation() instanceof Building) || (b2 = (Building)wlp.getWorkLocation()) == buildingReqProducer || b2 == townHall) continue;
                wlpIterator2.remove();
            }
        }
        GoodsType buildMatToGo = buildingReq;
        if (this.colony.getGoodsCount(buildingRawMat) > 0) {
            buildMatToGo = buildingRawMat;
        }
        if (this.getFoodProduction() < this.workLocationPlans.size() * 2) {
            Iterator<WorkLocationPlan> wlpIterator22 = this.workLocationPlans.iterator();
            while (wlpIterator22.hasNext() && this.getFoodProduction() < this.workLocationPlans.size() * 2) {
                wlp2 = wlpIterator22.next();
                if (!(wlp2.getWorkLocation() instanceof ColonyTile) || wlp2.getGoodsType() != buildMatToGo) continue;
                wlpIterator22.remove();
            }
            if (this.getFoodProduction() < this.workLocationPlans.size() * 2) {
                buildMatToGo = buildMatToGo == buildingRawMat ? buildingReq : buildingRawMat;
                wlpIterator22 = this.workLocationPlans.iterator();
                while (wlpIterator22.hasNext() && this.getFoodProduction() < this.workLocationPlans.size() * 2) {
                    wlp2 = wlpIterator22.next();
                    if (!(wlp2.getWorkLocation() instanceof ColonyTile) || wlp2.getGoodsType() != buildMatToGo) continue;
                    wlpIterator22.remove();
                }
            }
        }
        if (this.getFoodProduction() < this.workLocationPlans.size() * 2 + 2) {
            return;
        }
        int primaryWorkers = 1;
        int secondaryWorkers = 0;
        int builders = 1;
        int gunsmiths = 0;
        boolean colonistAdded = true;
        while (colonistAdded) {
            Building b3;
            WorkLocationPlan wlp6;
            GoodsType producedGoods2;
            Building b4;
            boolean blacksmithAdded = false;
            if (this.getFoodProduction() >= this.workLocationPlans.size() * 2 + 2 && secondaryRawMaterial != null && 12 * secondaryWorkers + 6 <= this.getProductionOf(secondaryRawMaterial) && secondaryWorkers <= 3 && (b4 = this.colony.getBuildingForProducing(producedGoods2 = secondaryRawMaterial.getProducedMaterial())) != null) {
                wlp6 = new WorkLocationPlan(this.getAIMain(), b4, producedGoods2);
                this.workLocationPlans.add(wlp6);
                colonistAdded = true;
                ++secondaryWorkers;
                if (secondaryRawMaterial == Goods.ORE) {
                    blacksmithAdded = true;
                }
            }
            if (this.getFoodProduction() >= this.workLocationPlans.size() * 2 + 2 && primaryRawMaterial != null && 12 * primaryWorkers + 6 <= this.getProductionOf(primaryRawMaterial) && primaryWorkers <= 3 && (b4 = this.colony.getBuildingForProducing(producedGoods2 = primaryRawMaterial.getProducedMaterial())) != null) {
                wlp6 = new WorkLocationPlan(this.getAIMain(), b4, producedGoods2);
                this.workLocationPlans.add(wlp6);
                colonistAdded = true;
                ++primaryWorkers;
                if (primaryRawMaterial == Goods.ORE) {
                    blacksmithAdded = true;
                }
            }
            if (blacksmithAdded && this.getFoodProduction() >= this.workLocationPlans.size() * 2 + 2 && gunsmiths < 3 && (b3 = this.colony.getBuildingForProducing(Goods.MUSKETS)) != null) {
                WorkLocationPlan wlp7 = new WorkLocationPlan(this.getAIMain(), b3, Goods.MUSKETS);
                this.workLocationPlans.add(wlp7);
                colonistAdded = true;
                ++gunsmiths;
            }
            if (this.getFoodProduction() >= this.workLocationPlans.size() * 2 + 2 && buildingReqProducer != null && buildingReqProducer.getProduction() * builders <= this.getProductionOf(buildingRawMat) && buildingReqProducer.getMaxUnits() < builders) {
                WorkLocationPlan wlp8 = new WorkLocationPlan(this.getAIMain(), buildingReqProducer, buildingReq);
                this.workLocationPlans.add(wlp8);
                colonistAdded = true;
                ++builders;
            }
            colonistAdded = false;
        }
    }

    public int getProductionOf(GoodsType goodsType) {
        int amount = 0;
        for (WorkLocationPlan wlp : this.workLocationPlans) {
            amount += wlp.getProductionOf(goodsType);
        }
        if (goodsType == this.colony.getTile().primaryGoods() || goodsType == this.colony.getTile().secondaryGoods()) {
            amount += this.colony.getTile().getMaximumPotential(goodsType, null);
        }
        return amount;
    }

    public int getFoodProduction() {
        int amount = 0;
        for (GoodsType foodType : FreeCol.getSpecification().getGoodsFood()) {
            amount += this.getProductionOf(foodType);
        }
        return amount;
    }

    private GoodsType getBestGoodsToProduce(Tile t) {
        if (t.hasResource()) {
            return t.getTileItemContainer().getResource().getBestGoodsType();
        }
        List<AbstractGoods> sortedPotentials = t.getSortedPotential();
        if (sortedPotentials.isEmpty()) {
            return null;
        }
        return sortedPotentials.get(0).getType();
    }

    public Colony getColony() {
        return this.colony;
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(ColonyPlan.getXMLElementTagName());
        element.setAttribute("ID", this.colony.getId());
        return element;
    }

    public void readFromXMLElement(Element element) {
        this.colony = (Colony)this.getAIMain().getFreeColGameObject(element.getAttribute("ID"));
    }

    public static String getXMLElementTagName() {
        return "colonyPlan";
    }
}

