/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.NewAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EuropeanAIPlayer
extends NewAIPlayer {
    private static final Logger logger = Logger.getLogger(EuropeanAIPlayer.class.getName());

    public boolean hasManOfWar() {
        Iterator<Unit> it = this.getPlayer().getUnitIterator();
        while (it.hasNext()) {
            Unit unit = it.next();
            if (!"model.unit.manOWar".equals(unit.getType().getId())) continue;
            return true;
        }
        return false;
    }

    public AIUnit trainAIUnitInEurope(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Invalid UnitType.");
        }
        AIUnit unit = null;
        try {
            Element trainUnitInEuropeElement = Message.createNewRootElement("trainUnitInEurope");
            trainUnitInEuropeElement.setAttribute("unitType", unitType.getId());
            Element reply = this.getConnection().ask(trainUnitInEuropeElement);
            if (reply != null && reply.getTagName().equals("trainUnitInEuropeConfirmed")) {
                Element unitElement = (Element)reply.getChildNodes().item(0);
                String unitID = unitElement.getAttribute("ID");
                unit = (AIUnit)this.getAIMain().getAIObject(unitID);
                if (unit == null) {
                    logger.warning("Could not train the specified AI unit " + unitType.getId() + " in europe.");
                }
            } else {
                logger.warning("Could not train the specified AI unit " + unitType.getId() + " in europe.");
            }
        }
        catch (IOException e) {
            logger.warning("Could not send \"trainUnitInEurope\"-message to the server.");
        }
        return unit;
    }

    public AIUnit recruitAIUnitInEurope(int slot) {
        AIUnit unit = null;
        Element recruitUnitInEuropeElement = Message.createNewRootElement("recruitUnitInEurope");
        recruitUnitInEuropeElement.setAttribute("slot", Integer.toString(slot));
        try {
            Element reply = this.getConnection().ask(recruitUnitInEuropeElement);
            if (reply != null && reply.getTagName().equals("recruitUnitInEuropeConfirmed")) {
                Element unitElement = (Element)reply.getChildNodes().item(0);
                String unitID = unitElement.getAttribute("ID");
                unit = (AIUnit)this.getAIMain().getAIObject(unitID);
                if (unit == null) {
                    logger.warning("Could not recruit the specified AI unit in europe");
                }
                return unit;
            }
            logger.warning("Could not recruit the specified AI unit in europe.");
        }
        catch (IOException e) {
            logger.warning("Could not send \"recruitUnitInEurope\"-message to the server.");
        }
        return unit;
    }

    protected void ensureCorrectMissions() {
        logger.finest("Entering method ensureCorrectMissions");
        Iterator<AIUnit> it = this.getAIUnitIterator();
        while (it.hasNext()) {
            AIUnit au = it.next();
            if (au.hasMission() || !(au.getUnit().getLocation() instanceof ColonyTile) && !(au.getUnit().getLocation() instanceof Building)) continue;
            AIColony ac = (AIColony)this.getAIMain().getAIObject(au.getUnit().getColony());
            au.setMission(new WorkInsideColonyMission(this.getAIMain(), au, ac));
        }
    }

    protected void giveNavalMissions() {
        logger.finest("Entering method giveNavalMissions");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (!aiUnit.getUnit().isNaval() || aiUnit.hasMission()) continue;
            aiUnit.setMission(new TransportMission(this.getAIMain(), aiUnit));
        }
    }

    protected void rearrangeWorkersInColonies() {
        logger.finest("Entering method rearrangeWorkersInColonies");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            ArrayList<Tile> oldWorkTiles = new ArrayList<Tile>();
            for (ColonyTile colonyTile : c.getColony().getColonyTiles()) {
                if (colonyTile.getUnit() == null) continue;
                oldWorkTiles.add(colonyTile.getWorkTile());
            }
            c.rearrangeWorkers(this.getConnection());
            ArrayList<Tile> tilesToUpdate = new ArrayList<Tile>();
            for (ColonyTile colonyTile : c.getColony().getColonyTiles()) {
                boolean wasOccupied;
                boolean isOccupied = colonyTile.getUnit() != null;
                if (isOccupied == (wasOccupied = oldWorkTiles.remove(colonyTile.getWorkTile()))) continue;
                tilesToUpdate.add(colonyTile.getWorkTile());
            }
            this.sendUpdatedTilesToAll(tilesToUpdate);
        }
    }

    protected void secureSettlements() {
        logger.finest("Entering method secureSettlements");
    }

    protected void secureColony(Colony colony) {
        Iterator<Unit> uit;
        Map map = this.getPlayer().getGame().getMap();
        int olddefenders = 0;
        int defenders = 0;
        int threat = 0;
        int worstThreat = 0;
        FreeColGameObject bestTarget = null;
        Iterator<Unit> ui = colony.getTile().getUnitIterator();
        while (ui.hasNext()) {
            if (!ui.next().isDefensiveUnit()) continue;
            ++defenders;
        }
        Map.CircleIterator positionIterator = map.getCircleIterator(colony.getTile().getPosition(), true, 5);
        while (positionIterator.hasNext()) {
            Iterator<Unit> uit2;
            Tile t = map.getTile((Map.Position)positionIterator.next());
            if (t.getFirstUnit() == null) continue;
            if (t.getFirstUnit().getOwner() == this.getPlayer()) {
                uit = t.getUnitIterator();
                while (uit.hasNext()) {
                    if (!uit.next().isOffensiveUnit()) continue;
                    ++defenders;
                }
                continue;
            }
            int thisThreat = 0;
            if (this.getPlayer().getTension(t.getFirstUnit().getOwner()).getValue() >= 300) {
                uit2 = t.getUnitIterator();
                while (uit2.hasNext()) {
                    if (!uit2.next().isOffensiveUnit()) continue;
                    thisThreat += 2;
                }
            } else if (this.getPlayer().getTension(t.getFirstUnit().getOwner()).getValue() >= 100) {
                uit2 = t.getUnitIterator();
                while (uit2.hasNext()) {
                    if (!uit2.next().isOffensiveUnit()) continue;
                    ++thisThreat;
                }
            }
            threat += thisThreat;
            if (thisThreat <= worstThreat) continue;
            bestTarget = t.getSettlement() != null ? t.getSettlement() : t.getFirstUnit();
            worstThreat = thisThreat;
        }
        olddefenders = defenders;
        if (colony.hasStockade()) {
            defenders += defenders * colony.getStockade().getLevel() / 2;
        }
        if (threat > defenders) {
            GoodsWish gw;
            Wish w;
            Iterator<Wish> wishes;
            ArrayList<Unit> recruits = new ArrayList<Unit>();
            ArrayList<Unit> others = new ArrayList<Unit>();
            int inColonyCount = 0;
            ui = colony.getUnitIterator();
            while (ui.hasNext()) {
                Unit u = ui.next();
                if (u.isOffensiveUnit()) continue;
                if (u.getLocation() != colony.getTile()) {
                    ++inColonyCount;
                }
                if (u.hasAbility("model.ability.expertSoldier")) {
                    recruits.add(u);
                    continue;
                }
                if (!u.hasAbility("model.ability.canBeEquipped")) continue;
                others.add(u);
            }
            Collections.sort(others, new Comparator<Unit>(){

                @Override
                public int compare(Unit unit1, Unit unit2) {
                    if (unit1.getSkillLevel() < unit2.getSkillLevel()) {
                        return -1;
                    }
                    if (unit1.getSkillLevel() > unit2.getSkillLevel()) {
                        return 1;
                    }
                    return 0;
                }
            });
            recruits.addAll(others);
            int recruitCount = threat - defenders;
            if (recruitCount > recruits.size() - 1) {
                recruitCount = recruits.size() - 1;
            }
            if (recruitCount > inColonyCount - 1) {
                recruitCount = inColonyCount - 1;
            }
            boolean needMuskets = false;
            boolean needHorses = false;
            ui = recruits.iterator();
            while (ui.hasNext() && recruitCount > 0) {
                Unit u = ui.next();
                if (!u.isArmed() && u.canBeEquippedWith(muskets)) {
                    --recruitCount;
                    Element equipUnitElement = Message.createNewRootElement("equipUnit");
                    equipUnitElement.setAttribute("unit", u.getId());
                    equipUnitElement.setAttribute("type", muskets.getId());
                    equipUnitElement.setAttribute("amount", "1");
                    u.equipWith(muskets);
                    this.sendAndWaitSafely(equipUnitElement);
                    Element putOutsideColonyElement = Message.createNewRootElement("putOutsideColony");
                    putOutsideColonyElement.setAttribute("unit", u.getId());
                    u.putOutsideColony();
                    this.sendAndWaitSafely(putOutsideColonyElement);
                    if (u.checkSetState(Unit.UnitState.FORTIFYING)) {
                        Element changeStateElement = Message.createNewRootElement("changeState");
                        changeStateElement.setAttribute("unit", u.getId());
                        changeStateElement.setAttribute("state", Unit.UnitState.FORTIFYING.toString());
                        this.sendAndWaitSafely(changeStateElement);
                    }
                    ++olddefenders;
                    if (!u.isMounted() && u.canBeEquippedWith(horses)) {
                        equipUnitElement = Message.createNewRootElement("equipUnit");
                        equipUnitElement.setAttribute("unit", u.getId());
                        equipUnitElement.setAttribute("type", horses.getId());
                        equipUnitElement.setAttribute("amount", "1");
                        this.sendAndWaitSafely(equipUnitElement);
                        continue;
                    }
                    needHorses = true;
                    continue;
                }
                needMuskets = true;
                break;
            }
            AIColony ac = null;
            if (needMuskets || needHorses) {
                Iterator<AIColony> aIterator = this.getAIColonyIterator();
                while (aIterator.hasNext()) {
                    AIColony temp = aIterator.next();
                    if (temp == null || temp.getColony() != colony) continue;
                    ac = temp;
                    break;
                }
            }
            if (needMuskets && ac != null) {
                wishes = ac.getWishIterator();
                boolean made = false;
                while (wishes.hasNext()) {
                    w = wishes.next();
                    if (!(w instanceof GoodsWish) || (gw = (GoodsWish)w).getGoodsType() != Goods.MUSKETS) continue;
                    made = true;
                }
                if (!made) {
                    ac.addGoodsWish(new GoodsWish(this.getAIMain(), colony, (threat - olddefenders) * 50, Goods.MUSKETS));
                }
            }
            if (needHorses && ac != null) {
                wishes = ac.getWishIterator();
                boolean made = false;
                while (wishes.hasNext()) {
                    w = wishes.next();
                    if (!(w instanceof GoodsWish) || (gw = (GoodsWish)w).getGoodsType() != Goods.HORSES) continue;
                    made = true;
                }
                if (!made) {
                    ac.addGoodsWish(new GoodsWish(this.getAIMain(), colony, (threat - defenders) * 50, Goods.HORSES));
                }
            }
            defenders = olddefenders;
            if (colony.hasStockade()) {
                defenders += defenders * colony.getStockade().getLevel() / 2;
            }
        }
        if (defenders > threat * 2) {
            Unit u = null;
            uit = colony.getUnitIterator();
            while (uit.hasNext()) {
                Unit candidate = uit.next();
                if (!candidate.isOffensiveUnit() || candidate.getState() != Unit.UnitState.FORTIFIED) continue;
                u = candidate;
                break;
            }
            if (u != null) {
                u.setState(Unit.UnitState.ACTIVE);
                u.setLocation(colony.getTile());
                AIUnit newDefenderAI = (AIUnit)this.getAIMain().getAIObject(u);
                if (bestTarget != null) {
                    newDefenderAI.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), newDefenderAI, (Location)((Object)bestTarget)));
                } else {
                    newDefenderAI.setMission(new UnitWanderHostileMission(this.getAIMain(), newDefenderAI));
                }
            }
        }
    }

    protected void createAIGoodsInColonies() {
        logger.finest("Entering method createAIGoodsInColonies");
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            c.createAIGoods();
        }
    }

    int getDefendColonyMissionValue(Unit u, Colony colony, int turns) {
        logger.finest("Entering method getDefendColonyMissionValue");
        if (colony == null) {
            return Integer.MIN_VALUE;
        }
        int value = 10025 - turns;
        int numberOfDefendingUnits = 0;
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext()) {
            Mission m = aui.next().getMission();
            if (m == null || !(m instanceof DefendSettlementMission) || ((DefendSettlementMission)m).getSettlement() != colony) continue;
            value -= 6;
            ++numberOfDefendingUnits;
        }
        if (u.getOwner().isREF()) {
            value -= 19;
            if (numberOfDefendingUnits > 0) {
                return 0;
            }
        }
        if (colony.getStockade() != null && numberOfDefendingUnits > colony.getStockade().getLevel() + 1) {
            return Math.max(0, value - 9000);
        }
        return value;
    }

    void giveMilitaryMission(AIUnit aiUnit) {
        Tile targetTile;
        int value;
        GoalDecider targetDecider;
        PathNode newTarget;
        int value2;
        PathNode ln;
        int value3;
        logger.finest("Entering method giveMilitaryMission");
        if (this.getPlayer().isIndian()) {
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
            return;
        }
        Unit unit = aiUnit.getUnit();
        Unit carrier = unit.isOnCarrier() ? (Unit)unit.getLocation() : null;
        Map map = unit.getGame().getMap();
        Ownable bestTarget = null;
        int bestValue = Integer.MIN_VALUE;
        Tile startTile = unit.getTile();
        if (startTile == null) {
            startTile = unit.isOnCarrier() ? (Tile)((Unit)unit.getLocation()).getEntryLocation() : (Tile)unit.getOwner().getEntryLocation();
        }
        if (unit.getColony() != null) {
            bestTarget = unit.getColony();
            bestValue = this.getDefendColonyMissionValue(unit, (Colony)bestTarget, 0);
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode best = null;
            private int bestValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode pathNode) {
                Tile t = pathNode.getTile();
                if (t.getColony() != null && t.getColony().getOwner() == u.getOwner()) {
                    int value = EuropeanAIPlayer.this.getDefendColonyMissionValue(u, t.getColony(), pathNode.getTurns());
                    if (value > 0 && value > this.bestValue) {
                        this.bestValue = value;
                        this.best = pathNode;
                    }
                    return true;
                }
                return false;
            }
        };
        int MAXIMUM_DISTANCE_TO_SETTLEMENT = 10;
        PathNode bestPath = map.search(unit, startTile, gd, map.getDefaultCostDecider(), 10, carrier);
        if (bestPath != null && (value3 = this.getDefendColonyMissionValue(unit, (ln = bestPath.getLastNode()).getTile().getColony(), ln.getTurns())) > bestValue) {
            bestTarget = ln.getTile().getColony();
            bestValue = value3;
        }
        Location bestExistingTarget = null;
        int smallestDifference = Integer.MAX_VALUE;
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext() && smallestDifference > 0) {
            int difference;
            AIUnit coAIUnit = aui.next();
            Unit coUnit = coAIUnit.getUnit();
            if (coUnit.getTile() == null || !(coAIUnit.getMission() instanceof UnitSeekAndDestroyMission)) continue;
            Location target = ((UnitSeekAndDestroyMission)coAIUnit.getMission()).getTarget();
            int ourDistance = unit.getTurnsToReach(startTile, target.getTile());
            int coUnitDistance = coUnit.getTurnsToReach(target.getTile());
            if (ourDistance == Integer.MAX_VALUE || (difference = Math.abs(ourDistance - coUnitDistance)) >= smallestDifference) continue;
            smallestDifference = difference;
            bestExistingTarget = target;
        }
        if (bestExistingTarget != null && (value2 = this.getUnitSeekAndDestroyMissionValue(unit, bestExistingTarget.getTile(), smallestDifference)) > bestValue) {
            bestValue = value2;
            bestTarget = (Ownable)((Object)bestExistingTarget);
        }
        if ((newTarget = map.search(unit, startTile, targetDecider = new GoalDecider(){
            private PathNode bestTarget = null;
            private int bestNewTargetValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                int value;
                Tile newTile = pathNode.getTile();
                Unit defender = newTile.getDefendingUnit(unit);
                if (EuropeanAIPlayer.this.isTargetValidForSeekAndDestroy(unit, defender) && (value = EuropeanAIPlayer.this.getUnitSeekAndDestroyMissionValue(unit, pathNode.getTile(), pathNode.getTurns())) > this.bestNewTargetValue) {
                    this.bestTarget = pathNode;
                    this.bestNewTargetValue = value;
                    return true;
                }
                return false;
            }
        }, map.getDefaultCostDecider(), Integer.MAX_VALUE, carrier)) != null && (value = this.getUnitSeekAndDestroyMissionValue(unit, targetTile = newTarget.getLastNode().getTile(), newTarget.getTotalTurns())) > bestValue) {
            bestValue = value;
            bestTarget = targetTile.getSettlement() != null ? targetTile.getSettlement() : (this.getBestTreasureTrain(targetTile) != null ? this.getBestTreasureTrain(targetTile) : targetTile.getDefendingUnit(unit));
        }
        if (bestTarget != null && bestValue > 0) {
            if (bestTarget.getOwner() == unit.getOwner()) {
                aiUnit.setMission(new DefendSettlementMission(this.getAIMain(), aiUnit, (Settlement)bestTarget));
            } else {
                aiUnit.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), aiUnit, (Location)((Object)bestTarget)));
            }
        } else {
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
        }
    }

    public Iterator<TileImprovementPlan> getTileImprovementPlanIterator() {
        ArrayList<TileImprovementPlan> tileImprovements = new ArrayList<TileImprovementPlan>();
        Iterator<AIColony> acIterator = this.getAIColonyIterator();
        while (acIterator.hasNext()) {
            AIColony ac = acIterator.next();
            Iterator<TileImprovementPlan> it = ac.getTileImprovementPlanIterator();
            while (it.hasNext()) {
                tileImprovements.add(it.next());
            }
        }
        return tileImprovements.iterator();
    }

    public boolean hasFewColonies() {
        logger.finest("Entering method hasFewColonies");
        if (!this.getPlayer().canBuildColonies()) {
            return false;
        }
        int numberOfColonies = 0;
        int numberOfWorkers = 0;
        for (Colony colony : this.getPlayer().getColonies()) {
            ++numberOfColonies;
            numberOfWorkers += colony.getUnitCount();
        }
        logger.finest("Leaving method hasFewColonies");
        return numberOfColonies <= 2 || numberOfColonies >= 3 && numberOfWorkers / numberOfColonies > numberOfColonies - 2;
    }

    protected void createTransportLists() {
        Transportable t;
        logger.finest("Entering method createTransportLists");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        ArrayList<AIObject> transportables = new ArrayList<AIObject>();
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext()) {
            AIUnit au = aui.next();
            if (au.getUnit().isNaval() || au.getTransportDestination() == null || au.getTransport() != null) continue;
            transportables.add(au);
        }
        Iterator<AIColony> aci = this.getAIColonyIterator();
        while (aci.hasNext()) {
            AIColony ac = aci.next();
            Iterator<AIGoods> agi = ac.getAIGoodsIterator();
            while (agi.hasNext()) {
                AIGoods ag = agi.next();
                if (ag.getTransportDestination() == null || ag.getTransport() != null) continue;
                transportables.add(ag);
            }
        }
        Collections.sort(transportables, new Comparator<Transportable>(){

            @Override
            public int compare(Transportable o1, Transportable o2) {
                if (o1 == o2) {
                    return 0;
                }
                int result = o2.getTransportPriority() - o1.getTransportPriority();
                if (result == 0) {
                    result = o1.getId().compareTo(o2.getId());
                }
                return result;
            }
        });
        ArrayList<Mission> vacantTransports = new ArrayList<Mission>();
        Iterator<AIUnit> iter = this.getAIUnitIterator();
        while (iter.hasNext()) {
            AIUnit au = iter.next();
            if (!au.hasMission() || !(au.getMission() instanceof TransportMission) || au.getUnit().getLocation() instanceof Europe) continue;
            vacantTransports.add(au.getMission());
        }
        Iterator ti = transportables.iterator();
        while (ti.hasNext()) {
            t = (Transportable)ti.next();
            t.increaseTransportPriority();
            if (!(t.getTransportLocatable().getLocation() instanceof Unit)) continue;
            Mission m = ((AIUnit)this.getAIMain().getAIObject((FreeColGameObject)((Object)t.getTransportLocatable().getLocation()))).getMission();
            if (m instanceof TransportMission) {
                ((TransportMission)m).addToTransportList(t);
            }
            ti.remove();
        }
        while (transportables.size() > 0) {
            int i;
            t = (Transportable)transportables.get(0);
            TransportMission bestTransport = null;
            int bestTransportSpace = 0;
            int bestTransportTurns = Integer.MAX_VALUE;
            for (i = 0; i < vacantTransports.size(); ++i) {
                int transportSpace;
                TransportMission tm = (TransportMission)vacantTransports.get(i);
                if (t.getTransportSource().getTile() == tm.getUnit().getLocation().getTile()) {
                    int transportSpace2 = tm.getAvailableSpace(t);
                    if (transportSpace2 <= 0) continue;
                    bestTransport = tm;
                    bestTransportSpace = transportSpace2;
                    bestTransportTurns = 0;
                    break;
                }
                PathNode path = tm.getPath(t);
                if (path == null || path.getTotalTurns() > bestTransportTurns || (transportSpace = tm.getAvailableSpace(t)) <= 0 || path.getTotalTurns() >= bestTransportTurns && transportSpace <= bestTransportSpace) continue;
                bestTransport = tm;
                bestTransportSpace = transportSpace;
                bestTransportTurns = path.getTotalTurns();
            }
            if (bestTransport == null) break;
            bestTransport.addToTransportList(t);
            transportables.remove(t);
            vacantTransports.remove(bestTransport);
            --bestTransportSpace;
            for (i = 0; i < transportables.size() && bestTransportSpace > 0; ++i) {
                Transportable t2 = (Transportable)transportables.get(0);
                if (t2.getTransportLocatable().getLocation() != t.getTransportLocatable().getLocation()) continue;
                bestTransport.addToTransportList(t2);
                transportables.remove(t2);
                --bestTransportSpace;
            }
        }
    }

    public int tradeProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method tradeProposition");
        Colony colony = (Colony)settlement;
        Player otherPlayer = unit.getOwner();
        if (this.getPlayer().getStance(otherPlayer) == Player.Stance.WAR) {
            return -1;
        }
        int amount = colony.getWarehouseCapacity() - colony.getGoodsCount(goods.getType());
        amount = Math.min(amount, goods.getAmount());
        Tension.Level tensionLevel = this.getPlayer().getTension(otherPlayer).getLevel();
        int percentage = (9 - tensionLevel.ordinal()) * 10;
        int netProfits = (100 - this.getPlayer().getTax()) * this.getPlayer().getMarket().getSalePrice(goods.getType(), amount) / 100;
        int price = netProfits * percentage / 100;
        return price;
    }

    public abstract boolean acceptIndianDemand(Unit var1, Colony var2, Goods var3, int var4);

    public Iterator<AIColony> getAIColonyIterator() {
        ArrayList<AIColony> ac = new ArrayList<AIColony>();
        for (Colony colony : this.getPlayer().getColonies()) {
            AIColony a = (AIColony)this.getAIMain().getAIObject(colony.getId());
            if (a != null) {
                ac.add(a);
                continue;
            }
            logger.warning("Could not find the AIColony for: " + colony);
        }
        return ac.iterator();
    }

    public Iterator<Wish> getWishIterator() {
        ArrayList<Wish> wishList = new ArrayList<Wish>();
        Iterator<AIColony> ai = this.getAIColonyIterator();
        while (ai.hasNext()) {
            AIColony ac = ai.next();
            Iterator<Wish> wishIterator = ac.getWishIterator();
            while (wishIterator.hasNext()) {
                Wish w = wishIterator.next();
                wishList.add(w);
            }
        }
        Collections.sort(wishList, new Comparator<Wish>(){

            @Override
            public int compare(Wish o1, Wish o2) {
                Integer a = o1.getValue();
                Integer b = o2.getValue();
                return b.compareTo(a);
            }
        });
        return wishList.iterator();
    }
}

