/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class GoodsWish
extends Wish {
    private static final Logger logger = Logger.getLogger(GoodsWish.class.getName());
    private GoodsType goodsType;

    public GoodsWish(AIMain aiMain, Location destination, int value, GoodsType goodsType) {
        super(aiMain, GoodsWish.getXMLElementTagName() + ":" + aiMain.getNextID());
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        this.destination = destination;
        this.value = value;
        this.goodsType = goodsType;
    }

    public GoodsWish(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public GoodsWish(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public GoodsWish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(GoodsWish.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("destination", this.destination.getId());
        if (this.transportable != null) {
            out.writeAttribute("transportable", this.transportable.getId());
        }
        out.writeAttribute("value", Integer.toString(this.value));
        out.writeAttribute("goodsType", this.goodsType.getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.destination = (Location)((Object)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "destination")));
        String transportableStr = in.getAttributeValue(null, "transportable");
        if (transportableStr != null) {
            this.transportable = (Transportable)((Object)this.getAIMain().getAIObject(transportableStr));
            if (this.transportable == null) {
                this.transportable = new AIGoods(this.getAIMain(), transportableStr);
            }
        } else {
            this.transportable = null;
        }
        this.value = Integer.parseInt(in.getAttributeValue(null, "value"));
        this.goodsType = FreeCol.getSpecification().getGoodsType(in.getAttributeValue(null, "goodsType"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "GoodsWish";
    }
}

