/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewAIPlayer
extends AIObject {
    private static final Logger logger = Logger.getLogger(AIPlayer.class.getName());
    protected static EquipmentType muskets = FreeCol.getSpecification().getEquipmentType("model.equipment.muskets");
    protected static EquipmentType horses = FreeCol.getSpecification().getEquipmentType("model.equipment.horses");
    protected static EquipmentType toolsType = FreeCol.getSpecification().getEquipmentType("model.equipment.tools");
    protected HashMap<String, Integer> sessionRegister = new HashMap();
    private ServerPlayer player;
    private ArrayList<AIUnit> aiUnits = new ArrayList();
    private Connection debuggingConnection;

    public NewAIPlayer() {
        super(null);
    }

    public NewAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.player = player;
    }

    public NewAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public NewAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public abstract void startWorking();

    protected void determineStances() {
        logger.finest("Entering method determineStances");
        for (Player p : this.getGame().getPlayers()) {
            if (p == this.player) continue;
            Player.Stance stance = this.player.getStance(p);
            Tension tension = this.player.getTension(p);
            if (stance == null || tension == null) continue;
            if (p.getREFPlayer() == this.player && p.getPlayerType() == Player.PlayerType.REBEL) {
                tension.modify(1000);
                if (stance == Player.Stance.WAR) continue;
                this.player.changeRelationWithPlayer(p, Player.Stance.WAR);
                continue;
            }
            if (stance != Player.Stance.WAR && tension.getLevel() == Tension.Level.HATEFUL) {
                this.player.changeRelationWithPlayer(p, Player.Stance.WAR);
                continue;
            }
            if (stance == Player.Stance.WAR && tension.getLevel().compareTo(Tension.Level.CONTENT) <= 0) {
                this.player.changeRelationWithPlayer(p, Player.Stance.CEASE_FIRE);
                continue;
            }
            if (stance != Player.Stance.CEASE_FIRE || tension.getLevel().compareTo(Tension.Level.HAPPY) > 0) continue;
            this.player.changeRelationWithPlayer(p, Player.Stance.PEACE);
        }
    }

    protected void abortInvalidMissions() {
        logger.finest("Entering method abortInvalidMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid()) continue;
            aiUnit.setMission(null);
        }
    }

    protected void abortInvalidAndOneTimeMissions() {
        logger.finest("Entering method abortInvalidAndOneTimeMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid() && !(aiUnit.getMission() instanceof UnitWanderHostileMission) && !(aiUnit.getMission() instanceof UnitWanderMission)) continue;
            aiUnit.setMission(null);
        }
    }

    protected void sendAndWaitSafely(Element element) {
        logger.finest("Entering method sendAndWaitSafely");
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("AI player (" + this + ") sending " + element.getTagName() + "...");
            }
            this.getConnection().sendAndWait(element);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Sent and waited, returning.");
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Couldn't send AI element " + element.getTagName() + "!", e);
        }
    }

    protected void sendUpdatedTilesToAll(ArrayList<Tile> tiles) {
        Iterator<Player> enemyPlayerIterator = this.getGame().getPlayerIterator();
        while (enemyPlayerIterator.hasNext()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
            if (this.equals(enemyPlayer) || enemyPlayer.getConnection() == null) continue;
            try {
                Element updateElement = Message.createNewRootElement("update");
                boolean send = false;
                for (Tile tile : tiles) {
                    if (!enemyPlayer.canSee(tile)) continue;
                    updateElement.appendChild(tile.toXMLElement(enemyPlayer, updateElement.getOwnerDocument()));
                    send = true;
                }
                if (!send) continue;
                enemyPlayer.getConnection().send(updateElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    protected void doMissions() {
        logger.finest("Entering method doMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (!aiUnit.hasMission() || !aiUnit.getMission().isValid() || aiUnit.getUnit().isOnCarrier()) continue;
            try {
                aiUnit.doMission(this.getConnection());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
            }
        }
    }

    public Unit getBestTreasureTrain(Tile tile) {
        Unit bestTreasureTrain = null;
        for (Unit unit : tile.getUnitList()) {
            if (!unit.canCarryTreasure() || bestTreasureTrain != null && bestTreasureTrain.getTreasureAmount() >= unit.getTreasureAmount()) continue;
            bestTreasureTrain = unit;
        }
        return bestTreasureTrain;
    }

    int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        logger.finest("Entering method getUnitSeekAndDestroyMissionValue");
        Unit defender = newTile.getDefendingUnit(unit);
        if (!this.isTargetValidForSeekAndDestroy(unit, defender)) {
            return Integer.MIN_VALUE;
        }
        int value = 10020;
        CombatModel combatModel = unit.getGame().getCombatModel();
        if (this.getBestTreasureTrain(newTile) != null) {
            value += Math.min(this.getBestTreasureTrain(newTile).getTreasureAmount() / 10, 50);
        }
        if (defender.getType().getOffence() > 0 && newTile.getSettlement() == null) {
            value = (int)((float)value + (200.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 50)));
        }
        value = (int)((float)value + (combatModel.getOffencePower(defender, unit) - combatModel.getDefencePower(defender, unit)));
        value -= turns * 10;
        if (!defender.isNaval()) {
            if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                value = (int)((float)value + (10.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 25)));
            }
            if (newTile.getSettlement() != null) {
                value += 300;
                Iterator<Unit> dp = newTile.getUnitIterator();
                while (dp.hasNext()) {
                    Unit u = dp.next();
                    if (!u.isDefensiveUnit()) continue;
                    if (combatModel.getDefencePower(unit, u) > combatModel.getOffencePower(unit, u)) {
                        value = (int)((float)value - 100.0f * (combatModel.getDefencePower(unit, u) - combatModel.getOffencePower(unit, u)));
                        continue;
                    }
                    value = (int)((float)value - combatModel.getDefencePower(unit, u));
                }
            }
        }
        return Math.max(0, value);
    }

    boolean isTargetValidForSeekAndDestroy(Unit attacker, Unit defender) {
        boolean notAtWar;
        Player defenderPlayer;
        if (defender == null) {
            return false;
        }
        boolean attackerInLand = true;
        if (attacker.getTile() != null) {
            attackerInLand = attacker.getTile().isLand();
        }
        boolean defenderInLand = true;
        if (defender.getTile() != null) {
            defenderInLand = defender.getTile().isLand();
        }
        if (attackerInLand != defenderInLand) {
            return false;
        }
        if (attacker.isNaval() != defender.isNaval()) {
            return false;
        }
        Player attackerPlayer = attacker.getOwner();
        if (attackerPlayer == (defenderPlayer = defender.getOwner())) {
            return false;
        }
        boolean bl = notAtWar = attackerPlayer.getStance(defenderPlayer) != Player.Stance.WAR;
        if (attackerPlayer.isEuropean() && notAtWar) {
            return false;
        }
        if (attackerPlayer.isIndian()) {
            boolean inFriendlyMood;
            boolean bl2 = inFriendlyMood = attackerPlayer.getTension(defenderPlayer).getLevel().compareTo(Tension.Level.CONTENT) >= 0;
            if (notAtWar && inFriendlyMood) {
                return false;
            }
        }
        return true;
    }

    public Iterator<AIUnit> getAIUnitIterator() {
        if (this.aiUnits.size() == 0) {
            ArrayList<AIUnit> au = new ArrayList<AIUnit>();
            Iterator<Unit> unitsIterator = this.player.getUnitIterator();
            while (unitsIterator.hasNext()) {
                Unit theUnit = unitsIterator.next();
                AIUnit a = (AIUnit)this.getAIMain().getAIObject(theUnit.getId());
                if (a != null) {
                    au.add(a);
                    continue;
                }
                logger.warning("Could not find the AIUnit for: " + theUnit + " (" + theUnit.getId() + ") - " + (this.getGame().getFreeColGameObject(theUnit.getId()) != null));
            }
            this.aiUnits = au;
        }
        return this.aiUnits.iterator();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Connection getConnection() {
        if (this.debuggingConnection != null) {
            return this.debuggingConnection;
        }
        return ((DummyConnection)this.player.getConnection()).getOtherConnection();
    }

    public void setDebuggingConnection(Connection debuggingConnection) {
        this.debuggingConnection = debuggingConnection;
    }

    @Override
    public String getId() {
        return this.player.getId();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(NewAIPlayer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.player = (ServerPlayer)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }

    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getIndex() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    public int buyProposition(Unit unit, Goods goods, int gold) {
        logger.finest("Entering method tradeProposition");
        IndianSettlement settlement = (IndianSettlement)goods.getLocation();
        String goldKey = "tradeGold#" + goods.getType().getIndex() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = settlement.getPriceToSell(goods) + this.player.getTension(unit.getOwner()).getValue();
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (this.getRandom().nextInt(3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, new Integer(gold));
            this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
            return gold;
        }
        this.sessionRegister.put(goldKey, new Integer(-1));
        return -1;
    }

    protected void clearAIUnits() {
        this.aiUnits.clear();
    }
}

