/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(StandardAIPlayer.class.getName());
    private static final int MAX_DISTANCE_TO_BRING_GIFT = 5;
    private static final int MAX_NUMBER_OF_GIFTS_BEING_DELIVERED = 1;
    private static final int MAX_DISTANCE_TO_MAKE_DEMANDS = 5;
    private static final int MAX_NUMBER_OF_DEMANDS = 1;
    private AIStrategy strategy = AIStrategy.NONE;
    private HashMap<String, Integer> sessionRegister = new HashMap();

    public StandardAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.setPlayer(player);
    }

    public StandardAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public StandardAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    @Override
    public void startWorking() {
        logger.fine("Entering AI code for: " + this.getPlayer().getNationAsString());
        this.strategy = AIStrategy.TRADE;
        this.sessionRegister.clear();
        this.aiUnits.clear();
        if (this.getPlayer().isREF()) {
            if (this.checkForREFDefeat()) {
                return;
            }
            if (!this.isWorkForREF()) {
                return;
            }
        }
        this.cheat();
        this.determineStances();
        this.rearrangeWorkersInColonies();
        this.abortInvalidAndOneTimeMissions();
        this.ensureCorrectMissions();
        this.giveNavalMissions();
        this.secureSettlements();
        this.giveNormalMissions();
        this.bringGifts();
        this.demandTribute();
        this.createAIGoodsInColonies();
        this.createTransportLists();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.ensureCorrectMissions();
        this.aiUnits.clear();
    }

    private void cheat() {
        logger.finest("Entering method cheat");
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            this.getPlayer().resetArrears(goodsType);
        }
        if (this.getAIMain().getFreeColServer().isSingleplayer() && this.getPlayer().isEuropean() && !this.getPlayer().isREF() && this.getPlayer().isAI() && this.getPlayer().getPlayerType() == Player.PlayerType.COLONIAL) {
            Europe europe = this.getPlayer().getEurope();
            List<UnitType> unitTypes = FreeCol.getSpecification().getUnitTypeList();
            if (this.getRandom().nextInt(10) == 1) {
                int price = 0;
                UnitType unitToTrain = null;
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasPrice()) continue;
                    int unitPrice = europe.getUnitPrice(unitType);
                    if (unitToTrain != null && unitPrice >= price) continue;
                    unitToTrain = unitType;
                    price = unitPrice;
                }
                Unit unit = null;
                if (unitToTrain != null) {
                    this.getPlayer().modifyGold(price);
                    AIUnit aiUnit = this.trainAIUnitInEurope(unitToTrain);
                    if (aiUnit != null) {
                        unit = aiUnit.getUnit();
                    }
                }
                if (unit != null && unit.isColonist()) {
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(Goods.MUSKETS, 50));
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(Goods.HORSES, 50));
                    Element clearSpecialityElement = Message.createNewRootElement("clearSpeciality");
                    clearSpecialityElement.setAttribute("unit", unit.getId());
                    this.sendAndWaitSafely(clearSpecialityElement);
                    Element equipMusketsElement = Message.createNewRootElement("equipUnit");
                    equipMusketsElement.setAttribute("unit", unit.getId());
                    equipMusketsElement.setAttribute("type", "model.equipment.muskets");
                    equipMusketsElement.setAttribute("amount", Integer.toString(50));
                    this.sendAndWaitSafely(equipMusketsElement);
                    Element equipHorsesElement = Message.createNewRootElement("equipUnit");
                    equipHorsesElement.setAttribute("unit", unit.getId());
                    equipHorsesElement.setAttribute("type", "model.equipment.horses");
                    equipHorsesElement.setAttribute("amount", Integer.toString(50));
                    this.sendAndWaitSafely(equipHorsesElement);
                }
            }
            if (this.getRandom().nextInt(40) == 21) {
                int total = 0;
                ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.hasPrice()) continue;
                    navalUnits.add(unitType);
                    total += europe.getUnitPrice(unitType);
                }
                UnitType unitToPurchase = null;
                int random = this.getRandom().nextInt(total);
                total = 0;
                for (UnitType unitType : navalUnits) {
                    if (random >= (total += unitType.getPrice())) continue;
                    unitToPurchase = unitType;
                    break;
                }
                this.getPlayer().modifyGold(europe.getUnitPrice(unitToPurchase));
                this.trainAIUnitInEurope(unitToPurchase);
            }
        }
    }

    private void ensureCorrectMissions() {
        logger.finest("Entering method ensureCorrectMissions");
        if (this.getPlayer().isIndian()) {
            return;
        }
        Iterator<AIUnit> it = this.getAIUnitIterator();
        while (it.hasNext()) {
            AIUnit au = it.next();
            if (au.hasMission() || !(au.getUnit().getLocation() instanceof ColonyTile) && !(au.getUnit().getLocation() instanceof Building)) continue;
            AIColony ac = (AIColony)this.getAIMain().getAIObject(au.getUnit().getColony());
            au.setMission(new WorkInsideColonyMission(this.getAIMain(), au, ac));
        }
    }

    private boolean isWorkForREF() {
        logger.finest("Entering method isWorkForREF");
        Iterator<Unit> it = this.getPlayer().getUnitIterator();
        while (it.hasNext()) {
            if (it.next().getTile() == null) continue;
            return true;
        }
        Iterator<Player> it2 = this.getGame().getPlayerIterator();
        while (it2.hasNext()) {
            Player p = it2.next();
            if (p.getREFPlayer() != this.getPlayer() || p.getPlayerType() != Player.PlayerType.REBEL) continue;
            return true;
        }
        return false;
    }

    private void determineStances() {
        logger.finest("Entering method determineStances");
        Player player = this.getPlayer();
        for (Player p : this.getGame().getPlayers()) {
            if (p == player) continue;
            Player.Stance stance = player.getStance(p);
            Tension tension = player.getTension(p);
            if (stance == null || tension == null) continue;
            if (p.getREFPlayer() == player && p.getPlayerType() == Player.PlayerType.REBEL) {
                tension.modify(1000);
                if (stance == Player.Stance.WAR) continue;
                player.changeRelationWithPlayer(p, Player.Stance.WAR);
                continue;
            }
            if (stance != Player.Stance.WAR && tension.getLevel() == Tension.Level.HATEFUL) {
                player.changeRelationWithPlayer(p, Player.Stance.WAR);
                continue;
            }
            if (stance == Player.Stance.WAR && tension.getLevel().compareTo(Tension.Level.CONTENT) <= 0) {
                player.changeRelationWithPlayer(p, Player.Stance.CEASE_FIRE);
                continue;
            }
            if (stance != Player.Stance.CEASE_FIRE || tension.getLevel().compareTo(Tension.Level.HAPPY) > 0) continue;
            player.changeRelationWithPlayer(p, Player.Stance.PEACE);
        }
    }

    private void abortInvalidMissions() {
        logger.finest("Entering method abortInvalidMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid()) continue;
            aiUnit.setMission(null);
        }
    }

    private void abortInvalidAndOneTimeMissions() {
        logger.finest("Entering method abortInvalidAndOneTimeMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.getMission() == null || aiUnit.getMission().isValid() && !(aiUnit.getMission() instanceof UnitWanderHostileMission) && !(aiUnit.getMission() instanceof UnitWanderMission) && !(aiUnit.getMission() instanceof IdleAtColonyMission)) continue;
            aiUnit.setMission(null);
        }
    }

    private void giveNavalMissions() {
        logger.finest("Entering method giveNavalMissions");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            Unit unit = aiUnit.getUnit();
            if (aiUnit.hasMission() || !unit.isNaval()) continue;
            if (PrivateerMission.isValid(aiUnit)) {
                aiUnit.setMission(new PrivateerMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new TransportMission(this.getAIMain(), aiUnit));
        }
    }

    private void rearrangeWorkersInColonies() {
        logger.finest("Entering method rearrangeWorkersInColonies");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            ArrayList<Tile> oldWorkTiles = new ArrayList<Tile>();
            for (ColonyTile colonyTile : c.getColony().getColonyTiles()) {
                if (colonyTile.getUnit() == null) continue;
                oldWorkTiles.add(colonyTile.getWorkTile());
            }
            c.rearrangeWorkers(this.getConnection());
            ArrayList<Tile> tilesToUpdate = new ArrayList<Tile>();
            for (ColonyTile colonyTile : c.getColony().getColonyTiles()) {
                boolean wasOccupied;
                boolean isOccupied = colonyTile.getUnit() != null;
                if (isOccupied == (wasOccupied = oldWorkTiles.remove(colonyTile.getWorkTile()))) continue;
                tilesToUpdate.add(colonyTile.getWorkTile());
            }
            this.sendUpdatedTilesToAll(tilesToUpdate);
        }
    }

    private void secureSettlements() {
        logger.finest("Entering method secureSettlements");
        if (!this.getPlayer().isEuropean()) {
            for (IndianSettlement is : this.getPlayer().getIndianSettlements()) {
                this.secureIndianSettlement(is);
                is.equipBraves();
            }
        }
    }

    void secureIndianSettlement(IndianSettlement is) {
        AIUnit newDefenderAI;
        if (!is.getOwner().isAtWar()) {
            return;
        }
        Map map = this.getPlayer().getGame().getMap();
        int defenders = is.getTile().getUnitCount();
        int threat = 0;
        int worstThreat = 0;
        Location bestTarget = null;
        Map.CircleIterator positionIterator = map.getCircleIterator(is.getTile().getPosition(), true, 2);
        while (positionIterator.hasNext()) {
            Tile t = map.getTile((Map.Position)positionIterator.next());
            if (!t.isLand() || t.getUnitCount() == 0) continue;
            Player enemy = t.getFirstUnit().getOwner();
            if (enemy == this.getPlayer()) {
                ++defenders;
                continue;
            }
            Tension tension = this.getPlayer().getTension(enemy);
            if (tension == null) {
                logger.warning(this.getPlayer().getNationAsString() + " tension towards " + enemy.getNationAsString() + " is NULL");
                continue;
            }
            int value = tension.getValue();
            int threatModifier = 0;
            int unitThreat = 0;
            if (value >= 300) {
                threatModifier = 2;
                unitThreat = t.getUnitCount() * 2;
            } else if (value >= 100) {
                threatModifier = 1;
                unitThreat = t.getUnitCount();
            }
            threat += threatModifier;
            if (unitThreat <= worstThreat) continue;
            bestTarget = t.getSettlement() != null ? t.getSettlement() : t.getFirstUnit();
            worstThreat = unitThreat;
        }
        if (threat > defenders && bestTarget != null && (newDefenderAI = this.getBraveForSeekAndDestroy(is)) != null) {
            boolean validUnitTarget;
            Tile targetTile = bestTarget.getTile();
            boolean targetIsSettlement = targetTile.getSettlement() != null;
            boolean bl = validUnitTarget = !targetIsSettlement && this.isTargetValidForSeekAndDestroy(newDefenderAI.getUnit(), targetTile.getFirstUnit());
            if (targetIsSettlement || validUnitTarget) {
                newDefenderAI.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), newDefenderAI, bestTarget));
            }
        }
    }

    private AIUnit getBraveForSeekAndDestroy(IndianSettlement indianSettlement) {
        Iterator<Unit> it = indianSettlement.getOwnedUnitsIterator();
        while (it.hasNext()) {
            AIUnit chosenOne = (AIUnit)this.getAIMain().getAIObject(it.next());
            if (!(chosenOne.getUnit().getLocation() instanceof Tile) || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission)) continue;
            return chosenOne;
        }
        return null;
    }

    private void secureColony(Colony colony) {
        Iterator<Unit> uit;
        EquipmentType muskets = FreeCol.getSpecification().getEquipmentType("model.equipment.muskets");
        EquipmentType horses = FreeCol.getSpecification().getEquipmentType("model.equipment.horses");
        Map map = this.getPlayer().getGame().getMap();
        int olddefenders = 0;
        int defenders = 0;
        int threat = 0;
        int worstThreat = 0;
        FreeColGameObject bestTarget = null;
        Iterator<Unit> ui = colony.getTile().getUnitIterator();
        while (ui.hasNext()) {
            if (!ui.next().isDefensiveUnit()) continue;
            ++defenders;
        }
        Map.CircleIterator positionIterator = map.getCircleIterator(colony.getTile().getPosition(), true, 5);
        while (positionIterator.hasNext()) {
            Iterator<Unit> uit2;
            Tile t = map.getTile((Map.Position)positionIterator.next());
            if (t.getFirstUnit() == null) continue;
            if (t.getFirstUnit().getOwner() == this.getPlayer()) {
                uit = t.getUnitIterator();
                while (uit.hasNext()) {
                    if (!uit.next().isOffensiveUnit()) continue;
                    ++defenders;
                }
                continue;
            }
            int thisThreat = 0;
            if (this.getPlayer().getTension(t.getFirstUnit().getOwner()).getValue() >= 300) {
                uit2 = t.getUnitIterator();
                while (uit2.hasNext()) {
                    if (!uit2.next().isOffensiveUnit()) continue;
                    thisThreat += 2;
                }
            } else if (this.getPlayer().getTension(t.getFirstUnit().getOwner()).getValue() >= 100) {
                uit2 = t.getUnitIterator();
                while (uit2.hasNext()) {
                    if (!uit2.next().isOffensiveUnit()) continue;
                    ++thisThreat;
                }
            }
            threat += thisThreat;
            if (thisThreat <= worstThreat) continue;
            bestTarget = t.getSettlement() != null ? t.getSettlement() : t.getFirstUnit();
            worstThreat = thisThreat;
        }
        olddefenders = defenders;
        if (colony.hasStockade()) {
            defenders += defenders * colony.getStockade().getLevel() / 2;
        }
        if (threat > defenders) {
            GoodsWish gw;
            Wish w;
            Iterator<Wish> wishes;
            ArrayList<Unit> recruits = new ArrayList<Unit>();
            ArrayList<Unit> others = new ArrayList<Unit>();
            int inColonyCount = 0;
            ui = colony.getUnitIterator();
            while (ui.hasNext()) {
                Unit u = ui.next();
                if (u.isOffensiveUnit()) continue;
                if (u.getLocation() != colony.getTile()) {
                    ++inColonyCount;
                }
                if (u.hasAbility("model.ability.expertSoldier")) {
                    recruits.add(u);
                    continue;
                }
                if (!u.hasAbility("model.ability.canBeEquipped")) continue;
                others.add(u);
            }
            Collections.sort(others, new Comparator<Unit>(){

                @Override
                public int compare(Unit unit1, Unit unit2) {
                    if (unit1.getSkillLevel() < unit2.getSkillLevel()) {
                        return -1;
                    }
                    if (unit1.getSkillLevel() > unit2.getSkillLevel()) {
                        return 1;
                    }
                    return 0;
                }
            });
            recruits.addAll(others);
            int recruitCount = threat - defenders;
            if (recruitCount > recruits.size() - 1) {
                recruitCount = recruits.size() - 1;
            }
            if (recruitCount > inColonyCount - 1) {
                recruitCount = inColonyCount - 1;
            }
            boolean needMuskets = false;
            boolean needHorses = false;
            ui = recruits.iterator();
            while (ui.hasNext() && recruitCount > 0) {
                Unit u = ui.next();
                if (!u.isArmed() && u.canBeEquippedWith(muskets)) {
                    --recruitCount;
                    Element equipUnitElement = Message.createNewRootElement("equipUnit");
                    equipUnitElement.setAttribute("unit", u.getId());
                    equipUnitElement.setAttribute("type", muskets.getId());
                    equipUnitElement.setAttribute("amount", "1");
                    u.equipWith(muskets);
                    this.sendAndWaitSafely(equipUnitElement);
                    Element putOutsideColonyElement = Message.createNewRootElement("putOutsideColony");
                    putOutsideColonyElement.setAttribute("unit", u.getId());
                    u.putOutsideColony();
                    this.sendAndWaitSafely(putOutsideColonyElement);
                    if (u.checkSetState(Unit.UnitState.FORTIFYING)) {
                        Element changeStateElement = Message.createNewRootElement("changeState");
                        changeStateElement.setAttribute("unit", u.getId());
                        changeStateElement.setAttribute("state", Unit.UnitState.FORTIFYING.toString());
                        this.sendAndWaitSafely(changeStateElement);
                    }
                    ++olddefenders;
                    if (!u.isMounted() && u.canBeEquippedWith(horses)) {
                        equipUnitElement = Message.createNewRootElement("equipUnit");
                        equipUnitElement.setAttribute("unit", u.getId());
                        equipUnitElement.setAttribute("type", horses.getId());
                        equipUnitElement.setAttribute("amount", "1");
                        this.sendAndWaitSafely(equipUnitElement);
                        continue;
                    }
                    needHorses = true;
                    continue;
                }
                needMuskets = true;
                break;
            }
            AIColony ac = null;
            if (needMuskets || needHorses) {
                Iterator<AIColony> aIterator = this.getAIColonyIterator();
                while (aIterator.hasNext()) {
                    AIColony temp = aIterator.next();
                    if (temp == null || temp.getColony() != colony) continue;
                    ac = temp;
                    break;
                }
            }
            if (needMuskets && ac != null) {
                wishes = ac.getWishIterator();
                boolean made = false;
                while (wishes.hasNext()) {
                    w = wishes.next();
                    if (!(w instanceof GoodsWish) || (gw = (GoodsWish)w).getGoodsType() != Goods.MUSKETS) continue;
                    made = true;
                }
                if (!made) {
                    ac.addGoodsWish(new GoodsWish(this.getAIMain(), colony, (threat - olddefenders) * 50, Goods.MUSKETS));
                }
            }
            if (needHorses && ac != null) {
                wishes = ac.getWishIterator();
                boolean made = false;
                while (wishes.hasNext()) {
                    w = wishes.next();
                    if (!(w instanceof GoodsWish) || (gw = (GoodsWish)w).getGoodsType() != Goods.HORSES) continue;
                    made = true;
                }
                if (!made) {
                    ac.addGoodsWish(new GoodsWish(this.getAIMain(), colony, (threat - defenders) * 50, Goods.HORSES));
                }
            }
            defenders = olddefenders;
            if (colony.hasStockade()) {
                defenders += defenders * colony.getStockade().getLevel() / 2;
            }
        }
        if (defenders > threat * 2) {
            Unit u = null;
            uit = colony.getUnitIterator();
            while (uit.hasNext()) {
                Unit candidate = uit.next();
                if (!candidate.isOffensiveUnit() || candidate.getState() != Unit.UnitState.FORTIFIED) continue;
                u = candidate;
                break;
            }
            if (u != null) {
                u.setState(Unit.UnitState.ACTIVE);
                u.setLocation(colony.getTile());
                AIUnit newDefenderAI = (AIUnit)this.getAIMain().getAIObject(u);
                if (bestTarget != null) {
                    newDefenderAI.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), newDefenderAI, (Location)((Object)bestTarget)));
                } else {
                    newDefenderAI.setMission(new UnitWanderHostileMission(this.getAIMain(), newDefenderAI));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        int numberOfUnits = FreeCol.getSpecification().numberOfUnitTypes();
        Vector workerWishes = new Vector(numberOfUnits);
        for (int i = 0; i < numberOfUnits; ++i) {
            workerWishes.add(new ArrayList());
        }
        if (this.getPlayer().isEuropean()) {
            Iterator<AIColony> aIterator = this.getAIColonyIterator();
            while (aIterator.hasNext()) {
                Iterator<Wish> wIterator = aIterator.next().getWishIterator();
                while (wIterator.hasNext()) {
                    Wish w = wIterator.next();
                    if (!(w instanceof WorkerWish) || w.getTransportable() != null) continue;
                    ((ArrayList)workerWishes.get(((WorkerWish)w).getUnitType().getIndex())).add(w);
                }
            }
        }
        boolean fewColonies = this.hasFewColonies();
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            if (unit.canCarryTreasure()) {
                aiUnit.setMission(new CashInTreasureTrainMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (unit.hasAbility("model.ability.scoutIndianSettlement") && ScoutingMission.isValid(aiUnit)) {
                aiUnit.setMission(new ScoutingMission(this.getAIMain(), aiUnit));
                continue;
            }
            if ((unit.isOffensiveUnit() || unit.isDefensiveUnit()) && (!unit.isColonist() || unit.hasAbility("model.ability.expertSoldier") || this.getGame().getTurn().getNumber() > 5)) {
                this.giveMilitaryMission(aiUnit);
                continue;
            }
            if (unit.hasAbility("model.ability.improveTerrain") && PioneeringMission.isValid(aiUnit)) {
                aiUnit.setMission(new PioneeringMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (unit.isColonist()) {
                void var9_10;
                void var9_14;
                HashMap<Location, Integer> distances = new HashMap<Location, Integer>(121);
                for (ArrayList arrayList : workerWishes) {
                    for (Wish w : arrayList) {
                        if (distances.containsKey(w.getDestination())) continue;
                        distances.put(w.getDestination(), unit.getTurnsToReach(w.getDestination()));
                    }
                }
                ArrayList wishList = (ArrayList)workerWishes.get(unit.getType().getIndex());
                Object var9_13 = null;
                int bestTurns = Integer.MAX_VALUE;
                for (int i = 0; i < wishList.size(); ++i) {
                    WorkerWish ww = (WorkerWish)wishList.get(i);
                    if (ww.getTransportable() != null) {
                        wishList.remove(i);
                        --i;
                        continue;
                    }
                    int turns = (Integer)distances.get(ww.getDestination());
                    if (turns == Integer.MAX_VALUE) {
                        turns = ww.getDestination().getTile() == null ? 5 : 10;
                    } else if (turns > 5) {
                        turns = 5;
                    }
                    if (var9_14 != null && ww.getValue() - turns * 2 <= var9_14.getValue() - bestTurns * 2) continue;
                    WorkerWish workerWish = ww;
                    bestTurns = turns;
                }
                if (var9_14 != null) {
                    var9_14.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, (Wish)var9_14));
                    continue;
                }
                Tile colonyTile = null;
                if (this.getPlayer().canBuildColonies() && (colonyTile = BuildColonyMission.findColonyLocation(aiUnit.getUnit())) != null) {
                    bestTurns = unit.getTurnsToReach(colonyTile);
                }
                if (!fewColonies || colonyTile == null || bestTurns > 10) {
                    for (int i = 0; i < workerWishes.size(); ++i) {
                        wishList = (ArrayList)workerWishes.get(i);
                        for (int j = 0; j < wishList.size(); ++j) {
                            WorkerWish ww = (WorkerWish)wishList.get(j);
                            if (ww.getTransportable() != null) {
                                wishList.remove(j);
                                --j;
                                continue;
                            }
                            int turns = (Integer)distances.get(ww.getDestination());
                            if (turns == Integer.MAX_VALUE) {
                                turns = ww.getDestination().getTile() == null ? 5 : 10;
                            } else if (turns > 5) {
                                turns = 5;
                            }
                            if (var9_10 != null && ww.getValue() - turns * 2 <= var9_10.getValue() - bestTurns * 2) continue;
                            WorkerWish workerWish = ww;
                            bestTurns = turns;
                        }
                    }
                }
                if (var9_10 != null) {
                    var9_10.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, (Wish)var9_10));
                    continue;
                }
                if (colonyTile != null) {
                    BuildColonyMission mission = new BuildColonyMission(this.getAIMain(), aiUnit, colonyTile, this.getPlayer().getColonyValue(colonyTile));
                    aiUnit.setMission(mission);
                    boolean isUnitOnCarrier = aiUnit.getUnit().isOnCarrier();
                    if (!isUnitOnCarrier) continue;
                    AIUnit carrier = (AIUnit)this.getAIMain().getAIObject((FreeColGameObject)((Object)aiUnit.getUnit().getLocation()));
                    Mission carrierMission = carrier.getMission();
                    boolean isCarrierMissionToTransport = carrierMission instanceof TransportMission;
                    if (!isCarrierMissionToTransport) {
                        throw new IllegalStateException("Carrier carrying unit not on a transport mission");
                    }
                    ((TransportMission)carrierMission).addToTransportList(aiUnit);
                    continue;
                }
            }
            if (aiUnit.hasMission()) continue;
            if (aiUnit.getUnit().isOffensiveUnit()) {
                aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new IdleAtColonyMission(this.getAIMain(), aiUnit));
        }
    }

    private void bringGifts() {
        logger.finest("Entering method bringGifts");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (this.getRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(((AIUnit)this.getAIMain().getAIObject(ownedUnits.next())).getMission() instanceof IndianBringGiftMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            Map.CircleIterator it = this.getGame().getMap().getCircleIterator(indianSettlement.getTile().getPosition(), true, 5);
            while (it.hasNext()) {
                Tile t = this.getGame().getMap().getTile((Map.Position)it.next());
                if (t.getColony() == null || !IndianBringGiftMission.isValidMission(this.getPlayer(), t.getColony().getOwner())) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            Colony target = (Colony)nearbyColonies.get(this.getRandom().nextInt(nearbyColonies.size()));
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = (AIUnit)this.getAIMain().getAIObject(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                chosenOne.setMission(new IndianBringGiftMission(this.getAIMain(), chosenOne, target));
                continue block0;
            }
        }
    }

    private void demandTribute() {
        logger.finest("Entering method demandTribute");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (this.getRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(((AIUnit)this.getAIMain().getAIObject(ownedUnits.next())).getMission() instanceof IndianDemandMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            Map.CircleIterator it = this.getGame().getMap().getCircleIterator(indianSettlement.getTile().getPosition(), true, 5);
            while (it.hasNext()) {
                Tile t = this.getGame().getMap().getTile((Map.Position)it.next());
                if (t.getColony() == null) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            int targetTension = Integer.MIN_VALUE;
            Settlement target = null;
            for (int i = 0; i < nearbyColonies.size(); ++i) {
                Colony t = (Colony)nearbyColonies.get(i);
                Player to = t.getOwner();
                if (this.getPlayer().getTension(to) == null || indianSettlement.getAlarm(to) == null) continue;
                int tension = 1 + this.getPlayer().getTension(to).getValue() + indianSettlement.getAlarm(to).getValue();
                tension = this.getRandom().nextInt(tension);
                if (tension <= targetTension) continue;
                targetTension = tension;
                target = t;
            }
            if (target == null) continue;
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = (AIUnit)this.getAIMain().getAIObject(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                Player tp = target.getOwner();
                int tension = 1 + this.getPlayer().getTension(tp).getValue() + indianSettlement.getAlarm(tp).getValue();
                if (this.getRandom().nextInt(tension) <= Tension.Level.HAPPY.getLimit()) continue;
                chosenOne.setMission(new IndianDemandMission(this.getAIMain(), chosenOne, (Colony)target));
                continue block0;
            }
        }
    }

    private void createAIGoodsInColonies() {
        logger.finest("Entering method createAIGoodsInColonies");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            c.createAIGoods();
        }
    }

    private void doMissions() {
        logger.finest("Entering method doMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (!aiUnit.hasMission() || !aiUnit.getMission().isValid() || aiUnit.getUnit().isOnCarrier()) continue;
            try {
                aiUnit.doMission(this.getConnection());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
            }
        }
    }

    int getDefendColonyMissionValue(Unit u, Colony colony, int turns) {
        logger.finest("Entering method getDefendColonyMissionValue");
        if (colony == null) {
            return Integer.MIN_VALUE;
        }
        int value = 10025 - turns;
        int numberOfDefendingUnits = 0;
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext()) {
            Mission m = aui.next().getMission();
            if (m == null || !(m instanceof DefendSettlementMission) || ((DefendSettlementMission)m).getSettlement() != colony) continue;
            value -= 6;
            ++numberOfDefendingUnits;
        }
        if (u.getOwner().isREF()) {
            value -= 19;
            if (numberOfDefendingUnits > 0) {
                return 0;
            }
        }
        if (colony.getStockade() != null && numberOfDefendingUnits > colony.getStockade().getLevel() + 1) {
            return Math.max(0, value - 9000);
        }
        return value;
    }

    int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        logger.finest("Entering method getUnitSeekAndDestroyMissionValue");
        Unit defender = newTile.getDefendingUnit(unit);
        if (!this.isTargetValidForSeekAndDestroy(unit, defender)) {
            return Integer.MIN_VALUE;
        }
        int value = 10020;
        CombatModel combatModel = unit.getGame().getCombatModel();
        if (this.getBestTreasureTrain(newTile) != null) {
            value += Math.min(this.getBestTreasureTrain(newTile).getTreasureAmount() / 10, 50);
        }
        if (defender.getType().getOffence() > 0 && newTile.getSettlement() == null) {
            value = (int)((float)value + (200.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 50)));
        }
        value = (int)((float)value + (combatModel.getOffencePower(defender, unit) - combatModel.getDefencePower(defender, unit)));
        value -= turns * 10;
        if (!defender.isNaval()) {
            if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                value = (int)((float)value + (10.0f - combatModel.getDefencePower(unit, defender) * 2.0f - (float)(turns * 25)));
            }
            if (newTile.getSettlement() != null) {
                value += 300;
                Iterator<Unit> dp = newTile.getUnitIterator();
                while (dp.hasNext()) {
                    Unit u = dp.next();
                    if (!u.isDefensiveUnit()) continue;
                    if (combatModel.getDefencePower(unit, u) > combatModel.getOffencePower(unit, u)) {
                        value = (int)((float)value - 100.0f * (combatModel.getDefencePower(unit, u) - combatModel.getOffencePower(unit, u)));
                        continue;
                    }
                    value = (int)((float)value - combatModel.getDefencePower(unit, u));
                }
            }
        }
        return Math.max(0, value);
    }

    boolean isTargetValidForSeekAndDestroy(Unit attacker, Unit defender) {
        boolean atWar;
        Player defenderPlayer;
        if (defender == null) {
            return false;
        }
        if (attacker.isNaval() != defender.isNaval()) {
            return false;
        }
        if (attacker.isNaval() && (attacker.getTile() == null || attacker.getTile().isLand() || defender.getTile() == null || defender.getTile().isLand())) {
            return false;
        }
        Player attackerPlayer = attacker.getOwner();
        if (attackerPlayer == (defenderPlayer = defender.getOwner())) {
            return false;
        }
        boolean bl = atWar = attackerPlayer.getStance(defenderPlayer) == Player.Stance.WAR;
        return !(attackerPlayer.isEuropean() ? !atWar : attackerPlayer.isIndian() && !atWar && attackerPlayer.getTension(defenderPlayer).getLevel().compareTo(Tension.Level.CONTENT) <= 0);
    }

    void giveMilitaryMission(AIUnit aiUnit) {
        Tile targetTile;
        int value;
        GoalDecider targetDecider;
        PathNode newTarget;
        int value2;
        PathNode ln;
        int value3;
        logger.finest("Entering method giveMilitaryMission");
        if (this.getPlayer().isIndian()) {
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
            return;
        }
        final Unit unit = aiUnit.getUnit();
        Unit carrier = unit.isOnCarrier() ? (Unit)unit.getLocation() : null;
        Map map = unit.getGame().getMap();
        Ownable bestTarget = null;
        int bestValue = Integer.MIN_VALUE;
        Tile startTile = unit.getTile();
        if (startTile == null) {
            startTile = unit.isOnCarrier() ? (Tile)((Unit)unit.getLocation()).getEntryLocation() : (Tile)unit.getOwner().getEntryLocation();
        }
        if (unit.getColony() != null) {
            bestTarget = unit.getColony();
            bestValue = this.getDefendColonyMissionValue(unit, (Colony)bestTarget, 0);
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode best = null;
            private int bestValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode pathNode) {
                Tile t = pathNode.getTile();
                if (t.getColony() != null && t.getColony().getOwner() == u.getOwner()) {
                    int value = StandardAIPlayer.this.getDefendColonyMissionValue(unit, t.getColony(), pathNode.getTurns());
                    if (value > 0 && value > this.bestValue) {
                        this.bestValue = value;
                        this.best = pathNode;
                    }
                    return true;
                }
                return false;
            }
        };
        int MAXIMUM_DISTANCE_TO_SETTLEMENT = 10;
        PathNode bestPath = map.search(unit, startTile, gd, map.getDefaultCostDecider(), 10, carrier);
        if (bestPath != null && (value3 = this.getDefendColonyMissionValue(unit, (ln = bestPath.getLastNode()).getTile().getColony(), ln.getTurns())) > bestValue) {
            bestTarget = ln.getTile().getColony();
            bestValue = value3;
        }
        Location bestExistingTarget = null;
        int smallestDifference = Integer.MAX_VALUE;
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext() && smallestDifference > 0) {
            int difference;
            AIUnit coAIUnit = aui.next();
            Unit coUnit = coAIUnit.getUnit();
            if (coUnit.getTile() == null || !(coAIUnit.getMission() instanceof UnitSeekAndDestroyMission)) continue;
            Location target = ((UnitSeekAndDestroyMission)coAIUnit.getMission()).getTarget();
            int ourDistance = unit.getTurnsToReach(startTile, target.getTile());
            int coUnitDistance = coUnit.getTurnsToReach(target.getTile());
            if (ourDistance == Integer.MAX_VALUE || (difference = Math.abs(ourDistance - coUnitDistance)) >= smallestDifference) continue;
            smallestDifference = difference;
            bestExistingTarget = target;
        }
        if (bestExistingTarget != null && (value2 = this.getUnitSeekAndDestroyMissionValue(unit, bestExistingTarget.getTile(), smallestDifference)) > bestValue) {
            bestValue = value2;
            bestTarget = (Ownable)((Object)bestExistingTarget);
        }
        if ((newTarget = map.search(unit, startTile, targetDecider = new GoalDecider(){
            private PathNode bestTarget = null;
            private int bestNewTargetValue = Integer.MIN_VALUE;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode pathNode) {
                int value;
                Tile newTile = pathNode.getTile();
                Unit defender = newTile.getDefendingUnit(unit);
                if (StandardAIPlayer.this.isTargetValidForSeekAndDestroy(unit, defender) && (value = StandardAIPlayer.this.getUnitSeekAndDestroyMissionValue(unit, pathNode.getTile(), pathNode.getTurns())) > this.bestNewTargetValue) {
                    this.bestTarget = pathNode;
                    this.bestNewTargetValue = value;
                    return true;
                }
                return false;
            }
        }, map.getDefaultCostDecider(), Integer.MAX_VALUE, carrier)) != null && (value = this.getUnitSeekAndDestroyMissionValue(unit, targetTile = newTarget.getLastNode().getTile(), newTarget.getTotalTurns())) > bestValue) {
            bestValue = value;
            bestTarget = targetTile.getSettlement() != null ? targetTile.getSettlement() : (this.getBestTreasureTrain(targetTile) != null ? this.getBestTreasureTrain(targetTile) : targetTile.getDefendingUnit(unit));
        }
        if (bestTarget != null && bestValue > 0) {
            if (bestTarget.getOwner() == unit.getOwner()) {
                aiUnit.setMission(new DefendSettlementMission(this.getAIMain(), aiUnit, (Settlement)bestTarget));
            } else {
                aiUnit.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), aiUnit, (Location)((Object)bestTarget)));
            }
        } else {
            aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
        }
    }

    @Override
    public Iterator<TileImprovementPlan> getTileImprovementPlanIterator() {
        ArrayList<TileImprovementPlan> tileImprovements = new ArrayList<TileImprovementPlan>();
        Iterator<AIColony> acIterator = this.getAIColonyIterator();
        while (acIterator.hasNext()) {
            AIColony ac = acIterator.next();
            Iterator<TileImprovementPlan> it = ac.getTileImprovementPlanIterator();
            while (it.hasNext()) {
                tileImprovements.add(it.next());
            }
        }
        return tileImprovements.iterator();
    }

    @Override
    public void removeTileImprovementPlan(TileImprovementPlan plan) {
        Iterator<AIColony> colonyIter = this.getAIColonyIterator();
        while (colonyIter.hasNext()) {
            AIColony colony = colonyIter.next();
            if (!colony.removeTileImprovementPlan(plan)) continue;
            return;
        }
        logger.warning("Not found given TileImprovementPlan to remove");
    }

    @Override
    public boolean hasFewColonies() {
        logger.finest("Entering method hasFewColonies");
        if (!this.getPlayer().canBuildColonies()) {
            return false;
        }
        int numberOfColonies = 0;
        int numberOfWorkers = 0;
        for (Colony colony : this.getPlayer().getColonies()) {
            ++numberOfColonies;
            numberOfWorkers += colony.getUnitCount();
        }
        logger.finest("Leaving method hasFewColonies");
        return numberOfColonies <= 2 || numberOfColonies >= 3 && numberOfWorkers / numberOfColonies > numberOfColonies - 2;
    }

    private void createTransportLists() {
        logger.finest("Entering method createTransportLists");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        ArrayList<AIObject> transportables = new ArrayList<AIObject>();
        Iterator<AIUnit> aui = this.getAIUnitIterator();
        while (aui.hasNext()) {
            AIUnit au = aui.next();
            if (au.getUnit().isNaval() || au.getTransportDestination() == null || au.getTransport() != null) continue;
            transportables.add(au);
        }
        Iterator<AIColony> aci = this.getAIColonyIterator();
        while (aci.hasNext()) {
            AIColony ac = aci.next();
            Iterator<AIGoods> iterator = ac.getAIGoodsIterator();
            while (iterator.hasNext()) {
                AIGoods ag = iterator.next();
                if (ag.getTransportDestination() == null || ag.getTransport() != null) continue;
                transportables.add(ag);
            }
        }
        if (transportables.isEmpty()) {
            return;
        }
        for (Transportable transportable : transportables) {
            transportable.increaseTransportPriority();
        }
        ArrayList<Mission> vacantTransports = new ArrayList<Mission>();
        Iterator<AIUnit> iterator = this.getAIUnitIterator();
        while (iterator.hasNext()) {
            AIUnit au = iterator.next();
            if (!au.hasMission() || !(au.getMission() instanceof TransportMission) || au.getUnit().getLocation() instanceof Europe) continue;
            vacantTransports.add(au.getMission());
        }
        if (vacantTransports.isEmpty()) {
            return;
        }
        Collections.sort(transportables, new Comparator<Transportable>(){

            @Override
            public int compare(Transportable o1, Transportable o2) {
                if (o1 == o2) {
                    return 0;
                }
                int result = o2.getTransportPriority() - o1.getTransportPriority();
                if (result == 0) {
                    result = o1.getId().compareTo(o2.getId());
                }
                return result;
            }
        });
        ArrayList iteratingList = new ArrayList(transportables);
        for (Transportable t : iteratingList) {
            Location transportableLoc = t.getTransportLocatable().getLocation();
            boolean isTransportableAlreadyOnCarrier = transportableLoc instanceof Unit;
            if (!isTransportableAlreadyOnCarrier) continue;
            AIUnit carrierAI = (AIUnit)this.getAIMain().getAIObject((Unit)transportableLoc);
            Mission m = carrierAI.getMission();
            if (m instanceof TransportMission) {
                ((TransportMission)m).addToTransportList(t);
            }
            transportables.remove(t);
        }
        while (transportables.size() > 0) {
            int i;
            Transportable t = (Transportable)transportables.get(0);
            TransportMission bestTransport = null;
            int bestTransportSpace = 0;
            int bestTransportTurns = Integer.MAX_VALUE;
            for (i = 0; i < vacantTransports.size(); ++i) {
                int transportSpace;
                TransportMission tm = (TransportMission)vacantTransports.get(i);
                if (t.getTransportSource().getTile() == tm.getUnit().getLocation().getTile()) {
                    int transportSpace2 = tm.getAvailableSpace(t);
                    if (transportSpace2 <= 0) continue;
                    bestTransport = tm;
                    bestTransportSpace = transportSpace2;
                    bestTransportTurns = 0;
                    break;
                }
                PathNode path = tm.getPath(t);
                if (path == null || path.getTotalTurns() > bestTransportTurns || (transportSpace = tm.getAvailableSpace(t)) <= 0 || path.getTotalTurns() >= bestTransportTurns && transportSpace <= bestTransportSpace) continue;
                bestTransport = tm;
                bestTransportSpace = transportSpace;
                bestTransportTurns = path.getTotalTurns();
            }
            if (bestTransport == null) break;
            bestTransport.addToTransportList(t);
            transportables.remove(t);
            vacantTransports.remove(bestTransport);
            --bestTransportSpace;
            for (i = 0; i < transportables.size() && bestTransportSpace > 0; ++i) {
                Transportable t2 = (Transportable)transportables.get(0);
                if (t2.getTransportLocatable().getLocation() != t.getTransportLocatable().getLocation()) continue;
                bestTransport.addToTransportList(t2);
                transportables.remove(t2);
                --bestTransportSpace;
            }
        }
    }

    @Override
    public Iterator<Wish> getWishIterator() {
        ArrayList<Wish> wishList = new ArrayList<Wish>();
        Iterator<AIColony> ai = this.getAIColonyIterator();
        while (ai.hasNext()) {
            AIColony ac = ai.next();
            Iterator<Wish> wishIterator = ac.getWishIterator();
            while (wishIterator.hasNext()) {
                Wish w = wishIterator.next();
                wishList.add(w);
            }
        }
        Collections.sort(wishList, new Comparator<Wish>(){

            @Override
            public int compare(Wish o1, Wish o2) {
                Integer a = o1.getValue();
                Integer b = o2.getValue();
                return b.compareTo(a);
            }
        });
        return wishList.iterator();
    }

    @Override
    public FoundingFather selectFoundingFather(List<FoundingFather> foundingFathers) {
        int age = this.getGame().getTurn().getAge();
        FoundingFather bestFather = null;
        int bestWeight = -1;
        for (FoundingFather father : foundingFathers) {
            int weight;
            if (father == null || (weight = father.getWeight(age)) <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }

    @Override
    public int tradeProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method tradeProposition");
        if (settlement instanceof IndianSettlement) {
            int price;
            String goldKey = "tradeGold#" + goods.getType().getIndex() + "#" + goods.getAmount() + "#" + unit.getId();
            String hagglingKey = "tradeHaggling#" + unit.getId();
            if (this.sessionRegister.containsKey(goldKey)) {
                price = this.sessionRegister.get(goldKey);
                if (price <= 0) {
                    return price;
                }
            } else {
                price = ((IndianSettlement)settlement).getPrice(goods) - this.getPlayer().getTension(unit.getOwner()).getValue();
                if ((price = Math.min(price, this.getPlayer().getGold() / 2)) <= 0) {
                    return 0;
                }
                this.sessionRegister.put(goldKey, new Integer(price));
            }
            if (gold < 0 || price == gold) {
                return price;
            }
            if (gold > this.getPlayer().getGold() * 3 / 4) {
                this.sessionRegister.put(goldKey, new Integer(-1));
                return -1;
            }
            if (gold > price * 11 / 10) {
                logger.warning("Cheating attempt: haggling with a request too high");
                this.sessionRegister.put(goldKey, new Integer(-1));
                return -1;
            }
            int haggling = 1;
            if (this.sessionRegister.containsKey(hagglingKey)) {
                haggling = this.sessionRegister.get(hagglingKey);
            }
            if (this.getRandom().nextInt(3 + haggling) <= 3) {
                this.sessionRegister.put(goldKey, new Integer(gold));
                this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
                return gold;
            }
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            Player otherPlayer = unit.getOwner();
            if (this.getPlayer().getStance(otherPlayer) == Player.Stance.WAR) {
                return -1;
            }
            int amount = colony.getWarehouseCapacity() - colony.getGoodsCount(goods.getType());
            amount = Math.min(amount, goods.getAmount());
            Tension.Level tensionLevel = this.getPlayer().getTension(otherPlayer).getLevel();
            int percentage = (9 - tensionLevel.ordinal()) * 10;
            int netProfits = (100 - this.getPlayer().getTax()) * this.getPlayer().getMarket().getSalePrice(goods.getType(), amount) / 100;
            int price = netProfits * percentage / 100;
            return price;
        }
        throw new IllegalArgumentException("Unknown type of settlement.");
    }

    @Override
    public boolean acceptTax(int tax) {
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        if (toBeDestroyed == null) {
            return false;
        }
        GoodsType goodsType = toBeDestroyed.getType();
        if (goodsType.isFoodType() || goodsType.isBreedable()) {
            return false;
        }
        if (goodsType.isMilitaryGoods() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            return this.getGame().getTurn().getAge() != 3;
        }
        int averageIncome = 0;
        int numberOfGoods = 0;
        List<GoodsType> goodsTypes = FreeCol.getSpecification().getGoodsTypeList();
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable()) continue;
            averageIncome += this.getPlayer().getIncomeAfterTaxes(type);
            ++numberOfGoods;
        }
        return this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType()) <= (averageIncome /= numberOfGoods);
    }

    @Override
    public boolean acceptIndianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return this.strategy != AIStrategy.CONQUEST;
    }

    @Override
    public boolean acceptMercenaryOffer() {
        return this.strategy == AIStrategy.CONQUEST || this.getPlayer().isAtWar();
    }

    @Override
    public boolean acceptDiplomaticTrade(DiplomaticTrade agreement) {
        Player.Stance stance = null;
        int value = 0;
        Iterator<TradeItem> itemIterator = agreement.iterator();
        while (itemIterator.hasNext()) {
            TradeItem item = itemIterator.next();
            if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                if (item.getSource() == this.getPlayer()) {
                    value -= gold;
                    continue;
                }
                value += gold;
                continue;
            }
            if (item instanceof StanceTradeItem) {
                stance = ((StanceTradeItem)item).getStance();
                continue;
            }
            if (item instanceof ColonyTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    value = Integer.MIN_VALUE;
                    break;
                }
                value += 1000;
                continue;
            }
            if (item instanceof UnitTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    value = Integer.MIN_VALUE;
                    break;
                }
                value += 100;
                continue;
            }
            if (!(item instanceof GoodsTradeItem)) continue;
            Goods goods = ((GoodsTradeItem)item).getGoods();
            if (item.getSource() == this.getPlayer()) {
                value -= this.getPlayer().getMarket().getBidPrice(goods.getType(), goods.getAmount());
                continue;
            }
            value += this.getPlayer().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        }
        boolean accept = false;
        if (stance == Player.Stance.PEACE) {
            if (agreement.getSender().hasAbility("model.ability.alwaysOfferedPeace") && value >= 0) {
                accept = true;
            } else if (value >= 1000) {
                accept = true;
            }
        } else if (this.getPlayer().getStance(agreement.getSender()).compareTo(Player.Stance.PEACE) >= 0 && value > 100) {
            accept = true;
        }
        logger.info("Trade value is " + value + ", accept is " + accept);
        return accept;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(StandardAIPlayer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setPlayer((ServerPlayer)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getIndex() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    @Override
    public int buyProposition(Unit unit, Goods goods, int gold) {
        logger.finest("Entering method tradeProposition");
        IndianSettlement settlement = (IndianSettlement)goods.getLocation();
        String goldKey = "tradeGold#" + goods.getType().getIndex() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = settlement.getPriceToSell(goods) + this.getPlayer().getTension(unit.getOwner()).getValue();
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (this.getRandom().nextInt(3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, new Integer(gold));
            this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
            return gold;
        }
        this.sessionRegister.put(goldKey, new Integer(-1));
        return -1;
    }

    private Unit getBestTreasureTrain(Tile tile) {
        Unit bestTreasureTrain = null;
        for (Unit unit : tile.getUnitList()) {
            if (!unit.canCarryTreasure() || bestTreasureTrain != null && bestTreasureTrain.getTreasureAmount() >= unit.getTreasureAmount()) continue;
            bestTreasureTrain = unit;
        }
        return bestTreasureTrain;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AIStrategy {
        NONE,
        TRADE,
        IMMIGRATION,
        COOPERATION,
        CONQUEST;

    }
}

