/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.Transportable;
import org.w3c.dom.Element;

public abstract class Wish
extends AIObject {
    private static final Logger logger = Logger.getLogger(Wish.class.getName());
    protected Location destination = null;
    protected int value;
    protected Transportable transportable = null;

    public Wish(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public Wish(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public Wish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public boolean shouldBeStored() {
        return this.transportable != null;
    }

    public int getValue() {
        return this.value;
    }

    public void setTransportable(Transportable transportable) {
        this.transportable = transportable;
    }

    public Transportable getTransportable() {
        return this.transportable;
    }

    public void dispose() {
        if (this.destination instanceof Colony) {
            AIColony ac = (AIColony)this.getAIMain().getAIObject((FreeColGameObject)((Object)this.destination));
            ac.removeWish(this);
        } else {
            logger.warning("Unknown destination: " + this.destination);
        }
        if (this.transportable != null) {
            Transportable temp = this.transportable;
            this.transportable = null;
            temp.abortWish(this);
        }
        super.dispose();
    }

    public Location getDestination() {
        return this.destination;
    }
}

