/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.TileImprovementPlan;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WorkLocationPlan {
    private static final Logger logger = Logger.getLogger(WorkLocationPlan.class.getName());
    private AIMain aiMain;
    private WorkLocation workLocation;
    private int priority;
    private GoodsType goodsType;

    public WorkLocationPlan(AIMain aiMain, WorkLocation workLocation, GoodsType goodsType) {
        this.aiMain = aiMain;
        this.workLocation = workLocation;
        this.goodsType = goodsType;
    }

    public WorkLocationPlan(AIMain aiMain, Element element) {
        this.aiMain = aiMain;
        this.readFromXMLElement(element);
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public Game getGame() {
        return this.aiMain.getGame();
    }

    public TileImprovementPlan createTileImprovementPlan() {
        return this.updateTileImprovementPlan(null);
    }

    public TileImprovementPlan updateTileImprovementPlan(TileImprovementPlan tip) {
        if (this.workLocation instanceof ColonyTile) {
            Tile tile = ((ColonyTile)this.workLocation).getWorkTile();
            if (tip != null && tip.getTarget() != tile) {
                throw new IllegalArgumentException("The given TileImprovementPlan was not created for this Tile.");
            }
            TileImprovementType impType = TileImprovement.findBestTileImprovementType(tile, this.goodsType);
            if (impType != null) {
                int value = impType.getValue(tile.getType(), this.goodsType);
                if (tip == null) {
                    return new TileImprovementPlan(this.getAIMain(), tile, impType, value);
                }
                tip.setType(impType);
                tip.setValue(value);
                return tip;
            }
        }
        return null;
    }

    public WorkLocation getWorkLocation() {
        return this.workLocation;
    }

    public int getProductionOf(GoodsType goodsType) {
        if (goodsType != this.goodsType) {
            return 0;
        }
        if (this.workLocation instanceof ColonyTile) {
            if (!goodsType.isFarmed()) {
                return 0;
            }
            ColonyTile ct = (ColonyTile)this.workLocation;
            Tile t = ct.getWorkTile();
            UnitType expertUnitType = FreeCol.getSpecification().getExpertForProducing(goodsType);
            int base = t.getMaximumPotential(goodsType, expertUnitType);
            if (t.isLand() && base != 0) {
                ++base;
            }
            return expertUnitType.getProductionFor(goodsType, base);
        }
        if (goodsType.isFarmed()) {
            return 0;
        }
        if (goodsType == Goods.HAMMERS) {
            return 16;
        }
        if (goodsType == Goods.BELLS) {
            return 12;
        }
        if (goodsType == Goods.CROSSES) {
            return 10;
        }
        return this.workLocation.getColony().getOwner().getMarket().getSalePrice(goodsType, 1);
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public void setGoodsType(GoodsType goodsType) {
        this.goodsType = goodsType;
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(WorkLocationPlan.getXMLElementTagName());
        element.setAttribute("ID", this.workLocation.getId());
        element.setAttribute("priority", Integer.toString(this.priority));
        element.setAttribute("goodsType", this.goodsType.getId());
        return element;
    }

    public void readFromXMLElement(Element element) {
        this.workLocation = (WorkLocation)((Object)this.getAIMain().getFreeColGameObject(element.getAttribute("ID")));
        this.priority = Integer.parseInt(element.getAttribute("priority"));
        this.goodsType = FreeCol.getSpecification().getGoodsType(element.getAttribute("goodsType"));
    }

    public static String getXMLElementTagName() {
        return "workLocationPlan";
    }
}

