/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class BuildColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(BuildColonyMission.class.getName());
    private Tile target;
    private int colonyValue;
    private boolean doNotGiveUp = false;
    private boolean colonyBuilt = false;

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit, Tile target, int colonyValue) {
        super(aiMain, aiUnit);
        this.target = target;
        this.colonyValue = colonyValue;
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        if (!this.getUnit().isColonist()) {
            logger.warning("Only colonists can build a new Colony.");
            throw new IllegalArgumentException("Only colonists can build a new Colony.");
        }
    }

    public BuildColonyMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        this.target = null;
        this.colonyValue = -1;
        this.doNotGiveUp = true;
        if (!this.getUnit().isColonist()) {
            logger.warning("Only colonists can build a new Colony.");
            throw new IllegalArgumentException("Only colonists can build a new Colony.");
        }
    }

    public BuildColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public BuildColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        if (!this.isValid()) {
            return;
        }
        if (this.getUnit().getTile() == null) {
            return;
        }
        if (this.target == null || this.doNotGiveUp && (this.colonyValue != this.getUnit().getOwner().getColonyValue(this.target) || this.target.getSettlement() != null)) {
            this.target = BuildColonyMission.findColonyLocation(this.getUnit());
            if (this.target == null) {
                this.doNotGiveUp = false;
                return;
            }
            this.colonyValue = this.getUnit().getOwner().getColonyValue(this.target);
        }
        if (this.getUnit().getTile() != null) {
            if (this.target != this.getUnit().getTile()) {
                Map.Direction r = this.moveTowards(connection, this.target);
                this.moveButDontAttack(connection, r);
            }
            if (this.getUnit().canBuildColony() && this.target == this.getUnit().getTile() && this.getUnit().getMovesLeft() > 0) {
                Element buildColonyElement = Message.createNewRootElement("buildColony");
                buildColonyElement.setAttribute("name", unit.getOwner().getDefaultColonyName());
                buildColonyElement.setAttribute("unit", unit.getId());
                try {
                    Element reply = connection.ask(buildColonyElement);
                    if (reply != null && reply.getTagName().equals("buildColonyConfirmed")) {
                        this.colonyBuilt = true;
                        Settlement settlement = unit.getTile().getSettlement();
                        AIColony aiColony = (AIColony)this.getAIMain().getAIObject(settlement);
                        this.getAIUnit().setMission(new WorkInsideColonyMission(this.getAIMain(), this.getAIUnit(), aiColony));
                    } else {
                        logger.warning("Could not build an AI colony on tile " + this.getUnit().getTile().getPosition().toString());
                    }
                }
                catch (IOException e) {
                    logger.warning("Could not send \"buildColonyElement\"-message!");
                }
            }
        }
    }

    public Tile getTransportDestination() {
        if (this.target == null) {
            if (this.getUnit().isOnCarrier()) {
                return (Tile)((Unit)this.getUnit().getLocation()).getEntryLocation();
            }
            return (Tile)this.getUnit().getOwner().getEntryLocation();
        }
        if (this.getUnit().isOnCarrier()) {
            return this.target;
        }
        if (this.getUnit().getLocation().getTile() == this.target) {
            return null;
        }
        if (this.getUnit().getTile() == null) {
            return this.target;
        }
        if (this.getUnit().findPath(this.target) == null) {
            return this.target;
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public static Tile findColonyLocation(Unit unit) {
        Game game = unit.getGame();
        Tile startTile = null;
        if (unit.isOnCarrier()) {
            Unit carrier = (Unit)unit.getLocation();
            startTile = carrier.getTile();
        } else {
            startTile = unit.getLocation() instanceof Europe ? (Tile)unit.getEntryLocation() : unit.getTile();
        }
        if (startTile == null) {
            return null;
        }
        Tile bestTile = null;
        int highestColonyValue = 0;
        int maxNumberofTiles = 500;
        int tileCounter = 0;
        boolean gameStart = false;
        if (unit.getGame().getTurn().getNumber() < 10 && unit.isOnCarrier()) {
            gameStart = true;
        }
        Iterator<Map.Position> it = game.getMap().getFloodFillIterator(startTile.getPosition());
        while (it.hasNext()) {
            Tile tile = game.getMap().getTile(it.next());
            int newColonyValue = -1;
            if (tile.getColonyValue() > 0) {
                if (tile != startTile) {
                    PathNode path;
                    if (unit.isOnCarrier()) {
                        Unit carrier = (Unit)unit.getLocation();
                        path = game.getMap().findPath(unit, startTile, tile, carrier);
                    } else {
                        path = game.getMap().findPath(unit, startTile, tile);
                    }
                    if (path != null) {
                        newColonyValue = 10000 + unit.getOwner().getColonyValue(tile) - path.getTotalTurns() * (unit.getGame().getTurn().getNumber() < 10 && unit.isOnCarrier() ? 25 : 4);
                    }
                } else {
                    newColonyValue = 10000 + unit.getOwner().getColonyValue(tile);
                }
                if (newColonyValue > highestColonyValue) {
                    highestColonyValue = newColonyValue;
                    bestTile = tile;
                }
            }
            if (++tileCounter < maxNumberofTiles || gameStart && bestTile == null) continue;
            break;
        }
        if (bestTile == null) {
            logger.info("Unit " + unit.getId() + " unsuccessfully searched for colony spot");
        }
        return bestTile;
    }

    public boolean isValid() {
        return !this.colonyBuilt && (this.doNotGiveUp || this.target != null && this.target.getSettlement() == null && this.colonyValue <= this.getUnit().getOwner().getColonyValue(this.target));
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(BuildColonyMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
        out.writeAttribute("doNotGiveUp", Boolean.toString(this.doNotGiveUp));
        out.writeAttribute("colonyBuilt", Boolean.toString(this.colonyBuilt));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        String targetStr = in.getAttributeValue(null, "target");
        this.target = targetStr != null ? (Tile)this.getGame().getFreeColGameObject(targetStr) : null;
        String doNotGiveUpStr = in.getAttributeValue(null, "doNotGiveUp");
        this.doNotGiveUp = doNotGiveUpStr != null ? Boolean.valueOf(doNotGiveUpStr) : false;
        this.colonyBuilt = Boolean.valueOf(in.getAttributeValue(null, "colonyBuilt"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "buildColonyMission";
    }

    public String getDebuggingInfo() {
        String targetName = this.target != null ? this.target.getPosition().toString() : "unassigned";
        return targetName + " " + this.colonyValue + (this.doNotGiveUp ? "!" : "");
    }
}

