/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class CashInTreasureTrainMission
extends Mission {
    private static final Logger logger = Logger.getLogger(CashInTreasureTrainMission.class.getName());

    public CashInTreasureTrainMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public CashInTreasureTrainMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public CashInTreasureTrainMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void dispose() {
        super.dispose();
    }

    public void doMission(Connection connection) {
        Map map = this.getUnit().getGame().getMap();
        if (!this.isValid()) {
            return;
        }
        if (!this.getUnit().canCashInTreasureTrain()) {
            GoalDecider destinationDecider = new GoalDecider(){
                private PathNode best = null;

                public PathNode getGoal() {
                    return this.best;
                }

                public boolean hasSubGoals() {
                    return false;
                }

                public boolean check(Unit u, PathNode pathNode) {
                    Tile t = pathNode.getTile();
                    if (u.canCashInTreasureTrain(t)) {
                        this.best = pathNode;
                        return true;
                    }
                    return false;
                }
            };
            PathNode bestPath = map.search(this.getUnit(), destinationDecider, Integer.MAX_VALUE);
            if (bestPath != null) {
                Map.Direction direction = this.moveTowards(connection, bestPath);
                this.moveButDontAttack(connection, direction);
            }
        }
        if (this.getUnit().canCashInTreasureTrain()) {
            Element cashInTreasureTrainElement = Message.createNewRootElement("cashInTreasureTrain");
            cashInTreasureTrainElement.setAttribute("unit", this.getUnit().getId());
            try {
                connection.sendAndWait(cashInTreasureTrainElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message: \"cashInTreasureTrain\".");
            }
        }
    }

    public Tile getTransportDestination() {
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public boolean isValid() {
        return !this.getUnit().isDisposed();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(CashInTreasureTrainMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "cashInTreasureTrainMission";
    }
}

