/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class DefendSettlementMission
extends Mission {
    private static final Logger logger = Logger.getLogger(DefendSettlementMission.class.getName());
    private Settlement settlement;

    public DefendSettlementMission(AIMain aiMain, AIUnit aiUnit, Settlement settlement) {
        super(aiMain, aiUnit);
        this.settlement = settlement;
        if (settlement == null) {
            logger.warning("settlement == null");
            throw new NullPointerException("settlement == null");
        }
    }

    public DefendSettlementMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public DefendSettlementMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        Map map = unit.getGame().getMap();
        if (!this.isValid()) {
            return;
        }
        if (unit.getTile() == null) {
            return;
        }
        if (unit.isOffensiveUnit()) {
            Map.Direction[] directions;
            CombatModel combatModel = unit.getGame().getCombatModel();
            Unit bestTarget = null;
            float bestDifference = Float.MIN_VALUE;
            Map.Direction bestDirection = null;
            for (Map.Direction direction : directions = map.getRandomDirectionArray()) {
                float weDefend;
                float enemyDefend;
                Unit defender;
                Tile t = map.getNeighbourOrNull(direction, unit.getTile());
                if (t == null || (defender = t.getFirstUnit()) == null || defender.getOwner().getStance(unit.getOwner()) != Player.Stance.WAR || unit.getMoveType(direction) != Unit.MoveType.ATTACK) continue;
                Unit enemyUnit = t.getDefendingUnit(unit);
                float enemyAttack = combatModel.getOffencePower(enemyUnit, unit);
                float weAttack = combatModel.getOffencePower(unit, enemyUnit);
                float difference = weAttack / (weAttack + (enemyDefend = combatModel.getDefencePower(unit, enemyUnit))) - enemyAttack / (enemyAttack + (weDefend = combatModel.getDefencePower(enemyUnit, unit)));
                if (!(difference > bestDifference) || !(difference > 0.0f) && !(weAttack > enemyDefend)) continue;
                bestDifference = difference;
                bestTarget = enemyUnit;
                bestDirection = direction;
            }
            if (bestTarget != null) {
                this.attack(connection, unit, bestDirection);
                return;
            }
        }
        if (unit.getTile() != this.settlement.getTile()) {
            Map.Direction r = this.moveTowards(connection, this.settlement.getTile());
            this.moveButDontAttack(connection, r);
        } else if (unit.getState() != Unit.UnitState.FORTIFIED && unit.getState() != Unit.UnitState.FORTIFYING && unit.checkSetState(Unit.UnitState.FORTIFYING)) {
            Element changeStateElement = Message.createNewRootElement("changeState");
            changeStateElement.setAttribute("unit", unit.getId());
            changeStateElement.setAttribute("state", Unit.UnitState.FORTIFYING.toString());
            try {
                logger.log(Level.FINEST, "Sending fortity request...");
                connection.sendAndWait(changeStateElement);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Couldn't fortify unit!", e);
            }
        }
    }

    public Tile getTransportDestination() {
        if (this.getUnit().isOnCarrier()) {
            return this.settlement.getTile();
        }
        if (this.getUnit().getLocation().getTile() == this.settlement.getTile()) {
            return null;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.settlement.getTile()) == null) {
            return this.settlement.getTile();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 105;
        }
        return 0;
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public boolean isValid() {
        return !this.settlement.isDisposed() && this.settlement.getOwner() == this.getUnit().getOwner() && this.getUnit().isDefensiveUnit();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(DefendSettlementMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        out.writeAttribute("settlement", this.settlement.getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        this.settlement = (Settlement)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "settlement"));
        if (this.settlement == null) {
            logger.warning("settlement == null");
            throw new NullPointerException("settlement == null");
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "defendSettlementMission";
    }

    public String getDebuggingInfo() {
        String name = this.settlement instanceof Colony ? ((Colony)this.settlement).getName() : "";
        return this.settlement.getTile().getPosition().toString() + " " + name;
    }
}

