/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class IdleAtColonyMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IdleAtColonyMission.class.getName());

    public IdleAtColonyMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public IdleAtColonyMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public IdleAtColonyMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        Tile thisTile = this.getUnit().getTile();
        Unit unit = this.getUnit();
        Map gameMap = this.getGame().getMap();
        if (thisTile != null) {
            if (thisTile.getSettlement() != null) {
                logger.info("Unit " + unit.getId() + " idle at settlement: " + thisTile.getSettlement().getId());
                return;
            }
            PathNode pathToTarget = null;
            int MAX_COLONY_DISTANCE = 10;
            Map.CircleIterator i = gameMap.getCircleIterator(thisTile.getPosition(), true, 10);
            while (i.hasNext()) {
                Map.Position pos = (Map.Position)i.next();
                Settlement s = gameMap.getTile(pos).getSettlement();
                if (!(s instanceof Colony) || ((Colony)s).getOwner() != this.getUnit().getOwner()) continue;
                logger.info("Unit " + unit.getId() + " moving towards settlement: " + s.getId());
                pathToTarget = this.getUnit().findPath(s.getTile());
                break;
            }
            if (pathToTarget != null) {
                Map.Direction dir = this.moveTowards(connection, pathToTarget);
                if (dir != null) {
                    this.moveButDontAttack(connection, dir);
                }
            } else {
                this.moveRandomly(connection);
            }
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(IdleAtColonyMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "idleAtColonyMission";
    }
}

