/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class IndianBringGiftMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianBringGiftMission.class.getName());
    private Colony target;
    private boolean giftDelivered;

    public IndianBringGiftMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.target = target;
        this.giftDelivered = false;
        if (!this.getUnit().getOwner().isIndian() || !this.getUnit().canCarryGoods()) {
            logger.warning("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
            throw new IllegalArgumentException("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
        }
    }

    public IndianBringGiftMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public IndianBringGiftMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        if (!this.isValid()) {
            return;
        }
        if (!this.hasGift()) {
            if (this.getUnit().getTile() != this.getUnit().getIndianSettlement().getTile()) {
                Map.Direction r = this.moveTowards(connection, this.getUnit().getIndianSettlement().getTile());
                this.moveButDontAttack(connection, r);
            } else {
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                GoodsContainer gc = this.getUnit().getIndianSettlement().getGoodsContainer();
                for (GoodsType goodsType : FreeCol.getSpecification().getNewWorldGoodsTypeList()) {
                    if (gc.getGoodsCount(goodsType) < 75) continue;
                    goodsList.add(new Goods(this.getGame(), this.getUnit().getIndianSettlement(), goodsType, this.getRandom().nextInt(15) + 10));
                }
                if (goodsList.size() > 0) {
                    Goods goods = (Goods)goodsList.get(this.getRandom().nextInt(goodsList.size()));
                    goods.setLocation(this.getUnit());
                }
            }
        } else {
            Map.Direction r = this.moveTowards(connection, this.target.getTile());
            if (r != null && this.getGame().getMap().getNeighbourOrNull(r, this.getUnit().getTile()) == this.target.getTile()) {
                Element deliverGiftElement = Message.createNewRootElement("deliverGift");
                deliverGiftElement.setAttribute("unit", this.getUnit().getId());
                deliverGiftElement.setAttribute("settlement", this.target.getId());
                deliverGiftElement.appendChild(this.getUnit().getGoodsIterator().next().toXMLElement(null, deliverGiftElement.getOwnerDocument()));
                try {
                    connection.sendAndWait(deliverGiftElement);
                }
                catch (IOException e) {
                    logger.warning("Could not send \"deliverGift\"-message!");
                }
                this.giftDelivered = true;
                this.getUnit().getOwner().modifyTension(this.target.getOwner(), 1);
            }
        }
        this.moveRandomly(connection);
    }

    private boolean hasGift() {
        return this.getUnit().getSpaceLeft() == 0;
    }

    public boolean isValid() {
        return this.target != null && !this.target.isDisposed() && this.target.getTile().getColony() == this.target && !this.giftDelivered && IndianBringGiftMission.isValidMission(this.getUnit().getOwner(), this.target.getOwner()) && this.getUnit().getIndianSettlement() != null;
    }

    public static boolean isValidMission(Player owner, Player targetPlayer) {
        Player.Stance stance = owner.getStance(targetPlayer);
        if (stance == null) {
            return false;
        }
        return stance != Player.Stance.WAR && stance != Player.Stance.CEASE_FIRE && owner.getTension(targetPlayer).getLevel() != null && owner.getTension(targetPlayer).getLevel().compareTo(Tension.Level.HAPPY) <= 0;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(IndianBringGiftMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
        out.writeAttribute("giftDelivered", Boolean.toString(this.giftDelivered));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        this.target = (Colony)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "target"));
        this.giftDelivered = Boolean.valueOf(in.getAttributeValue(null, "giftDelivered"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "indianBringGiftMission";
    }

    public String getDebuggingInfo() {
        if (!this.hasGift()) {
            return "[" + this.target.getName() + "] Getting gift: " + this.getUnit().getIndianSettlement().getTile().getPosition();
        }
        return "[" + this.target.getName() + "] " + this.getUnit().getGoodsIterator().next().getName();
    }
}

