/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class IndianDemandMission
extends Mission {
    private static final Logger logger = Logger.getLogger(IndianDemandMission.class.getName());
    private Colony target;
    private boolean completed;

    public IndianDemandMission(AIMain aiMain, AIUnit aiUnit, Colony target) {
        super(aiMain, aiUnit);
        this.target = target;
        if (!this.getUnit().getOwner().isIndian() || !this.getUnit().canCarryGoods()) {
            logger.warning("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
            throw new IllegalArgumentException("Only an indian which can carry goods can be given the mission: IndianBringGiftMission");
        }
    }

    public IndianDemandMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public IndianDemandMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        if (!this.isValid()) {
            return;
        }
        if (!this.hasGift()) {
            if (this.getUnit().getTile() != this.getUnit().getIndianSettlement().getTile()) {
                Map.Direction r = this.moveTowards(connection, this.getUnit().getIndianSettlement().getTile());
                this.moveButDontAttack(connection, r);
            } else {
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                GoodsContainer gc = this.getUnit().getIndianSettlement().getGoodsContainer();
                for (GoodsType goodsType : FreeCol.getSpecification().getNewWorldGoodsTypeList()) {
                    if (gc.getGoodsCount(goodsType) < 75) continue;
                    goodsList.add(new Goods(this.getGame(), this.getUnit().getIndianSettlement(), goodsType, this.getRandom().nextInt(15) + 10));
                }
                if (goodsList.size() > 0) {
                    Goods goods = (Goods)goodsList.get(this.getRandom().nextInt(goodsList.size()));
                    goods.setLocation(this.getUnit());
                }
            }
        } else {
            Unit unit = this.getUnit();
            Map.Direction r = this.moveTowards(connection, this.target.getTile());
            if (r != null && this.getGame().getMap().getNeighbourOrNull(r, unit.getTile()) == this.target.getTile() && unit.getMovesLeft() > 0) {
                Element reply;
                Element demandElement = Message.createNewRootElement("indianDemand");
                demandElement.setAttribute("unit", unit.getId());
                demandElement.setAttribute("colony", this.target.getId());
                Player enemy = this.target.getOwner();
                Goods goods = this.selectGoods(this.target);
                if (goods == null) {
                    if (enemy.getGold() == 0) {
                        this.completed = true;
                        return;
                    }
                    demandElement.setAttribute("gold", String.valueOf(enemy.getGold() / 20));
                } else {
                    demandElement.appendChild(goods.toXMLElement(null, demandElement.getOwnerDocument()));
                }
                if (!unit.isVisibleTo(enemy)) {
                    demandElement.appendChild(unit.toXMLElement(enemy, demandElement.getOwnerDocument()));
                }
                try {
                    reply = connection.ask(demandElement);
                }
                catch (IOException e) {
                    logger.warning("Could not send \"demand\"-message!");
                    this.completed = true;
                    return;
                }
                boolean accepted = Boolean.valueOf(reply.getAttribute("accepted"));
                int tension = 0;
                int unitTension = unit.getOwner().getTension(enemy).getValue();
                if (unit.getIndianSettlement() != null) {
                    unitTension += unit.getIndianSettlement().getOwner().getTension(enemy).getValue();
                }
                int difficulty = enemy.getDifficulty().getIndex();
                if (accepted) {
                    tension = -(5 - difficulty) * 50;
                    unit.getOwner().modifyTension(enemy, tension);
                    if (unitTension <= Tension.Level.HAPPY.getLimit() && (goods == null || goods.getType().isFoodType())) {
                        Element deliverGiftElement = Message.createNewRootElement("deliverGift");
                        deliverGiftElement.setAttribute("unit", this.getUnit().getId());
                        deliverGiftElement.setAttribute("settlement", this.target.getId());
                        deliverGiftElement.appendChild(this.getUnit().getGoodsIterator().next().toXMLElement(null, deliverGiftElement.getOwnerDocument()));
                        try {
                            connection.sendAndWait(deliverGiftElement);
                        }
                        catch (IOException e) {
                            logger.warning("Could not send \"deliverGift\"-message!");
                        }
                    }
                } else {
                    tension = (difficulty + 1) * 50;
                    unit.getOwner().modifyTension(enemy, tension);
                    if (unitTension >= Tension.Level.CONTENT.getLimit()) {
                        this.attack(connection, unit, r);
                    }
                }
                this.completed = true;
            }
        }
        this.moveRandomly(connection);
    }

    public Goods selectGoods(Colony target) {
        int goodsValue;
        List<Goods> warehouseGoods;
        int value;
        Tension.Level tension = this.getUnit().getOwner().getTension(target.getOwner()).getLevel();
        int dx = target.getOwner().getDifficulty().getIndex() + 1;
        GoodsType food = FreeCol.getSpecification().getGoodsType("model.goods.food");
        AbstractGoods goods = null;
        GoodsContainer warehouse = target.getGoodsContainer();
        if (tension.compareTo(Tension.Level.CONTENT) <= 0 && warehouse.getGoodsCount(food) >= 100) {
            int amount = warehouse.getGoodsCount(food) * dx / 6;
            if (amount > 0) {
                return new Goods(this.getGame(), target, food, this.capAmount(amount, dx));
            }
        } else if (tension.compareTo(Tension.Level.DISPLEASED) <= 0) {
            Market market = target.getOwner().getMarket();
            value = 0;
            warehouseGoods = warehouse.getCompactGoods();
            for (Goods currentGoods : warehouseGoods) {
                goodsValue = market.getSalePrice(currentGoods);
                if (currentGoods.getType().isFoodType() || currentGoods.getType().isMilitaryGoods() || goodsValue <= value) continue;
                value = goodsValue;
                goods = currentGoods;
            }
            if (goods != null) {
                goods.setAmount(this.capAmount(goods.getAmount(), dx));
                return goods;
            }
        } else {
            int amount;
            for (GoodsType preferred : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!preferred.isMilitaryGoods() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!preferred.isBuildingMaterial() || !preferred.isStorable() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!preferred.isTradeGoods() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
            for (GoodsType preferred : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!preferred.isRefined() || !preferred.isStorable() || (amount = warehouse.getGoodsCount(preferred)) <= 0) continue;
                return new Goods(this.getGame(), target, preferred, this.capAmount(amount, dx));
            }
        }
        Market market = target.getOwner().getMarket();
        value = 0;
        warehouseGoods = warehouse.getCompactGoods();
        for (Goods currentGoods : warehouseGoods) {
            goodsValue = market.getSalePrice(currentGoods);
            if (goodsValue <= value) continue;
            value = goodsValue;
            goods = currentGoods;
        }
        if (goods != null) {
            goods.setAmount(this.capAmount(goods.getAmount(), dx));
        }
        return goods;
    }

    private int capAmount(int amount, int difficulty) {
        int finalAmount = Math.max(amount * difficulty / 6, 1);
        finalAmount = Math.min(finalAmount, 100);
        return finalAmount;
    }

    private boolean hasGift() {
        return this.getUnit().getSpaceLeft() == 0;
    }

    public boolean isValid() {
        return !this.completed && this.target != null && !this.target.isDisposed() && this.target.getTile().getColony() == this.target && this.getUnit().getIndianSettlement() != null;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(IndianDemandMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        out.writeAttribute("target", this.target.getId());
        out.writeAttribute("completed", Boolean.toString(this.completed));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        this.target = (Colony)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "target"));
        this.completed = Boolean.valueOf(in.getAttributeValue(null, "completed"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "indianDemandMission";
    }

    public String getDebuggingInfo() {
        String targetName;
        if (this.getUnit().getIndianSettlement() == null) {
            return "invalid";
        }
        String string = targetName = this.target != null ? this.target.getName() : "null";
        if (!this.hasGift()) {
            return "[" + targetName + "] Getting gift: " + this.getUnit().getIndianSettlement().getTile().getPosition();
        }
        return "[" + targetName + "] " + this.getUnit().getGoodsIterator().next().getName();
    }
}

