/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.logging.Logger;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import org.w3c.dom.Element;

public abstract class Mission
extends AIObject {
    private static final Logger logger = Logger.getLogger(Mission.class.getName());
    protected static final int MINIMUM_TRANSPORT_PRIORITY = 60;
    protected static final int NORMAL_TRANSPORT_PRIORITY = 100;
    protected static final int NO_PATH_TO_TARGET = -2;
    protected static final int NO_MORE_MOVES_LEFT = -1;
    private AIUnit aiUnit;

    public Mission(AIMain aiMain) {
        this(aiMain, (AIUnit)null);
    }

    public Mission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain);
        this.aiUnit = aiUnit;
    }

    protected Map.Direction moveTowards(Connection connection, Tile tile) {
        PathNode pathNode = this.getUnit().findPath(tile);
        if (pathNode != null) {
            return this.moveTowards(connection, pathNode);
        }
        return null;
    }

    protected Map.Direction moveTowards(Connection connection, PathNode pathNode) {
        if (this.getUnit().getMovesLeft() <= 0) {
            return null;
        }
        while (pathNode.next != null && pathNode.getTurns() == 0 && this.isValid() && (this.getUnit().getMoveType(pathNode.getDirection()) == Unit.MoveType.MOVE || this.getUnit().getMoveType(pathNode.getDirection()) == Unit.MoveType.MOVE_HIGH_SEAS || this.getUnit().getMoveType(pathNode.getDirection()) == Unit.MoveType.EXPLORE_LOST_CITY_RUMOUR)) {
            this.move(connection, pathNode.getDirection());
            pathNode = pathNode.next;
        }
        if (pathNode.getTurns() == 0 && this.getUnit().getMoveType(pathNode.getDirection()) != Unit.MoveType.ILLEGAL_MOVE) {
            return pathNode.getDirection();
        }
        return null;
    }

    protected void moveRandomly(Connection connection) {
        Tile thisTile = this.getUnit().getTile();
        Unit unit = this.getUnit();
        Map.Direction[] randomDirections = unit.getGame().getMap().getRandomDirectionArray();
        while (unit.getMovesLeft() > 0) {
            int j;
            Map.Direction direction = Map.Direction.N;
            for (j = 0; j < randomDirections.length; ++j) {
                direction = randomDirections[j];
                if (unit.getGame().getMap().getNeighbourOrNull(direction, thisTile) != null && unit.getMoveType(direction) == Unit.MoveType.MOVE) break;
            }
            if (j == randomDirections.length) {
                unit.setMovesLeft(0);
                break;
            }
            thisTile = unit.getGame().getMap().getNeighbourOrNull(direction, thisTile);
            this.move(connection, direction);
        }
    }

    protected void move(Connection connection, Map.Direction direction) {
        Element moveElement = Message.createNewRootElement("move");
        moveElement.setAttribute("unit", this.getUnit().getId());
        moveElement.setAttribute("direction", direction.toString());
        try {
            connection.sendAndWait(moveElement);
        }
        catch (IOException e) {
            logger.warning("Could not send \"move\"-message!");
        }
    }

    protected void moveUnitToAmerica(Connection connection, Unit unit) {
        Element moveToAmericaElement = Message.createNewRootElement("moveToAmerica");
        moveToAmericaElement.setAttribute("unit", unit.getId());
        try {
            connection.sendAndWait(moveToAmericaElement);
        }
        catch (IOException e) {
            logger.warning("Could not send \"moveToAmericaElement\"-message!");
        }
    }

    protected void moveUnitToEurope(Connection connection, Unit unit) {
        Element moveToAmericaElement = Message.createNewRootElement("moveToEurope");
        moveToAmericaElement.setAttribute("unit", unit.getId());
        try {
            connection.sendAndWait(moveToAmericaElement);
        }
        catch (IOException e) {
            logger.warning("Could not send \"moveToAmericaElement\"-message!");
        }
    }

    protected void moveButDontAttack(Connection connection, Map.Direction direction) {
        if (direction != null) {
            switch (this.getUnit().getMoveType(direction)) {
                case MOVE: 
                case MOVE_HIGH_SEAS: 
                case EXPLORE_LOST_CITY_RUMOUR: {
                    this.move(connection, direction);
                    break;
                }
            }
        }
    }

    protected void exploreLostCityRumour(Connection connection) {
        if (this.getUnit().getTile().hasLostCityRumour()) {
            Element exploreElement = Message.createNewRootElement("explore");
            exploreElement.setAttribute("unit", this.getUnit().getId());
            try {
                connection.ask(exploreElement);
            }
            catch (IOException e) {
                logger.warning("Could not send \"explore\"-message!");
            }
        }
    }

    protected PathNode findTarget(int maxTurns) {
        if (!this.getUnit().isOffensiveUnit()) {
            throw new IllegalStateException("A target can only be found for offensive units. You tried with: " + this.getUnit().getName());
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode bestTarget = null;
            private int higherTension = 0;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                CombatModel combatModel = Mission.this.getGame().getCombatModel();
                Tile newTile = pathNode.getTile();
                Unit defender = newTile.getDefendingUnit(unit);
                if (defender == null) {
                    return false;
                }
                if (defender.getOwner() == unit.getOwner()) {
                    return false;
                }
                if (newTile.isLand() && unit.isNaval() || !newTile.isLand() && !unit.isNaval()) {
                    return false;
                }
                int tension = 0;
                Tension alarm = unit.getOwner().getTension(defender.getOwner());
                if (alarm != null) {
                    tension = alarm.getValue();
                }
                if (unit.getIndianSettlement() != null && unit.getIndianSettlement().getAlarm(defender.getOwner()) != null) {
                    tension += unit.getIndianSettlement().getAlarm(defender.getOwner()).getValue();
                }
                if (defender.canCarryTreasure()) {
                    tension += Math.min(defender.getTreasureAmount() / 10, 600);
                }
                if (defender.getType().getDefence() > 0 && newTile.getSettlement() == null) {
                    tension = (int)((float)tension + (100.0f - combatModel.getDefencePower(unit, defender) * 2.0f));
                }
                if (defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                    tension = (int)((float)tension + (50.0f - combatModel.getDefencePower(unit, defender) * 2.0f));
                }
                if (unit.hasAbility("model.ability.piracy")) {
                    tension += PrivateerMission.getModifierValueForTarget(combatModel, unit, defender);
                }
                if (unit.getOwner().isIndian() && defender.getOwner().isAI()) {
                    tension -= 200;
                }
                if (tension > Tension.Level.CONTENT.getLimit()) {
                    if (this.bestTarget == null) {
                        this.bestTarget = pathNode;
                        this.higherTension = tension;
                        return true;
                    }
                    if (this.bestTarget.getTurns() == pathNode.getTurns() && tension > this.higherTension) {
                        this.bestTarget = pathNode;
                        this.higherTension = tension;
                        return true;
                    }
                }
                return false;
            }
        };
        return this.getGame().getMap().search(this.getUnit(), gd, maxTurns);
    }

    public Tile getTransportDestination() {
        if (this.getUnit().getTile() == null) {
            if (this.getUnit().isOnCarrier()) {
                return (Tile)((Unit)this.getUnit().getLocation()).getEntryLocation();
            }
            return (Tile)this.getUnit().getOwner().getEntryLocation();
        }
        if (!this.getUnit().isOnCarrier()) {
            return null;
        }
        Unit carrier = (Unit)this.getUnit().getLocation();
        if (carrier.getTile().getSettlement() != null) {
            return carrier.getTile();
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode bestTarget = null;

            public PathNode getGoal() {
                return this.bestTarget;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit unit, PathNode pathNode) {
                boolean hasOurSettlement;
                Tile newTile = pathNode.getTile();
                boolean bl = hasOurSettlement = newTile.getSettlement() != null && newTile.getSettlement().getOwner() == unit.getOwner();
                if (hasOurSettlement) {
                    this.bestTarget = pathNode;
                }
                return hasOurSettlement;
            }
        };
        PathNode path = this.getGame().getMap().search(carrier, gd, Integer.MAX_VALUE);
        if (path != null) {
            return path.getLastNode().getTile();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    protected boolean unloadCargoInColony(Connection connection, Unit carrier, Goods goods) {
        Element unloadCargoElement = Message.createNewRootElement("unloadCargo");
        unloadCargoElement.appendChild(goods.toXMLElement(carrier.getOwner(), unloadCargoElement.getOwnerDocument()));
        try {
            connection.sendAndWait(unloadCargoElement);
        }
        catch (IOException e) {
            logger.warning("Could not send \"unloadCargoElement\"-message!");
            return false;
        }
        return true;
    }

    protected boolean sellCargoInEurope(Connection connection, Unit carrier, Goods goods) {
        Player p = carrier.getOwner();
        if (p.isAI() && this.getAIMain().getFreeColServer().isSingleplayer()) {
            p.modifyGold(p.getMarket().getSalePrice(goods));
        }
        Element sellGoodsElement = Message.createNewRootElement("sellGoods");
        sellGoodsElement.appendChild(goods.toXMLElement(carrier.getOwner(), sellGoodsElement.getOwnerDocument()));
        try {
            connection.sendAndWait(sellGoodsElement);
        }
        catch (IOException e) {
            logger.warning("Could not send \"sellGoodsElement\"-message!");
            return false;
        }
        return true;
    }

    public void dispose() {
    }

    public abstract void doMission(Connection var1);

    public boolean isValid() {
        return this.getUnit() == null || !this.getUnit().isDisposed();
    }

    public Unit getUnit() {
        return this.aiUnit.getUnit();
    }

    public AIUnit getAIUnit() {
        return this.aiUnit;
    }

    protected void setAIUnit(AIUnit aiUnit) {
        this.aiUnit = aiUnit;
    }

    public String getDebuggingInfo() {
        return "";
    }

    public void attack(Connection connection, Unit unit, Map.Direction direction) {
        assert (direction != null);
        Element element = Message.createNewRootElement("attack");
        element.setAttribute("unit", unit.getId());
        element.setAttribute("direction", direction.toString());
        try {
            connection.ask(element);
        }
        catch (IOException e) {
            logger.warning("Could not send message!");
        }
    }

    protected void unitLeavesShip(Connection connection, Unit u) {
        Element leaveShipElement = Message.createNewRootElement("leaveShip");
        leaveShipElement.setAttribute("unit", u.getId());
        try {
            connection.sendAndWait(leaveShipElement);
        }
        catch (IOException e) {
            logger.warning("Could not send \"leaveShipElement\"-message!");
        }
    }
}

