/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class PioneeringMission
extends Mission {
    private static final Logger logger = Logger.getLogger(PioneeringMission.class.getName());
    private static final EquipmentType toolsType = FreeCol.getSpecification().getEquipmentType("model.equipment.tools");
    private TileImprovementPlan tileImprovementPlan = null;
    private boolean skipMission = false;

    public PioneeringMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public PioneeringMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public PioneeringMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void dispose() {
        if (this.tileImprovementPlan != null) {
            this.tileImprovementPlan.setPioneer(null);
            this.tileImprovementPlan = null;
        }
        super.dispose();
    }

    public void setTileImprovementPlan(TileImprovementPlan tileImprovementPlan) {
        this.tileImprovementPlan = tileImprovementPlan;
    }

    private void updateTileImprovementPlan() {
        Tile improvementTarget;
        AIPlayer aiPlayer = (AIPlayer)this.getAIMain().getAIObject(this.getUnit().getOwner().getId());
        Unit carrier = this.getUnit().isOnCarrier() ? (Unit)this.getUnit().getLocation() : null;
        Tile tile = improvementTarget = this.tileImprovementPlan != null ? this.tileImprovementPlan.getTarget() : null;
        if (this.tileImprovementPlan != null && improvementTarget == null) {
            logger.warning("Found invalid TileImprovementPlan, removing it and assigning a new one");
            aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
            this.tileImprovementPlan.dispose();
        }
        if (this.tileImprovementPlan != null && improvementTarget != null && improvementTarget.hasImprovement(this.tileImprovementPlan.getType())) {
            aiPlayer.removeTileImprovementPlan(this.tileImprovementPlan);
            this.tileImprovementPlan.dispose();
        }
        if (this.tileImprovementPlan != null && improvementTarget != null) {
            return;
        }
        Tile startTile = this.getUnit().getTile() == null ? (this.getUnit().isOnCarrier() ? (Tile)((Unit)this.getUnit().getLocation()).getEntryLocation() : (Tile)this.getUnit().getOwner().getEntryLocation()) : this.getUnit().getTile();
        TileImprovementPlan bestChoice = null;
        int bestValue = 0;
        Iterator<TileImprovementPlan> tiIterator = aiPlayer.getTileImprovementPlanIterator();
        while (tiIterator.hasNext()) {
            int value;
            TileImprovementPlan ti = tiIterator.next();
            if (ti.getPioneer() != null) continue;
            if (ti.getTarget() == null) {
                logger.warning("Found invalid TileImprovementPlan, removing it and finding a new one");
                aiPlayer.removeTileImprovementPlan(ti);
                ti.dispose();
                continue;
            }
            PathNode path = null;
            if (startTile != ti.getTarget()) {
                path = this.getGame().getMap().findPath(this.getUnit(), startTile, ti.getTarget(), carrier);
                if (path != null) {
                    value = ti.getValue() + 10000 - path.getTotalTurns() * 5;
                    PathNode pn = path;
                    while (pn != null) {
                        if (pn.getTile().getFirstUnit() != null && pn.getTile().getFirstUnit().getOwner() != this.getUnit().getOwner()) {
                            value -= 1000;
                        }
                        pn = pn.next;
                    }
                } else {
                    value = ti.getValue();
                }
            } else {
                value = ti.getValue() + 10000;
            }
            if (value <= bestValue) continue;
            bestChoice = ti;
            bestValue = value;
        }
        if (bestChoice != null) {
            this.tileImprovementPlan = bestChoice;
            bestChoice.setPioneer(this.getAIUnit());
        }
    }

    private PathNode findColonyWithTools() {
        GoalDecider destinationDecider = new GoalDecider(){
            private PathNode best = null;

            public PathNode getGoal() {
                return this.best;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode pathNode) {
                Tile t = pathNode.getTile();
                boolean target = false;
                if (t.getColony() != null && t.getColony().getOwner() == u.getOwner() && t.getColony().canBuildEquipment(toolsType)) {
                    AIColony ac = (AIColony)PioneeringMission.this.getAIMain().getAIObject(t.getColony());
                    target = ac.canBuildEquipment(toolsType);
                }
                if (target) {
                    this.best = pathNode;
                }
                return target;
            }
        };
        return this.getGame().getMap().search(this.getUnit(), destinationDecider, Integer.MAX_VALUE);
    }

    public void doMission(Connection connection) {
        if (!this.isValid()) {
            return;
        }
        if (this.getUnit().getTile() != null && !this.getUnit().hasAbility("model.ability.improveTerrain")) {
            if (this.getUnit().getColony() == null) {
                PathNode bestPath = this.findColonyWithTools();
                if (bestPath != null) {
                    Map.Direction direction = this.moveTowards(connection, bestPath);
                    this.moveButDontAttack(connection, direction);
                } else {
                    this.skipMission = true;
                }
            }
            if (this.getUnit().getColony() != null) {
                AIColony ac = (AIColony)this.getAIMain().getAIObject(this.getUnit().getColony());
                int amount = toolsType.getMaximumCount();
                for (AbstractGoods materials : toolsType.getGoodsRequired()) {
                    int requiredAmount;
                    int availableAmount = ac.getAvailableGoods(materials.getType());
                    if (availableAmount < (requiredAmount = materials.getAmount())) {
                        this.skipMission = true;
                        break;
                    }
                    amount = Math.min(amount, availableAmount / requiredAmount);
                }
                if (!this.skipMission) {
                    Element equipUnitElement = Message.createNewRootElement("equipUnit");
                    equipUnitElement.setAttribute("unit", this.getUnit().getId());
                    equipUnitElement.setAttribute("type", toolsType.getId());
                    equipUnitElement.setAttribute("amount", Integer.toString(amount));
                    try {
                        connection.sendAndWait(equipUnitElement);
                    }
                    catch (Exception e) {
                        logger.warning("Could not send equip message.");
                    }
                }
            }
            return;
        }
        if (this.tileImprovementPlan == null) {
            this.updateTileImprovementPlan();
        }
        if (this.tileImprovementPlan != null && this.getUnit().getTile() != null) {
            Map.Direction direction;
            PathNode pathToTarget;
            if (this.getUnit().getTile() != this.tileImprovementPlan.getTarget() && (pathToTarget = this.getUnit().findPath(this.tileImprovementPlan.getTarget())) != null && (direction = this.moveTowards(connection, pathToTarget)) != null && (this.getUnit().getMoveType(direction) == Unit.MoveType.MOVE || this.getUnit().getMoveType(direction) == Unit.MoveType.EXPLORE_LOST_CITY_RUMOUR)) {
                this.move(connection, direction);
            }
            if (this.getUnit().getTile() == this.tileImprovementPlan.getTarget() && this.getUnit().getState() != Unit.UnitState.IMPROVING && this.getUnit().checkSetState(Unit.UnitState.IMPROVING)) {
                int price = this.getUnit().getOwner().getLandPrice(this.getUnit().getTile());
                if (price > 0) {
                    // empty if block
                }
                Element changeWorkTypeElement = Message.createNewRootElement("workImprovement");
                changeWorkTypeElement.setAttribute("unit", this.getUnit().getId());
                changeWorkTypeElement.setAttribute("improvementType", this.tileImprovementPlan.getType().getId());
                Element reply = null;
                try {
                    reply = connection.ask(changeWorkTypeElement);
                }
                catch (IOException e) {
                    logger.warning("Could not send message!");
                }
                if (reply != null && reply.getTagName().equals("workImprovementConfirmed")) {
                    Element improvementElement;
                    Element containerElement = (Element)reply.getElementsByTagName(TileItemContainer.getXMLElementTagName()).item(0);
                    if (containerElement != null) {
                        TileItemContainer container = (TileItemContainer)this.getGame().getFreeColGameObject(containerElement.getAttribute("ID"));
                        if (container == null) {
                            container = new TileItemContainer(this.getGame(), this.getUnit().getTile(), containerElement);
                            this.getUnit().getTile().setTileItemContainer(container);
                        } else {
                            container.readFromXMLElement(containerElement);
                        }
                    }
                    if ((improvementElement = (Element)reply.getElementsByTagName(TileImprovement.getXMLElementTagName()).item(0)) != null) {
                        TileImprovement improvement = (TileImprovement)this.getGame().getFreeColGameObject(improvementElement.getAttribute("ID"));
                        if (improvement == null) {
                            improvement = new TileImprovement(this.getGame(), improvementElement);
                            this.getUnit().getTile().add(improvement);
                        } else {
                            improvement.readFromXMLElement(improvementElement);
                        }
                    }
                }
            }
        }
    }

    public Tile getTransportDestination() {
        this.updateTileImprovementPlan();
        if (this.tileImprovementPlan == null) {
            return null;
        }
        if (this.getUnit().isOnCarrier()) {
            return this.tileImprovementPlan.getTarget();
        }
        if (this.getUnit().getTile() == this.tileImprovementPlan.getTarget()) {
            return null;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.tileImprovementPlan.getTarget()) == null) {
            return this.tileImprovementPlan.getTarget();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public boolean isValid() {
        this.updateTileImprovementPlan();
        return !this.skipMission && this.tileImprovementPlan != null && (this.getUnit().getRole() == Unit.Role.PIONEER || this.getUnit().hasAbility("model.ability.expertPioneer"));
    }

    public static boolean isValid(AIUnit aiUnit) {
        AIPlayer aiPlayer = (AIPlayer)aiUnit.getAIMain().getAIObject(aiUnit.getUnit().getOwner().getId());
        Iterator<TileImprovementPlan> tiIterator = aiPlayer.getTileImprovementPlanIterator();
        while (tiIterator.hasNext()) {
            TileImprovementPlan ti = tiIterator.next();
            if (ti.getPioneer() != null) continue;
            return true;
        }
        return false;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(PioneeringMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        if (this.tileImprovementPlan != null) {
            out.writeAttribute("tileImprovementPlan", this.tileImprovementPlan.getId());
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        String tileImprovementPlanStr = in.getAttributeValue(null, "tileImprovementPlan");
        if (tileImprovementPlanStr != null) {
            this.tileImprovementPlan = (TileImprovementPlan)this.getAIMain().getAIObject(tileImprovementPlanStr);
            if (this.tileImprovementPlan == null) {
                this.tileImprovementPlan = new TileImprovementPlan(this.getAIMain(), tileImprovementPlanStr);
            }
        } else {
            this.tileImprovementPlan = null;
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "tileImprovementPlanMission";
    }

    public String getDebuggingInfo() {
        if (this.tileImprovementPlan != null) {
            String action = this.tileImprovementPlan.getType().getName();
            return this.tileImprovementPlan.getTarget().getPosition().toString() + " " + action;
        }
        PathNode bestPath = this.findColonyWithTools();
        if (bestPath != null) {
            return "Getting tools: " + bestPath.getLastNode().getTile().getPosition().toString();
        }
        return "No target";
    }
}

