/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class ScoutingMission
extends Mission {
    private static final Logger logger = Logger.getLogger(ScoutingMission.class.getName());
    private boolean valid = true;
    private EquipmentType scoutEquipment;
    private Tile transportDestination = null;
    private String debugAction = "";

    public ScoutingMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
    }

    public ScoutingMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public ScoutingMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void dispose() {
        super.dispose();
    }

    public void doMission(Connection connection) {
        Map map = this.getUnit().getGame().getMap();
        if (this.getUnit().getTile() == null) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        if (this.getUnit().getRole() != Unit.Role.SCOUT && this.getUnit().getColony() != null) {
            AIColony colony = (AIColony)this.getAIMain().getAIObject(this.getUnit().getColony());
            for (EquipmentType equipment : FreeCol.getSpecification().getEquipmentTypeList()) {
                if (equipment.getRole() != Unit.Role.SCOUT || !this.getUnit().canBeEquippedWith(equipment) || !colony.canBuildEquipment(equipment)) continue;
                Element equipUnitElement = Message.createNewRootElement("equipUnit");
                equipUnitElement.setAttribute("unit", this.getUnit().getId());
                equipUnitElement.setAttribute("type", equipment.getId());
                equipUnitElement.setAttribute("amount", "1");
                try {
                    connection.ask(equipUnitElement);
                    this.scoutEquipment = equipment;
                }
                catch (IOException e) {
                    logger.warning("Could not send \"equipUnit\"-message!");
                }
                return;
            }
            this.valid = false;
            return;
        }
        if (!ScoutingMission.isTarget(this.getUnit().getTile(), this.getUnit(), this.scoutEquipment)) {
            GoalDecider destinationDecider = new GoalDecider(){
                private PathNode best = null;

                public PathNode getGoal() {
                    return this.best;
                }

                public boolean hasSubGoals() {
                    return false;
                }

                public boolean check(Unit u, PathNode pathNode) {
                    Tile t = pathNode.getTile();
                    boolean target = ScoutingMission.isTarget(t, ScoutingMission.this.getUnit(), ScoutingMission.this.scoutEquipment);
                    if (target) {
                        this.best = pathNode;
                        ScoutingMission.this.debugAction = "Target: " + t.getPosition();
                    }
                    return target;
                }
            };
            PathNode bestPath = map.search(this.getUnit(), destinationDecider, Integer.MAX_VALUE);
            if (bestPath != null) {
                this.transportDestination = null;
                Map.Direction direction = this.moveTowards(connection, bestPath);
                if (direction != null) {
                    Unit.MoveType mt = this.getUnit().getMoveType(direction);
                    if (this.getUnit().getMoveType(direction) == Unit.MoveType.ENTER_INDIAN_VILLAGE_WITH_SCOUT) {
                        Element scoutMessage = Message.createNewRootElement("scoutIndianSettlement");
                        scoutMessage.setAttribute("unit", this.getUnit().getId());
                        scoutMessage.setAttribute("direction", direction.toString());
                        scoutMessage.setAttribute("action", "basic");
                        try {
                            connection.ask(scoutMessage);
                        }
                        catch (IOException e) {
                            logger.warning("Could not send \"scoutIndianSettlement\"-message!");
                            return;
                        }
                        scoutMessage.setAttribute("action", "speak");
                        try {
                            connection.ask(scoutMessage);
                        }
                        catch (IOException e) {
                            logger.warning("Could not send \"scoutIndianSettlement (speak)\"-message!");
                            return;
                        }
                        if (this.getUnit().isDisposed()) {
                            return;
                        }
                    } else if (mt != Unit.MoveType.ILLEGAL_MOVE && mt != Unit.MoveType.ATTACK) {
                        this.move(connection, direction);
                    }
                }
            } else {
                if (this.transportDestination != null && !ScoutingMission.isTarget(this.transportDestination, this.getUnit(), this.scoutEquipment)) {
                    this.transportDestination = null;
                }
                if (this.transportDestination == null) {
                    this.updateTransportDestination();
                }
            }
        }
        this.exploreLostCityRumour(connection);
        if (this.getUnit().isDisposed()) {
            return;
        }
        if (ScoutingMission.isTarget(this.getUnit().getTile(), this.getUnit(), this.scoutEquipment) && this.getUnit().getColony() != null && this.scoutEquipment != null) {
            Element equipUnitElement = Message.createNewRootElement("equipUnit");
            equipUnitElement.setAttribute("unit", this.getUnit().getId());
            equipUnitElement.setAttribute("type", this.scoutEquipment.getId());
            equipUnitElement.setAttribute("amount", "0");
            try {
                connection.ask(equipUnitElement);
                this.scoutEquipment = null;
            }
            catch (IOException e) {
                logger.warning("Could not send \"equipUnit (0)\"-message!");
                return;
            }
            this.debugAction = "Awaiting 52 horses";
        }
    }

    private void updateTransportDestination() {
        if (this.getUnit().getTile() == null) {
            this.transportDestination = (Tile)this.getUnit().getOwner().getEntryLocation();
        } else if (this.getUnit().isOnCarrier()) {
            GoalDecider destinationDecider = new GoalDecider(){
                private PathNode best = null;

                public PathNode getGoal() {
                    return this.best;
                }

                public boolean hasSubGoals() {
                    return false;
                }

                public boolean check(Unit u, PathNode pathNode) {
                    Tile t = pathNode.getTile();
                    boolean target = ScoutingMission.isTarget(t, ScoutingMission.this.getUnit(), ScoutingMission.this.scoutEquipment);
                    if (target) {
                        this.best = pathNode;
                        ScoutingMission.this.debugAction = "Target: " + t.getPosition();
                    }
                    return target;
                }
            };
            PathNode bestPath = this.getGame().getMap().search(this.getUnit(), destinationDecider, Integer.MAX_VALUE, (Unit)this.getUnit().getLocation());
            if (bestPath != null) {
                this.transportDestination = bestPath.getLastNode().getTile();
                this.debugAction = "Transport to: " + this.transportDestination.getPosition();
            } else {
                this.transportDestination = null;
                this.valid = false;
            }
        } else {
            Iterator<Map.Position> it = this.getGame().getMap().getFloodFillIterator(this.getUnit().getTile().getPosition());
            while (it.hasNext()) {
                Tile t = this.getGame().getMap().getTile(it.next());
                if (!ScoutingMission.isTarget(t, this.getUnit(), this.scoutEquipment)) continue;
                this.transportDestination = t;
                this.debugAction = "Transport to: " + this.transportDestination.getPosition();
                return;
            }
            this.transportDestination = null;
            this.valid = false;
        }
    }

    private static boolean isTarget(Tile t, Unit u, EquipmentType scoutEquipment) {
        if (t.hasLostCityRumour()) {
            return true;
        }
        if (scoutEquipment != null && t.getColony() != null && t.getColony().getOwner() == u.getOwner()) {
            for (AbstractGoods goods : scoutEquipment.getGoodsRequired()) {
                if (!goods.getType().isBreedable() || t.getColony().canBreed(goods.getType()) || t.getColony().getProductionNetOf(goods.getType()) <= 1) continue;
                return true;
            }
            return false;
        }
        return t.getSettlement() != null && t.getSettlement() instanceof IndianSettlement && !((IndianSettlement)t.getSettlement()).hasBeenVisited();
    }

    public Tile getTransportDestination() {
        if (this.getUnit().isOnCarrier() || this.getUnit().getTile() == null) {
            if (this.transportDestination == null || !this.transportDestination.isLand()) {
                this.updateTransportDestination();
            }
            return this.transportDestination;
        }
        if (this.getUnit().getTile() == this.transportDestination) {
            this.transportDestination = null;
            return null;
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 100;
        }
        return 0;
    }

    public boolean isValid() {
        Unit unit = this.getUnit();
        if (!unit.isMounted() && unit.getTile().getColony() == null) {
            return false;
        }
        return this.valid && super.isValid();
    }

    public static boolean isValid(AIUnit au) {
        if (au.getUnit().getTile() == null) {
            return true;
        }
        Iterator<Map.Position> it = au.getGame().getMap().getFloodFillIterator(au.getUnit().getTile().getPosition());
        while (it.hasNext()) {
            Tile t = au.getGame().getMap().getTile(it.next());
            if (!ScoutingMission.isTarget(t, au.getUnit(), null)) continue;
            return true;
        }
        return false;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(ScoutingMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "scoutingMission";
    }

    public String getDebuggingInfo() {
        return this.debugAction;
    }
}

