/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import org.w3c.dom.Element;

public class TransportMission
extends Mission {
    private static final Logger logger = Logger.getLogger(TransportMission.class.getName());
    private static final String ELEMENT_TRANSPORTABLE = "transportable";
    private static final int MINIMUM_GOLD_TO_STAY_IN_EUROPE = 600;
    private ArrayList<Transportable> transportList = new ArrayList();

    public TransportMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        if (!this.getUnit().isCarrier()) {
            logger.warning("Only carriers can transport unit/goods.");
            throw new IllegalArgumentException("Only carriers can transport unit/goods.");
        }
    }

    public TransportMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public TransportMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    private void updateTransportList() {
        Unit carrier = this.getUnit();
        Iterator<Unit> ui = carrier.getUnitIterator();
        while (ui.hasNext()) {
            Unit u = ui.next();
            AIUnit aiUnit = (AIUnit)this.getAIMain().getAIObject(u);
            this.addToTransportList(aiUnit);
        }
        LinkedList<Transportable> ts = new LinkedList<Transportable>();
        for (Transportable t : new LinkedList<Transportable>(this.transportList)) {
            if (ts.contains(t) || this.isCarrying(t)) {
                if (t.getTransportDestination() == null) {
                    this.removeFromTransportList(t);
                }
            } else if (t.getTransportSource() == null) {
                this.removeFromTransportList(t);
            }
            ts.add(t);
        }
    }

    private boolean isCarrying(Transportable t) {
        return t.getTransportLocatable().getLocation() == this.getUnit();
    }

    public void dispose() {
        ArrayList<Transportable> cargoList = new ArrayList<Transportable>();
        ArrayList<Transportable> scheduledCargoList = new ArrayList<Transportable>();
        for (Transportable t : this.transportList) {
            if (this.isCarrying(t)) {
                cargoList.add(t);
                continue;
            }
            scheduledCargoList.add(t);
        }
        for (Transportable t : cargoList) {
            ((AIObject)((Object)t)).dispose();
        }
        for (Transportable t : scheduledCargoList) {
            t.setTransport(null);
        }
        super.dispose();
    }

    public boolean isOnTransportList(Transportable newTransportable) {
        for (int i = 0; i < this.transportList.size(); ++i) {
            if (this.transportList.get(i) != newTransportable) continue;
            return true;
        }
        return false;
    }

    public void removeFromTransportList(Transportable transportable) {
        Iterator<Transportable> ti = this.transportList.iterator();
        while (ti.hasNext()) {
            Transportable t = ti.next();
            if (t != transportable) continue;
            ti.remove();
            if (transportable.getTransport() != this.getAIUnit()) continue;
            transportable.setTransport(null);
        }
    }

    public void addToTransportList(Transportable newTransportable) {
        int distToDestination;
        Transportable t1;
        int i;
        Unit carrier = this.getUnit();
        if (newTransportable.getTransportLocatable() instanceof Unit && ((Unit)newTransportable.getTransportLocatable()).isCarrier()) {
            throw new IllegalArgumentException("You cannot add a carrier to the transport list.");
        }
        Location newSource = newTransportable.getTransportSource();
        Location newDestination = newTransportable.getTransportDestination();
        if (newDestination == null) {
            if (newTransportable instanceof AIGoods) {
                logger.warning("No destination for goods: " + newTransportable.getTransportLocatable().toString());
                return;
            }
            logger.warning("No destination for: " + newTransportable.getTransportLocatable().toString());
            return;
        }
        if (newSource == null && !this.isCarrying(newTransportable)) {
            logger.warning("No source for: " + newTransportable.getTransportLocatable().toString());
            return;
        }
        if (this.isOnTransportList(newTransportable)) {
            return;
        }
        int bestSourceIndex = -1;
        if (!this.isCarrying(newTransportable)) {
            int distToSource;
            if (carrier.getLocation().getTile() == newSource.getTile()) {
                distToSource = 0;
            } else {
                distToSource = this.getDistanceTo(newTransportable, carrier.getTile() != null ? carrier.getTile() : carrier.getEntryLocation().getTile(), true);
                if (distToSource == Integer.MIN_VALUE) {
                    return;
                }
            }
            bestSourceIndex = 0;
            int bestSourceDistance = distToSource;
            for (i = 1; i < this.transportList.size() && bestSourceDistance > 0; ++i) {
                t1 = this.transportList.get(i - 1);
                if ((t1.getTransportSource() == null || t1.getTransportSource().getTile() != newSource.getTile()) && (t1.getTransportDestination() == null || t1.getTransportDestination().getTile() != newSource.getTile())) continue;
                bestSourceIndex = i;
                bestSourceDistance = 0;
            }
            for (i = 1; i < this.transportList.size() && bestSourceDistance > 0; ++i) {
                t1 = this.transportList.get(i - 1);
                if (this.isCarrying(t1)) {
                    distToDestination = this.getDistanceTo(newTransportable, t1.getTransportDestination(), true);
                    if (distToDestination == Integer.MIN_VALUE || distToDestination > bestSourceDistance) continue;
                    bestSourceIndex = i;
                    bestSourceDistance = distToDestination;
                    continue;
                }
                distToSource = this.getDistanceTo(newTransportable, t1.getTransportSource(), true);
                if (distToSource == Integer.MIN_VALUE || distToSource > bestSourceDistance) continue;
                bestSourceIndex = i;
                bestSourceDistance = distToSource;
            }
            this.transportList.add(bestSourceIndex, newTransportable);
        }
        int bestDestinationIndex = bestSourceIndex + 1;
        int bestDestinationDistance = Integer.MAX_VALUE;
        if (bestSourceIndex == -1) {
            bestDestinationIndex = 0;
            if (carrier.getTile() == newSource.getTile()) {
                bestDestinationDistance = 0;
            } else {
                int distToCarrier = this.getDistanceTo(newTransportable, carrier.getTile(), false);
                if (distToCarrier != Integer.MIN_VALUE) {
                    bestDestinationDistance = distToCarrier;
                }
            }
        }
        for (i = Math.max(bestSourceIndex, 1); i < this.transportList.size() && bestDestinationDistance > 0; ++i) {
            t1 = this.transportList.get(i - 1);
            if (t1.getTransportSource().getTile() != newDestination.getTile() && t1.getTransportDestination().getTile() != newDestination.getTile()) continue;
            bestDestinationIndex = i;
            bestDestinationDistance = 0;
        }
        for (i = Math.max(bestSourceIndex, 1); i < this.transportList.size() && bestDestinationDistance > 0; ++i) {
            t1 = this.transportList.get(i - 1);
            if (this.isCarrying(t1)) {
                distToDestination = this.getDistanceTo(newTransportable, t1.getTransportDestination(), false);
                if (distToDestination == Integer.MIN_VALUE || distToDestination > bestDestinationDistance) continue;
                bestDestinationIndex = i;
                bestDestinationDistance = distToDestination;
                continue;
            }
            int distToSource = this.getDistanceTo(newTransportable, t1.getTransportSource(), false);
            if (distToSource == Integer.MIN_VALUE || distToSource > bestDestinationDistance) continue;
            bestDestinationIndex = i;
            bestDestinationDistance = distToSource;
        }
        this.transportList.add(bestDestinationIndex, newTransportable);
        if (newTransportable.getTransport() != this.getAIUnit()) {
            newTransportable.setTransport(this.getAIUnit());
        }
    }

    private int getDistanceTo(Transportable t, Location start, boolean source) {
        PathNode path = this.getPath(t, start, source);
        if (path == null) {
            return Integer.MIN_VALUE;
        }
        return path.getTotalTurns();
    }

    public void doMission(Connection connection) {
        Unit carrier;
        if (this.transportList == null || this.transportList.size() <= 0) {
            this.updateTransportList();
        }
        if ((carrier = this.getUnit()).getLocation() instanceof Europe) {
            if (carrier.getState() == Unit.UnitState.TO_EUROPE || carrier.getState() == Unit.UnitState.TO_AMERICA) {
                return;
            }
            this.inEurope(connection);
            return;
        }
        this.restockCargoAtDestination(connection);
        boolean transportListChanged = false;
        boolean moreWork = true;
        for (int i = 0; i < this.transportList.size() && moreWork || i == 0; ++i) {
            moreWork = false;
            if (transportListChanged) {
                i = 0;
                transportListChanged = false;
            }
            boolean moveToEurope = false;
            PathNode path = null;
            if (i == 0 && this.transportList.size() == 0) {
                path = this.findPathToEurope(carrier.getTile());
                moveToEurope = true;
            } else {
                Transportable transportable = this.transportList.get(i);
                try {
                    path = this.getPath(transportable);
                    moveToEurope = this.isCarrying(transportable) ? transportable.getTransportDestination() instanceof Europe : transportable.getTransportLocatable().getLocation() instanceof Europe;
                }
                catch (IllegalArgumentException e) {
                    transportListChanged = this.restockCargoAtDestination(connection);
                    continue;
                }
            }
            if (path != null) {
                Map.Direction r = this.moveTowards(connection, path);
                if (r != null && (carrier.getMoveType(r) == Unit.MoveType.MOVE || carrier.getMoveType(r) == Unit.MoveType.MOVE_HIGH_SEAS)) {
                    if (carrier.getMoveType(r) == Unit.MoveType.MOVE_HIGH_SEAS && moveToEurope) {
                        this.moveUnitToEurope(connection, carrier);
                    } else {
                        this.move(connection, r);
                    }
                    if (!(carrier.getLocation() instanceof Europe)) {
                        moreWork = true;
                    }
                }
                transportListChanged = this.restockCargoAtDestination(connection);
                continue;
            }
            if (!moveToEurope || !carrier.canMoveToEurope()) continue;
            this.moveUnitToEurope(connection, carrier);
        }
    }

    private void buyCargo(Connection connection) {
        AIColony ac;
        AIUnit newUnit;
        int space;
        AIPlayer aiPlayer = (AIPlayer)this.getAIMain().getAIObject(this.getUnit().getOwner().getId());
        if (!(this.getUnit().getLocation() instanceof Europe)) {
            throw new IllegalStateException("Carrier not in Europe");
        }
        if (aiPlayer.hasFewColonies()) {
            Unit carrier = this.getUnit();
            Tile colonyTile = BuildColonyMission.findColonyLocation(carrier);
            for (space = this.getAvailableSpace(); colonyTile != null && space > 0; --space) {
                newUnit = this.getCheapestUnitInEurope(connection);
                if (newUnit != null) {
                    if (newUnit.getUnit().isColonist() && !newUnit.getUnit().isArmed() && !newUnit.getUnit().isMounted() && newUnit.getUnit().getRole() != Unit.Role.PIONEER) {
                        int colonyValue = aiPlayer.getPlayer().getColonyValue(colonyTile);
                        newUnit.setMission(new BuildColonyMission(this.getAIMain(), newUnit, colonyTile, colonyValue));
                    }
                    this.addToTransportList(newUnit);
                    continue;
                }
                return;
            }
        }
        ArrayList<AIColony> aiColonies = new ArrayList<AIColony>();
        for (int i = 0; i < this.transportList.size(); ++i) {
            Transportable t = this.transportList.get(i);
            if (t.getTransportDestination() == null || t.getTransportDestination().getTile() == null || t.getTransportDestination().getTile().getColony() == null || t.getTransportDestination().getTile().getColony().getOwner() != this.getUnit().getOwner()) continue;
            ac = (AIColony)this.getAIMain().getAIObject(t.getTransportDestination().getTile().getColony().getId());
            aiColonies.add(ac);
        }
        Iterator<Wish> highValueWishIterator = ((AIPlayer)this.getAIMain().getAIObject(this.getUnit().getOwner().getId())).getWishIterator();
        while (highValueWishIterator.hasNext()) {
            AIColony ac2;
            Colony c;
            Wish w = highValueWishIterator.next();
            if (w.getTransportable() != null) continue;
            if (w instanceof WorkerWish && w.getDestination() instanceof Colony) {
                WorkerWish ww = (WorkerWish)w;
                c = (Colony)ww.getDestination();
                ac2 = (AIColony)this.getAIMain().getAIObject(c);
                if (aiColonies.contains(ac2)) continue;
                aiColonies.add(ac2);
                continue;
            }
            if (w instanceof GoodsWish && w.getDestination() instanceof Colony) {
                GoodsWish gw = (GoodsWish)w;
                c = (Colony)gw.getDestination();
                ac2 = (AIColony)this.getAIMain().getAIObject(c);
                if (aiColonies.contains(ac2)) continue;
                aiColonies.add(ac2);
                continue;
            }
            logger.warning("Unknown type of wish: " + w);
        }
        for (int i = 0; i < aiColonies.size(); ++i) {
            ac = (AIColony)aiColonies.get(i);
            int space2 = this.getAvailableSpace(this.getUnit().getType(), this.getUnit().getOwner().getEurope(), ac.getColony());
            Iterator<Wish> wishIterator = ac.getWishIterator();
            while (space2 > 0 && wishIterator.hasNext()) {
                Wish w = wishIterator.next();
                if (w.getTransportable() != null) continue;
                if (w instanceof WorkerWish) {
                    WorkerWish ww = (WorkerWish)w;
                    AIUnit newUnit2 = this.getUnitInEurope(connection, ww.getUnitType());
                    if (newUnit2 == null) continue;
                    newUnit2.setMission(new WishRealizationMission(this.getAIMain(), newUnit2, ww));
                    ww.setTransportable(newUnit2);
                    this.addToTransportList(newUnit2);
                    --space2;
                    continue;
                }
                if (w instanceof GoodsWish) {
                    GoodsWish gw = (GoodsWish)w;
                    AIGoods ag = this.buyGoodsInEurope(connection, gw.getGoodsType(), 100, gw.getDestination());
                    if (ag == null) continue;
                    gw.setTransportable(ag);
                    this.addToTransportList(ag);
                    --space2;
                    continue;
                }
                logger.warning("Unknown type of wish: " + w);
            }
        }
        for (space = this.getAvailableSpace(); space > 0 && (newUnit = this.getCheapestUnitInEurope(connection)) != null; --space) {
            this.addToTransportList(newUnit);
        }
    }

    public AIGoods buyGoodsInEurope(Connection connection, GoodsType type, int amount, Location destination) {
        AIPlayer aiPlayer = (AIPlayer)this.getAIMain().getAIObject(this.getUnit().getOwner().getId());
        Player player = aiPlayer.getPlayer();
        Market market = player.getMarket();
        if (player.getGold() >= market.getBidPrice(type, amount)) {
            Element buyGoodsElement = Message.createNewRootElement("buyGoods");
            buyGoodsElement.setAttribute("carrier", this.getUnit().getId());
            buyGoodsElement.setAttribute("type", type.getId());
            buyGoodsElement.setAttribute("amount", Integer.toString(amount));
            try {
                connection.sendAndWait(buyGoodsElement);
            }
            catch (IOException e) {
                logger.warning("Could not send \"buyGoods\"-message to the server.");
                return null;
            }
            AIGoods ag = new AIGoods(this.getAIMain(), this.getUnit(), type, amount, destination);
            return ag;
        }
        return null;
    }

    private AIUnit getUnitInEurope(Connection connection, UnitType unitType) {
        AIPlayer aiPlayer = (AIPlayer)this.getAIMain().getAIObject(this.getUnit().getOwner().getId());
        Player player = aiPlayer.getPlayer();
        Europe europe = player.getEurope();
        if (!(this.getUnit().getLocation() instanceof Europe)) {
            throw new IllegalStateException("Carrier not in Europe");
        }
        Iterator<Unit> ui = europe.getUnitIterator();
        while (ui.hasNext()) {
            Unit u = ui.next();
            if (unitType != null && unitType != u.getType()) continue;
            return (AIUnit)this.getAIMain().getAIObject(u.getId());
        }
        if (player.getGold() >= player.getRecruitPrice()) {
            for (int i = 0; i < 3; ++i) {
                if (europe.getRecruitable(i) != unitType) continue;
                return aiPlayer.recruitAIUnitInEurope(i);
            }
        }
        if (unitType.hasPrice() && europe.getUnitPrice(unitType) >= 0 && player.getGold() >= europe.getUnitPrice(unitType)) {
            return aiPlayer.trainAIUnitInEurope(unitType);
        }
        return null;
    }

    private AIUnit getCheapestUnitInEurope(Connection connection) {
        AIPlayer aiPlayer = (AIPlayer)this.getAIMain().getAIObject(this.getUnit().getOwner().getId());
        Player player = aiPlayer.getPlayer();
        Europe europe = player.getEurope();
        if (!(this.getUnit().getLocation() instanceof Europe)) {
            throw new IllegalStateException("Carrier not in Europe");
        }
        if (!player.canRecruitUnits()) {
            return null;
        }
        Iterator<Unit> ui = europe.getUnitIterator();
        while (ui.hasNext()) {
            Unit u = ui.next();
            if (u.isCarrier() || ((AIUnit)this.getAIMain().getAIObject(u)).getTransport() != null) continue;
            return (AIUnit)this.getAIMain().getAIObject(u.getId());
        }
        int priceTrained = 0;
        UnitType cheapestTrained = null;
        List<UnitType> unitTypes = FreeCol.getSpecification().getUnitTypesTrainedInEurope();
        for (UnitType unitType : unitTypes) {
            int price = europe.getUnitPrice(unitType);
            if (cheapestTrained != null && price >= priceTrained) continue;
            cheapestTrained = unitType;
            priceTrained = price;
        }
        if (player.getGold() >= player.getRecruitPrice() && cheapestTrained != null && player.getRecruitPrice() < priceTrained) {
            return aiPlayer.recruitAIUnitInEurope(1);
        }
        if (cheapestTrained != null && player.getGold() >= priceTrained) {
            return aiPlayer.trainAIUnitInEurope(cheapestTrained);
        }
        return null;
    }

    public PathNode getPath(Transportable transportable) {
        return this.getPath(transportable, this.getUnit().getTile(), !this.isCarrying(transportable));
    }

    private PathNode getPath(Transportable transportable, Location start, boolean source) {
        PathNode path;
        Location destination;
        Unit carrier = this.getUnit();
        if (this.isCarrying(transportable) && source) {
            throw new IllegalStateException("Cannot find the path to the source while the transportable is on the carrier.");
        }
        Locatable locatable = transportable.getTransportLocatable();
        if (start == null || start.getTile() == null) {
            start = this.getUnit().getEntryLocation();
        }
        if ((destination = source ? locatable.getLocation() : transportable.getTransportDestination()) == null) {
            return null;
        }
        if (destination instanceof Europe) {
            path = this.findPathToEurope(start.getTile());
        } else if (locatable instanceof Unit && this.isCarrying(transportable)) {
            path = this.getGame().getMap().findPath((Unit)locatable, start.getTile(), destination.getTile(), carrier);
            if (path == null || path.getTransportDropNode().previous == null) {
                path = null;
            } else {
                path.getTransportDropNode().previous.next = null;
            }
        } else {
            path = this.getGame().getMap().findPath(carrier, start.getTile(), destination.getTile());
        }
        return path;
    }

    public int getAvailableSpace(Transportable t) {
        if (t.getTransportLocatable() instanceof Unit) {
            Unit u = (Unit)t.getTransportLocatable();
            return this.getAvailableSpace(u.getType(), t.getTransportSource(), t.getTransportDestination());
        }
        return this.getAvailableSpace(null, t.getTransportSource(), t.getTransportDestination());
    }

    public int getAvailableSpace(UnitType unitType, Location source, Location destination) {
        return Math.max(0, this.getUnit().getSpaceLeft() - this.transportList.size());
    }

    public int getAvailableSpace() {
        return Math.max(0, this.getUnit().getSpaceLeft() - this.transportList.size());
    }

    private boolean restockCargoAtDestination(Connection connection) {
        return this.unloadCargoAtDestination(connection) | this.loadCargoAtDestination(connection);
    }

    private boolean unloadCargoAtDestination(Connection connection) {
        Unit carrier = this.getUnit();
        boolean transportListChanged = false;
        for (Transportable t : new ArrayList<Transportable>(this.transportList)) {
            if (!this.isCarrying(t)) continue;
            if (t instanceof AIUnit) {
                PathNode p;
                AIUnit au = (AIUnit)t;
                Unit u = au.getUnit();
                Mission mission = au.getMission();
                if (mission == null || !mission.isValid()) continue;
                if (au.getTransportDestination() != null && au.getTransportDestination().getTile() == carrier.getTile() && carrier.getState() != Unit.UnitState.TO_EUROPE && carrier.getState() != Unit.UnitState.TO_AMERICA) {
                    if (u.getLocation() instanceof Europe || u.getColony() != null) {
                        this.unitLeavesShip(connection, u);
                    }
                    mission.doMission(connection);
                    if (u.getLocation() == this.getUnit()) continue;
                    this.removeFromTransportList(au);
                    transportListChanged = true;
                    continue;
                }
                if (carrier.getLocation() instanceof Europe || au.getTransportDestination() == null || au.getTransportDestination().getTile() == null || (p = this.getGame().getMap().findPath(u, carrier.getTile(), au.getTransportDestination().getTile(), carrier)) == null) continue;
                PathNode dropNode = p.getTransportDropNode();
                int distToCarrier = dropNode.getTile().getDistanceTo(carrier.getTile());
                if (dropNode == null || distToCarrier == Integer.MIN_VALUE || distToCarrier > 1) continue;
                mission.doMission(connection);
                if (u.getLocation() == this.getUnit()) continue;
                this.removeFromTransportList(au);
                transportListChanged = true;
                continue;
            }
            if (t instanceof AIGoods) {
                AIGoods ag = (AIGoods)t;
                if (ag.getTransportDestination() == null || ag.getTransportDestination().getTile() != carrier.getLocation().getTile() || carrier.getState() == Unit.UnitState.TO_EUROPE || carrier.getState() == Unit.UnitState.TO_AMERICA) continue;
                if (carrier.getLocation() instanceof Europe) {
                    boolean success = this.sellCargoInEurope(connection, carrier, ag.getGoods());
                    if (!success) continue;
                    this.removeFromTransportList(ag);
                    ag.dispose();
                    transportListChanged = true;
                    continue;
                }
                boolean success = this.unloadCargoInColony(connection, carrier, ag.getGoods());
                if (!success) continue;
                this.removeFromTransportList(ag);
                ag.dispose();
                transportListChanged = true;
                continue;
            }
            logger.warning("Unknown Transportable.");
        }
        return transportListChanged;
    }

    private boolean loadCargoAtDestination(Connection connection) {
        Unit carrier = this.getUnit();
        boolean transportListChanged = false;
        Iterator<Transportable> tli = this.transportList.iterator();
        while (tli.hasNext()) {
            Transportable t = tli.next();
            if (this.isCarrying(t)) continue;
            if (t instanceof AIUnit) {
                AIUnit au = (AIUnit)t;
                Unit u = au.getUnit();
                if (u.getTile() != carrier.getTile() || carrier.getState() == Unit.UnitState.TO_EUROPE || carrier.getState() == Unit.UnitState.TO_AMERICA) continue;
                Element boardShipElement = Message.createNewRootElement("boardShip");
                boardShipElement.setAttribute("unit", u.getId());
                boardShipElement.setAttribute("carrier", carrier.getId());
                try {
                    connection.sendAndWait(boardShipElement);
                    tli.remove();
                    transportListChanged = true;
                }
                catch (IOException e) {
                    logger.warning("Could not send \"boardShipElement\"-message!");
                }
                continue;
            }
            if (t instanceof AIGoods) {
                AIGoods ag = (AIGoods)t;
                if (ag.getGoods().getTile() != carrier.getTile() || carrier.getState() == Unit.UnitState.TO_EUROPE || carrier.getState() == Unit.UnitState.TO_AMERICA) continue;
                if (carrier.getLocation() instanceof Europe) {
                    Element buyGoodsElement = Message.createNewRootElement("buyGoods");
                    buyGoodsElement.setAttribute("carrier", carrier.getId());
                    buyGoodsElement.setAttribute("type", Integer.toString(ag.getGoods().getType().getIndex()));
                    buyGoodsElement.setAttribute("amount", Integer.toString(ag.getGoods().getAmount()));
                    try {
                        connection.sendAndWait(buyGoodsElement);
                        tli.remove();
                        transportListChanged = true;
                    }
                    catch (IOException e) {
                        logger.warning("Could not send \"buyGoodsElement\"-message!");
                    }
                    ag.setGoods(new Goods(this.getGame(), carrier, ag.getGoods().getType(), ag.getGoods().getAmount()));
                    continue;
                }
                Element loadCargoElement = Message.createNewRootElement("loadCargo");
                loadCargoElement.setAttribute("carrier", carrier.getId());
                loadCargoElement.appendChild(ag.getGoods().toXMLElement(carrier.getOwner(), loadCargoElement.getOwnerDocument()));
                try {
                    connection.sendAndWait(loadCargoElement);
                    tli.remove();
                    transportListChanged = true;
                }
                catch (IOException e) {
                    logger.warning("Could not send \"loadCargoElement\"-message!");
                }
                ag.setGoods(new Goods(this.getGame(), carrier, ag.getGoods().getType(), ag.getGoods().getAmount()));
                continue;
            }
            logger.warning("Unknown Transportable.");
        }
        return transportListChanged;
    }

    public static boolean isValid(AIUnit aiUnit) {
        AIPlayer aiPlayer;
        int transportMissions;
        boolean hasCargo;
        Unit unit = aiUnit.getUnit();
        if (!unit.isNaval()) {
            return true;
        }
        if (unit.isUnderRepair()) {
            return false;
        }
        boolean bl = hasCargo = unit.getGoodsCount() > 0 || unit.getUnitCount() > 0;
        if (hasCargo) {
            return true;
        }
        if (unit.hasAbility("model.ability.piracy") && (transportMissions = TransportMission.getPlayerNavalTransportMissionCount(aiPlayer = (AIPlayer)aiUnit.getAIMain().getAIObject(unit.getOwner().getId()), unit)) > 0) {
            logger.finest("Privateer (" + unit.getId() + ") at " + unit.getTile() + " does no longer have TransportMission");
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        AIUnit aiUnit = this.getAIUnit();
        return TransportMission.isValid(aiUnit);
    }

    public Tile getTransportDestination() {
        return null;
    }

    public int getTransportPriority() {
        return 0;
    }

    private void inEurope(Connection connection) {
        this.restockCargoAtDestination(connection);
        this.buyCargo(connection);
        this.restockCargoAtDestination(connection);
        Unit carrier = this.getUnit();
        if (carrier.getOwner().getGold() < 600 || this.transportList.size() > 0) {
            this.moveUnitToAmerica(connection, carrier);
        }
    }

    protected PathNode findPathToEurope(Tile start) {
        return this.getGame().getMap().findPathToEurope(this.getUnit(), start);
    }

    public static int getPlayerNavalTransportMissionCount(AIPlayer aiPlayer, Unit unitExcluded) {
        Player player = aiPlayer.getPlayer();
        int units = 0;
        for (Unit unit : player.getUnits()) {
            AIUnit aiUnit;
            if (unit == unitExcluded || !unit.isNaval() || !((aiUnit = (AIUnit)aiPlayer.getAIMain().getAIObject(unit)).getMission() instanceof TransportMission)) continue;
            ++units;
        }
        return units;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(TransportMission.getXMLElementTagName());
        out.writeAttribute("unit", this.getUnit().getId());
        for (Transportable t : this.transportList) {
            out.writeStartElement(ELEMENT_TRANSPORTABLE);
            out.writeAttribute("ID", ((AIObject)((Object)t)).getId());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        this.transportList.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(ELEMENT_TRANSPORTABLE)) {
                String tid = in.getAttributeValue(null, "ID");
                AIObject ao = this.getAIMain().getAIObject(tid);
                if (ao == null) {
                    ao = tid.startsWith(Unit.getXMLElementTagName()) ? new AIUnit(this.getAIMain(), tid) : new AIGoods(this.getAIMain(), tid);
                }
                if (!(ao instanceof Transportable)) {
                    logger.warning("AIObject not Transportable, ID: " + in.getAttributeValue(null, "ID"));
                } else {
                    this.transportList.add((Transportable)((Object)ao));
                }
                in.nextTag();
                continue;
            }
            logger.warning("Unknown tag.");
        }
    }

    public static String getXMLElementTagName() {
        return "transportMission";
    }

    public String getDebuggingInfo() {
        Unit carrier = this.getUnit();
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Transport list:\n");
        LinkedList<Transportable> ts = new LinkedList<Transportable>();
        for (Transportable t : this.transportList) {
            Location target;
            Locatable l = t.getTransportLocatable();
            sb.append(l.toString());
            sb.append(" (");
            if (ts.contains(t) || this.isCarrying(t)) {
                sb.append("to ");
                target = t.getTransportDestination();
            } else {
                sb.append("from ");
                target = t.getTransportSource();
            }
            if (target instanceof Europe) {
                sb.append("Europe");
            } else if (target == null) {
                sb.append("null");
            } else {
                sb.append(target.getTile().getPosition());
            }
            sb.append(")");
            sb.append("\n");
            ts.add(t);
        }
        return sb.toString();
    }
}

