/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class WishRealizationMission
extends Mission {
    private static final Logger logger = Logger.getLogger(WishRealizationMission.class.getName());
    private Wish wish;

    public WishRealizationMission(AIMain aiMain, AIUnit aiUnit, Wish wish) {
        super(aiMain, aiUnit);
        this.wish = wish;
        if (wish == null) {
            throw new NullPointerException("wish == null");
        }
    }

    public WishRealizationMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public WishRealizationMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void dispose() {
        if (this.wish != null) {
            this.wish.setTransportable(null);
            this.wish = null;
        }
        super.dispose();
    }

    public void doMission(Connection connection) {
        Unit unit = this.getUnit();
        if (!this.isValid()) {
            return;
        }
        if (this.getUnit().getTile() != null) {
            if (this.wish.getDestination().getTile() != this.getUnit().getTile()) {
                Map.Direction r = this.moveTowards(connection, this.wish.getDestination().getTile());
                this.moveButDontAttack(connection, r);
            }
            if (this.wish.getDestination().getTile() == this.getUnit().getTile()) {
                if (this.wish.getDestination() instanceof Colony) {
                    Colony colony = (Colony)this.wish.getDestination();
                    Element workElement = Message.createNewRootElement("work");
                    workElement.setAttribute("unit", unit.getId());
                    workElement.setAttribute("workLocation", colony.getVacantWorkLocationFor(this.getUnit()).getId());
                    try {
                        connection.sendAndWait(workElement);
                    }
                    catch (IOException e) {
                        logger.warning("Could not send \"work\"-message.");
                    }
                    this.getAIUnit().setMission(new WorkInsideColonyMission(this.getAIMain(), this.getAIUnit(), (AIColony)this.getAIMain().getAIObject(colony)));
                } else {
                    logger.warning("Unknown type of destination for: " + this.wish);
                }
            }
        }
    }

    public Tile getTransportDestination() {
        if (this.getUnit().isOnCarrier()) {
            return this.wish.getDestination().getTile();
        }
        if (this.getUnit().getTile() == this.wish.getDestination().getTile()) {
            return null;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.wish.getDestination().getTile()) == null) {
            return this.wish.getDestination().getTile();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getUnit().isOnCarrier()) {
            return 100;
        }
        if (this.getUnit().getLocation().getTile() == this.wish.getDestination().getTile()) {
            return 0;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.wish.getDestination().getTile()) == null) {
            return 100;
        }
        return 0;
    }

    public boolean isValid() {
        Colony colony;
        Location l = this.wish.getDestination();
        if (l == null) {
            return false;
        }
        if (((FreeColGameObject)((Object)l)).isDisposed()) {
            return false;
        }
        if (l instanceof Ownable && ((Ownable)((Object)l)).getOwner() != this.getUnit().getOwner()) {
            return false;
        }
        return !(l instanceof Colony) || (colony = (Colony)l).getVacantWorkLocationFor(this.getUnit()) != null;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.wish.shouldBeStored()) {
            out.writeStartElement(WishRealizationMission.getXMLElementTagName());
            out.writeAttribute("unit", this.getUnit().getId());
            out.writeAttribute("wish", this.wish.getId());
            out.writeEndElement();
        }
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setAIUnit((AIUnit)this.getAIMain().getAIObject(in.getAttributeValue(null, "unit")));
        this.wish = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "wish"));
        if (this.wish == null) {
            String wid = in.getAttributeValue(null, "wish");
            if (wid.startsWith(GoodsWish.getXMLElementTagName())) {
                this.wish = new GoodsWish(this.getAIMain(), wid);
            } else if (wid.startsWith(WorkerWish.getXMLElementTagName())) {
                this.wish = new WorkerWish(this.getAIMain(), wid);
            } else {
                logger.warning("Unknown type of Wish.");
            }
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "wishRealizationMission";
    }

    public String getDebuggingInfo() {
        if (this.wish == null) {
            return "No wish";
        }
        return this.wish.getDestination().getTile().getPosition() + " " + this.wish.getValue();
    }
}

