/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelController;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameController
extends Controller {
    private static Logger logger = Logger.getLogger(InGameController.class.getName());
    public int debugOnlyAITurns = 0;
    private java.util.Map<String, java.util.Map<String, java.util.Map<String, Object>>> transactionSessions = new HashMap<String, java.util.Map<String, java.util.Map<String, Object>>>();

    public InGameController(FreeColServer freeColServer) {
        super(freeColServer);
    }

    public void endTurn(ServerPlayer player) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer oldPlayer = (ServerPlayer)this.getGame().getCurrentPlayer();
        if (oldPlayer != player) {
            logger.warning("It is not " + player.getName() + "'s turn!");
            throw new IllegalArgumentException("It is not " + player.getName() + "'s turn!");
        }
        player.clearModelMessages();
        freeColServer.getModelController().clearTaskRegister();
        Player winner = this.checkForWinner();
        if (!(winner == null || freeColServer.isSingleplayer() && winner.isAI())) {
            Element gameEndedElement = Message.createNewRootElement("gameEnded");
            gameEndedElement.setAttribute("winner", winner.getId());
            freeColServer.getServer().sendToAll(gameEndedElement, null);
            if (FreeCol.getFreeColClient() == null) {
                new Timer(true).schedule(new TimerTask(){

                    public void run() {
                        System.exit(0);
                    }
                }, 20000L);
            }
            return;
        }
        ServerPlayer newPlayer = (ServerPlayer)this.nextPlayer();
        if (!(newPlayer == null || newPlayer.isAI() || newPlayer.isConnected() && this.debugOnlyAITurns <= 0)) {
            this.endTurn(newPlayer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Player nextPlayer() {
        FreeColServer freeColServer = this.getFreeColServer();
        if (!this.isHumanPlayersLeft()) {
            this.getGame().setCurrentPlayer(null);
            return null;
        }
        if (this.getGame().isNextPlayerInNewTurn()) {
            this.getGame().newTurn();
            if (this.debugOnlyAITurns > 0) {
                --this.debugOnlyAITurns;
            }
            Element newTurnElement = Message.createNewRootElement("newTurn");
            freeColServer.getServer().sendToAll(newTurnElement, null);
        }
        ServerPlayer newPlayer = (ServerPlayer)this.getGame().getNextPlayer();
        this.getGame().setCurrentPlayer(newPlayer);
        if (newPlayer == null) {
            this.getGame().setCurrentPlayer(null);
            return null;
        }
        ServerPlayer serverPlayer = newPlayer;
        synchronized (serverPlayer) {
            if (Player.checkForDeath(newPlayer)) {
                newPlayer.setDead(true);
                Element setDeadElement = Message.createNewRootElement("setDead");
                setDeadElement.setAttribute("player", newPlayer.getId());
                freeColServer.getServer().sendToAll(setDeadElement, null);
                return this.nextPlayer();
            }
        }
        if (newPlayer.isEuropean()) {
            try {
                Market market = newPlayer.getMarket();
                List<GoodsType> goodsTypes = FreeCol.getSpecification().getGoodsTypeList();
                GoodsType typeToRemove = goodsTypes.get(this.getPseudoRandom().nextInt(goodsTypes.size()));
                if (typeToRemove.isStorable()) {
                    int amountToRemove = this.getPseudoRandom().nextInt(21);
                    market.remove(typeToRemove, amountToRemove);
                    Element updateElement = Message.createNewRootElement("marketElement");
                    updateElement.setAttribute("type", typeToRemove.getId());
                    updateElement.setAttribute("amount", String.valueOf(-amountToRemove));
                    newPlayer.getConnection().send(updateElement);
                }
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + newPlayer.getName() + " with connection " + newPlayer.getConnection());
            }
            if (newPlayer.getCurrentFather() == null && newPlayer.getSettlements().size() > 0) {
                this.chooseFoundingFather(newPlayer);
            }
            if (newPlayer.getMonarch() != null) {
                this.monarchAction(newPlayer);
            }
            this.bombardEnemyShips(newPlayer);
        } else if (newPlayer.isIndian()) {
            for (IndianSettlement indianSettlement : newPlayer.getIndianSettlements()) {
                List<UnitType> converts;
                Tile t;
                if (!indianSettlement.checkForNewMissionaryConvert()) continue;
                Unit missionary = indianSettlement.getMissionary();
                ServerPlayer european = (ServerPlayer)missionary.getOwner();
                Tile settlementTile = indianSettlement.getTile();
                Tile targetTile = null;
                Iterator<Map.Position> ffi = this.getGame().getMap().getFloodFillIterator(settlementTile.getPosition());
                while (ffi.hasNext() && settlementTile.getDistanceTo(t = this.getGame().getMap().getTile(ffi.next())) <= 10) {
                    if (t.getSettlement() == null || t.getSettlement().getOwner() != european) continue;
                    targetTile = t;
                    break;
                }
                if (targetTile == null || (converts = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.convert")).size() <= 0) continue;
                Unit brave = indianSettlement.getUnitIterator().next();
                String nationId = brave.getOwner().getNationID();
                brave.dispose();
                ModelController modelController = this.getGame().getModelController();
                int random = modelController.getRandom(indianSettlement.getId() + "getNewConvertType", converts.size());
                UnitType unitType = converts.get(random);
                Unit unit = modelController.createUnit(indianSettlement.getId() + "newTurn100missionary", targetTile, european, unitType);
                try {
                    Element updateElement = Message.createNewRootElement("newConvert");
                    updateElement.setAttribute("nation", nationId);
                    updateElement.setAttribute("colonyTile", targetTile.getId());
                    updateElement.appendChild(unit.toXMLElement(european, updateElement.getOwnerDocument()));
                    european.getConnection().send(updateElement);
                    logger.info("New convert created for " + european.getName() + " with ID=" + unit.getId());
                }
                catch (IOException e) {
                    logger.warning("Could not send message to: " + european.getName());
                }
            }
        }
        Element setCurrentPlayerElement = Message.createNewRootElement("setCurrentPlayer");
        setCurrentPlayerElement.setAttribute("player", newPlayer.getId());
        freeColServer.getServer().sendToAll(setCurrentPlayerElement, null);
        return newPlayer;
    }

    private boolean isHumanPlayersLeft() {
        for (Player player : this.getFreeColServer().getGame().getPlayers()) {
            if (player.isDead() || player.isAI() || !((ServerPlayer)player).isConnected()) continue;
            return true;
        }
        return false;
    }

    private void chooseFoundingFather(ServerPlayer player) {
        final ServerPlayer nextPlayer = player;
        Thread t = new Thread("FreeColServer:FoundingFather-thread"){

            public void run() {
                List randomFoundingFathers = InGameController.this.getRandomFoundingFathers(nextPlayer);
                boolean atLeastOneChoice = false;
                Element chooseFoundingFatherElement = Message.createNewRootElement("chooseFoundingFather");
                for (FoundingFather father : randomFoundingFathers) {
                    chooseFoundingFatherElement.setAttribute(father.getType().toString(), father.getId());
                    atLeastOneChoice = true;
                }
                if (!atLeastOneChoice) {
                    nextPlayer.setCurrentFather(null);
                } else {
                    try {
                        FoundingFather father;
                        Element reply = nextPlayer.getConnection().ask(chooseFoundingFatherElement);
                        father = FreeCol.getSpecification().getFoundingFather(reply.getAttribute("foundingFather"));
                        if (!randomFoundingFathers.contains(father)) {
                            throw new IllegalArgumentException();
                        }
                        nextPlayer.setCurrentFather(father);
                    }
                    catch (IOException e) {
                        logger.warning("Could not send message to: " + nextPlayer.getName());
                    }
                }
            }
        };
        t.start();
    }

    private List<FoundingFather> getRandomFoundingFathers(Player player) {
        int age = this.getGame().getTurn().getAge();
        ArrayList<FoundingFather> randomFoundingFathers = new ArrayList<FoundingFather>();
        EnumMap<FoundingFather.FoundingFatherType, Integer> weightSums = new EnumMap<FoundingFather.FoundingFatherType, Integer>(FoundingFather.FoundingFatherType.class);
        for (FoundingFather foundingFather : FreeCol.getSpecification().getFoundingFathers()) {
            if (player.hasFather(foundingFather) || !foundingFather.isAvailableTo(player)) continue;
            Integer weightSum = (Integer)weightSums.get((Object)foundingFather.getType());
            if (weightSum == null) {
                weightSum = new Integer(0);
            }
            weightSums.put(foundingFather.getType(), weightSum + foundingFather.getWeight(age));
        }
        block1: for (Map.Entry entry : weightSums.entrySet()) {
            if ((Integer)entry.getValue() == 0) continue;
            int r = this.getPseudoRandom().nextInt((Integer)entry.getValue()) + 1;
            int weightSum = 0;
            for (FoundingFather father : FreeCol.getSpecification().getFoundingFathers()) {
                if (player.hasFather(father) || father.getType() != entry.getKey() || (weightSum += father.getWeight(age)) < r) continue;
                randomFoundingFathers.add(father);
                continue block1;
            }
        }
        return randomFoundingFathers;
    }

    public Player checkForWinner() {
        Player winner;
        List<Player> players = this.getGame().getPlayers();
        GameOptions go = this.getGame().getGameOptions();
        if (go.getBoolean("model.option.victoryDefeatREF")) {
            for (Player player : players) {
                if (player.isAI() || player.getPlayerType() != Player.PlayerType.INDEPENDENT) continue;
                return player;
            }
        }
        if (go.getBoolean("model.option.victoryDefeatEuropeans")) {
            winner = null;
            for (Player player : players) {
                if (player.isDead() || !player.isEuropean() || player.isREF()) continue;
                if (winner != null) {
                    winner = null;
                    break;
                }
                winner = player;
            }
            if (winner != null) {
                return winner;
            }
        }
        if (go.getBoolean("model.option.victoryDefeatHumans")) {
            winner = null;
            for (Player player : players) {
                if (player.isDead() || player.isAI()) continue;
                if (winner != null) {
                    winner = null;
                    break;
                }
                winner = player;
            }
            if (winner != null) {
                return winner;
            }
        }
        return null;
    }

    private void monarchAction(ServerPlayer player) {
        final ServerPlayer nextPlayer = player;
        Thread t = new Thread("monarchAction"){

            public void run() {
                try {
                    Monarch monarch = nextPlayer.getMonarch();
                    Monarch.MonarchAction action = monarch.getAction();
                    Element monarchActionElement = Message.createNewRootElement("monarchAction");
                    monarchActionElement.setAttribute("action", String.valueOf((Object)action));
                    switch (action) {
                        case RAISE_TAX: {
                            int oldTax = nextPlayer.getTax();
                            int newTax = monarch.getNewTax(Monarch.MonarchAction.RAISE_TAX);
                            if (newTax > 100) {
                                logger.warning("Tax rate exceeds 100 percent.");
                                return;
                            }
                            Goods goods = nextPlayer.getMostValuableGoods();
                            if (goods == null) {
                                return;
                            }
                            monarchActionElement.setAttribute("amount", String.valueOf(newTax));
                            monarchActionElement.setAttribute("goods", goods.getName());
                            monarchActionElement.setAttribute("force", String.valueOf(false));
                            try {
                                nextPlayer.setTax(newTax);
                                Element reply = nextPlayer.getConnection().ask(monarchActionElement);
                                boolean accepted = Boolean.valueOf(reply.getAttribute("accepted"));
                                if (!accepted) {
                                    Colony colony = (Colony)goods.getLocation();
                                    if (colony.getGoodsCount(goods.getType()) >= goods.getAmount()) {
                                        nextPlayer.setTax(oldTax);
                                        Element removeGoodsElement = Message.createNewRootElement("removeGoods");
                                        colony.removeGoods(goods);
                                        nextPlayer.setArrears(goods);
                                        colony.getFeatureContainer().addModifier(Modifier.createTeaPartyModifier(InGameController.this.getGame().getTurn()));
                                        removeGoodsElement.appendChild(goods.toXMLElement(nextPlayer, removeGoodsElement.getOwnerDocument()));
                                        nextPlayer.getConnection().send(removeGoodsElement);
                                        break;
                                    }
                                    monarchActionElement.setAttribute("force", String.valueOf(true));
                                    nextPlayer.getConnection().send(monarchActionElement);
                                }
                            }
                            catch (IOException e) {
                                logger.warning("Could not send message to: " + nextPlayer.getName());
                            }
                            break;
                        }
                        case LOWER_TAX: {
                            int taxLowered = monarch.getNewTax(Monarch.MonarchAction.LOWER_TAX);
                            if (taxLowered < 0) {
                                logger.warning("Tax rate less than 0 percent.");
                                return;
                            }
                            monarchActionElement.setAttribute("amount", String.valueOf(taxLowered));
                            try {
                                nextPlayer.setTax(taxLowered);
                                nextPlayer.getConnection().send(monarchActionElement);
                            }
                            catch (IOException e) {
                                logger.warning("Could not send message to: " + nextPlayer.getName());
                            }
                            break;
                        }
                        case ADD_TO_REF: {
                            List<AbstractUnit> unitsToAdd = monarch.addToREF();
                            monarch.addToREF(unitsToAdd);
                            Element additionElement = monarchActionElement.getOwnerDocument().createElement("addition");
                            for (AbstractUnit unit : unitsToAdd) {
                                additionElement.appendChild(unit.toXMLElement(nextPlayer, additionElement.getOwnerDocument()));
                            }
                            monarchActionElement.appendChild(additionElement);
                            try {
                                nextPlayer.getConnection().send(monarchActionElement);
                            }
                            catch (IOException e) {
                                logger.warning("Could not send message to: " + nextPlayer.getName());
                            }
                            break;
                        }
                        case DECLARE_WAR: {
                            Player enemy = monarch.declareWar();
                            if (enemy == null) {
                                logger.warning("Declared war on nobody.");
                                return;
                            }
                            if (nextPlayer.isAI()) {
                                nextPlayer.modifyTension(enemy, 1000);
                            }
                            nextPlayer.changeRelationWithPlayer(enemy, Player.Stance.WAR);
                            monarchActionElement.setAttribute("enemy", enemy.getId());
                            try {
                                nextPlayer.getConnection().send(monarchActionElement);
                            }
                            catch (IOException e) {
                                logger.warning("Could not send message to: " + nextPlayer.getName());
                            }
                            break;
                        }
                        case OFFER_MERCENARIES: {
                            Element mercenaryElement = monarchActionElement.getOwnerDocument().createElement("mercenaries");
                            List<AbstractUnit> units = monarch.getMercenaries();
                            int price = monarch.getPrice(units, true);
                            monarchActionElement.setAttribute("price", String.valueOf(price));
                            for (AbstractUnit unit : units) {
                                mercenaryElement.appendChild(unit.toXMLElement(monarchActionElement.getOwnerDocument()));
                            }
                            monarchActionElement.appendChild(mercenaryElement);
                            try {
                                Element reply = nextPlayer.getConnection().ask(monarchActionElement);
                                boolean accepted = Boolean.valueOf(reply.getAttribute("accepted"));
                                if (accepted) {
                                    Element updateElement = Message.createNewRootElement("monarchAction");
                                    updateElement.setAttribute("action", String.valueOf((Object)Monarch.MonarchAction.ADD_UNITS));
                                    nextPlayer.modifyGold(-price);
                                    InGameController.this.createUnits(units, updateElement, nextPlayer);
                                    nextPlayer.getConnection().send(updateElement);
                                }
                            }
                            catch (IOException e) {
                                logger.warning("Could not send message to: " + nextPlayer.getName());
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Monarch action failed!", e);
                }
            }
        };
        t.start();
    }

    public ServerPlayer createREFPlayer(ServerPlayer player) {
        Nation refNation = Specification.getSpecification().getNation(player.getNation().getRefId());
        ServerPlayer refPlayer = this.getFreeColServer().addAIPlayer(refNation);
        refPlayer.setEntryLocation(player.getEntryLocation());
        player.setStance(refPlayer, Player.Stance.PEACE);
        refPlayer.setTension(player, new Tension(Tension.Level.CONTENT.getLimit()));
        player.setTension(refPlayer, new Tension(Tension.Level.CONTENT.getLimit()));
        return refPlayer;
    }

    private void createUnits(List<AbstractUnit> units, Element element, ServerPlayer nextPlayer) {
        String musketsTypeStr = null;
        String horsesTypeStr = null;
        if (nextPlayer.isIndian()) {
            musketsTypeStr = "model.equipment.indian.muskets";
            horsesTypeStr = "model.equipment.indian.horses";
        } else {
            musketsTypeStr = "model.equipment.muskets";
            horsesTypeStr = "model.equipment.horses";
        }
        EquipmentType muskets = FreeCol.getSpecification().getEquipmentType(musketsTypeStr);
        EquipmentType horses = FreeCol.getSpecification().getEquipmentType(horsesTypeStr);
        EquipmentType[] soldier = new EquipmentType[]{muskets};
        EquipmentType[] dragoon = new EquipmentType[]{horses, muskets};
        for (AbstractUnit unit : units) {
            EquipmentType[] equipment = EquipmentType.NO_EQUIPMENT;
            for (int count = 0; count < unit.getNumber(); ++count) {
                switch (unit.getRole()) {
                    case SOLDIER: {
                        equipment = soldier;
                        break;
                    }
                    case DRAGOON: {
                        equipment = dragoon;
                        break;
                    }
                }
                Unit newUnit = new Unit(this.getGame(), nextPlayer.getEurope(), nextPlayer, unit.getUnitType(), Unit.UnitState.ACTIVE, equipment);
                if (element == null) continue;
                element.appendChild(newUnit.toXMLElement(nextPlayer, element.getOwnerDocument()));
            }
        }
    }

    public List<Unit> createREFUnits(ServerPlayer player, ServerPlayer refPlayer) {
        EquipmentType muskets = Specification.getSpecification().getEquipmentType("model.equipment.muskets");
        EquipmentType horses = Specification.getSpecification().getEquipmentType("model.equipment.horses");
        ArrayList<Unit> unitsList = new ArrayList<Unit>();
        ArrayList<Unit> navalUnits = new ArrayList<Unit>();
        ArrayList<Unit> landUnits = new ArrayList<Unit>();
        for (AbstractUnit unit : player.getMonarch().getNavalUnits()) {
            for (int index = 0; index < unit.getNumber(); ++index) {
                Unit newUnit = new Unit(this.getGame(), refPlayer.getEurope(), refPlayer, unit.getUnitType(), Unit.UnitState.TO_AMERICA);
                navalUnits.add(newUnit);
            }
        }
        unitsList.addAll(navalUnits);
        for (AbstractUnit unit : player.getMonarch().getLandUnits()) {
            EquipmentType[] equipment = EquipmentType.NO_EQUIPMENT;
            switch (unit.getRole()) {
                case SOLDIER: {
                    equipment = new EquipmentType[]{muskets};
                    break;
                }
                case DRAGOON: {
                    equipment = new EquipmentType[]{horses, muskets};
                    break;
                }
            }
            for (int index = 0; index < unit.getNumber(); ++index) {
                landUnits.add(new Unit(this.getGame(), refPlayer.getEurope(), refPlayer, unit.getUnitType(), Unit.UnitState.ACTIVE, equipment));
            }
        }
        unitsList.addAll(landUnits);
        Iterator carriers = navalUnits.iterator();
        for (Unit unit : landUnits) {
            boolean noSpaceForUnit = true;
            for (Unit carrier : navalUnits) {
                if (unit.getSpaceTaken() > carrier.getSpaceLeft()) continue;
                noSpaceForUnit = false;
                break;
            }
            if (noSpaceForUnit) continue;
            Unit carrier = null;
            while (carrier == null) {
                if (!carriers.hasNext()) {
                    carriers = navalUnits.iterator();
                }
                carrier = (Unit)carriers.next();
                if (unit.getSpaceTaken() <= carrier.getSpaceLeft()) continue;
                carrier = null;
            }
            unit.setLocation(carrier);
        }
        return unitsList;
    }

    public boolean createMission(IndianSettlement settlement, Unit missionary) {
        boolean success = false;
        switch (settlement.getAlarm(missionary.getOwner()).getLevel()) {
            case HAPPY: 
            case CONTENT: 
            case DISPLEASED: {
                success = true;
                settlement.setMissionary(missionary);
                break;
            }
            case ANGRY: 
            case HATEFUL: {
                success = false;
                missionary.dispose();
            }
        }
        return success;
    }

    private void bombardEnemyShips(ServerPlayer currentPlayer) {
        logger.finest("Entering method bombardEnemyShips.");
        Map map = this.getFreeColServer().getGame().getMap();
        CombatModel combatModel = this.getFreeColServer().getGame().getCombatModel();
        for (Settlement settlement : currentPlayer.getSettlements()) {
            Colony colony = (Colony)settlement;
            if (!colony.canBombardEnemyShip()) continue;
            logger.fine("Colony " + colony.getName() + " can bombard enemy ships.");
            Map.Position colonyPosition = colony.getTile().getPosition();
            for (Map.Direction direction : Map.Direction.values()) {
                Tile tile = map.getTile(Map.getAdjacent(colonyPosition, direction));
                if (tile == null || tile.isLand()) continue;
                ArrayList<Unit> unitList = new ArrayList<Unit>(tile.getUnitList());
                for (Unit unit : unitList) {
                    Player player = unit.getOwner();
                    if (player == currentPlayer || currentPlayer.getStance(player) != Player.Stance.WAR && !unit.hasAbility("model.ability.piracy")) continue;
                    logger.info(colony.getName() + " found enemy unit to bombard: " + unit.getName() + "(" + unit.getOwner().getNationAsString() + ")");
                    CombatModel.CombatResult result = combatModel.generateAttackResult(colony, unit);
                    Location repairLocation = null;
                    if (result.type == CombatModel.CombatResultType.WIN) {
                        repairLocation = player.getRepairLocation(unit);
                    }
                    this.getGame().getCombatModel().bombard(colony, unit, result, repairLocation);
                    int plunderGold = -1;
                    Iterator<Player> enemyPlayerIterator = this.getFreeColServer().getGame().getPlayerIterator();
                    while (enemyPlayerIterator.hasNext()) {
                        ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
                        if (enemyPlayer.getConnection() == null || !unit.isVisibleTo(enemyPlayer)) continue;
                        Element opponentAttackElement = Message.createNewRootElement("opponentAttack");
                        opponentAttackElement.setAttribute("direction", direction.toString());
                        opponentAttackElement.setAttribute("result", result.type.toString());
                        opponentAttackElement.setAttribute("plunderGold", Integer.toString(plunderGold));
                        opponentAttackElement.setAttribute("colony", colony.getId());
                        opponentAttackElement.setAttribute("defender", unit.getId());
                        opponentAttackElement.setAttribute("damage", String.valueOf(result.damage));
                        if (enemyPlayer == player && repairLocation != null) {
                            opponentAttackElement.setAttribute("repairIn", repairLocation.getId());
                        }
                        if (!enemyPlayer.canSee(colony.getTile())) {
                            opponentAttackElement.setAttribute("update", "tile");
                            enemyPlayer.setExplored(colony.getTile());
                            opponentAttackElement.appendChild(colony.getTile().toXMLElement(enemyPlayer, opponentAttackElement.getOwnerDocument()));
                        }
                        if (enemyPlayer.canSee(unit.getTile())) {
                            opponentAttackElement.setAttribute("update", "unit");
                            opponentAttackElement.appendChild(unit.toXMLElement(enemyPlayer, opponentAttackElement.getOwnerDocument()));
                        }
                        try {
                            enemyPlayer.getConnection().send(opponentAttackElement);
                        }
                        catch (IOException e) {
                            logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
                        }
                    }
                }
            }
        }
    }

    public java.util.Map<String, Object> getTransactionSession(Unit unit, Settlement settlement) {
        java.util.Map<String, java.util.Map<String, Object>> unitTransactions = null;
        if (this.transactionSessions.containsKey(unit.getId()) && (unitTransactions = this.transactionSessions.get(unit.getId())).containsKey(settlement.getId())) {
            return unitTransactions.get(settlement.getId());
        }
        HashMap<String, Object> session = new HashMap<String, Object>();
        session.put("canGift", true);
        session.put("canSell", true);
        session.put("canBuy", true);
        session.put("actionTaken", false);
        session.put("hasSpaceLeft", unit.getSpaceLeft() != 0);
        session.put("unitMoves", unit.getMovesLeft());
        if (settlement.getOwner().getStance(unit.getOwner()) == Player.Stance.WAR) {
            session.put("canSell", false);
            session.put("canBuy", false);
        } else if (unit.getSpaceTaken() == 0) {
            session.put("canSell", false);
        }
        if (unit.getOwner().isAI()) {
            return session;
        }
        if (unitTransactions == null) {
            unitTransactions = new HashMap<String, java.util.Map<String, Object>>();
            this.transactionSessions.put(unit.getId(), unitTransactions);
        }
        unitTransactions.put(settlement.getId(), session);
        return session;
    }

    public void closeTransactionSession(Unit unit, Settlement settlement) {
        if (unit.getOwner().isAI()) {
            return;
        }
        if (!this.transactionSessions.containsKey(unit.getId())) {
            throw new IllegalStateException("Trying to close a non-existing session");
        }
        java.util.Map<String, java.util.Map<String, Object>> unitTransactions = this.transactionSessions.get(unit.getId());
        if (!unitTransactions.containsKey(settlement.getId())) {
            throw new IllegalStateException("Trying to close a non-existing session");
        }
        unitTransactions.remove(settlement.getId());
        if (unitTransactions.isEmpty()) {
            this.transactionSessions.remove(unit.getId());
        }
    }

    public boolean isTransactionSessionOpen(Unit unit, Settlement settlement) {
        if (unit.getOwner().isAI()) {
            return true;
        }
        if (!this.transactionSessions.containsKey(unit.getId())) {
            return false;
        }
        return settlement == null || this.transactionSessions.get(unit.getId()).containsKey(settlement.getId());
    }
}

