/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.BuyLandMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.NetworkConstants;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.networking.StatisticsMessage;
import net.sf.freecol.common.networking.StealLandMessage;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.control.InputHandler;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameInputHandler
extends InputHandler
implements NetworkConstants {
    private static Logger logger = Logger.getLogger(InGameInputHandler.class.getName());

    public InGameInputHandler(final FreeColServer freeColServer) {
        super(freeColServer);
        this.register("createUnit", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.createUnit(connection, element);
            }
        });
        this.register("createBuilding", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.createBuilding(connection, element);
            }
        });
        this.register("getRandom", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.getRandom(connection, element);
            }
        });
        this.register("getVacantEntryLocation", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.getVacantEntryLocation(connection, element);
            }
        });
        this.register("setDestination", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.setDestination(connection, element);
            }
        });
        this.register("move", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.move(connection, element);
            }
        });
        this.register("askSkill", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.askSkill(connection, element);
            }
        });
        this.register("attack", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.attack(connection, element);
            }
        });
        this.register("embark", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.embark(connection, element);
            }
        });
        this.register("boardShip", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.boardShip(connection, element);
            }
        });
        this.register("learnSkillAtSettlement", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.learnSkillAtSettlement(connection, element);
            }
        });
        this.register("scoutIndianSettlement", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.scoutIndianSettlement(connection, element);
            }
        });
        this.register("missionaryAtSettlement", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.missionaryAtSettlement(connection, element);
            }
        });
        this.register("inciteAtSettlement", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.inciteAtSettlement(connection, element);
            }
        });
        this.register("armedUnitDemandTribute", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.armedUnitDemandTribute(connection, element);
            }
        });
        this.register("leaveShip", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.leaveShip(connection, element);
            }
        });
        this.register("loadCargo", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.loadCargo(connection, element);
            }
        });
        this.register("unloadCargo", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.unloadCargo(connection, element);
            }
        });
        this.register("buyGoods", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.buyGoods(connection, element);
            }
        });
        this.register("sellGoods", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.sellGoods(connection, element);
            }
        });
        this.register("moveToEurope", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.moveToEurope(connection, element);
            }
        });
        this.register("moveToAmerica", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.moveToAmerica(connection, element);
            }
        });
        this.register("buildColony", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.buildColony(connection, element);
            }
        });
        this.register("recruitUnitInEurope", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.recruitUnitInEurope(connection, element);
            }
        });
        this.register("emigrateUnitInEurope", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.emigrateUnitInEurope(connection, element);
            }
        });
        this.register("trainUnitInEurope", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.trainUnitInEurope(connection, element);
            }
        });
        this.register("equipUnit", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.equipUnit(connection, element);
            }
        });
        this.register("work", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.work(connection, element);
            }
        });
        this.register("changeWorkType", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.changeWorkType(connection, element);
            }
        });
        this.register("workImprovement", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.workImprovement(connection, element);
            }
        });
        this.register("setCurrentlyBuilding", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.setCurrentlyBuilding(connection, element);
            }
        });
        this.register("changeState", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.changeState(connection, element);
            }
        });
        this.register("putOutsideColony", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.putOutsideColony(connection, element);
            }
        });
        this.register("clearSpeciality", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.clearSpeciality(connection, element);
            }
        });
        this.register("setNewLandName", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.setNewLandName(connection, element);
            }
        });
        this.register("endTurn", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.endTurn(connection, element);
            }
        });
        this.register("disbandUnit", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.disbandUnit(connection, element);
            }
        });
        this.register("cashInTreasureTrain", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.cashInTreasureTrain(connection, element);
            }
        });
        this.register("getTransaction", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.getTransactionSession(connection, element);
            }
        });
        this.register("closeTransaction", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.closeTransactionSession(connection, element);
            }
        });
        this.register("tradeProposition", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.tradeProposition(connection, element);
            }
        });
        this.register("trade", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.trade(connection, element);
            }
        });
        this.register("goodsForSale", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.goodsForSaleRequest(connection, element);
            }
        });
        this.register("buyProposition", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.buyProposition(connection, element);
            }
        });
        this.register("buy", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.buy(connection, element);
            }
        });
        this.register("deliverGift", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.deliverGift(connection, element);
            }
        });
        this.register("indianDemand", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.indianDemand(connection, element);
            }
        });
        this.register(BuyLandMessage.getXMLElementTagName(), new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                BuyLandMessage message = new BuyLandMessage(InGameInputHandler.this.getGame(), element);
                return message.handle(freeColServer, player, connection);
            }
        });
        this.register(StealLandMessage.getXMLElementTagName(), new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                StealLandMessage message = new StealLandMessage(InGameInputHandler.this.getGame(), element);
                return message.handle(freeColServer, player, connection);
            }
        });
        this.register("payForBuilding", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.payForBuilding(connection, element);
            }
        });
        this.register("payArrears", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.payArrears(connection, element);
            }
        });
        this.register("setGoodsLevels", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.setGoodsLevels(connection, element);
            }
        });
        this.register("declareIndependence", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.declareIndependence(connection, element);
            }
        });
        this.register("giveIndependence", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.giveIndependence(connection, element);
            }
        });
        this.register("foreignAffairs", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.foreignAffairs(connection, element);
            }
        });
        this.register("highScores", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.highScores(connection, element);
            }
        });
        this.register("getREFUnits", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.getREFUnits(connection, element);
            }
        });
        this.register("rename", new InputHandler.CurrentPlayerNetworkRequestHandler(){

            public Element handle(Player player, Connection connection, Element element) {
                return InGameInputHandler.this.rename(connection, element);
            }
        });
        this.register("getNewTradeRoute", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.getNewTradeRoute(connection, element);
            }
        });
        this.register("updateTradeRoute", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.updateTradeRoute(connection, element);
            }
        });
        this.register("setTradeRoutes", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.setTradeRoutes(connection, element);
            }
        });
        this.register("assignTradeRoute", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.assignTradeRoute(connection, element);
            }
        });
        this.register("updateCurrentStop", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.updateCurrentStop(connection, element);
            }
        });
        this.register("diplomaticTrade", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.diplomaticTrade(connection, element);
            }
        });
        this.register("selectFromFountainYouth", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.selectFromFountainYouth(connection, element);
            }
        });
        this.register("spySettlement", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.spySettlement(connection, element);
            }
        });
        this.register("abandonColony", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.abandonColony(connection, element);
            }
        });
        this.register("continuePlaying", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.continuePlaying(connection, element);
            }
        });
        this.register("assignTeacher", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.assignTeacher(connection, element);
            }
        });
        this.register(StatisticsMessage.getXMLElementTagName(), new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.getServerStatistics(connection, element);
            }
        });
        this.register("retire", new InputHandler.NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InGameInputHandler.this.retire(connection, element);
            }
        });
    }

    private List<ServerPlayer> getOtherPlayers(Player player) {
        ArrayList<ServerPlayer> result = new ArrayList<ServerPlayer>();
        for (Player otherPlayer : this.getGame().getPlayers()) {
            ServerPlayer enemyPlayer = (ServerPlayer)otherPlayer;
            if (player.equals(enemyPlayer) || enemyPlayer.getConnection() == null) continue;
            result.add(enemyPlayer);
        }
        return result;
    }

    private void sendRemoveUnitToAll(Unit unit, Player player) {
        Element removeElement = Message.createNewRootElement("remove");
        Element removeUnit = removeElement.getOwnerDocument().createElement("removeObject");
        removeUnit.setAttribute("ID", unit.getId());
        removeElement.appendChild(removeUnit);
        for (ServerPlayer enemyPlayer : this.getOtherPlayers(player)) {
            if (!unit.isVisibleTo(enemyPlayer)) continue;
            try {
                enemyPlayer.getConnection().sendAndWait(removeElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    private Element setNewLandName(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        player.setNewLandName(element.getAttribute("newLandName"));
        player.getHistory().add(new HistoryEvent(this.getGame().getTurn().getNumber(), HistoryEvent.Type.DISCOVER_NEW_WORLD, "%name%", player.getNewLandName()));
        return null;
    }

    private Element createUnit(Connection connection, Element element) {
        logger.info("Receiving \"createUnit\"-request.");
        String taskID = element.getAttribute("taskID");
        Location location = (Location)((Object)this.getGame().getFreeColGameObject(element.getAttribute("location")));
        Player owner = (Player)this.getGame().getFreeColGameObject(element.getAttribute("owner"));
        UnitType type = FreeCol.getSpecification().getUnitType(element.getAttribute("type"));
        if (location == null) {
            throw new NullPointerException();
        }
        if (owner == null) {
            throw new NullPointerException();
        }
        Unit unit = this.getFreeColServer().getModelController().createUnit(taskID, location, owner, type, false, connection);
        Element reply = Message.createNewRootElement("createUnitConfirmed");
        reply.appendChild(unit.toXMLElement(owner, reply.getOwnerDocument()));
        return reply;
    }

    private Element createBuilding(Connection connection, Element element) {
        logger.info("Receiving \"createBuilding\"-request.");
        String taskID = element.getAttribute("taskID");
        Colony colony = (Colony)this.getGame().getFreeColGameObject(element.getAttribute("colony"));
        BuildingType type = FreeCol.getSpecification().getBuildingType(element.getAttribute("type"));
        if (colony == null) {
            throw new NullPointerException();
        }
        Building building = this.getFreeColServer().getModelController().createBuilding(taskID, colony, type, false, connection);
        Element reply = Message.createNewRootElement("createBuildingConfirmed");
        reply.appendChild(building.toXMLElement(colony.getOwner(), reply.getOwnerDocument()));
        return reply;
    }

    private Element getRandom(Connection connection, Element element) {
        String taskID = element.getAttribute("taskID");
        int n = Integer.parseInt(element.getAttribute("n"));
        int result = this.getFreeColServer().getModelController().getRandom(taskID, n);
        Element reply = Message.createNewRootElement("getRandomConfirmed");
        reply.setAttribute("result", Integer.toString(result));
        return reply;
    }

    private Element getVacantEntryLocation(Connection connection, Element element) {
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Player owner = unit.getOwner();
        ServerPlayer askingPlayer = this.getFreeColServer().getPlayer(connection);
        Location entryLocation = unit.getEntryLocation();
        if (owner != askingPlayer) {
            if (entryLocation == null) {
                throw new IllegalStateException("Unit " + unit.getId() + " with owner " + owner + " not owned by " + askingPlayer + ", refusing to get vacant location!");
            }
            logger.warning("Unit " + unit.getId() + " with owner " + owner + " not owned by " + askingPlayer + ", entry location is " + entryLocation.getId());
        } else {
            entryLocation = this.getFreeColServer().getModelController().setToVacantEntryLocation(unit);
        }
        Element reply = Message.createNewRootElement("getVacantEntryLocationConfirmed");
        reply.setAttribute("location", entryLocation.getId());
        return reply;
    }

    private Element getNewTradeRoute(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        TradeRoute tradeRoute = this.getFreeColServer().getModelController().getNewTradeRoute(player);
        Element reply = Message.createNewRootElement("getNewTradeRouteConfirmed");
        reply.appendChild(tradeRoute.toXMLElement(player, reply.getOwnerDocument()));
        return reply;
    }

    private Element updateTradeRoute(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Element childElement = (Element)element.getChildNodes().item(0);
        TradeRoute clientTradeRoute = new TradeRoute(null, childElement);
        TradeRoute serverTradeRoute = (TradeRoute)this.getGame().getFreeColGameObject(clientTradeRoute.getId());
        if (serverTradeRoute == null) {
            throw new IllegalArgumentException("Could not find 'TradeRoute' with specified ID: " + clientTradeRoute.getId());
        }
        if (serverTradeRoute.getOwner() != player) {
            throw new IllegalStateException("Not your trade route!");
        }
        serverTradeRoute.updateFrom(clientTradeRoute);
        return null;
    }

    private Element setTradeRoutes(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        ArrayList<TradeRoute> routes = new ArrayList<TradeRoute>();
        NodeList childElements = element.getChildNodes();
        for (int i = 0; i < childElements.getLength(); ++i) {
            Element childElement = (Element)childElements.item(i);
            String id = childElement.getAttribute("id");
            TradeRoute serverTradeRoute = (TradeRoute)this.getGame().getFreeColGameObject(id);
            if (serverTradeRoute == null) {
                throw new IllegalArgumentException("Could not find 'TradeRoute' with specified ID: " + id);
            }
            if (serverTradeRoute.getOwner() != player) {
                throw new IllegalStateException("Not your trade route!");
            }
            routes.add(serverTradeRoute);
        }
        player.setTradeRoutes(routes);
        return null;
    }

    private Element updateCurrentStop(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        unit.nextStop();
        return null;
    }

    private Element assignTradeRoute(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        String tradeRouteString = element.getAttribute("tradeRoute");
        if (tradeRouteString == null || tradeRouteString == "") {
            unit.setTradeRoute(null);
        } else {
            TradeRoute tradeRoute = (TradeRoute)this.getGame().getFreeColGameObject(tradeRouteString);
            if (tradeRoute == null) {
                throw new IllegalArgumentException("Could not find 'TradeRoute' with specified ID: " + element.getAttribute("tradeRoute"));
            }
            if (tradeRoute.getOwner() != player) {
                throw new IllegalStateException("Not your trade route!");
            }
            unit.setTradeRoute(tradeRoute);
        }
        return null;
    }

    private Element diplomaticTrade(Connection connection, Element element) {
        String accept;
        boolean isPlayersREF;
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        Tile tile = this.getGame().getMap().getNeighbourOrNull(direction, unit.getTile());
        if (tile == null) {
            throw new IllegalArgumentException("Could not find 'Tile' in direction " + (Object)((Object)direction));
        }
        Settlement settlement = tile.getSettlement();
        if (settlement == null) {
            throw new IllegalArgumentException("No settlement on 'Tile' " + tile.getId());
        }
        unit.setMovesLeft(0);
        NodeList childElements = element.getChildNodes();
        Element childElement = (Element)childElements.item(0);
        DiplomaticTrade agreement = new DiplomaticTrade(this.getGame(), childElement);
        if (agreement.getSender() != player) {
            throw new IllegalArgumentException("Sender of 'DiplomaticTrade' message is not player " + player.getName());
        }
        ServerPlayer enemyPlayer = (ServerPlayer)agreement.getRecipient();
        boolean bl = isPlayersREF = enemyPlayer == player.getREFPlayer();
        if (isPlayersREF) {
            String errMsg = "Received diplomatic message to players own REF, both cannot negotiate";
            throw new IllegalStateException(errMsg);
        }
        if (agreement.isAccept()) {
            agreement.makeTrade();
        }
        Element reply = null;
        try {
            reply = enemyPlayer.getConnection().ask(element);
        }
        catch (IOException e) {
            logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
        }
        if (reply != null && (accept = reply.getAttribute("accept")) != null && accept.equals("accept")) {
            agreement.makeTrade();
        }
        return reply;
    }

    private Element spySettlement(Connection connection, Element spyElement) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(spyElement.getAttribute("unit"));
        Map.Direction direction = Enum.valueOf(Map.Direction.class, spyElement.getAttribute("direction"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + spyElement.getAttribute("unit"));
        }
        if (unit.getTile() == null) {
            throw new IllegalArgumentException("'Unit' is not on the map: " + unit.toString());
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile newTile = this.getGame().getMap().getNeighbourOrNull(direction, unit.getTile());
        if (newTile == null) {
            throw new IllegalArgumentException("Could not find tile in direction " + (Object)((Object)direction) + " from unit with ID " + spyElement.getAttribute("unit"));
        }
        Settlement settlement = newTile.getSettlement();
        if (settlement == null) {
            throw new IllegalArgumentException("There is no settlement in direction " + (Object)((Object)direction) + " from unit with ID " + spyElement.getAttribute("unit"));
        }
        Element reply = Message.createNewRootElement("foreignColony");
        if (settlement instanceof Colony) {
            reply.appendChild(((Colony)settlement).toXMLElement(player, reply.getOwnerDocument(), true, false));
        } else if (settlement instanceof IndianSettlement) {
            reply.appendChild(((IndianSettlement)settlement).toXMLElement(player, reply.getOwnerDocument(), true, false));
        }
        for (Unit foreignUnit : newTile.getUnitList()) {
            reply.appendChild(foreignUnit.toXMLElement(player, reply.getOwnerDocument(), true, false));
        }
        return reply;
    }

    private Element abandonColony(Connection connection, Element abandonElement) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Colony colony = (Colony)this.getGame().getFreeColGameObject(abandonElement.getAttribute("colony"));
        if (colony == null) {
            throw new IllegalArgumentException("Could not find 'Colony' with specified ID: " + abandonElement.getAttribute("colony"));
        }
        if (colony.getOwner() != player) {
            throw new IllegalStateException("Not your colony!");
        }
        colony.getOwner().getHistory().add(new HistoryEvent(colony.getGame().getTurn().getNumber(), HistoryEvent.Type.ABANDON_COLONY, "%colony%", colony.getName()));
        Tile tile = colony.getTile();
        colony.dispose();
        this.sendUpdatedTileToAll(tile, player);
        return null;
    }

    private Element move(Connection connection, Element moveElement) {
        Region region;
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        String unitID = moveElement.getAttribute("unit");
        Unit unit = (Unit)this.getGame().getFreeColGameObject(unitID);
        Map.Direction direction = Enum.valueOf(Map.Direction.class, moveElement.getAttribute("direction"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + unitID);
        }
        if (unit.getTile() == null) {
            throw new IllegalArgumentException("'Unit' not on map: ID: " + unitID + " (" + unit.getName() + ")");
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile newTile = this.getGame().getMap().getNeighbourOrNull(direction, unit.getTile());
        for (ServerPlayer enemyPlayer : this.getOtherPlayers(player)) {
            try {
                Element opponentMoveElement;
                if (unit.isVisibleTo(enemyPlayer)) {
                    opponentMoveElement = Message.createNewRootElement("opponentMove");
                    opponentMoveElement.setAttribute("fromTile", unit.getTile().getId());
                    opponentMoveElement.setAttribute("direction", direction.toString());
                    opponentMoveElement.setAttribute("unit", unit.getId());
                    enemyPlayer.getConnection().sendAndWait(opponentMoveElement);
                    continue;
                }
                if (!enemyPlayer.canSee(newTile) || newTile.getSettlement() != null && this.getGame().getGameOptions().getBoolean("model.option.unitHiding")) continue;
                opponentMoveElement = Message.createNewRootElement("opponentMove");
                opponentMoveElement.setAttribute("direction", direction.toString());
                opponentMoveElement.setAttribute("toTile", newTile.getId());
                opponentMoveElement.appendChild(unit.toXMLElement(enemyPlayer, opponentMoveElement.getOwnerDocument(), false, false));
                if (unit.isOnCarrier() && !((Unit)unit.getLocation()).isVisibleTo(enemyPlayer)) {
                    Unit location = (Unit)unit.getLocation();
                    opponentMoveElement.setAttribute("inUnit", location.getId());
                    opponentMoveElement.appendChild(location.toXMLElement(enemyPlayer, opponentMoveElement.getOwnerDocument(), false, false));
                }
                enemyPlayer.getConnection().sendAndWait(opponentMoveElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
        unit.move(direction);
        Element reply = Message.createNewRootElement("update");
        CombatModel combatModel = unit.getGame().getCombatModel();
        if (unit.isNaval() && unit.getMovesLeft() > 0) {
            Iterator<Map.Position> tileIterator = this.getGame().getMap().getAdjacentIterator(unit.getTile().getPosition());
            float attackPower = 0.0f;
            Unit attacker = null;
            while (tileIterator.hasNext()) {
                Player enemy;
                Tile tile = this.getGame().getMap().getTile(tileIterator.next());
                Colony colony = tile.getColony();
                if (colony != null || tile.isLand() || tile.getFirstUnit() == null || player == (enemy = tile.getFirstUnit().getOwner())) continue;
                for (Unit enemyUnit : tile.getUnitList()) {
                    if (!enemyUnit.isOffensiveUnit() || player.getStance(enemy) != Player.Stance.WAR && !enemyUnit.hasAbility("model.ability.piracy") && !unit.hasAbility("model.ability.piracy")) continue;
                    attackPower += combatModel.getOffencePower(enemyUnit, unit);
                    if (attacker != null) continue;
                    attacker = enemyUnit;
                }
            }
            if (attackPower > 0.0f) {
                assert (attacker != null);
                float defencePower = combatModel.getDefencePower(attacker, unit);
                float totalProbability = attackPower + defencePower;
                int r = this.getPseudoRandom().nextInt(Math.round(totalProbability) + 1);
                if ((float)r < attackPower) {
                    int diff = Math.max(0, Math.round(attackPower - defencePower));
                    int moves = Math.min(9, 3 + diff / 3);
                    unit.setMovesLeft(unit.getMovesLeft() - moves);
                    reply.setAttribute("movesSlowed", Integer.toString(moves));
                    reply.setAttribute("slowedBy", attacker.getId());
                }
            }
        }
        if (player.isEuropean() && (region = newTile.getDiscoverableRegion()) != null && (region.isPacific() || this.getGame().getGameOptions().getBoolean("model.option.explorationPoints"))) {
            String name;
            if (region.isPacific()) {
                name = region.getDisplayName();
            } else {
                name = moveElement.getAttribute("regionName");
                if (name == null || "".equals(name)) {
                    name = player.getDefaultRegionName(region.getType());
                }
            }
            region.discover(player, this.getGame().getTurn(), name);
            reply.appendChild(region.toXMLElement(player, reply.getOwnerDocument()));
            Element updateElement = Message.createNewRootElement("update");
            updateElement.appendChild(region.toXMLElement(player, updateElement.getOwnerDocument()));
            freeColServer.getServer().sendToAll(updateElement, player.getConnection());
        }
        List<Tile> surroundingTiles = this.getGame().getMap().getSurroundingTiles(unit.getTile(), unit.getLineOfSight());
        for (int i = 0; i < surroundingTiles.size(); ++i) {
            Tile t = surroundingTiles.get(i);
            reply.appendChild(t.toXMLElement(player, reply.getOwnerDocument(), false, false));
        }
        if (newTile.hasLostCityRumour() && player.isEuropean()) {
            newTile.setLostCityRumour(false);
            this.exploreLostCityRumour(unit, player);
        }
        return reply;
    }

    private void exploreLostCityRumour(Unit unit, ServerPlayer player) {
        int percentGood;
        int percentBad;
        int[] BAD_EVENT_PERCENTAGE = new int[]{11, 17, 23, 30, 37};
        int[] GOOD_EVENT_PERCENTAGE = new int[]{75, 62, 48, 33, 17};
        int[] BAD_EVENT_MOD = new int[]{-6, -7, -7, -8, -9};
        int[] GOOD_EVENT_MOD = new int[]{14, 15, 16, 18, 20};
        Tile tile = unit.getTile();
        Specification specification = FreeCol.getSpecification();
        List<UnitType> learntUnitTypes = unit.getType().getUnitTypesLearntInLostCity();
        List<UnitType> newUnitTypes = specification.getUnitTypesWithAbility("model.ability.foundInLostCity");
        List<UnitType> treasureUnitTypes = specification.getUnitTypesWithAbility("model.ability.carryTreasure");
        int level = Specification.getSpecification().getRangeOption("model.option.difficulty").getValue();
        boolean isExpertScout = unit.hasAbility("model.ability.expertScout") && unit.hasAbility("model.ability.scoutIndianSettlement");
        boolean hasDeSoto = player.hasAbility("model.ability.rumoursAlwaysPositive");
        int percentNeutral = 0;
        if (hasDeSoto) {
            percentBad = 0;
            percentGood = 100;
        } else {
            percentBad = BAD_EVENT_PERCENTAGE[level];
            percentGood = GOOD_EVENT_PERCENTAGE[level];
            if (isExpertScout) {
                percentBad += BAD_EVENT_MOD[level];
                percentGood += GOOD_EVENT_MOD[level];
            }
            if (percentBad + percentGood < 100) {
                percentNeutral = 100 - percentBad - percentGood;
            }
        }
        int eventNothing = 100;
        int eventVanish = 100;
        int eventBurialGround = 0;
        if (tile.getOwner() != null && !tile.getOwner().isEuropean()) {
            eventVanish = 75;
            eventBurialGround = 25;
        }
        int eventLearn = 30;
        int eventTrinkets = 30;
        int eventColonist = 20;
        if (learntUnitTypes.isEmpty()) {
            eventLearn = 0;
            eventTrinkets = 50;
            eventColonist = 30;
        }
        int eventDorado = 13;
        int eventFountain = 7;
        eventNothing *= percentNeutral;
        eventVanish *= percentBad;
        eventBurialGround *= percentBad;
        eventLearn *= percentGood;
        eventTrinkets *= percentGood;
        eventColonist *= percentGood;
        eventDorado *= percentGood;
        eventFountain *= percentGood;
        ArrayList choices = new ArrayList();
        if (eventNothing > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.NOTHING, eventNothing));
        }
        if (eventVanish > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.EXPEDITION_VANISHES, eventVanish));
        }
        if (eventBurialGround > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.BURIAL_GROUND, eventBurialGround));
        }
        if (eventLearn > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.LEARN, eventLearn));
        }
        if (eventTrinkets > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.TRIBAL_CHIEF, eventTrinkets));
        }
        if (eventColonist > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.COLONIST, eventColonist));
        }
        if (eventFountain > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.FOUNTAIN_OF_YOUTH, eventFountain));
        }
        if (eventDorado > 0) {
            choices.add(new RandomChoice<LostCityRumour.RumourType>(LostCityRumour.RumourType.TREASURE, eventDorado));
        }
        LostCityRumour.RumourType rumour = (LostCityRumour.RumourType)((Object)RandomChoice.getWeightedRandom(this.getPseudoRandom(), choices));
        Element rumourElement = Message.createNewRootElement("lostCityRumour");
        rumourElement.setAttribute("type", rumour.toString());
        rumourElement.setAttribute("unit", unit.getId());
        int dx = 10 - level;
        switch (rumour) {
            case BURIAL_GROUND: {
                Player indianPlayer = tile.getOwner();
                indianPlayer.modifyTension(player, Tension.Level.HATEFUL.getLimit());
                break;
            }
            case EXPEDITION_VANISHES: {
                unit.dispose();
                break;
            }
            case NOTHING: {
                break;
            }
            case LEARN: {
                int random = this.getPseudoRandom().nextInt(learntUnitTypes.size());
                unit.setType(learntUnitTypes.get(random));
                rumourElement.setAttribute("unitType", learntUnitTypes.get(random).getId());
                break;
            }
            case TRIBAL_CHIEF: {
                int amount = this.getPseudoRandom().nextInt(dx * 10) + dx * 5;
                player.modifyGold(amount);
                rumourElement.setAttribute("amount", Integer.toString(amount));
                break;
            }
            case COLONIST: {
                int random = this.getPseudoRandom().nextInt(newUnitTypes.size());
                Unit newUnit = new Unit(this.getGame(), tile, player, newUnitTypes.get(random), Unit.UnitState.ACTIVE);
                rumourElement.appendChild(newUnit.toXMLElement(player, rumourElement.getOwnerDocument()));
                break;
            }
            case TREASURE: {
                int treasure = this.getPseudoRandom().nextInt(dx * 600) + dx * 300;
                int random = this.getPseudoRandom().nextInt(treasureUnitTypes.size());
                Unit newUnit = new Unit(this.getGame(), tile, player, treasureUnitTypes.get(random), Unit.UnitState.ACTIVE);
                newUnit.setTreasureAmount(treasure);
                rumourElement.setAttribute("amount", Integer.toString(treasure));
                rumourElement.appendChild(newUnit.toXMLElement(player, rumourElement.getOwnerDocument()));
                player.getHistory().add(new HistoryEvent(this.getGame().getTurn().getNumber(), HistoryEvent.Type.CITY_OF_GOLD, "%treasure%", String.valueOf(treasure)));
                break;
            }
            case FOUNTAIN_OF_YOUTH: {
                Unit newUnit;
                if (player.getEurope() == null) break;
                if (player.hasAbility("model.ability.selectRecruit")) {
                    player.setRemainingEmigrants(dx);
                    rumourElement.setAttribute("emigrants", Integer.toString(dx));
                    break;
                }
                for (int k = 0; k < dx; ++k) {
                    newUnit = new Unit(this.getGame(), player.getEurope(), player, player.generateRecruitable(String.valueOf(k)), Unit.UnitState.ACTIVE);
                    rumourElement.appendChild(newUnit.toXMLElement(player, rumourElement.getOwnerDocument()));
                }
                break;
            }
            default: {
                throw new IllegalStateException("No such rumour.");
            }
        }
        try {
            player.getConnection().sendAndWait(rumourElement);
        }
        catch (IOException e) {
            logger.warning("Could not send rumour message to: " + player.getName() + " with connection " + player.getConnection());
        }
        for (ServerPlayer updatePlayer : this.getOtherPlayers(player)) {
            if (!updatePlayer.canSee(tile)) continue;
            try {
                Element rumourUpdate = Message.createNewRootElement("update");
                rumourUpdate.appendChild(tile.toXMLElement(updatePlayer, rumourUpdate.getOwnerDocument()));
                updatePlayer.getConnection().sendAndWait(rumourUpdate);
            }
            catch (IOException e) {
                logger.warning("Could not send update message to: " + updatePlayer.getName() + " with connection " + updatePlayer.getConnection());
            }
        }
    }

    private Element selectFromFountainYouth(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        int remaining = player.getRemainingEmigrants();
        if (remaining == 0) {
            throw new IllegalStateException("There is no remaining emigrants for this player.");
        }
        player.setRemainingEmigrants(remaining - 1);
        Europe europe = player.getEurope();
        int slot = Integer.parseInt(element.getAttribute("slot"));
        UnitType recruitable = europe.getRecruitable(slot);
        UnitType newRecruitable = player.generateRecruitable(String.valueOf(remaining));
        europe.setRecruitable(slot, newRecruitable);
        Unit unit = new Unit(this.getGame(), europe, player, recruitable, Unit.UnitState.ACTIVE);
        Element reply = Message.createNewRootElement("selectFromFountainYouthConfirmed");
        reply.setAttribute("newRecruitable", newRecruitable.getId());
        reply.appendChild(unit.toXMLElement(player, reply.getOwnerDocument()));
        return reply;
    }

    private Element askSkill(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        Map map = this.getGame().getMap();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (unit.getMovesLeft() == 0) {
            throw new IllegalArgumentException("Unit has no moves left.");
        }
        if (unit.getTile() == null) {
            throw new IllegalArgumentException("'Unit' not on map: ID: " + element.getAttribute("unit"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        IndianSettlement settlement = (IndianSettlement)map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
        unit.setMovesLeft(0);
        Element reply = Message.createNewRootElement("provideSkill");
        if (settlement.getLearnableSkill() != null) {
            reply.setAttribute("skill", settlement.getLearnableSkill().getId());
        }
        settlement.setVisited(unit.getOwner());
        settlement.getTile().updateIndianSettlementSkill(player);
        return reply;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element attack(Connection connection, Element attackElement) {
        Unit lastUnit;
        CombatModel.CombatResult result;
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        String unitID = attackElement.getAttribute("unit");
        Unit unit = (Unit)this.getGame().getFreeColGameObject(unitID);
        Map.Direction direction = Enum.valueOf(Map.Direction.class, attackElement.getAttribute("direction"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + unitID);
        }
        if (unit.getTile() == null) {
            throw new IllegalArgumentException("'Unit' is not on the map: " + unit.toString());
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile newTile = this.getGame().getMap().getNeighbourOrNull(direction, unit.getTile());
        if (newTile == null) {
            throw new IllegalArgumentException("Could not find tile in direction " + (Object)((Object)direction) + " from unit with ID " + unitID);
        }
        int plunderGold = -1;
        Unit defender = newTile.getDefendingUnit(unit);
        Player defendingPlayer = null;
        if (defender == null) {
            if (newTile.getSettlement() == null) throw new IllegalStateException("Nothing to attack in direction " + (Object)((Object)direction) + " from unit with ID " + unitID);
            defendingPlayer = newTile.getSettlement().getOwner();
            result = new CombatModel.CombatResult(CombatModel.CombatResultType.DONE_SETTLEMENT, 0);
        } else {
            defendingPlayer = defender.getOwner();
            result = unit.getGame().getCombatModel().generateAttackResult(unit, defender);
        }
        if (result.type == CombatModel.CombatResultType.DONE_SETTLEMENT) {
            plunderGold = newTile.getSettlement().getOwner().getGold() / 10;
        }
        Location repairLocation = null;
        Player loserOwner = null;
        block1 : switch (result.type) {
            case WIN: {
                if (!defender.isNaval()) break;
                loserOwner = defendingPlayer;
                repairLocation = loserOwner.getRepairLocation(defender);
                break;
            }
            case DONE_SETTLEMENT: {
                for (Unit victim : newTile.getUnitList()) {
                    if (!victim.isNaval()) continue;
                    loserOwner = victim.getOwner();
                    repairLocation = loserOwner.getRepairLocation(victim);
                    break block1;
                }
                break;
            }
            case LOSS: {
                if (!unit.isNaval()) break;
                loserOwner = player;
                repairLocation = loserOwner.getRepairLocation(unit);
                break;
            }
        }
        for (ServerPlayer enemyPlayer : this.getOtherPlayers(player)) {
            Element opponentAttackElement = Message.createNewRootElement("opponentAttack");
            if (!unit.isVisibleTo(enemyPlayer) && !defender.isVisibleTo(enemyPlayer)) continue;
            opponentAttackElement.setAttribute("direction", direction.toString());
            opponentAttackElement.setAttribute("result", result.type.toString());
            opponentAttackElement.setAttribute("damage", String.valueOf(result.damage));
            opponentAttackElement.setAttribute("plunderGold", Integer.toString(plunderGold));
            opponentAttackElement.setAttribute("unit", unit.getId());
            opponentAttackElement.setAttribute("defender", defender.getId());
            if (defender.getOwner() == enemyPlayer) {
                if (repairLocation != null && loserOwner == defender.getOwner()) {
                    opponentAttackElement.setAttribute("repairIn", repairLocation.getId());
                }
                opponentAttackElement.setAttribute("update", "unit");
                opponentAttackElement.appendChild(unit.toXMLElement(enemyPlayer, opponentAttackElement.getOwnerDocument(), false, false));
            } else if (!defender.isVisibleTo(enemyPlayer)) {
                opponentAttackElement.setAttribute("update", "defender");
                opponentAttackElement.setAttribute("defenderTile", defender.getTile().getId());
                if (!enemyPlayer.canSee(defender.getTile())) {
                    enemyPlayer.setExplored(defender.getTile());
                    opponentAttackElement.appendChild(defender.getTile().toXMLElement(enemyPlayer, opponentAttackElement.getOwnerDocument()));
                }
                opponentAttackElement.appendChild(defender.toXMLElement(enemyPlayer, opponentAttackElement.getOwnerDocument(), false, false));
            } else if (!unit.isVisibleTo(enemyPlayer)) {
                opponentAttackElement.setAttribute("update", "unit");
                Element unitElm = unit.toXMLElement(enemyPlayer, opponentAttackElement.getOwnerDocument(), false, false);
                opponentAttackElement.appendChild(unitElm);
            }
            try {
                enemyPlayer.getConnection().sendAndWait(opponentAttackElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
        Element reply = Message.createNewRootElement("attackResult");
        reply.setAttribute("result", result.type.toString());
        reply.setAttribute("damage", String.valueOf(result.damage));
        reply.setAttribute("plunderGold", Integer.toString(plunderGold));
        if (repairLocation != null && player == loserOwner) {
            reply.setAttribute("repairIn", repairLocation.getId());
        }
        if (result.type == CombatModel.CombatResultType.DONE_SETTLEMENT && newTile.getColony() != null) {
            reply.appendChild(newTile.toXMLElement(newTile.getColony().getOwner(), reply.getOwnerDocument()));
            reply.appendChild(defender.toXMLElement(newTile.getColony().getOwner(), reply.getOwnerDocument()));
        } else {
            reply.appendChild(defender.toXMLElement(player, reply.getOwnerDocument(), false, false));
        }
        boolean isIndianCapitalBurned = false;
        if (result.type == CombatModel.CombatResultType.DONE_SETTLEMENT && newTile.getSettlement() instanceof IndianSettlement && ((IndianSettlement)newTile.getSettlement()).isCapital()) {
            isIndianCapitalBurned = true;
            reply.setAttribute("indianCapitalBurned", Boolean.toString(isIndianCapitalBurned));
        }
        Hashtable<String, Integer> oldGoodsCounts = new Hashtable<String, Integer>();
        if (unit.canCaptureGoods() && this.getGame().getGameOptions().getBoolean("model.option.unitHiding")) {
            List<Goods> goodsInUnit = unit.getGoodsContainer().getFullGoods();
            for (Goods goods : goodsInUnit) {
                oldGoodsCounts.put(goods.getType().getId(), goods.getAmount());
            }
        }
        int oldUnits = unit.getTile().getUnitCount();
        unit.getGame().getCombatModel().attack(unit, defender, result, plunderGold, repairLocation);
        if (isIndianCapitalBurned) {
            defendingPlayer.surrenderTo(player);
        }
        if (result.type.compareTo(CombatModel.CombatResultType.WIN) >= 0 && unit.getTile() != newTile && oldUnits < unit.getTile().getUnitCount() && !(lastUnit = unit.getTile().getLastUnit()).getOwner().isEuropean()) {
            Element convertElement = reply.getOwnerDocument().createElement("convert");
            convertElement.appendChild(lastUnit.toXMLElement(unit.getOwner(), reply.getOwnerDocument()));
            reply.appendChild(convertElement);
        }
        if (unit.canCaptureGoods() && this.getGame().getGameOptions().getBoolean("model.option.unitHiding")) {
            List<Goods> goodsInUnit = unit.getGoodsContainer().getCompactGoods();
            for (Goods newGoods : goodsInUnit) {
                Integer oldGoodsAmount = (Integer)oldGoodsCounts.get(newGoods.getType().getId());
                int capturedGoods = newGoods.getAmount() - (oldGoodsAmount != null ? oldGoodsAmount : 0);
                if (capturedGoods <= 0) continue;
                Element captured = reply.getOwnerDocument().createElement("capturedGoods");
                captured.setAttribute("type", newGoods.getType().getId());
                captured.setAttribute("amount", Integer.toString(capturedGoods));
                reply.appendChild(captured);
            }
        }
        if (result.type.compareTo(CombatModel.CombatResultType.EVADES) < 0 || !unit.getTile().equals(newTile)) return reply;
        Element update = reply.getOwnerDocument().createElement("update");
        int lineOfSight = unit.getLineOfSight();
        if (result.type == CombatModel.CombatResultType.DONE_SETTLEMENT && newTile.getSettlement() != null) {
            lineOfSight = Math.max(lineOfSight, newTile.getSettlement().getLineOfSight());
        }
        List<Tile> surroundingTiles = this.getGame().getMap().getSurroundingTiles(unit.getTile(), lineOfSight);
        for (int i = 0; i < surroundingTiles.size(); ++i) {
            Tile t = surroundingTiles.get(i);
            update.appendChild(t.toXMLElement(player, update.getOwnerDocument()));
        }
        update.appendChild(unit.getTile().toXMLElement(player, update.getOwnerDocument()));
        reply.appendChild(update);
        return reply;
    }

    private Element embark(Connection connection, Element embarkElement) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(embarkElement.getAttribute("unit"));
        Map.Direction direction = Enum.valueOf(Map.Direction.class, embarkElement.getAttribute("direction"));
        Unit destinationUnit = (Unit)this.getGame().getFreeColGameObject(embarkElement.getAttribute("embarkOnto"));
        if (unit == null || destinationUnit == null || this.getGame().getMap().getNeighbourOrNull(direction, unit.getTile()) != destinationUnit.getTile()) {
            throw new IllegalArgumentException("Invalid data format in client message.");
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile oldTile = unit.getTile();
        unit.embark(destinationUnit);
        this.sendRemoveUnitToAll(unit, player);
        return null;
    }

    private Element boardShip(Connection connection, Element boardShipElement) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(boardShipElement.getAttribute("unit"));
        Unit carrier = (Unit)this.getGame().getFreeColGameObject(boardShipElement.getAttribute("carrier"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile oldTile = unit.getTile();
        boolean tellEnemyPlayers = true;
        if (oldTile == null || oldTile.getSettlement() != null) {
            tellEnemyPlayers = false;
        }
        if (unit.isNaval()) {
            logger.warning("Tried to load a ship onto another carrier.");
            return null;
        }
        unit.boardShip(carrier);
        if (tellEnemyPlayers) {
            this.sendRemoveUnitToAll(unit, player);
        }
        this.sendUpdatedTileToAll(unit.getTile(), player);
        return null;
    }

    private Element learnSkillAtSettlement(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        Map map = this.getGame().getMap();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        boolean cancelAction = false;
        if (element.getAttribute("action").equals("cancel")) {
            cancelAction = true;
        }
        if (unit.getTile() == null) {
            throw new IllegalArgumentException("'Unit' not on map: ID: " + element.getAttribute("unit"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile tile = map.getNeighbourOrNull(direction, unit.getTile());
        IndianSettlement settlement = (IndianSettlement)tile.getSettlement();
        if (settlement == null) {
            throw new IllegalStateException("No settlement to learn skill from.");
        }
        if (!unit.getType().canBeUpgraded(settlement.getLearnableSkill(), UnitType.UpgradeType.NATIVES)) {
            throw new IllegalStateException("Unit can't learn that skill from settlement!");
        }
        Element reply = Message.createNewRootElement("learnSkillResult");
        if (!cancelAction) {
            Tension tension = settlement.getAlarm(player);
            if (tension == null) {
                tension = new Tension(0);
            }
            switch (tension.getLevel()) {
                case HATEFUL: {
                    reply.setAttribute("result", "die");
                    unit.dispose();
                    break;
                }
                case ANGRY: {
                    reply.setAttribute("result", "leave");
                    break;
                }
                default: {
                    unit.setType(settlement.getLearnableSkill());
                    if (!settlement.isCapital()) {
                        settlement.setLearnableSkill(null);
                    }
                    settlement.getTile().updateIndianSettlementSkill(player);
                    reply.setAttribute("result", "success");
                    break;
                }
            }
        } else {
            reply.setAttribute("result", "cancelled");
        }
        return reply;
    }

    private Element scoutIndianSettlement(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        Map map = this.getGame().getMap();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        String action = element.getAttribute("action");
        IndianSettlement settlement = (IndianSettlement)map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
        Element reply = Message.createNewRootElement("scoutIndianSettlementResult");
        if (action.equals("basic")) {
            unit.contactAdjacent(settlement.getTile());
            unit.setMovesLeft(0);
            UnitType skill = settlement.getLearnableSkill();
            if (skill != null) {
                reply.setAttribute("skill", skill.getId());
            }
            settlement.updateWantedGoods();
            GoodsType[] wantedGoods = settlement.getWantedGoods();
            reply.setAttribute("highlyWantedGoods", wantedGoods[0].getId());
            reply.setAttribute("wantedGoods1", wantedGoods[1].getId());
            reply.setAttribute("wantedGoods2", wantedGoods[2].getId());
            reply.setAttribute("numberOfCamps", String.valueOf(settlement.getOwner().getSettlements().size()));
            for (Tile tile : this.getGame().getMap().getSurroundingTiles(settlement.getTile(), unit.getLineOfSight())) {
                reply.appendChild(tile.toXMLElement(player, reply.getOwnerDocument()));
            }
            settlement.getTile().updateIndianSettlementInformation(player);
        } else {
            if (action.equals("cancel")) {
                return null;
            }
            if (action.equals("attack")) {
                unit.setMovesLeft(1);
                return null;
            }
            if (settlement.getAlarm(player) != null && settlement.getAlarm(player).getLevel() == Tension.Level.HATEFUL) {
                reply.setAttribute("result", "die");
                unit.dispose();
            } else if (action.equals("speak")) {
                if (!settlement.hasBeenVisited()) {
                    double random = Math.random();
                    if (random < 0.33) {
                        reply.setAttribute("result", "tales");
                        Element update = reply.getOwnerDocument().createElement("update");
                        Map.Position center = new Map.Position(settlement.getTile().getX(), settlement.getTile().getY());
                        Map.CircleIterator circleIterator = map.getCircleIterator(center, true, 6);
                        while (circleIterator.hasNext()) {
                            Map.Position position = (Map.Position)circleIterator.next();
                            if (position.equals(center) || !map.getTile(position).isLand() && map.getTile(position).getLandCount() <= 0) continue;
                            Tile t = map.getTile(position);
                            player.setExplored(t);
                            update.appendChild(t.toXMLElement(player, update.getOwnerDocument(), true, false));
                        }
                        reply.appendChild(update);
                    } else {
                        int beadsGold = (int)(Math.random() * (double)(400 * settlement.getBonusMultiplier())) + 50;
                        if (unit.hasAbility("model.ability.expertScout")) {
                            beadsGold = beadsGold * 11 / 10;
                        }
                        reply.setAttribute("result", "beads");
                        reply.setAttribute("amount", Integer.toString(beadsGold));
                        player.modifyGold(beadsGold);
                    }
                    settlement.setVisited(player);
                } else {
                    reply.setAttribute("result", "nothing");
                }
            } else if (action.equals("tribute")) {
                this.demandTribute(settlement, player, reply);
            }
        }
        return reply;
    }

    private Element armedUnitDemandTribute(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (unit.getTile() == null) {
            throw new IllegalArgumentException("'Unit' is not on the map: " + unit.toString());
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile newTile = this.getGame().getMap().getNeighbourOrNull(direction, unit.getTile());
        if (newTile == null) {
            throw new IllegalArgumentException("Could not find tile in direction " + (Object)((Object)direction) + " from unit with ID " + element.getAttribute("unit"));
        }
        unit.setMovesLeft(0);
        IndianSettlement settlement = (IndianSettlement)newTile.getSettlement();
        Element reply = Message.createNewRootElement("armedUnitDemandTributeResult");
        this.demandTribute(settlement, player, reply);
        return reply;
    }

    private void demandTribute(IndianSettlement settlement, Player player, Element reply) {
        int gold = settlement.getTribute(player);
        if (gold > 0) {
            reply.setAttribute("result", "agree");
            reply.setAttribute("amount", String.valueOf(gold));
            player.modifyGold(gold);
        } else {
            reply.setAttribute("result", "disagree");
        }
    }

    private Element missionaryAtSettlement(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        InGameController inGameController = freeColServer.getInGameController();
        Map map = this.getGame().getMap();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        String action = element.getAttribute("action");
        IndianSettlement settlement = (IndianSettlement)map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
        unit.setMovesLeft(0);
        if (action.equals("cancel")) {
            return null;
        }
        if (action.equals("establish")) {
            this.sendRemoveUnitToAll(unit, player);
            boolean success = inGameController.createMission(settlement, unit);
            Element reply = Message.createNewRootElement("missionaryReply");
            reply.setAttribute("success", String.valueOf(success));
            reply.setAttribute("tension", settlement.getAlarm(unit.getOwner()).getLevel().toString());
            return reply;
        }
        if (action.equals("heresy")) {
            Element reply = Message.createNewRootElement("missionaryReply");
            this.sendRemoveUnitToAll(unit, player);
            double random = Math.random() * (double)settlement.getMissionary().getOwner().getCrosses() / (double)(unit.getOwner().getCrosses() + 1);
            if (settlement.getMissionary().hasAbility("model.ability.expertMissionary")) {
                random += 0.2;
            }
            if (unit.hasAbility("model.ability.expertMissionary")) {
                random -= 0.2;
            }
            if (random < 0.5) {
                boolean success = inGameController.createMission(settlement, unit);
                reply.setAttribute("success", String.valueOf(success));
                reply.setAttribute("tension", settlement.getAlarm(unit.getOwner()).getLevel().toString());
            } else {
                reply.setAttribute("success", "false");
                unit.dispose();
            }
            return reply;
        }
        if (action.equals("incite")) {
            Element reply = Message.createNewRootElement("missionaryReply");
            Player enemy = (Player)this.getGame().getFreeColGameObject(element.getAttribute("incite"));
            reply.setAttribute("amount", String.valueOf(Game.getInciteAmount(player, enemy, settlement.getOwner())));
            unit.setLocation(settlement);
            return reply;
        }
        return null;
    }

    private Element inciteAtSettlement(Connection connection, Element element) {
        FreeColServer freeColServer = this.getFreeColServer();
        Map map = this.getGame().getMap();
        ServerPlayer player = freeColServer.getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        String confirmed = element.getAttribute("confirmed");
        IndianSettlement settlement = (IndianSettlement)unit.getTile().getSettlement();
        unit.setLocation(map.getNeighbourOrNull(direction.getReverseDirection(), unit.getTile()));
        if (confirmed.equals("true")) {
            Player enemy = (Player)this.getGame().getFreeColGameObject(element.getAttribute("enemy"));
            int amount = Game.getInciteAmount(player, enemy, settlement.getOwner());
            if (player.getGold() < amount) {
                throw new IllegalStateException("Not enough gold to incite indians!");
            }
            player.modifyGold(-amount);
            settlement.getOwner().changeRelationWithPlayer(enemy, Player.Stance.WAR);
            settlement.modifyAlarm(enemy, 1000);
            enemy.modifyTension(settlement.getOwner(), 500);
            enemy.modifyTension(player, 250);
        }
        return null;
    }

    private Element leaveShip(Connection connection, Element leaveShipElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(leaveShipElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        unit.leaveShip();
        Tile newTile = unit.getTile();
        if (newTile != null) {
            this.sendUpdatedTileToAll(newTile, player);
        }
        return null;
    }

    private Element loadCargo(Connection connection, Element loadCargoElement) {
        Unit carrier = (Unit)this.getGame().getFreeColGameObject(loadCargoElement.getAttribute("carrier"));
        Goods goods = new Goods(this.getGame(), (Element)loadCargoElement.getChildNodes().item(0));
        goods.loadOnto(carrier);
        return null;
    }

    private Element unloadCargo(Connection connection, Element unloadCargoElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Goods goods = new Goods(this.getGame(), (Element)unloadCargoElement.getChildNodes().item(0));
        if (goods.getLocation() instanceof Unit && ((Unit)goods.getLocation()).getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        if (goods.getLocation() instanceof Unit && ((Unit)goods.getLocation()).getColony() != null) {
            goods.unload();
        } else {
            goods.setLocation(null);
        }
        return null;
    }

    private Element buyGoods(Connection connection, Element buyGoodsElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit carrier = (Unit)this.getGame().getFreeColGameObject(buyGoodsElement.getAttribute("carrier"));
        GoodsType type = FreeCol.getSpecification().getGoodsType(buyGoodsElement.getAttribute("type"));
        int amount = Integer.parseInt(buyGoodsElement.getAttribute("amount"));
        if (carrier.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        if (carrier.getOwner() != player) {
            throw new IllegalStateException();
        }
        carrier.buyGoods(type, amount);
        Element marketElement = Message.createNewRootElement("marketElement");
        marketElement.setAttribute("type", type.getId());
        marketElement.setAttribute("amount", String.valueOf(-amount / 4));
        this.getFreeColServer().getServer().sendToAll(marketElement, player.getConnection());
        return null;
    }

    private Element sellGoods(Connection connection, Element sellGoodsElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Goods goods = new Goods(this.getGame(), (Element)sellGoodsElement.getChildNodes().item(0));
        if (goods.getLocation() instanceof Unit && ((Unit)goods.getLocation()).getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        player.getMarket().sell(goods, player);
        Element marketElement = Message.createNewRootElement("marketElement");
        marketElement.setAttribute("type", goods.getType().getId());
        marketElement.setAttribute("amount", String.valueOf(goods.getAmount() / 4));
        this.getFreeColServer().getServer().sendToAll(marketElement, player.getConnection());
        return null;
    }

    private Element moveToEurope(Connection connection, Element moveToEuropeElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(moveToEuropeElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        this.sendRemoveUnitToAll(unit, player);
        Tile oldTile = unit.getTile();
        unit.moveToEurope();
        return null;
    }

    private Element moveToAmerica(Connection connection, Element moveToAmericaElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(moveToAmericaElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        unit.moveToAmerica();
        return null;
    }

    private Element buildColony(Connection connection, Element buildColonyElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        String name = buildColonyElement.getAttribute("name");
        Unit unit = (Unit)this.getGame().getFreeColGameObject(buildColonyElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        if (unit.canBuildColony()) {
            Colony colony = new Colony(this.getGame(), player, name, unit.getTile());
            Element reply = Message.createNewRootElement("buildColonyConfirmed");
            reply.appendChild(colony.toXMLElement(player, reply.getOwnerDocument()));
            Element updateElement = reply.getOwnerDocument().createElement("update");
            int range = colony.getLineOfSight();
            if (range > unit.getLineOfSight()) {
                for (Tile t : this.getGame().getMap().getSurroundingTiles(unit.getTile(), range)) {
                    updateElement.appendChild(t.toXMLElement(player, reply.getOwnerDocument()));
                }
            }
            updateElement.appendChild(unit.getTile().toXMLElement(player, reply.getOwnerDocument()));
            reply.appendChild(updateElement);
            unit.buildColony(colony);
            this.sendUpdatedTileToAll(unit.getTile(), player);
            return reply;
        }
        logger.warning("A client is requesting to build a colony, but the operation is not permitted! (unsynchronized?)");
        return null;
    }

    private Element recruitUnitInEurope(Connection connection, Element recruitUnitInEuropeElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Europe europe = player.getEurope();
        int slot = Integer.parseInt(recruitUnitInEuropeElement.getAttribute("slot"));
        UnitType recruitable = europe.getRecruitable(slot);
        UnitType newRecruitable = player.generateRecruitable("abc" + this.getPseudoRandom().nextInt(10000));
        Unit unit = new Unit(this.getGame(), europe, player, recruitable, Unit.UnitState.ACTIVE, recruitable.getDefaultEquipment());
        Element reply = Message.createNewRootElement("recruitUnitInEuropeConfirmed");
        reply.setAttribute("newRecruitable", newRecruitable.getId());
        reply.appendChild(unit.toXMLElement(player, reply.getOwnerDocument()));
        europe.recruit(slot, unit, newRecruitable);
        return reply;
    }

    private Element emigrateUnitInEurope(Connection connection, Element emigrateUnitInEuropeElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Europe europe = player.getEurope();
        int slot = player.hasAbility("model.ability.selectRecruit") ? Integer.parseInt(emigrateUnitInEuropeElement.getAttribute("slot")) : (int)(Math.random() * 3.0);
        UnitType recruitable = europe.getRecruitable(slot);
        UnitType newRecruitable = player.generateRecruitable("xyzzy" + this.getPseudoRandom().nextInt(10000));
        Unit unit = new Unit(this.getGame(), europe, player, recruitable, Unit.UnitState.ACTIVE, recruitable.getDefaultEquipment());
        Element reply = Message.createNewRootElement("emigrateUnitInEuropeConfirmed");
        if (!player.hasAbility("model.ability.selectRecruit")) {
            reply.setAttribute("slot", Integer.toString(slot));
        }
        reply.setAttribute("newRecruitable", newRecruitable.getId());
        reply.appendChild(unit.toXMLElement(player, reply.getOwnerDocument()));
        europe.emigrate(slot, unit, newRecruitable);
        return reply;
    }

    private Element trainUnitInEurope(Connection connection, Element trainUnitInEuropeElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Europe europe = player.getEurope();
        String unitId = trainUnitInEuropeElement.getAttribute("unitType");
        UnitType unitType = FreeCol.getSpecification().getUnitType(unitId);
        Unit unit = new Unit(this.getGame(), europe, player, unitType, Unit.UnitState.ACTIVE, unitType.getDefaultEquipment());
        Element reply = Message.createNewRootElement("trainUnitInEuropeConfirmed");
        reply.appendChild(unit.toXMLElement(player, reply.getOwnerDocument()));
        europe.train(unit);
        return reply;
    }

    private Element equipUnit(Connection connection, Element workElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(workElement.getAttribute("unit"));
        String typeString = workElement.getAttribute("type");
        EquipmentType type = FreeCol.getSpecification().getEquipmentType(typeString);
        int amount = Integer.parseInt(workElement.getAttribute("amount"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        if (amount > 0) {
            for (int count = 0; count < amount; ++count) {
                unit.equipWith(type);
            }
        } else {
            for (int count = 0; count > amount; --count) {
                unit.removeEquipment(type);
            }
        }
        if (unit.getLocation() instanceof Tile) {
            this.sendUpdatedTileToAll(unit.getTile(), player);
        }
        return null;
    }

    private Element work(Connection connection, Element workElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(workElement.getAttribute("unit"));
        WorkLocation workLocation = (WorkLocation)((Object)this.getGame().getFreeColGameObject(workElement.getAttribute("workLocation")));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        if (workLocation == null) {
            throw new NullPointerException();
        }
        if (!workLocation.canAdd(unit)) {
            throw new IllegalStateException("Can not add " + unit.getName() + "(" + unit.getId() + ") to " + workLocation.toString() + "(" + workLocation.getId() + ")");
        }
        Location oldLocation = unit.getLocation();
        unit.work(workLocation);
        this.sendUpdatedTileToAll(unit.getTile(), player);
        if (oldLocation instanceof ColonyTile) {
            this.sendUpdatedTileToAll(((ColonyTile)oldLocation).getWorkTile(), player);
        }
        if (workLocation instanceof ColonyTile) {
            this.sendUpdatedTileToAll(((ColonyTile)workLocation).getWorkTile(), player);
        }
        return null;
    }

    private Element changeWorkType(Connection connection, Element workElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(workElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        String workTypeString = workElement.getAttribute("workType");
        if (workTypeString != null) {
            GoodsType workType = FreeCol.getSpecification().getGoodsType(workTypeString);
            unit.setWorkType(workType);
        }
        return null;
    }

    private Element workImprovement(Connection connection, Element workElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(workElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile tile = unit.getTile();
        String improvementTypeString = workElement.getAttribute("improvementType");
        if (improvementTypeString != null) {
            Element reply = Message.createNewRootElement("workImprovementConfirmed");
            if (tile.getTileItemContainer() == null) {
                tile.setTileItemContainer(new TileItemContainer(tile.getGame(), tile));
                reply.appendChild(tile.getTileItemContainer().toXMLElement(player, reply.getOwnerDocument()));
            }
            TileImprovementType type = FreeCol.getSpecification().getTileImprovementType(improvementTypeString);
            TileImprovement improvement = unit.getTile().findTileImprovementType(type);
            if (improvement == null) {
                improvement = new TileImprovement(this.getGame(), unit.getTile(), type);
                unit.getTile().add(improvement);
            }
            reply.appendChild(improvement.toXMLElement(player, reply.getOwnerDocument()));
            unit.work(improvement);
            return reply;
        }
        return null;
    }

    private Element assignTeacher(Connection connection, Element workElement) {
        Unit teacher;
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit student = (Unit)this.getGame().getFreeColGameObject(workElement.getAttribute("student"));
        if (!student.canBeStudent(teacher = (Unit)this.getGame().getFreeColGameObject(workElement.getAttribute("teacher")))) {
            throw new IllegalStateException("Unit can not be student!");
        }
        if (!teacher.getColony().canTrain(teacher)) {
            throw new IllegalStateException("Unit can not be teacher!");
        }
        if (student.getOwner() != player) {
            throw new IllegalStateException("Student is not your unit!");
        }
        if (teacher.getOwner() != player) {
            throw new IllegalStateException("Teacher is not your unit!");
        }
        if (student.getColony() != teacher.getColony()) {
            throw new IllegalStateException("Student and teacher are not in the same colony!");
        }
        if (!(student.getLocation() instanceof WorkLocation)) {
            throw new IllegalStateException("Student is not in a WorkLocation!");
        }
        if (student.getTeacher() != null) {
            student.getTeacher().setStudent(null);
        }
        student.setTeacher(teacher);
        if (teacher.getStudent() != null) {
            teacher.getStudent().setTeacher(null);
        }
        teacher.setStudent(student);
        return null;
    }

    private Element setCurrentlyBuilding(Connection connection, Element setCurrentlyBuildingElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Colony colony = (Colony)this.getGame().getFreeColGameObject(setCurrentlyBuildingElement.getAttribute("colony"));
        if (colony.getOwner() != player) {
            throw new IllegalStateException("Not your colony!");
        }
        String typeString = setCurrentlyBuildingElement.getAttribute("type");
        BuildableType type = null;
        type = typeString.equals("model.buildableType.nothing") ? BuildableType.NOTHING : (BuildableType)FreeCol.getSpecification().getType(typeString);
        colony.setCurrentlyBuilding(type);
        this.sendUpdatedTileToAll(colony.getTile(), player);
        return null;
    }

    private Element changeState(Connection connection, Element changeStateElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObjectSafely(changeStateElement.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + changeStateElement.getAttribute("unit"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Unit.UnitState state = Enum.valueOf(Unit.UnitState.class, changeStateElement.getAttribute("state"));
        Tile oldTile = unit.getTile();
        if (unit.checkSetState(state)) {
            unit.setState(state);
        } else {
            logger.warning("Can't set state " + (Object)((Object)state) + " for unit " + unit + " with current state " + (Object)((Object)unit.getState()) + " and " + unit.getMovesLeft() + " moves left belonging to " + player + ". Possible cheating attempt (or bug)?");
        }
        this.sendUpdatedTileToAll(oldTile, player);
        return null;
    }

    private Element putOutsideColony(Connection connection, Element putOutsideColonyElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(putOutsideColonyElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        unit.putOutsideColony();
        this.sendUpdatedTileToAll(unit.getTile(), player);
        return null;
    }

    private Element payForBuilding(Connection connection, Element payForBuildingElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Colony colony = (Colony)this.getGame().getFreeColGameObject(payForBuildingElement.getAttribute("colony"));
        if (colony.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        colony.payForBuilding();
        return null;
    }

    private Element payArrears(Connection connection, Element payArrearsElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        GoodsType goodsType = FreeCol.getSpecification().getGoodsType(payArrearsElement.getAttribute("goodsType"));
        int arrears = player.getArrears(goodsType);
        if (player.getGold() < arrears) {
            throw new IllegalStateException("Not enough gold to pay tax arrears!");
        }
        player.modifyGold(-arrears);
        player.resetArrears(goodsType);
        return null;
    }

    private Element setGoodsLevels(Connection connection, Element setGoodsLevelsElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Colony colony = (Colony)this.getGame().getFreeColGameObject(setGoodsLevelsElement.getAttribute("colony"));
        if (colony == null) {
            throw new IllegalArgumentException("Found no colony with ID " + setGoodsLevelsElement.getAttribute("colony"));
        }
        if (colony.getOwner() != player) {
            throw new IllegalStateException("Not your colony!");
        }
        ExportData exportData = new ExportData();
        exportData.readFromXMLElement((Element)setGoodsLevelsElement.getChildNodes().item(0));
        colony.setExportData(exportData);
        return null;
    }

    private Element clearSpeciality(Connection connection, Element clearSpecialityElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(clearSpecialityElement.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        unit.clearSpeciality();
        if (unit.getLocation() instanceof Tile) {
            this.sendUpdatedTileToAll(unit.getTile(), player);
        }
        return null;
    }

    private Element endTurn(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        this.getFreeColServer().getInGameController().endTurn(player);
        return null;
    }

    private Element disbandUnit(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile oldTile = unit.getTile();
        unit.dispose();
        this.sendUpdatedTileToAll(oldTile, player);
        return null;
    }

    private Element cashInTreasureTrain(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        Tile oldTile = unit.getTile();
        unit.cashInTreasureTrain();
        this.sendUpdatedTileToAll(oldTile, player);
        return null;
    }

    private Element declareIndependence(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        String nationName = element.getAttribute("independentNationName");
        player.setIndependentNationName(nationName);
        ServerPlayer refPlayer = this.getFreeColServer().getInGameController().createREFPlayer(player);
        List<Unit> refUnits = this.getFreeColServer().getInGameController().createREFUnits(player, refPlayer);
        Element reply = Message.createNewRootElement("update");
        reply.appendChild(refPlayer.toXMLElement(null, reply.getOwnerDocument()));
        for (Unit unit : refUnits) {
            reply.appendChild(unit.toXMLElement(null, reply.getOwnerDocument()));
        }
        player.declareIndependence();
        return reply;
    }

    private Element giveIndependence(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Player independent = (Player)this.getGame().getFreeColGameObject(element.getAttribute("player"));
        if (independent.getREFPlayer() != player) {
            throw new IllegalStateException("Cannot give independence to a country we do not own.");
        }
        independent.giveIndependence();
        Element giveIndependenceElement = Message.createNewRootElement("giveIndependence");
        giveIndependenceElement.setAttribute("player", independent.getId());
        this.getFreeColServer().getServer().sendToAll(giveIndependenceElement, connection);
        return null;
    }

    private Element foreignAffairs(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Element reply = Message.createNewRootElement("foreignAffairsReport");
        Iterator<Player> enemyPlayerIterator = this.getGame().getPlayerIterator();
        while (enemyPlayerIterator.hasNext()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
            if (enemyPlayer.getConnection() == null || enemyPlayer.isIndian() || enemyPlayer.isREF()) continue;
            Element enemyElement = reply.getOwnerDocument().createElement("opponent");
            enemyElement.setAttribute("player", enemyPlayer.getId());
            int numberOfColonies = enemyPlayer.getSettlements().size();
            int numberOfUnits = 0;
            int militaryStrength = 0;
            int navalStrength = 0;
            Iterator<Unit> unitIterator = enemyPlayer.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit unit = unitIterator.next();
                ++numberOfUnits;
                if (unit.isNaval()) {
                    navalStrength = (int)((float)navalStrength + unit.getGame().getCombatModel().getOffencePower(unit, null));
                    continue;
                }
                militaryStrength = (int)((float)militaryStrength + unit.getGame().getCombatModel().getOffencePower(unit, null));
            }
            Player.Stance stance = enemyPlayer.getStance(player);
            if (stance == null) {
                stance = Player.Stance.PEACE;
            }
            enemyElement.setAttribute("numberOfColonies", String.valueOf(numberOfColonies));
            enemyElement.setAttribute("numberOfUnits", String.valueOf(numberOfUnits));
            enemyElement.setAttribute("militaryStrength", String.valueOf(militaryStrength));
            enemyElement.setAttribute("navalStrength", String.valueOf(navalStrength));
            enemyElement.setAttribute("stance", String.valueOf((Object)stance));
            enemyElement.setAttribute("gold", String.valueOf(enemyPlayer.getGold()));
            if (player.equals(enemyPlayer) || player.hasAbility("model.ability.betterForeignAffairsReport")) {
                enemyElement.setAttribute("SoL", String.valueOf(enemyPlayer.getSoL()));
                enemyElement.setAttribute("foundingFathers", String.valueOf(enemyPlayer.getFatherCount()));
                enemyElement.setAttribute("tax", String.valueOf(enemyPlayer.getTax()));
            }
            reply.appendChild(enemyElement);
        }
        return reply;
    }

    private Element highScores(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Element reply = Message.createNewRootElement("highScoresReport");
        for (HighScore score : this.getFreeColServer().getHighScores()) {
            reply.appendChild(score.toXMLElement(player, reply.getOwnerDocument()));
        }
        return reply;
    }

    private Element retire(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Element reply = Message.createNewRootElement("confirmRetire");
        boolean highScore = this.getFreeColServer().newHighScore(player);
        if (highScore) {
            try {
                this.getFreeColServer().saveHighScores();
                reply.setAttribute("highScore", "true");
            }
            catch (Exception e) {
                logger.warning(e.toString());
                reply.setAttribute("highScore", "false");
            }
        } else {
            reply.setAttribute("highScore", "false");
        }
        return reply;
    }

    private Element getREFUnits(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        List<Object> units = new ArrayList();
        UnitType defaultType = FreeCol.getSpecification().getUnitType("model.unit.freeColonist");
        if (player.getMonarch() == null) {
            ServerPlayer enemyPlayer = (ServerPlayer)player.getREFPlayer();
            HashMap unitHash = new HashMap();
            for (Unit unit : enemyPlayer.getUnits()) {
                Unit.Role role;
                Integer count;
                EnumMap<Unit.Role, Integer> roleMap;
                if (!unit.isOffensiveUnit()) continue;
                UnitType unitType = defaultType;
                if (unit.getType().getOffence() > 0 || unit.hasAbility("model.ability.expertSoldier")) {
                    unitType = unit.getType();
                }
                if ((roleMap = (EnumMap<Unit.Role, Integer>)unitHash.get(unitType)) == null) {
                    roleMap = new EnumMap<Unit.Role, Integer>(Unit.Role.class);
                }
                if ((count = (Integer)roleMap.get((Object)(role = unit.getRole()))) == null) {
                    roleMap.put(role, new Integer(1));
                } else {
                    roleMap.put(role, new Integer(count + 1));
                }
                unitHash.put(unitType, roleMap);
            }
            for (Map.Entry entry : unitHash.entrySet()) {
                for (Map.Entry roleEntry : ((EnumMap)entry.getValue()).entrySet()) {
                    units.add(new AbstractUnit((UnitType)entry.getKey(), (Unit.Role)((Object)roleEntry.getKey()), (int)((Integer)roleEntry.getValue())));
                }
            }
        } else {
            units = player.getMonarch().getREF();
        }
        Element reply = Message.createNewRootElement("REFUnits");
        for (AbstractUnit abstractUnit : units) {
            reply.appendChild(abstractUnit.toXMLElement(player, reply.getOwnerDocument()));
        }
        return reply;
    }

    private Element setDestination(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not the owner of the unit.");
        }
        Location destination = null;
        if (element.hasAttribute("destination")) {
            destination = (Location)((Object)this.getGame().getFreeColGameObject(element.getAttribute("destination")));
        }
        unit.setDestination(destination);
        return null;
    }

    private Element rename(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Nameable object = (Nameable)((Object)this.getGame().getFreeColGameObject(element.getAttribute("nameable")));
        if (!(object instanceof Ownable) || ((Ownable)((Object)object)).getOwner() != player) {
            throw new IllegalStateException("Not the owner of the nameable.");
        }
        object.setName(element.getAttribute("name"));
        return null;
    }

    private Element getTransactionSession(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Settlement settlement = (Settlement)this.getGame().getFreeColGameObject(element.getAttribute("settlement"));
        this.checkGeneralCondForTradeQuery(element, player, unit, settlement, null);
        InGameController controller = (InGameController)this.getFreeColServer().getController();
        if (!controller.isTransactionSessionOpen(unit, settlement) && unit.getMovesLeft() <= 0) {
            throw new IllegalStateException("No moves left!");
        }
        java.util.Map<String, Object> session = controller.getTransactionSession(unit, settlement);
        unit.setMovesLeft(0);
        Element reply = Message.createNewRootElement("getTransactionAnswer");
        reply.setAttribute("canBuy", ((Boolean)session.get("canBuy")).toString());
        reply.setAttribute("canSell", ((Boolean)session.get("canSell")).toString());
        reply.setAttribute("canGift", ((Boolean)session.get("canGift")).toString());
        reply.setAttribute("hasSpaceLeft", ((Boolean)session.get("hasSpaceLeft")).toString());
        return reply;
    }

    private Element closeTransactionSession(Connection connection, Element element) {
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Settlement settlement = (Settlement)this.getGame().getFreeColGameObject(element.getAttribute("settlement"));
        InGameController controller = this.getFreeColServer().getInGameController();
        if (!controller.isTransactionSessionOpen(unit, settlement)) {
            throw new IllegalStateException("Trying to close a non-existing session");
        }
        java.util.Map<String, Object> session = controller.getTransactionSession(unit, settlement);
        boolean isActionTaken = (Boolean)session.get("actionTaken");
        if (!isActionTaken) {
            Integer unitMoves = (Integer)session.get("unitMoves");
            unit.setMovesLeft(unitMoves);
        }
        controller.closeTransactionSession(unit, settlement);
        return null;
    }

    private void checkGeneralCondForTradeQuery(Element element, Player player, Unit unit, Settlement settlement, Goods goods) {
        if (goods != null && goods.getAmount() > 100) {
            throw new IllegalArgumentException("Amount of goods exceeds 100: " + goods.getAmount());
        }
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (settlement == null) {
            throw new IllegalArgumentException("Could not find 'Settlement' with specified ID: " + element.getAttribute("settlement"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        if (unit.getTile().getDistanceTo(settlement.getTile()) > 1) {
            throw new IllegalStateException("Not adjacent to settlement!");
        }
        if (settlement.getOwner().isIndian() && !player.hasContacted(settlement.getOwner())) {
            throw new IllegalStateException("Player has not established contact with the Indians!");
        }
    }

    private Element tradeProposition(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Settlement settlement = (Settlement)this.getGame().getFreeColGameObject(element.getAttribute("settlement"));
        Goods goods = new Goods(this.getGame(), Message.getChildElement(element, Goods.getXMLElementTagName()));
        this.checkGeneralCondForTradeQuery(element, player, unit, settlement, goods);
        InGameController controller = (InGameController)this.getFreeColServer().getController();
        if (!controller.isTransactionSessionOpen(unit, settlement)) {
            throw new IllegalStateException("trying to trade without opening a transaction session");
        }
        java.util.Map<String, Object> session = controller.getTransactionSession(unit, settlement);
        if (!((Boolean)session.get("canSell")).booleanValue()) {
            throw new IllegalStateException("trying to sell with a session where selling not allowed");
        }
        int gold = -1;
        if (element.hasAttribute("gold")) {
            gold = Integer.parseInt(element.getAttribute("gold"));
        }
        int returnGold = ((AIPlayer)this.getFreeColServer().getAIMain().getAIObject(settlement.getOwner())).tradeProposition(unit, settlement, goods, gold);
        Element tpaElement = Message.createNewRootElement("tradePropositionAnswer");
        tpaElement.setAttribute("gold", Integer.toString(returnGold));
        return tpaElement;
    }

    private Element trade(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Settlement settlement = (Settlement)this.getGame().getFreeColGameObject(element.getAttribute("settlement"));
        Goods goods = new Goods(this.getGame(), Message.getChildElement(element, Goods.getXMLElementTagName()));
        this.checkGeneralCondForTradeQuery(element, player, unit, settlement, goods);
        InGameController controller = (InGameController)this.getFreeColServer().getController();
        if (!controller.isTransactionSessionOpen(unit, settlement)) {
            throw new IllegalStateException("trying to trade without opening a transaction session");
        }
        java.util.Map<String, Object> session = controller.getTransactionSession(unit, settlement);
        if (!((Boolean)session.get("canSell")).booleanValue()) {
            throw new IllegalStateException("trying to sell with a session where selling not allowed");
        }
        int gold = Integer.parseInt(element.getAttribute("gold"));
        if (gold <= 0) {
            throw new IllegalArgumentException();
        }
        AIPlayer aiPlayer = (AIPlayer)this.getFreeColServer().getAIMain().getAIObject(settlement.getOwner());
        int returnGold = aiPlayer.tradeProposition(unit, settlement, goods, gold);
        if (returnGold != gold) {
            throw new IllegalArgumentException("This was not the price we agreed upon! Cheater?");
        }
        unit.trade(settlement, goods, gold);
        session.put("actionTaken", true);
        session.put("hasSpaceLeft", unit.getSpaceLeft() != 0);
        return null;
    }

    private Element goodsForSaleRequest(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        IndianSettlement settlement = (IndianSettlement)this.getGame().getFreeColGameObject(element.getAttribute("settlement"));
        this.checkGeneralCondForTradeQuery(element, player, unit, settlement, null);
        if (!(settlement instanceof IndianSettlement)) {
            throw new IllegalStateException("Settlement not an Indian Settlement");
        }
        AIPlayer aiPlayer = (AIPlayer)this.getFreeColServer().getAIMain().getAIObject(settlement.getOwner());
        Element reply = Message.createNewRootElement("goodsForSaleAnswer");
        List<Goods> goodsForSale = settlement.getSellGoods();
        if (!goodsForSale.isEmpty()) {
            for (Goods goods : goodsForSale) {
                aiPlayer.registerSellGoods(goods);
                reply.appendChild(goods.toXMLElement(null, reply.getOwnerDocument()));
            }
        }
        return reply;
    }

    private Element buyProposition(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Goods goods = new Goods(this.getGame(), Message.getChildElement(element, Goods.getXMLElementTagName()));
        IndianSettlement settlement = (IndianSettlement)goods.getLocation();
        this.checkGeneralCondForTradeQuery(element, player, unit, settlement, goods);
        InGameController controller = (InGameController)this.getFreeColServer().getController();
        if (!controller.isTransactionSessionOpen(unit, settlement)) {
            throw new IllegalStateException("trying to trade without opening a transaction session");
        }
        java.util.Map<String, Object> session = controller.getTransactionSession(unit, settlement);
        if (!((Boolean)session.get("canBuy")).booleanValue() && !((Boolean)session.get("hasSpaceLeft")).booleanValue()) {
            throw new IllegalStateException("trying to buy with a session where buying not allowed");
        }
        int gold = -1;
        if (element.hasAttribute("gold")) {
            gold = Integer.parseInt(element.getAttribute("gold"));
        }
        int returnGold = ((AIPlayer)this.getFreeColServer().getAIMain().getAIObject(settlement.getOwner())).buyProposition(unit, goods, gold);
        Element tpaElement = Message.createNewRootElement("buyPropositionAnswer");
        tpaElement.setAttribute("gold", Integer.toString(returnGold));
        return tpaElement;
    }

    private Element buy(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Goods goods = new Goods(this.getGame(), Message.getChildElement(element, Goods.getXMLElementTagName()));
        IndianSettlement settlement = (IndianSettlement)goods.getLocation();
        this.checkGeneralCondForTradeQuery(element, player, unit, settlement, goods);
        InGameController controller = (InGameController)this.getFreeColServer().getController();
        if (!controller.isTransactionSessionOpen(unit, settlement)) {
            throw new IllegalStateException("trying to trade without opening a transaction session");
        }
        java.util.Map<String, Object> session = controller.getTransactionSession(unit, settlement);
        if (!((Boolean)session.get("canBuy")).booleanValue() && !((Boolean)session.get("hasSpaceLeft")).booleanValue()) {
            throw new IllegalStateException("trying to buy with a session where buying not allowed");
        }
        int gold = Integer.parseInt(element.getAttribute("gold"));
        if (gold <= 0) {
            throw new IllegalArgumentException();
        }
        int returnGold = ((AIPlayer)this.getFreeColServer().getAIMain().getAIObject(settlement.getOwner())).buyProposition(unit, goods, gold);
        if (returnGold != gold) {
            throw new IllegalArgumentException("This was not the price we agreed upon! Cheater?");
        }
        unit.buy(settlement, goods, gold);
        session.put("actionTaken", true);
        return null;
    }

    private Element deliverGift(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Settlement settlement = (Settlement)this.getGame().getFreeColGameObject(element.getAttribute("settlement"));
        Goods goods = new Goods(this.getGame(), Message.getChildElement(element, Goods.getXMLElementTagName()));
        this.checkGeneralCondForTradeQuery(element, player, unit, settlement, goods);
        InGameController controller = (InGameController)this.getFreeColServer().getController();
        if (!controller.isTransactionSessionOpen(unit, settlement)) {
            throw new IllegalStateException("trying to trade without opening a transaction session");
        }
        ServerPlayer receiver = (ServerPlayer)settlement.getOwner();
        if (!receiver.isAI() && receiver.isConnected()) {
            Element deliverGiftElement = Message.createNewRootElement("deliverGift");
            Element unitElement = unit.toXMLElement(receiver, deliverGiftElement.getOwnerDocument());
            Element goodsContainerElement = unit.getGoodsContainer().toXMLElement(receiver, deliverGiftElement.getOwnerDocument());
            unitElement.replaceChild(goodsContainerElement, unitElement.getElementsByTagName(GoodsContainer.getXMLElementTagName()).item(0));
            deliverGiftElement.appendChild(unitElement);
            deliverGiftElement.setAttribute("settlement", settlement.getId());
            deliverGiftElement.appendChild(goods.toXMLElement(receiver, deliverGiftElement.getOwnerDocument()));
            try {
                receiver.getConnection().sendAndWait(deliverGiftElement);
            }
            catch (IOException e) {
                logger.warning("Could not send \"deliverGift\"-message!");
            }
        }
        unit.deliverGift(settlement, goods);
        return null;
    }

    private Element indianDemand(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Colony colony = (Colony)this.getGame().getFreeColGameObject(element.getAttribute("colony"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        if (unit.getMovesLeft() <= 0) {
            throw new IllegalStateException("No moves left!");
        }
        if (colony == null) {
            throw new IllegalArgumentException("Could not find 'Colony' with specified ID: " + element.getAttribute("colony"));
        }
        if (unit.getOwner() != player) {
            throw new IllegalStateException("Not your unit!");
        }
        if (unit.getTile().getDistanceTo(colony.getTile()) > 1) {
            throw new IllegalStateException("Not adjacent to colony!");
        }
        ServerPlayer receiver = (ServerPlayer)colony.getOwner();
        if (receiver.isConnected()) {
            int gold = 0;
            Goods goods = null;
            Element goodsElement = Message.getChildElement(element, Goods.getXMLElementTagName());
            if (goodsElement == null) {
                gold = Integer.parseInt(element.getAttribute("gold"));
            } else {
                goods = new Goods(this.getGame(), goodsElement);
            }
            try {
                Element reply = receiver.getConnection().ask(element);
                boolean accepted = Boolean.valueOf(reply.getAttribute("accepted"));
                if (accepted) {
                    if (goods == null) {
                        receiver.modifyGold(-gold);
                    } else {
                        colony.getGoodsContainer().removeGoods(goods);
                    }
                }
                return reply;
            }
            catch (IOException e) {
                logger.warning("Could not send \"demand\"-message!");
            }
        }
        return null;
    }

    private Element continuePlaying(Connection connection, Element element) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        if (!this.getFreeColServer().isSingleplayer()) {
            throw new IllegalStateException("Can't continue playing in multiplayer!");
        }
        if (player != this.getFreeColServer().getInGameController().checkForWinner()) {
            throw new IllegalStateException("Can't continue playing! Player " + player.getName() + " hasn't won the game");
        }
        GameOptions go = this.getGame().getGameOptions();
        ((BooleanOption)go.getObject("model.option.victoryDefeatREF")).setValue(false);
        ((BooleanOption)go.getObject("model.option.victoryDefeatEuropeans")).setValue(false);
        ((BooleanOption)go.getObject("model.option.victoryDefeatHumans")).setValue(false);
        ServerPlayer currentPlayer = (ServerPlayer)this.getFreeColServer().getGame().getCurrentPlayer();
        this.getFreeColServer().getInGameController().endTurn(currentPlayer);
        return null;
    }

    @Override
    protected Element logout(Connection connection, Element logoutElement) {
        ServerPlayer player = this.getFreeColServer().getPlayer(connection);
        logger.info("Logout by: " + connection + (player != null ? " (" + player.getName() + ") " : ""));
        if (player == null) {
            return null;
        }
        player.setConnected(false);
        if (this.getFreeColServer().getGame().getCurrentPlayer() == player && !this.getFreeColServer().isSingleplayer()) {
            this.getFreeColServer().getInGameController().endTurn(player);
        }
        try {
            this.getFreeColServer().updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            // empty catch block
        }
        return null;
    }

    private void sendUpdatedTileToAll(Tile newTile, Player player) {
        Iterator<Player> enemyPlayerIterator = this.getGame().getPlayerIterator();
        while (enemyPlayerIterator.hasNext()) {
            ServerPlayer enemyPlayer = (ServerPlayer)enemyPlayerIterator.next();
            if (player != null && player.equals(enemyPlayer) || enemyPlayer.getConnection() == null) continue;
            try {
                if (!enemyPlayer.canSee(newTile)) continue;
                Element updateElement = Message.createNewRootElement("update");
                updateElement.appendChild(newTile.toXMLElement(enemyPlayer, updateElement.getOwnerDocument()));
                enemyPlayer.getConnection().sendAndWait(updateElement);
            }
            catch (IOException e) {
                logger.warning("Could not send message to: " + enemyPlayer.getName() + " with connection " + enemyPlayer.getConnection());
            }
        }
    }

    private Element getServerStatistics(Connection connection, Element request) {
        StatisticsMessage m = new StatisticsMessage(this.getGame(), this.getFreeColServer().getAIMain());
        Element reply = m.toXMLElement();
        return reply;
    }
}

