/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.generator.IMapGenerator;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public final class PreGameController
extends Controller {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());

    public PreGameController(FreeColServer freeColServer) {
        super(freeColServer);
    }

    public void startGame() throws FreeColException {
        FreeColServer freeColServer = this.getFreeColServer();
        Game game = freeColServer.getGame();
        Specification.getSpecification().applyDifficultyLevel(game.getGameOptions().getInteger("model.option.difficulty"));
        IMapGenerator mapGenerator = freeColServer.getMapGenerator();
        AIMain aiMain = new AIMain(freeColServer);
        freeColServer.setAIMain(aiMain);
        game.setFreeColGameObjectListener(aiMain);
        ArrayList<Nation> nations = new ArrayList<Nation>();
        int numberOfPlayers = freeColServer.getNumberOfPlayers() - game.getPlayers().size();
        if (numberOfPlayers > 0) {
            nations.addAll(game.getVacantNations().subList(0, numberOfPlayers));
        }
        nations.addAll(FreeCol.getSpecification().getIndianNations());
        game.setUnknownEnemy(new Player(game, "unknown enemy", false, null));
        for (Nation nation : nations) {
            if (game.getPlayer(nation.getId()) != null) continue;
            freeColServer.addAIPlayer(nation);
        }
        Element oldGameOptions = game.getGameOptions().toXMLElement(Message.createNewRootElement("oldGameOptions").getOwnerDocument());
        mapGenerator.createMap(game);
        Map map = game.getMap();
        game.getGameOptions().readFromXMLElement(oldGameOptions);
        this.sendUpdatedGame();
        freeColServer.setGameState(FreeColServer.GameState.IN_GAME);
        try {
            freeColServer.updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            // empty catch block
        }
        Element startGameElement = Message.createNewRootElement("startGame");
        freeColServer.getServer().sendToAll(startGameElement);
        freeColServer.getServer().setMessageHandlerToAllConnections(freeColServer.getInGameInputHandler());
    }

    public void sendUpdatedGame() {
        Game game = this.getFreeColServer().getGame();
        Iterator<Player> playerIterator = game.getPlayerIterator();
        while (playerIterator.hasNext()) {
            ServerPlayer player = (ServerPlayer)playerIterator.next();
            if (player.isEuropean() && !player.isREF()) {
                player.modifyGold(game.getGameOptions().getInteger("model.option.startingMoney"));
                player.getEurope().generateInitialRecruits();
                Market market = player.getMarket();
                for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
                    int increase;
                    if (!goodsType.isNewWorldGoodsType() && !goodsType.isNewWorldLuxuryType() || (increase = this.getPseudoRandom().nextInt(3)) <= 0) continue;
                    int newPrice = goodsType.getInitialSellPrice() + increase;
                    market.getMarketData(goodsType).setInitialPrice(newPrice);
                }
            }
            if (player.isAI()) continue;
            try {
                XMLStreamWriter out = player.getConnection().send();
                out.writeStartElement("updateGame");
                game.toXML(out, player);
                out.writeEndElement();
                player.getConnection().endTransmission(null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "EXCEPTION: ", e);
            }
        }
    }
}

